<?php
    //define('BASEPATH','zzz');
	//wczytanie konfigów z panel.networds.pl
	require_once('/home/networds/public_html/panel/system/application/config/database.php');
    require_once('/home/networds/public_html/panel/system/application/libraries/walidacja.php');
    require_once('/home/networds/public_html/panel/system/application/config/global_settings.php');
    require_once('files/Swift-4.0.5/lib/swift_required.php');
    
	DEFINE('db_server',		$db['default']['hostname']);
	DEFINE('db_user',		$db['default']['username']);
	DEFINE('db_password',	$db['default']['password']);
	DEFINE('db_name',		$db['default']['database']);

 
    session_start();
    include_once('files/securimage/securimage.php');
	//-----------------------------------------------------------------------------------------------
	function getConnection()
	{
			try
			{
				$mysqli = mysqli_connect(db_server, db_user, db_password, db_name);

				if (mysqli_connect_errno())
			    {
				        die("Connect failed: " . mysqli_connect_error());
			    }
				//$mysqli->close();
				return $mysqli;
			}
			catch(Exception $ex)
			{
				die("Connect to db failed");
			}
	}
	//-----------------------------------------------------------------------------------------------
	function checkIfEmailIsUnique($email)
	{
		try
		{
			$mysqli = getConnection();
			$sql    = "SELECT COUNT(id) AS liczba FROM afilianci WHERE email ='".$email."'";
			$result = $mysqli->query($sql);

			if($mysqli->error)
				throw new Exception($mysqli->error);

			$row = $result->fetch_assoc();
			if($row['liczba'] == 0)
				return TRUE;
			$result->free();
		}
		catch(Exception $ex)
		{

		}
		return FALSE;
	}
	//-----------------------------------------------------------------------------------------------
	//wyslanie maila do afilianta z wiadomoscia do aktywacji konta
 	function send_email($afiliant_id,$afiliant_imie,$afiliant_nazwisko,$afiliant_email,$config)
	{
		try {

				 $transport = Swift_SmtpTransport::newInstance($config['global_settings']['smtp']['smtp_serwer'],$config['global_settings']['smtp']['smtp_port'])
							  ->setUsername($config['global_settings']['smtp']['smtp_user'])
							  ->setPassword($config['global_settings']['smtp']['smtp_password']);

				$mailer = Swift_Mailer::newInstance($transport);


				//kodowanie id
				$afiliant_id_encoded 		 = 	md5($afiliant_id.$afiliant_email);

				$body 	 = 'Witaj '.$afiliant_imie.' '.$afiliant_nazwisko.',<br/>';
				$body 	.= 'W celu aktywacji konta w systemie networds kliknij na link poniżej:<br/>';
				$body   .= '<a href="http://panel.networds.pl/afiliant/activate/'.$afiliant_id_encoded.'" target="_blank">http://panel.networds.pl/afiliant/activate/'.$afiliant_id_encoded.'</a><br/><br/>';

				$body   .= 'Po aktywacji konta, aby zalogować sie w systemie należy wejść na panel:<br/><br/>';
				$body   .= '<a href="http://panel.networds.pl/afiliant" target="_blank">http://panel.networds.pl/afiliant</a> <br/><br/><br/>';

				$body   .= 'Uwaga: wiadomość została automatycznie wygenerowana przez system i prosze na nia nie odpowiadac.';

				$message = Swift_Message::newInstance('networds.pl aktywacja konta')
				  ->setFrom(array($config['global_settings']['smtp']['smtp_user'] => 'Networds System'))
				  ->setTo(array($afiliant_email))
				  ->setBody($body, 'text/html', 'utf-8');


				$headers = $message->getHeaders();
				$headers->addTextHeader('Reply-To',$config['global_settings']['smtp']['smtp_user']);

				//Send the message
				$result = $mailer->send($message);
				return $result;
		}
		catch (Exception $e)
		{
		    echo $e->getTraceAsString();
			return FALSE;
		}
	}
 	//-----------------------------------------------------------------------------------------------
    //FORM PROCESSING
    $errors     = null;
    $values     = null;
    $alerts['field_required']   =   'Pole wymagane';
    $alerts['field_invalid']  =   'Nieprawidłowa wartość';

    $securimage = new Securimage();
    if(!empty($_POST))
    {
        $tab = $_POST['tab'];
        if ($securimage->check($_POST['captcha_code']) == false) {
            $errors[$tab]['captcha']    = 'Nieprawidłowy kod';
        }

            $walidacja                              = new Walidacja();


            $values[$tab]['typ']                    =	trim(strip_tags($_POST['typ']));
			$values[$tab]['pass']					=	trim(strip_tags($_POST['pass']));
			$values[$tab]['pass2']					=	trim(strip_tags($_POST['pass2']));
            $values[$tab]['email']					=	trim(strip_tags($_POST['email']));

			$values[$tab]['imie']                   =	isset($_POST['imie']) 		? trim(strip_tags($_POST['imie'])) 		: '';
			$values[$tab]['nazwisko']               =	isset($_POST['nazwisko']) 	? trim(strip_tags($_POST['nazwisko']))	: '';
            $values[$tab]['nazwa']                  =	isset($_POST['nazwa']) 	? trim(strip_tags($_POST['nazwa']))	: '';

            $values[$tab]['regon']					=	isset($_POST['regon']) ? trim(strip_tags($_POST['regon'])) : '';
            $values[$tab]['pesel']					=	isset($_POST['pesel']) ? trim(strip_tags($_POST['pesel'])) : '';
            $values[$tab]['nip']					=	trim(strip_tags($_POST['nip']));

			$values[$tab]['miasto']					=	trim(strip_tags($_POST['miasto']));
			$values[$tab]['ulica']					=	trim(strip_tags($_POST['ulica']));
			$values[$tab]['kod_pocztowy']			=	trim(strip_tags($_POST['kod_pocztowy']));
			$values[$tab]['numer_domu']				=	trim(strip_tags($_POST['numer_domu']));
			$values[$tab]['nr_mieszkania']			=	trim(strip_tags($_POST['nr_mieszkania']));
            $values[$tab]['telefon']				=	trim(strip_tags($_POST['telefon']));

            $values[$tab]['dane_korespondencyjne']  = 0;
            if(isset($_POST['tab1_dane_korespondecyjne']))
                $values[$tab]['dane_korespondencyjne'] = $_POST['tab1_dane_korespondecyjne'];
            elseif(isset($_POST['tab2_dane_korespondecyjne']))
                $values[$tab]['dane_korespondencyjne'] = $_POST['tab2_dane_korespondecyjne'];

			$values[$tab]['dk_miasto']				=	isset($_POST['dk_miasto'])          ?    trim(strip_tags($_POST['dk_miasto']))  : '';
			$values[$tab]['dk_ulica']				=	isset($_POST['dk_ulica'])           ?    trim(strip_tags($_POST['dk_ulica']))   : '';
			$values[$tab]['dk_kod_pocztowy']		=	isset($_POST['dk_kod_pocztowy'])    ?    trim(strip_tags($_POST['dk_kod_pocztowy']))    : '';
			$values[$tab]['dk_nr_domu']				=	isset($_POST['dk_nr_domu'])         ?    trim(strip_tags($_POST['dk_nr_domu'])) : '';
			$values[$tab]['dk_nr_mieszkania']		=	isset($_POST['dk_nr_mieszkania'])   ?    trim(strip_tags($_POST['dk_nr_mieszkania']))    : '';
			$values[$tab]['dk_telefon']				=	isset($_POST['dk_telefon'])         ?    trim(strip_tags($_POST['dk_telefon']))  : '';


            $values[$tab]['regulamin']				=	isset($_POST['regulamin'])              ?    trim(strip_tags($_POST['regulamin']))  : 0;

            
            //walidacja
            if(empty($values[$tab]['email']))
                $errors[$tab]['email']       =	$alerts['field_required'];
            elseif(!$walidacja->CheckEmail($values[$tab]['email']))
                $errors[$tab]['email']		=	$alerts['field_invalid'];
            elseif(!checkIfEmailIsUnique($values[$tab]['email']))
                $errors[$tab]['email']		=	'Podany email już istnieje w systemie';

            if(empty($values[$tab]['pass']))
                        $errors[$tab]['pass']	=	$alerts['field_required'];
            if(empty($values[$tab]['pass2']))
                $errors[$tab]['pass2']          =	$alerts['field_required'];
            elseif($values[$tab]['pass2'] != $values[$tab]['pass'])
                $errors[$tab]['pass2']          =	$alerts['field_invalid'];

            if($values[$tab]['typ'] == 'osoba fizyczna')
            {
				if(empty($values[$tab]['imie']))
					$errors[$tab]['imie']			=	$alerts['field_required'];

				if(empty($values[$tab]['nazwisko']))
					$errors[$tab]['nazwisko']			=	$alerts['field_required'];

				if(empty($values[$tab]['pesel']))
					$errors[$tab]['pesel']			=	$alerts['field_required'];
				elseif(!$walidacja->CheckPESEL($values[$tab]['pesel']))
					$errors[$tab]['pesel']				=	$alerts['field_invalid'];
            }
            elseif($values[$tab]['typ'] == 'firma')
            {
				if(empty($values[$tab]['nazwa']))
					$errors[$tab]['nazwa']			=	$alerts['field_required'];

				if(empty($values[$tab]['regon']))
					$errors[$tab]['regon']			=	$alerts['field_required'];
				elseif(!$walidacja->CheckREGON($values[$tab]['regon']))
					$errors[$tab]['regon']				=	$alerts['field_invalid'];
            }

            if(empty($values[$tab]['nip']))
                $errors[$tab]['nip']			=	$alerts['field_required'];
            elseif(!$walidacja->CheckNIP($values[$tab]['nip']))
                $errors[$tab]['nip']				=	$alerts['field_invalid'];

            if(empty($values[$tab]['miasto']))
                $errors[$tab]['miasto']			=	$alerts['field_required'];

            if(empty($values[$tab]['ulica']))
                $errors[$tab]['ulica']			=	$alerts['field_required'];

            if(empty($values[$tab]['kod_pocztowy']))
                $errors[$tab]['kod_pocztowy']			=	$alerts['field_required'];

            if(empty($values[$tab]['numer_domu']))
                $errors[$tab]['numer_domu']			=	$alerts['field_required'];

            if(empty($values[$tab]['telefon']))
                $errors[$tab]['telefon']			=	$alerts['field_required'];

            if(empty($values[$tab]['regulamin']))
                $errors[$tab]['regulamin']			=	$alerts['field_required'];

            if($values[$tab]['dane_korespondencyjne'])
            {
                if(empty($values[$tab]['dk_miasto']))
                    $errors[$tab]['dk_miasto']			=	$alerts['field_required'];

                if(empty($values[$tab]['dk_ulica']))
                    $errors[$tab]['dk_ulica']			=	$alerts['field_required'];

                if(empty($values[$tab]['dk_kod_pocztowy']))
                    $errors[$tab]['dk_kod_pocztowy']			=	$alerts['field_required'];

                if(empty($values[$tab]['dk_nr_domu']))
                    $errors[$tab]['dk_nr_domu']			=	$alerts['field_required'];

                if(empty($values[$tab]['dk_telefon']))
                    $errors[$tab]['dk_telefon']			=	$alerts['field_required'];
            }

        if(empty($errors))
        {
		try
			{
				$mysqli = getConnection();
				$mysqli->autocommit(FALSE);
				//insert data to afilianci
				$sql1 	= 'INSERT INTO afilianci(nazwa,typ,imie,nazwisko,pesel,nip,regon,miasto,ulica,kod_pocztowy,numer_domu,nr_mieszkania,dk_miasto,dk_ulica,dk_kod_pocztowy,dk_nr_domu,dk_nr_mieszkania,dk_telefon,telefon,email,pass,uwagi,active,umowa,dokumenty_firma,dokumenty_osoba_prywatna) VALUES';
				$sql1   .= '("'.$values[$tab]['nazwa'].'","'. $values[$tab]['typ'].'","'.$values[$tab]['imie'].'","'.$values[$tab]['nazwisko'].'","'.$values[$tab]['pesel'].'","'.$values[$tab]['nip'].'","'.$values[$tab]['regon'].'","'.$values[$tab]['miasto'].'","'.$values[$tab]['ulica'].'","'.$values[$tab]['kod_pocztowy'].'","'.$values[$tab]['numer_domu'].'","'.$values[$tab]['nr_mieszkania'].'","'.$values[$tab]['dk_miasto'].'","'.$values[$tab]['dk_ulica'].'","'.$values[$tab]['dk_kod_pocztowy'].'","'.$values[$tab]['dk_nr_domu'].'","'.$values[$tab]['dk_nr_mieszkania'].'","'.$values[$tab]['dk_telefon'].'","'.$values[$tab]['telefon'].'","'.$values[$tab]['email'].'","'.md5($values[$tab]['pass']).'","",0,0,0,0)';

				$mysqli->query($sql1);
				if($mysqli->error)
					throw new Exception($mysqli->error);

				$afiliant_id	=	 $mysqli->insert_id;

				//insert data to konta
				$sql2 	= 'INSERT INTO konta(origin_id,origin_table) VALUES('.$afiliant_id.',"afilianci")';
				$mysqli->query($sql2);
				if($mysqli->error)
					throw new Exception($mysqli->error);

				//send email
				if(!send_email($afiliant_id,$values[$tab]['imie'] ,$values[$tab]['nazwisko'] ,$values[$tab]['email'],$config))
					throw new Exception('Wystapił bład przy wysyłaniu maila aktywacyjnego.');

				$mysqli->commit();
				$mysqli->autocommit(TRUE);


				$values = null;		//zerowanie wartosci
				$errors = null;		//zerowanie bledów
				$errors[$tab]['general'] = 'Rejestracja przebiegła pomyślnie. W celu aktywacji konta sprawdz skrzynkę pocztowa i wykonaj instrukcje wskazane w wiadomości która zostala do Ciebie wysłana.';
			}
			catch(Exception $e)
			{
				$mysqli->rollback();
				$mysqli->autocommit(TRUE);
				$errors[$tab]['general'] = 'Rejestracja nie powiodla się. Wystapił bład przy wprowadzaniu danych do bazy danych. ';
				echo $e->getMessage();
			}

        }
    }
    //-----------------------------------------------------------------------------------------------
?>

<div class="menu-pion">
    <div class="menu-pion-top">
       <?php
        if(isset($title)){
            echo '<h3>'.$title.'</h3>';
        }
        ?>
    </div>
    <div class="menu-pion-main">
        <?php
            if(isset($menu_pion)){
                echo $menu_pion;
            }
        ?>
    </div>
    <div class="menu-pion-bottom"></div>
</div>
<div class="content">
    <div class="content-top"></div>
    <div class="content-main">
	<?php
        echo '<div class="content-image" style="background-image: url(\'/files/css/img/frontside/rejestracja-afilianta.jpg\'); background-repeat: no-repeat;" >';
            echo '<h3 class="title"><img src="/files/css/img/frontside/white-arrows.png" alt=""/>&nbsp; Rejestracja afilianta</h3>';
        echo '</div>';

    ?>
        <script type="text/javascript" src="/files/js/jquery.js"></script> 
        <link href="/files/js/jquery-ui/ui.all.css" type="text/css" rel="stylesheet" />
        <script src="/files/js/jquery-ui/ui.core.js" type="text/javascript"></script>
        <script src="/files/js/jquery-ui/ui.tabs.js" type="text/javascript"></script>
        <style type="text/css">
                .error_info
                {
                    font-weight:bold;
                    color:red;
                }
                .info_box
                {
                    margin-bottom:10px;
                    margin-top:10px;
                    padding: 10px;
                    border: 2px solid grey;
                    background-color:#999999;
                }
        </style>
         <script type="text/javascript">
                  $(function() {
                    $("#tabs").tabs();

                });
                function dane_korespondecyjne_change()
                {
          
                    if($("#tabs-1 input[@name='tab1_dane_korespondecyjne']:checked").val() == 0)
                        $('.dk_field').hide();
                    else
                        $('.dk_field').show();

                    if($("#tabs-2 input[@name='tab2_dane_korespondecyjne']:checked").val() == 0)
                    {
                        $('.dk_field2').hide();
                    }
                    else
                    {
                        $('.dk_field2').show();
                    }
                }
                $(document).ready(function() {
                    dane_korespondecyjne_change();
                });

                
                
        </script>
        <?php if(!empty($tab) && !empty($errors[$tab]['general']))
            echo '<p class="info_box">'.$errors[$tab]['general'].'</p>';
        ?>
        <div id="tabs">
                <ul>
                    <li><a href="#tabs-2">Firma</a></li>
                    <li><a href="#tabs-1">Osoba fizyczna</a></li>
                </ul>
                <div id="tabs-1">
                    <form action="/pl/rejestracja-afilianta.html#tabs-1" id="tab1" method="post">
                        <table>
                            <tr>
                                <td colspan="2">
                                    <b>Dane konta</b>
                                    <input type="hidden" value="tab1" name="tab"/>
                                    <input type="hidden" value="osoba fizyczna" name="typ"/>
                                </td>
                                
                            </tr>
                            <!--EMAIL -->
                            <tr>
                                <td width="200">Email*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['email'])) echo $values['tab1']['email'];?>" name="email"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['email'])) echo $errors['tab1']['email'];?></span>
                                </td>
                            </tr>
                            <!--HASLO -->
                            <tr>
                                <td width="200">Hasło*</td>
                                <td><input type="password" value="" name="pass"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['pass'])) echo $errors['tab1']['pass'];?></span>
                                </td>
                            </tr>
                            <!--POWTIERDZ HASLO -->
                            <tr>
                                <td width="200">Potwierdz hasło*</td>
                                <td><input type="password" value="" name="pass2"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['pass2'])) echo $errors['tab1']['pass2'];?></span>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <b>Dane osobowe</b>
                                </td>
                            </tr>
                            <!--IMIE -->
                            <tr>
                                <td width="200">Imie*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['imie'])) echo $values['tab1']['imie'];?>" name="imie"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['imie'])) echo $errors['tab1']['imie'];?></span>
                                </td>
                            </tr>
                            <!--NAZWISKO -->
                            <tr>
                                <td width="200">Nazwisko*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['nazwisko'])) echo $values['tab1']['nazwisko'];?>" name="nazwisko"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['nazwisko'])) echo $errors['tab1']['nazwisko'];?></span>
                                </td>
                            </tr>
                            <!--PESEL -->
                            <tr>
                                <td width="200">Pesel*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['pesel'])) echo $values['tab1']['pesel'];?>" name="pesel" size="11"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['pesel'])) echo $errors['tab1']['pesel'];?></span>
                                </td>
                            </tr>
                            <!--NIP -->
                            <tr>
                                <td width="200">Nip*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['nip'])) echo $values['tab1']['nip'];?>" name="nip" size="10"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['nip'])) echo $errors['tab1']['nip'];?></span>
                                </td>
                            </tr>
                            <!--MIASTO -->
                            <tr>
                                <td width="200">Miasto*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['miasto'])) echo $values['tab1']['miasto'];?>" name="miasto"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['miasto'])) echo $errors['tab1']['miasto'];?></span>
                                </td>
                            </tr>
                            <!--ULICA -->
                            <tr>
                                <td width="200">Ulica*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['ulica'])) echo $values['tab1']['ulica'];?>" name="ulica"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['ulica'])) echo $errors['tab1']['ulica'];?></span>
                                </td>
                            </tr>
                            <!--KOD POCZTOWY -->
                            <tr>
                                <td width="200">Kod pocztowy*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['kod_pocztowy'])) echo $values['tab1']['kod_pocztowy'];?>" name="kod_pocztowy" size="6"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['kod_pocztowy'])) echo $errors['tab1']['kod_pocztowy'];?></span>
                                </td>
                            </tr>
                            <!--NUMER DOMU -->
                            <tr>
                                <td width="200">Nr domu*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['numer_domu'])) echo $values['tab1']['numer_domu'];?>" name="numer_domu"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['numer_domu'])) echo $errors['tab1']['numer_domu'];?></span>
                                </td>
                            </tr>
                            <!--NUMER MIESZKANIA -->
                            <tr>
                                <td width="200">Nr mieszkania</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['nr_mieszkania'])) echo $values['tab1']['nr_mieszkania'];?>" name="nr_mieszkania"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['nr_mieszkania'])) echo $errors['tab1']['nr_mieszkania'];?></span>
                                </td>
                            </tr>
                            <!--TELEFON -->
                            <tr>
                                <td width="200">Telefon*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['telefon'])) echo $values['tab1']['telefon'];?>" name="telefon"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['telefon'])) echo $errors['tab1']['telefon'];?></span>
                                </td>
                            </tr>
                            <!--DANE KORESPONDENCYJNE -->
                            <tr>
                                <td width="200"><b>Dane korespondencyjne</b></td>
                                <td>
                                    <input type="radio" name="tab1_dane_korespondecyjne" <?php echo (isset($_POST['tab1_dane_korespondecyjne']) && ($_POST['tab1_dane_korespondecyjne'] == 0) ? 'checked':	'checked'); ?> value="0" onclick="dane_korespondecyjne_change()"/>jak wyżej
                                    <input type="radio" name="tab1_dane_korespondecyjne" <?php echo (isset($_POST['tab1_dane_korespondecyjne']) && ($_POST['tab1_dane_korespondecyjne'] == 1) ? 'checked':	''); ?> value="1" onclick="dane_korespondecyjne_change()"/>inne
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['dane_korespondencyjne'])) echo $errors['tab1']['dane_korespondencyjne'];?></span>
                                </td>
                            </tr>
                            <!--DK MIASTO -->
                            <tr class="dk_field">
                                <td width="200">Miasto*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['dk_miasto'])) echo $values['tab1']['dk_miasto'];?>" name="dk_miasto"></td>
                            </tr>
                            <tr class="dk_field">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['dk_miasto'])) echo $errors['tab1']['dk_miasto'];?></span>
                                </td>
                            </tr>
                            <!--DK ULICA -->
                            <tr class="dk_field">
                                <td width="200">Ulica*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['dk_ulica'])) echo $values['tab1']['dk_ulica'];?>" name="dk_ulica"></td>
                            </tr>
                            <tr class="dk_field">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['dk_ulica'])) echo $errors['tab1']['dk_ulica'];?></span>
                                </td>
                            </tr>
                            <!--DK KOD POCZTOWY -->
                            <tr class="dk_field">
                                <td width="200">Kod pocztowy*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['dk_kod_pocztowy'])) echo $values['tab1']['dk_kod_pocztowy'];?>" name="dk_kod_pocztowy"></td>
                            </tr>
                            <tr class="dk_field">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['dk_kod_pocztowy'])) echo $errors['tab1']['dk_kod_pocztowy'];?></span>
                                </td>
                            </tr>
                            <!--DK NR DOMU -->
                            <tr class="dk_field">
                                <td width="200">Nr domu*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['dk_nr_domu'])) echo $values['tab1']['dk_nr_domu'];?>" name="dk_ulica" size="6"></td>
                            </tr>
                            <tr class="dk_field">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['dk_nr_domu'])) echo $errors['tab1']['dk_nr_domu'];?></span>
                                </td>
                            </tr>
                            <!--DK NR MIESZKANIA -->
                            <tr class="dk_field">
                                <td width="200">Nr mieszkania</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['dk_nr_mieszkania'])) echo $values['tab1']['dk_nr_mieszkania'];?>" name="dk_ulica" size="6"></td>
                            </tr>
                            <tr class="dk_field">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['dk_nr_mieszkania'])) echo $errors['tab1']['dk_nr_mieszkania'];?></span>
                                </td>
                            </tr>
                            <!--DK TELEFON -->
                            <tr class="dk_field">
                                <td width="200">Telefon*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab1']['dk_telefon'])) echo $values['tab1']['dk_telefon'];?>" name="dk_ulica"></td>
                            </tr>
                            <tr class="dk_field">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['dk_telefon'])) echo $errors['tab1']['dk_telefon'];?></span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <img id="captcha" src="/files/securimage/securimage_show.php" alt="CAPTCHA Image" />                                    
                                </td>
                                <td>
                                    <input type="text" name="captcha_code" size="10" maxlength="6" />
                                    <a href="#" onclick="document.getElementById('captcha').src = '/files/securimage/securimage_show.php?' + Math.random(); return false">Zmień obrazek</a>
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab1']['captcha'])) echo $errors['tab1']['captcha'];?></span>
                                </td>
                            </tr>
                            <!--DK REGULAMIN -->
                            <tr>
                                <td colspan="2">
                                    <input type="checkbox" name="regulamin" id="regulamin" <?php echo (isset($values['tab1']['regulamin']) && ($values['tab1']['regulamin']) ? 'checked': ''); ?> />Zapoznałem się i akceptuję warunki <a href=""><b>umowy</b></a> z Networds Sp.z.o.o.*
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <span class="error_info"><?php if(!empty($errors['tab1']['regulamin'])) echo $errors['tab1']['regulamin'];?></span>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">*-pole obowiazkowe</td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <input type="submit" class="submit" name="register" value="Załóż konto"/>
                                </td>
                            </tr>
                        </table>
                    </form>
                </div>
                <div id="tabs-2">
                   <form action="/pl/rejestracja-afilianta.html#tabs-2" method="post">
                        <table>
                            <tr>
                                <td colspan="2">
                                    <b>Dane konta</b>
                                    <input type="hidden" value="tab2" name="tab"/>
                                    <input type="hidden" value="firma" name="typ"/>
                                </td>

                            </tr>
                            <!--EMAIL -->
                            <tr>
                                <td width="200">Email*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['email'])) echo $values['tab2']['email'];?>" name="email"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['email'])) echo $errors['tab2']['email'];?></span>
                                </td>
                            </tr>
                            <!--HASLO -->
                            <tr>
                                <td width="200">Hasło*</td>
                                <td><input type="password" value="" name="pass"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['pass'])) echo $errors['tab2']['pass'];?></span>
                                </td>
                            </tr>
                            <!--POWTIERDZ HASLO -->
                            <tr>
                                <td width="200">Potwierdz hasło*</td>
                                <td><input type="password" value="" name="pass2"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['pass2'])) echo $errors['tab2']['pass2'];?></span>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <b>Dane firmy</b>
                                </td>
                            </tr>
                            <!--NAZWA -->
                            <tr>
                                <td width="200">Nazwa*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['nazwa'])) echo $values['tab2']['nazwa'];?>" name="nazwa"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['nazwa'])) echo $errors['tab2']['nazwa'];?></span>
                                </td>
                            </tr>
                            <!--NIP -->
                            <tr>
                                <td width="200">Nip*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['nip'])) echo $values['tab2']['nip'];?>" name="nip" size="10"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['nip'])) echo $errors['tab2']['nip'];?></span>
                                </td>
                            </tr>
                            <!--REGON -->
                            <tr>
                                <td>Regon*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['regon'])) echo $values['tab2']['regon'];?>" name="regon" size="9"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['regon'])) echo $errors['tab2']['regon'];?></span>
                                </td>
                            </tr>
                            <!--MIASTO -->
                            <tr>
                                <td width="200">Miasto*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['miasto'])) echo $values['tab2']['miasto'];?>" name="miasto"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['miasto'])) echo $errors['tab2']['miasto'];?></span>
                                </td>
                            </tr>
                            <!--ULICA -->
                            <tr>
                                <td width="200">Ulica*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['ulica'])) echo $values['tab2']['ulica'];?>" name="ulica"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['ulica'])) echo $errors['tab2']['ulica'];?></span>
                                </td>
                            </tr>
                            <!--KOD POCZTOWY -->
                            <tr>
                                <td width="200">Kod pocztowy*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['kod_pocztowy'])) echo $values['tab2']['kod_pocztowy'];?>" name="kod_pocztowy" size="6"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['kod_pocztowy'])) echo $errors['tab2']['kod_pocztowy'];?></span>
                                </td>
                            </tr>
                            <!--NUMER DOMU -->
                            <tr>
                                <td width="200">Nr domu*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['numer_domu'])) echo $values['tab2']['numer_domu'];?>" name="numer_domu"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['numer_domu'])) echo $errors['tab2']['numer_domu'];?></span>
                                </td>
                            </tr>
                            <!--NUMER MIESZKANIA -->
                            <tr>
                                <td width="200">Nr mieszkania</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['nr_mieszkania'])) echo $values['tab2']['nr_mieszkania'];?>" name="nr_mieszkania"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['nr_mieszkania'])) echo $errors['tab2']['nr_mieszkania'];?></span>
                                </td>
                            </tr>
                            <!--TELEFON -->
                            <tr>
                                <td width="200">Telefon*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['telefon'])) echo $values['tab2']['telefon'];?>" name="telefon"></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['telefon'])) echo $errors['tab2']['telefon'];?></span>
                                </td>
                            </tr>
                            <!--DANE KORESPONDENCYJNE -->
                            <tr>
                                <td width="200"><b>Dane korespondencyjne</b></td>
                                <td>
                                    <input type="radio" name="tab2_dane_korespondecyjne" <?php echo (isset($_POST['tab2_dane_korespondecyjne']) && ($_POST['tab2_dane_korespondecyjne'] == 0) ? 'checked':	'checked'); ?> value="0" onclick="dane_korespondecyjne_change()"/>jak wyżej
                                    <input type="radio" name="tab2_dane_korespondecyjne" <?php echo (isset($_POST['tab2_dane_korespondecyjne']) && ($_POST['tab2_dane_korespondecyjne'] == 1) ? 'checked':	''); ?>value="1" onclick="dane_korespondecyjne_change()"/>inne
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['dane_korespondencyjne'])) echo $errors['tab2']['dane_korespondencyjne'];?></span>
                                </td>
                            </tr>
                            <!--DK MIASTO -->
                            <tr class="dk_field2">
                                <td width="200">Miasto*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['dk_miasto'])) echo $values['tab2']['dk_miasto'];?>" name="dk_miasto"></td>
                            </tr>
                            <tr class="dk_field2">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['dk_miasto'])) echo $errors['tab2']['dk_miasto'];?></span>
                                </td>
                            </tr>
                            <!--DK ULICA -->
                            <tr class="dk_field2">
                                <td width="200">Ulica*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['dk_ulica'])) echo $values['tab2']['dk_ulica'];?>" name="dk_ulica"></td>
                            </tr>
                            <tr class="dk_field2">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['dk_ulica'])) echo $errors['tab2']['dk_ulica'];?></span>
                                </td>
                            </tr>
                            <!--DK KOD POCZTOWY -->
                            <tr class="dk_field2">
                                <td width="200">Kod pocztowy*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['dk_kod_pocztowy'])) echo $values['tab2']['dk_kod_pocztowy'];?>" name="dk_kod_pocztowy"></td>
                            </tr>
                            <tr class="dk_field2">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['dk_kod_pocztowy'])) echo $errors['tab2']['dk_kod_pocztowy'];?></span>
                                </td>
                            </tr>
                            <!--DK NR DOMU -->
                            <tr class="dk_field2">
                                <td width="200">Nr domu*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['dk_nr_domu'])) echo $values['tab2']['dk_nr_domu'];?>" name="dk_ulica" size="6"></td>
                            </tr>
                            <tr class="dk_field2">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['dk_nr_domu'])) echo $errors['tab2']['dk_nr_domu'];?></span>
                                </td>
                            </tr>
                            <!--DK NR MIESZKANIA -->
                            <tr class="dk_field2">
                                <td width="200">Nr mieszkania*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['dk_nr_mieszkania'])) echo $values['tab2']['dk_nr_mieszkania'];?>" name="dk_ulica" size="6"></td>
                            </tr>
                            <tr class="dk_field2">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['dk_nr_mieszkania'])) echo $errors['tab2']['dk_nr_mieszkania'];?></span>
                                </td>
                            </tr>
                            <!--DK TELEFON -->
                            <tr class="dk_field2">
                                <td width="200">Telefon*</td>
                                <td><input type="text" value="<?php if(!empty($values['tab2']['dk_telefon'])) echo $values['tab2']['dk_telefon'];?>" name="dk_ulica"></td>
                            </tr>
                            <tr class="dk_field2">
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['dk_telefon'])) echo $errors['tab2']['dk_telefon'];?></span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <img id="captcha" src="/files/securimage/securimage_show.php" alt="CAPTCHA Image" />
                                </td>
                                <td>
                                    <input type="text" name="captcha_code" size="10" maxlength="6" />
                                    <a href="#" onclick="document.getElementById('captcha').src = '/files/securimage/securimage_show.php?' + Math.random(); return false">Zmień obrazek</a>
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>
                                    <span class="error_info"><?php if(!empty($errors['tab2']['captcha'])) echo $errors['tab2']['captcha'];?></span>
                                </td>
                            </tr>
                            <!--DK REGULAMIN -->
                            <tr>
                                <td colspan="2">
                                    <input type="checkbox" name="regulamin" id="regulamin" <?php echo (isset($values['tab2']['regulamin']) && ($values['tab2']['regulamin']) ? 'checked': ''); ?> />Zapoznałem się i akceptuję warunki <a href=""><b>umowy</b></a> z Networds Sp.z.o.o.*
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <span class="error_info"><?php if(!empty($errors['tab2']['regulamin'])) echo $errors['tab2']['regulamin'];?></span>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">*-pole obowiazkowe</td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <input type="submit" class="submit" name="register" value="Załóż konto"/>
                                </td>
                            </tr>
                        </table>
                   </form>
                </div>
        </div>
    </div>
    <div class="content-bottom"></div>
</div>