<?php
class List_model extends Model{

    //--------------------------------------------------------------------------
    function List_model()
    {
        parent::Model();
    }
    //--------------------------------------------------------------------------
    function getAll()
    {
        $this->db->select('*');
        $this->db->from('lists');
        $result = $this->db->get();
        return $result->result_array();
    }
    //--------------------------------------------------------------------------
    //pobierz uchwyty do listy
    function getParents()
    {
        $this->db->select('*');
        $this->db->from('lists');
        $this->db->where('parent_id IS NULL');
        $result = $this->db->get();
        return $result->result_array();        
    }
    //--------------------------------------------------------------------------
    function getTree()
    {
        $data   = $this->getAll();
        $output = $this->mapTree($data);
        return $output;
    }
    //--------------------------------------------------------------------------
    function mapTree($dataset, $parent_id=null) {
        $tree = array();
        foreach ($dataset as $id=>$node) {
            if ($node['parent_id'] !== $parent_id) continue;
            $node['children'] = $this->mapTree($dataset, $node['id']);
            $tree[$id] = $node;
        }

        return $tree;
    }
    //--------------------------------------------------------------------------
    function getById($id)
    {
        $result = null;
        $this->db->select('*');
        $this->db->from('lists');
        $this->db->where('id',$id);
        $query = $this->db->get();

		if ($query->num_rows() >= 1)
        {
            return $query->row();
        }
		return $result;
    }
    //--------------------------------------------------------------------------
    function getElementsByParentId($parent_id)
    {
        $this->db->select('*');
        $this->db->from('lists');
        $this->db->where('parent_id',$parent_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    //--------------------------------------------------------------------------
    function create($data)
    {
        $this->db->insert('lists',$data);
        return $this->db->insert_id();
    }
    //--------------------------------------------------------------------------
    function update($id,$data)
    {
        $this->db->where('id',$id);
        $this->db->update('lists', $data);
        return true;
    }
    //--------------------------------------------------------------------------
    //usuwa drzewko
    function delete($id)
    {
        $child_items = $this->getElementsByParentId($id);
        if(!empty($child_items) && is_array($child_items))
            foreach($child_items as $k=>$v)
            {
                $this->delete($v['id']);
            }
        $this->deleteOnlyOne($id);
    }
    //--------------------------------------------------------------------------
    //usuwa liscia
    function deleteOnlyOne($id)
    {
        $item = $this->getById($id);
          if(!empty($item->image))
             @unlink('.'.$item->image);                       

        $this->db->where('id',$id);
        $this->db->delete('lists');
    }
    //--------------------------------------------------------------------------
}
?>
