<?php
class Immovable_model extends Model{

    //--------------------------------------------------------------------------
    function immovable_model()
    {
        parent::Model();
    }
    //--------------------------------------------------------------------------
    function getAll($lang_id=3)
    {
        $query = $this->db->query("SELECT i.id, i.name,i.building_type_id,(SELECT bt.name FROM immovable_building_types bt WHERE bt.id = i.building_type_id) AS building_type,
                                          i.offer_type_id,(SELECT ot.name FROM immovable_offer_types ot WHERE ot.id = i.offer_type_id) AS offer_type,
                                          i.gallery_id, i.localization,i.surface, i.rooms, i.garage_surface, i.nowelty, i.active, i.date_added
                                  FROM immovables i ORDER BY i.building_type_id,i.offer_type_id,i.date_added");
        return $query->result_array();
    }
    //--------------------------------------------------------------------------
    function getActiveAndNovelty($lang_id)
    {
        $query = $this->db->query("SELECT DISTINCT i.id, i.name,il.id as language_id,i.building_type_id,il.plot_type,(SELECT bt.name FROM immovable_building_types bt WHERE bt.id = i.building_type_id) AS building_type,
                                          i.offer_type_id,(SELECT ot.name FROM immovable_offer_types ot WHERE ot.id = i.offer_type_id) AS offer_type,
                                          i.gallery_id,i.localization,i.surface,il.price, il.floor, i.rooms, i.garage_surface, il.description, i.nowelty, i.active, i.date_added
                                  FROM immovables i
                                  JOIN immovable_languages il
                                  ON il.immovable_id = i.id
                                  WHERE il.lang_id=".$lang_id." AND i.active=1 AND i.nowelty =1 ORDER BY i.building_type_id,i.offer_type_id,i.date_added");
        return $query->result_array();        
    }
    //--------------------------------------------------------------------------
    function getActiveByOfferTypeId($offer_type_id, $lang_id)
    {
        $query = $this->db->query("SELECT DISTINCT i.id, i.name,il.id as language_id,i.building_type_id,il.plot_type,(SELECT bt.name FROM immovable_building_types bt WHERE bt.id = i.building_type_id) AS building_type,
                                          i.offer_type_id,(SELECT ot.name FROM immovable_offer_types ot WHERE ot.id = i.offer_type_id) AS offer_type,
                                          i.gallery_id,i.localization,i.surface,il.price, il.floor, i.rooms, i.garage_surface, il.description, i.nowelty, i.active, i.date_added
                                  FROM immovables i
                                  JOIN immovable_languages il
                                  ON il.immovable_id = i.id
                                  WHERE il.lang_id=".$lang_id." AND i.active=1 AND i.offer_type_id =".$offer_type_id." ORDER BY i.building_type_id,i.offer_type_id,i.date_added");
        return $query->result_array();
    }
    //--------------------------------------------------------------------------
    function getActiveByBuildingTypeId($building_type_id, $lang_id)
    {
        $query = $this->db->query("SELECT DISTINCT i.id, i.name,il.id as language_id,i.building_type_id,il.plot_type,(SELECT bt.name FROM immovable_building_types bt WHERE bt.id = i.building_type_id) AS building_type,
                                          i.offer_type_id,(SELECT ot.name FROM immovable_offer_types ot WHERE ot.id = i.offer_type_id) AS offer_type,
                                          i.gallery_id,i.localization,i.surface,il.price, il.floor, i.rooms, i.garage_surface, il.description, i.nowelty, i.active, i.date_added
                                  FROM immovables i
                                  JOIN immovable_languages il
                                  ON il.immovable_id = i.id
                                  WHERE il.lang_id=".$lang_id." AND i.active=1 AND i.building_type_id =".$building_type_id." ORDER BY i.building_type_id,i.offer_type_id,i.date_added");
        return $query->result_array();
    }
    //--------------------------------------------------------------------------
    function getActiveByBuildingTypeIdAndOffertTypeId($building_type_id,$offer_type_id, $lang_id)
    {
        $query = $this->db->query("SELECT DISTINCT i.id, i.name,il.id as language_id,i.building_type_id,il.plot_type,(SELECT bt.name FROM immovable_building_types bt WHERE bt.id = i.building_type_id) AS building_type,
                                          i.offer_type_id,(SELECT ot.name FROM immovable_offer_types ot WHERE ot.id = i.offer_type_id) AS offer_type,
                                          i.gallery_id,i.localization,i.surface,il.price, il.floor, i.rooms, i.garage_surface, il.description, i.nowelty, i.active, i.date_added
                                  FROM immovables i
                                  JOIN immovable_languages il
                                  ON il.immovable_id = i.id
                                  WHERE il.lang_id=".$lang_id." AND i.active=1 AND i.building_type_id =".$building_type_id." AND i.offer_type_id =".$offer_type_id." ORDER BY i.building_type_id,i.offer_type_id,i.date_added");
        $result = $query->result_array();
        return $result;
    }
    //--------------------------------------------------------------------------
    //aktywne nieruchomosci do wynajęcie
    function getActiveForRent($lang_id=3)
    {
        $query = $this->db->query("SELECT i.id, i.name,il.price,i.building_type_id,il.plot_type,(SELECT bt.name FROM immovable_building_types bt WHERE bt.id = i.building_type_id) AS building_type,
                                          i.offer_type_id,(SELECT ot.name FROM immovable_offer_types ot WHERE ot.id = i.offer_type_id) AS offer_type,
                                          i.gallery_id,i.localization,i.surface,il.price, il.floor, i.rooms, i.garage_surface, il.description, i.nowelty, i.active, i.date_added
                                  FROM immovables i
                                  JOIN immovable_languages il
                                  ON il.immovable_id = i.id
                                  WHERE i.offer_type_id = 2 AND i.active=1 AND il.lang_id=".$lang_id);
        
        return $query->result_array();        
    }
    //--------------------------------------------------------------------------
    //aktywne nieruchomosci do sprzedazy
    function getActiveForSale($lang_id=3)
    {
        $query = $this->db->query("SELECT i.id, i.name,il.price,i.building_type_id,il.plot_type,(SELECT bt.name FROM immovable_building_types bt WHERE bt.id = i.building_type_id) AS building_type,
                                          i.offer_type_id,(SELECT ot.name FROM immovable_offer_types ot WHERE ot.id = i.offer_type_id) AS offer_type,
                                         i.gallery_id,i.localization,i.surface,il.price, il.floor, i.rooms, i.garage_surface, il.description, i.nowelty, i.active, i.date_added
                                  FROM immovables i
                                  JOIN immovable_languages il
                                  ON il.immovable_id = i.id
                                  WHERE i.offer_type_id = 1 AND i.active=1 AND il.lang_id=".$lang_id);
        
        return $query->result_array();        
    }
    //--------------------------------------------------------------------------
    function getById($id,$lang_id=3)
    {
        $result = null;
        $sql = "SELECT i.id, i.name,il.price,il.id AS language_id ,i.building_type_id,il.plot_type,(SELECT bt.name FROM immovable_building_types bt WHERE bt.id = i.building_type_id) AS building_type,
                                          i.offer_type_id,(SELECT ot.name FROM immovable_offer_types ot WHERE ot.id = i.offer_type_id) AS offer_type,
                                          i.gallery_id,i.localization,i.surface,il.price, il.floor, i.rooms, i.garage_surface, il.description, i.nowelty, i.active, i.date_added
                                  FROM immovables i
                                  JOIN immovable_languages il
                                  ON il.immovable_id = i.id
                                  WHERE i.id=".$id." AND il.lang_id=".$lang_id;
       
        $query = $this->db->query($sql);

        
        if ($query->num_rows() >= 1)
        {
            return (array)$query->row();
        }
		return $result;
    }
    //--------------------------------------------------------------------------
    function getByLangVersionId($id)
    {
        $result = null;
        $sql = "SELECT i.id, i.name,il.price,il.id AS language_id ,i.building_type_id,il.plot_type,(SELECT bt.name FROM immovable_building_types bt WHERE bt.id = i.building_type_id) AS building_type,
                                          i.offer_type_id,(SELECT ot.name FROM immovable_offer_types ot WHERE ot.id = i.offer_type_id) AS offer_type,
                                          i.gallery_id,i.localization,i.surface,il.price, il.floor, i.rooms, i.garage_surface, il.description, i.nowelty, i.active, i.date_added
                                  FROM immovables i
                                  JOIN immovable_languages il
                                  ON il.immovable_id = i.id
                                  WHERE il.id=".$id;

        $query = $this->db->query($sql);


        if ($query->num_rows() >= 1)
        {
            return (array)$query->row();
        }
		return $result;
    }
    //--------------------------------------------------------------------------
    function getLangVersions($id)
    {
        $sql = "SELECT il.id,il.immovable_id, il.lang_id,il.plot_type, (SELECT l.shortname from languages as l WHERE l.idlanguages = il.lang_id) as lang_name,
                       il.floor, il.price, il.description
                FROM immovable_languages AS il
                WHERE il.immovable_id=".$id;
        
        $query = $this->db->query($sql);      
        return $query->result_array();        
    }
    //--------------------------------------------------------------------------
    function getLangVersion($immovable_lang_id)
    {
        $result = null;
        $sql = "SELECT il.id,il.immovable_id, il.lang_id, il.plot_type,(SELECT l.shortname from languages as l WHERE l.idlanguages = il.lang_id) as lang_name,
                       il.floor, il.price, il.description
                FROM immovable_languages AS il
                WHERE il.id=".$immovable_lang_id;
        
        $query = $this->db->query($sql);

        
		if ($query->num_rows() >= 1)
        {
            return (array)$query->row();
        }
		return $result;        
    }
    //--------------------------------------------------------------------------
    function create($data,$lang_data)
    {
        $this->db->insert('immovables',$data);
        $id = $this->db->insert_id();
        $lang_data['immovable_id'] = $id;
        $this->db->insert('immovable_languages',$lang_data);        
        return $this->db->insert_id();
    }
    //--------------------------------------------------------------------------
    function createLang($lang_data)
    {
        $this->db->insert('immovable_languages',$lang_data);
        return $this->db->insert_id();
    }
    //--------------------------------------------------------------------------
    function update($id,$data)
    {
        $this->db->where('id',$id);
        $r =  $this->db->update('immovables', $data);

        return $r;
    }
    //--------------------------------------------------------------------------
    function updateLangVersion($id,$data)
    {
        $this->db->where('id',$id);                
        return $this->db->update('immovable_languages', $data);
    }
    //--------------------------------------------------------------------------
    function delete($id)
    {
        $item = $this->getById($id);
        $this->db->where('id',$id);
        return $this->db->delete('immovables');
    }
    //--------------------------------------------------------------------------
    //--------------------------------------------------------------------------
    //--------------------------------------------------------------------------
    function getBuildingTypes($lang_id=3)
    {
        $this->db->select('*');
        $this->db->from('immovable_building_types');
        //$this->db->where('lang_id', $lang_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    //--------------------------------------------------------------------------
    function getOfferTypes($lang_id=3)
    {
        $this->db->select('*');
        $this->db->from('immovable_offer_types');
        //$this->db->where('lang_id', $lang_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    //--------------------------------------------------------------------------
}
?>
