<?php
class Admin_model extends Model{
		function Admin_model()
	    {
	        parent::Model();
			$this->load->library('session');
	    }
		
 		function get_all_guests()
	    {
	    	$this->db->select('*');
			$this->db->from('guest_book');	
			$this->db->orderby('id desc');
			$this->db->limit('30');
			$result = $this->db->get();
			return $result->result_array();
	    }
	    
	    function del_guest($id)
	    {
	    	$this->db->where('id',$id);
			$this->db->delete('guest_book'); 
	    }
	    
		function get_languages(){
			$this->db->select('idlanguages, fullname, shortname');
			$this->db->where('active', true); 
			$this->db->order_by('showorder', 'asc'); 
			$result = $this->db->get('languages');
			return $result->result_array();
		}
		
		function get_all_languages(){
			$this->db->select('*');
			$this->db->order_by('showorder', 'asc'); 
			$result = $this->db->get('languages');
			return $result->result_array();
		}
		
		function get_language_by_id($id){
			$this->db->select('*');
			$this->db->where('idlanguages', $id); 
			$this->db->order_by('showorder', 'asc'); 
			$result = $this->db->get('languages');
			return $result->result_array();
		}
		
		function get_groups(){
			$this->db->select('iduser_groups, name');
			$result = $this->db->get('user_groups');
			return $result->result_array();
		}
//galerie		
		//pobiera wszystkie galerie dla wybranego języka($idlang), kolejność po showorder
		function get_galleries(){
			$this->db->select('galleries.*, galleries_languages.*, languages.fullname, languages.shortname');
			$this->db->from('galleries');
			$this->db->join('galleries_languages', 'galleries.idgalleries = galleries_languages.idgalleries');			
			$this->db->join('languages', 'languages.idlanguages = galleries_languages.idlanguages');
			$this->db->order_by('showorder'); 
			$result = $this->db->get();
			return $result->result_array();
		}

		function get_gallery_list($lang_id=3){
			$this->db->select('galleries.*, galleries_languages.*, languages.fullname, languages.shortname');
			$this->db->from('galleries');
			$this->db->join('galleries_languages', 'galleries.idgalleries = galleries_languages.idgalleries');
			$this->db->join('languages', 'languages.idlanguages = galleries_languages.idlanguages');
			$this->db->order_by('showorder');
            $this->db->where('galleries_languages.idlanguages',$lang_id);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_gal_lang_versions($id){
			$this->db->select('*');
			$this->db->from('galleries');
			$this->db->join('galleries_languages', 'galleries.idgalleries = galleries_languages.idgalleries');
			$this->db->join('languages', 'languages.idlanguages = galleries_languages.idlanguages');			
			$this->db->where('galleries.idgalleries',$id);
			$this->db->order_by('galleries.showorder'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function add_gallery($data){
			$this->db->insert('galleries', $data); 
		}
		
		function add_gallery_language($data){
			$this->db->insert('galleries_languages', $data); 
		}
		
		function get_galleries_languages(){
			$this->db->select('*');
			$this->db->from('galleries_languages');
			$this->db->join('languages', 'languages.idlanguages = galleries_languages.idlanguages');
			$this->db->order_by('fullname', 'languages.idlanguages'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function update_gallery_language($id, $data){
			$this->db->where('idgalleries_languages',$id);
			$this->db->update('galleries_languages', $data); 
		}
		
		function update_gallery($id, $data){
			$this->db->where('idgalleries',$id);
			$this->db->update('galleries', $data); 
		}
		
		function delete_gallery_language($id){
			$this->db->where('idgalleries_languages',$id);
			$this->db->delete('galleries_languages'); 
		}		
		
		function get_data_to_delete_gallery($id){
			$this->db->select('images.idimages, images_languages.idimages_languages');
			$this->db->from('images');
			$this->db->join('images_languages', 'images_languages.idimages = images.idimages');	
			$this->db->where('images.idgalleries',$id);
			$this->db->order_by('showorder', 'asc'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function delete_gallery($id){
			$this->db->where('idgalleries',$id);
			$this->db->delete('galleries'); 
		}			
		//pobiera wszystkie info o danej galerii dla wybranego języka($idlang) i listę fotek dla niej, kolejność po showorder
		function get_gallery_by_id($id,$idlang){
			$this->db->select('*');
			$this->db->from('galleries_languages');
			$this->db->join('galleries', 'galleries.idgalleries = galleries_languages.idgalleries');	
			$this->db->where('galleries_languages.idlanguages',$idlang);
			$this->db->where('galleries_languages.idgalleries',$id);
			$this->db->order_by('showorder', 'asc'); 
			$result = $this->db->get();
			return $result->result_array();
		}

//obrazki		
		function add_image($data){
			$this->db->insert('images', $data); 
		}
			
		function add_image_language($data){
			$this->db->insert('images_languages', $data); 
		}
		
		function delete_image_language($id){
			$this->db->where('idimages_languages',$id);
			$this->db->delete('images_languages'); 
		}
		
		function delete_image($id){
			$this->db->where('idimages',$id);
			$this->db->delete('images'); 
		}
		
		function update_image($id, $data){
			$this->db->where('idimages',$id);
			$this->db->update('images', $data); 
		}
		
		function get_img_lang_versions(){
			$this->db->select('images.*, images_languages.*, languages.fullname, languages.shortname');			
			$this->db->from('images');
			$this->db->join('images_languages', 'images_languages.idimages = images.idimages');		
			$this->db->join('languages', 'images_languages.idlanguages = languages.idlanguages');			
			$this->db->order_by('images.showorder'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_img_lang_versions_by_id($id){		
			$this->db->where('idimages',$id);
			$result = $this->db->get('images_languages');
			return $result->result_array();
		}
		
		function update_image_language($id, $data){
			$this->db->where('idimages_languages',$id);
			$this->db->update('images_languages', $data); 
		}
		//pobiera wszystkie info o danego obrazka dla wybranego języka($idlang), kolejność po showorder
		function get_image_by_id($id){
			$this->db->select('*');
			$this->db->from('images');
			$this->db->where('images.idimages',$id);
			$this->db->order_by('showorder', 'asc'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_image_lang_by_id($id){
			$this->db->select('*');
			$this->db->from('images_languages');
			$this->db->join('images', 'images_languages.idimages = images.idimages');
			$this->db->where('images_languages.idimages_languages',$id);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		//pobiera wszystkie obrazki dla danej gallerii ($idlang), kolejność po showorder
		function get_gallery_images($id){
			$this->db->where('images.idgalleries',$id);
  			$this->db->order_by('images.showorder','desc');
            $this->db->order_by('images.idimages','desc');
			$result = $this->db->get('images');
			return $result->result_array();
		}
		
		//pobiera standardowe metatagi dla danego typu(artykul, news, itd)($type) dla danego języka($idlang)
		function get_default_metatags($type, $idlang){
			$this->db->select('*');
			$this->db->from('metatags');
			$this->db->join('metatag_types', 'metatag_types.idmetatag_types = metatags.idmetatag_types');		
			$this->db->where('metatags.idlanguages',$idlang);
			$this->db->where('metatag_types.name',$type);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_metatags(){
			$this->db->select('*');
			$this->db->from('metatag_types');
			$this->db->join('metatags','metatags.idmetatag_types=metatag_types.idmetatag_types');
			$this->db->join('languages','metatags.idlanguages=languages.idlanguages');
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_metatag_types(){
			$this->db->select('*');
			$this->db->from('metatag_types');
			$this->db->order_by('idmetatag_types', 'desc');
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function update_metatag($id, $data){
			$this->db->where('idmetatags',$id);
			$this->db->update('metatags', $data); 
		}
		
		function delete_metatags($id){
			$this->db->where('idmetatags',$id);
			$this->db->delete('metatags'); 
		}
		
		function get_metatag_by_id($id){
			$this->db->select('*');
			$this->db->from('metatags');
			$this->db->where('idmetatags', $id);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function add_metatags($data){
			$this->db->insert('metatags', $data); 
		}
		
		function get_metatag_types_languages($idmeta_type){
			$this->db->select('*');
			$this->db->from('metatag_types');
			$this->db->join('metatags', 'metatags.idmetatag_types = metatag_types.idmetatag_types');
			$this->db->where('metatag_types.idmetatag_types', $idmeta_type);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_metatag_types_languages_by_lang($idlangs){
			$this->db->select('*');
			$this->db->from('metatag_types');
			$this->db->join('metatags', 'metatags.idmetatag_types = metatag_types.idmetatag_types');
			$this->db->where('metatags.idlanguages', $idlangs);
			$this->db->where('metatag_types.name', 'template');
			$result = $this->db->get();
			return $result->result_array();
		}
//menus
		function get_menus(){
			$this->db->select('*');
			$this->db->from('menus');
			$this->db->order_by('idmenus');
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_menu_item_children($idparent){
			$this->db->select('*');
			$this->db->from('menu_items');
			$this->db->where('idparent', $idparent);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_menu_items(){
			$this->db->select('languages.fullname, languages.shortname, menu_item_types.*, menu_item_languages.*, menu_items.*, ');
			$this->db->from('menu_item_types');
			$this->db->join('menu_items', 'menu_item_types.idmenu_item_types = menu_items.idmenu_item_types');			
			$this->db->join('menu_item_languages', 'menu_item_languages.idmenu_items = menu_items.idmenu_items');
			$this->db->join('languages', 'languages.idlanguages = menu_item_languages.idlanguages');			
			$this->db->order_by('menu_items.showorder DESC, menu_items.idmenu_items, languages.showorder');
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_menu_item_to_delete($id){
			$this->db->select('*');
			$this->db->from('menu_items');		
			$this->db->where('menu_items.idmenu_items', $id);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_menu_item_by_id($id){
			$this->db->select('*');
			$this->db->from('menu_item_types');
			$this->db->join('menu_items', 'menu_item_types.idmenu_item_types = menu_items.idmenu_item_types');			
			$this->db->join('menu_item_languages', 'menu_item_languages.idmenu_items = menu_items.idmenu_items');
			$this->db->join('languages', 'languages.idlanguages = menu_item_languages.idlanguages');			
			$this->db->where('menu_item_languages.idmenu_item_languages', $id);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function add_menu($data){
			$this->db->insert('menus', $data); 
		}

		function delete_menu($id){
			$this->db->where('idmenus',$id);
			$this->db->delete('menus'); 
		}

		function update_menu_items($id, $data){
			$this->db->where('idmenu_items',$id);
			$this->db->update('menu_items', $data); 
		}
		
		function update_menu_item_languages($id, $data){
			$this->db->where('idmenu_item_languages',$id);
			$this->db->update('menu_item_languages', $data);
            
		}
		
		function add_menu_item($data){
			$this->db->insert('menu_items', $data); 
		}
		
		function add_menu_item_language($data){
			$this->db->insert('menu_item_languages', $data); 
		}
		
		function get_menu_item_types(){
			$this->db->select('*');
			$this->db->from('menu_item_types');
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_menu_item_languages($idmenu_item){
			$this->db->select('*');
			$this->db->from('menu_item_languages');
			$this->db->where('idmenu_items', $idmenu_item);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function delete_menu_item_language($id){
			$this->db->where('idmenu_item_languages',$id);
			$this->db->delete('menu_item_languages'); 
		}
		
		function delete_menu_item_language_by_idmenu_items($id){
			$this->db->where('idmenu_items',$id);
			$this->db->delete('menu_item_languages'); 
		}
		
		function delete_menu_item($id){
			$this->db->where('idmenu_items',$id);
			$this->db->delete('menu_items'); 
		}
		
		function get_menu_by_id($id, $idlang){
			$this->db->select('*, mit_languages.friendlyurl as mit_url, menu_item_languages.friendlyurl as mi_url');
			$this->db->from('mit_languages');
			$this->db->join('menu_item_types', 'mit_languages.idmit = menu_item_types.idmenu_item_types');
			$this->db->join('menu_items', 'menu_items.idmenu_item_types = menu_item_types.idmenu_item_types');
			$this->db->join('menu_item_languages', 'menu_item_languages.idmenu_items = menu_items.idmenu_items');		
			$this->db->where('menu_item_languages.idlanguages',$idlang);
			$this->db->where('mit_languages.idlanguages',$idlang);
			$this->db->where('menu_items.idmenus',$id);
			$this->db->order_by('showorder');
			$result = $this->db->get();
			return $result->result_array();
		}
		
//użytkownicy
		function get_users(){
			$this->db->select('*');
			$this->db->from('users');
			$this->db->join('user_groups','user_groups.iduser_groups=users.iduser_groups');	
			$this->db->order_by('user_groups.iduser_groups', 'asc'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_user_by_id($id){
			$this->db->where('idusers',$id);
			$result = $this->db->get('users');
			return $result->result_array();
		}
		
		function update_user($id, $data){
			$this->db->where('idusers',$id);
			$this->db->update('users', $data); 
		}
		
		function delete_user($id){
			$this->db->where('idusers',$id);
			$this->db->delete('users'); 
		}
		
		function add_user($data){
			$this->db->insert('users', $data); 
		}		
		
		function login($login, $password){
			$this->db->select('*');
			$this->db->from('users');
			$this->db->join('user_groups', 'users.iduser_groups = user_groups.iduser_groups');
			$this->db->where('login', $login);
			$this->db->where('password', $password);
			$result = $this->db->get();
			return $result->result_array();
		}

//newsy
		function get_newses(){
			$this->db->select('*');
			$this->db->from('newses');
			$this->db->order_by('newses.showorder'); 
			$this->db->order_by('newses.date', 'desc'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_newses_by_id($id){
			$this->db->select('*');
			$this->db->from('newses');
			$this->db->where('idnewses', $id);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_news_languages(){
			$this->db->select('newses.*, news_languages.*, languages.fullname, languages.shortname');
			$this->db->from('newses');
			$this->db->join('news_languages', 'newses.idnewses = news_languages.idnewses');
			$this->db->join('languages', 'languages.idlanguages = news_languages.idlanguages');
			$this->db->order_by('languages.showorder'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_news_languages_by_idnewses($id){
			$this->db->select('*');
			$this->db->where('idnewses', $id);
			$result = $this->db->get('news_languages');
			return $result->result_array();
		}
		
		function update_news($id, $data){
			$this->db->where('idnewses',$id);
			$this->db->update('newses', $data); 
		}
		
		function update_news_language($id, $data){
			$this->db->where('idnews_languages',$id);
			$this->db->update('news_languages', $data); 
		}
		
		function delete_news($id){
			$this->db->where('idnewses',$id);
			$this->db->delete('newses'); 
		}
		
		function delete_news_language($id){
			$this->db->where('idnews_languages',$id);
			$this->db->delete('news_languages'); 
		}
		
		function add_news($data){
			$this->db->insert('newses', $data); 
		}
		
		function add_news_language($data){
			$this->db->insert('news_languages', $data); 
		}
		
		//pobiera news po id, kolejność po showorder
		function get_news_lang_by_id($id){
			$this->db->select('newses.*, news_languages.*, languages.fullname');
			$this->db->from('newses');
			$this->db->join('news_languages', 'newses.idnewses = news_languages.idnewses');
			$this->db->join('languages', 'languages.idlanguages = news_languages.idlanguages');
			$this->db->where('news_languages.idnews_languages',$id);
			$this->db->order_by('languages.showorder, newses.showorder'); 
			$result = $this->db->get();
			return $result->result_array();
		}
//articles
		function get_articles(){
			$this->db->select('*');
			$this->db->from('articles');
			$this->db->order_by('articles.showorder desc');
			$result = $this->db->get();
			return $result->result_array();

		}
		
		function get_article_languages(){
			$this->db->select('articles.*, article_languages.*, languages.fullname, languages.shortname');
			$this->db->from('articles');
			$this->db->join('article_languages', 'articles.idarticles = article_languages.idarticles');
			$this->db->join('languages', 'languages.idlanguages = article_languages.idlanguages');
			$this->db->order_by('languages.showorder'); 			
			$this->db->order_by('articles.showorder desc');
			$this->db->order_by('date', 'desc'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function update_article($id, $data){
			$this->db->where('idarticles',$id);
			$this->db->update('articles', $data);
		}
		
		function update_article_language($id, $data){
			$this->db->where('idarticle_languages',$id);
			$this->db->update('article_languages', $data); 
		}
		
		function update_change_article_parent($id, $data){
			$this->db->where('idparent',$id);
			$this->db->update('articles', $data); 
		}
	
		function add_article($data){
			$this->db->insert('articles', $data); 
		}
		
		function add_article_language($data){
			$this->db->insert('article_languages', $data); 
		}
		
		function delete_article($id){
			$this->db->where('idarticles',$id);
			$this->db->delete('articles'); 
		}
		
		function delete_article_language($id){
			$this->db->where('idarticle_languages',$id);
			$this->db->delete('article_languages'); 
		}
		
		function get_article_languages_by_idarticles($id){
			$this->db->select('*');
			$this->db->where('idarticles', $id);
			$result = $this->db->get('article_languages');
			return $result->result_array();
		}
		
		function get_article_lang_by_id($id){
			$this->db->select('articles.*, article_languages.*, languages.fullname');
			$this->db->from('articles');
			$this->db->join('article_languages', 'articles.idarticles = article_languages.idarticles');
			$this->db->join('languages', 'languages.idlanguages = article_languages.idlanguages');
			$this->db->where('article_languages.idarticle_languages',$id);
			$this->db->order_by('languages.showorder, articles.showorder'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_article_by_id($id){
			$this->db->select('*');
			$this->db->from('articles');
			$this->db->where('idarticles',$id);
			$result = $this->db->get();
			return $result->result_array();
		}
//notes
		function get_notes(){
			$this->db->select('*');
			$this->db->from('notes');
			$this->db->join('users', 'users.idusers = notes.idusers');
			$this->db->order_by('date'); 
			$result = $this->db->get();
			return $result->result_array();
		}	
	
		function add_note($data){
			$this->db->insert('notes', $data); 
		}
	
		function delete_note($id){
			$this->db->where('idnotes',$id);
			$this->db->delete('notes'); 
		}
		
//panel zarzadzania CMSem
		function get_rights(){
			$this->db->select('*');
			$this->db->order_by('showorder');
			$result = $this->db->get('elements');
			return $result->result_array();
		}		
		
		function get_user_groups(){
			$this->db->select('*');
			$result = $this->db->get('user_groups');
			return $result->result_array();
		}
		
		function get_user_group_elements(){
			$this->db->select('*');
			$result = $this->db->get('user_group_elements');
			return $result->result_array();
		}
		
		function get_user_group_element($idelement, $iduser_group){
			$this->db->select('*');
			$this->db->where('iduser_groups',$iduser_group);
			$this->db->where('idelements',$idelement);
			$result = $this->db->get('user_group_elements');
			return $result->result_array();
		}
		
		function add_user_group_elements($data){
			$this->db->insert('user_group_elements', $data); 
		}
		
		function update_user_group_elements($id, $data){
			$this->db->where('iduser_group_elements',$id);
			$this->db->update('user_group_elements', $data); 
		}
		
		function update_elements($id, $data){
			$this->db->where('idelements',$id);
			$this->db->update('elements', $data); 
		}
	
		function get_elements_for_group($group){
			$this->db->select('*');
			$this->db->from('user_group_elements');
			$this->db->join('elements', 'elements.idelements = user_group_elements.idelements');
			$this->db->where('iduser_groups',$group);
			$this->db->order_by('showorder');
			$result = $this->db->get();
			return $result->result_array();
		}
//jezyki
		function update_languages($id, $data){
			$this->db->where('idlanguages',$id);
			$this->db->update('languages', $data); 
		}
		
		function add_language($data){
			$this->db->insert('languages', $data); 
		}
//produkty
		function get_products(){
			$this->db->select('*');
			$this->db->from('products');
			$this->db->join('product_product_categories', 'product_product_categories.idproducts = products.idproducts');
			$this->db->order_by('products.showorder'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_products_by_cat_name($cat_name){
			$this->db->select('*');
			$this->db->from('products');
			$this->db->join('product_product_categories', 'product_product_categories.idproducts = products.idproducts');
			$this->db->join('product_categories', 'product_product_categories.idproduct_categories = product_categories.idproduct_categories');
			$this->db->where('product_categories.type', $cat_name);
			$this->db->order_by('products.showorder'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_product_children(){
			$this->db->select('subproducts.*, products.name');
			$this->db->from('products');
			$this->db->join('subproducts', 'subproducts.idchild = products.idproducts');
			$this->db->where('products.active', true);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_product_languages(){
			$this->db->select('products.*, products_languages.*, languages.fullname, languages.shortname');
			$this->db->from('products');
			$this->db->join('products_languages', 'products.idproducts = products_languages.idproducts');
			$this->db->join('languages', 'languages.idlanguages = products_languages.idlanguages');
			$this->db->order_by('languages.showorder'); 			
			$this->db->order_by('products.showorder');
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_product_categories(){
			$this->db->select('*');
			$this->db->from('product_categories');
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function update_product($id, $data){
			$this->db->where('idproducts',$id);
			$this->db->update('products', $data); 
		}
		
		function update_subproduct($idparent, $idchild, $data){
			$this->db->where('idparent',$idparent);
			$this->db->where('idchild',$idchild);
			$this->db->update('subproducts', $data); 
		}
		
		function add_product($data){
			$this->db->insert('products', $data); 
		}
		
		function add_product_language($data){
			$this->db->insert('products_languages', $data); 
		}
		
		function add_subproduct($data){
			$this->db->insert('subproducts', $data); 
		}
		
		function add_product_product_category($data){
			$this->db->insert('product_product_categories', $data); 
		}
		
		function delete_product($id){
			$this->db->where('idproducts',$id);
			$this->db->delete('products'); 
		}
		
		function delete_product_language($id){
			$this->db->where('idproducts_languages',$id);
			$this->db->delete('products_languages'); 
		}
		
		function get_subproduct_by_parent_by_child($idparent, $idchild){
			$this->db->where('idchild',$idchild);
			$this->db->where('idparent',$idparent);
			$result = $this->db->get('subproducts');
			return $result->result_array();
		}
		
		function delete_subproduct_by_parent_by_child($idparent, $idchild){
			$this->db->where('idchild',$idchild);
			$this->db->where('idparent',$idparent);
			$this->db->delete('subproducts');
		}
		
		function delete_subproduct_by_idparent($id){
			$this->db->where('idparent',$id);
			$this->db->delete('subproducts'); 
		}
		
		function delete_subproduct_by_idchild($id){
			$this->db->where('idchild',$id);
			$this->db->delete('subproducts'); 
		}
		
		function delete_product_product_category_by_idproduct($id){
			$this->db->where('idproducts',$id);
			$this->db->delete('product_product_categories'); 
		}
		
		function get_product_languages_by_idproducts($id){
			$this->db->select('*');
			$this->db->where('idproducts', $id);
			$result = $this->db->get('products_languages');
			return $result->result_array();
		}
		
		function update_product_language($id, $data){
			$this->db->where('idproducts_languages',$id);
			$this->db->update('products_languages', $data); 
		}
		
		function get_product_lang_by_id($id){
			$this->db->select('products.*, products_languages.*, languages.fullname');
			$this->db->from('products');
			$this->db->join('products_languages', 'products.idproducts = products_languages.idproducts');
			$this->db->join('languages', 'languages.idlanguages = products_languages.idlanguages');
			$this->db->where('products_languages.idproducts_languages',$id);
			$this->db->order_by('languages.showorder, products.showorder'); 
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function get_product_by_id($id){
			$this->db->select('*');
			$this->db->from('products');
			$this->db->where('idproducts',$id);
			$result = $this->db->get();
			return $result->result_array();
		}	
		
//kategorie produktów
		function get_product_categories_languages(){
			$this->db->select('product_categories.*, product_categories_languages.*, languages.fullname, languages.shortname');
			$this->db->from('product_categories');
			$this->db->join('product_categories_languages', 'product_categories.idproduct_categories = product_categories_languages.idproduct_categories');
			$this->db->join('languages', 'languages.idlanguages = product_categories_languages.idlanguages');
			$this->db->order_by('languages.showorder'); 	
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function add_product_category($data){
			$this->db->insert('product_categories', $data); 
		}
		
		function add_product_category_language($data){
			$this->db->insert('product_categories_languages', $data); 
		}
		
		function get_product_category_language($id){
			$this->db->select('*');
			$this->db->from('product_categories');
			$this->db->join('product_categories_languages', 'product_categories_languages.idproduct_categories = product_categories.idproduct_categories');
			$this->db->where('product_categories_languages.idproduct_categories_languages',$id);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function update_product_category_language($id, $data){
			$this->db->where('idproduct_categories_languages',$id);
			$this->db->update('product_categories_languages', $data); 
		}
		
		function get_prod_prod_cat_idcategory($idcategory){
			$this->db->select('*');
			$this->db->from('product_product_categories');
			$this->db->where('idproduct_categories',$idcategory);
			$result = $this->db->get();
			return $result->result_array();
		}
		
		function delete_prod_cat_language($id){
			$this->db->where('idproduct_categories_languages',$id);
			$this->db->delete('product_categories_languages'); 
		}
		
		function delete_product_category($id){
			$this->db->where('idproduct_categories',$id);
			$this->db->delete('product_categories'); 
		}
		
		function get_prod_cat_languages_by_idcategory($idcategory){
			$this->db->select('*');
			$this->db->from('product_categories_languages');
			$this->db->where('idproduct_categories',$idcategory);
			$result = $this->db->get();
			return $result->result_array();
		}
	}

		
?>