<?php
class Frontside extends Controller {
	
	var $cache_duration = 600;
	var $site;
	var $main_menu_id=1;
	//mail kontaktowy do formularza
    var $slideshowImages = array();     //fotki do slideshow w naglowku strony
    var $articles        = array();     //lista wszystkich artykułów
	
	//prefix i surfix tytułu strony
	var $title_surfix='';
	var $title_prefix='';
	
	function Frontside(){
		parent::Controller();	
		$this->load->model('frontside_model','',TRUE);
        $this->load->model('admin_model','',TRUE);
        $this->load->model('list_model','',TRUE);
        $this->load->model('immovable_model','',TRUE);
		//plik z jezykiem polskim
		$this->config->load('lang_pl');
		//rozmiary miniaturek
		$this->site = $this->config->item('PL');
		$this->load->library('session');
		$this->load->helper('form');
        $this->load->helper('url');
        $this->load->helper('text');

        $this->slideshowImages = $this->frontside_model->get_homepage_slideshow_images();
        $this->articles        = $this->admin_model->get_articles();

	}
	
	private function get_standard_metatags($type, $idlang){
		$result = $this->frontside_model->get_default_metatags($type, $idlang);
		if(isset($result[0])){
			$result = $result[0];
		}else{
			$result = '';
		}
		return $result;
	}
	
	private function get_language($idlang){
		$result = $this->frontside_model->get_language($idlang);
		if(isset($result[0])){
			$result = $result[0];
		}else{
			$result = '';
		}
		return $result;
	}
	
	private function get_metatags($data, $idlang){
		$metatags = array( 	'title'     => $this->title_prefix.$data['title'].$this->title_surfix,
							'keywords'  => $data['keywords'],
							'shortdesc' => $data['shortdesc'],
							'abstract'  => $data['abstract'],
							'subject'   => $data['subject'],
							'topic' => $data['topic'],
							'copyright' => $data['copyrights']
						);
		return $metatags;
	}
	
	//funkcja dba o zarządzanie językiem
	private function set_language($idlang){
		$lang = $this->get_language($idlang);
		$this->site = $this->config->item($lang['shortname']);
	}
	
	function index($idlang = 3){
		$this->set_language($idlang);
        $data = null;


        
        

		//$this->output->cache($this->cache_duration/2);
		//"artykul dostepny takze w jezykach"
		$other_languages = $this->frontside_model->get_active_languages();
		$other_versions = '';
		if(isset($other_languages[1])){
			$other_versions .= ucfirst($this->site['wersje_jezykowe']);
			$i=0;
			foreach($other_languages as $other_lang_version){
				if($this->site['lang']['skrot']!=$other_lang_version['shortname']){
					if($i==0){
						$i++;
					}else{
						$other_versions .=  ' | ';
					}
					$other_versions .=  '<a href="/'.strtolower($other_lang_version['shortname']).'">'.$other_lang_version['shortname'].'</a>';
				}
			}
		}
		$data['other_versions'] = $other_versions;
		

        $list           = null;
        $article        = $this->frontside_model->get_first_article($idlang);        
        
        
        if(!empty($article->idlists))
        {
            $listId = $article->idlists;
            $list   = $this->list_model->getElementsByParentId($listId);
        }

        $langs                  = $this->frontside_model->get_active_languages();
        $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);
        $data['homepage_list']  = $this->load->view('front/elements/show_homepage_list',array('list'=>$list),true);
        $data['content']        = $this->load->view('front/elements/show_home', array('article'=> $article,'slideshowImages'=> $this->slideshowImages), true);
        $data['isHomepage']     = true;
        
        //main menu
        $menu_items             = $this->frontside_model->get_menu_by_id($this->main_menu_id, $idlang);
        $data['main_menu']      = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items,'articles'=>$this->articles), true);
        
        $metatags               = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
        $data['metatags']       = $metatags;

		$this->load->view('front/layout/intro/header', $data);
		$this->load->view('front/layout/intro/content', $data);
		$this->load->view('front/layout/intro/footer');
	}
    //-------------------------------------------------------------------------------------------------------------------
    function properties($idlang = 3,$building_type_id=null,$offer_type_id=null)
    {
        $this->set_language($idlang);
        $langs                  = $this->frontside_model->get_active_languages();
        $lang                   = $this->frontside_model->get_language($idlang);
        


        $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

        if((empty($building_type_id) || empty($offer_type_id)))
        {
            $new_immovables         = $this->immovable_model->getActiveAndNovelty($idlang);
            $data['nowelty']        = true;
        }
        else
        {
            $new_immovables         = $this->immovable_model->getActiveByBuildingTypeIdAndOffertTypeId($building_type_id,$offer_type_id,$idlang);
            $data['nowelty']        = false;
        }

        if(!empty($new_immovables) && is_array($new_immovables))
        {
            foreach($new_immovables as $k=>$v)
            {
                //dla kazdego wczytaj polska galerie
                $new_immovables[$k]['images'] = $this->frontside_model->get_gallery_images($v['gallery_id'],3);
            }
        }
        $immovables_for_sale    = $this->immovable_model->getActiveForSale($idlang);
        $immovables_for_rent    = $this->immovable_model->getActiveForRent($idlang);

        $data['menu_immovables_for_sale']  = $this->load->view('front/elements/menu_properties_for_sale',array('immovables'=>$immovables_for_sale,'lang'=>$lang[0],'selected_id'=>null), true);
        $data['menu_immovables_for_rent']  = $this->load->view('front/elements/menu_properties_for_rent',array('immovables'=>$immovables_for_rent,'lang'=>$lang[0],'selected_id'=>null), true);
        $data['content']                   = $this->load->view('front/elements/properties',array('immovables'=>$new_immovables,'lang'=>$lang[0],'nowelty'=>$data['nowelty']), true);
        

        //main menu
        $menu_items             = $this->frontside_model->get_menu_by_id($this->main_menu_id, $idlang);
        $data['main_menu']      = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items,'articles'=>$this->articles,'lang'=>$lang[0]), true);

        $metatags               = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
        $data['metatags']       = $metatags;

		$this->load->view('front/layout/nieruchomosci/header', $data);
		$this->load->view('front/layout/nieruchomosci/content', $data);
		$this->load->view('front/layout/nieruchomosci/footer');
    }
    //-------------------------------------------------------------------------------------------------------------------
    function property($id,$idlang = 3)
    {
		$this->set_language($idlang);
        $data                   = null;
        $langs                  = $this->frontside_model->get_active_languages();
        $lang                   = $this->frontside_model->get_language($idlang);

        $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

        $immovable              = $this->immovable_model->getById($id,$idlang);
        //dla kazdego pobieraj zdjecia z polskiej galerii
        $immovable['images']    = $this->frontside_model->get_gallery_images($immovable['gallery_id'],3);


        $immovables_for_sale    = $this->immovable_model->getActiveForSale($idlang);
        $immovables_for_rent    = $this->immovable_model->getActiveForRent($idlang);

        $data['menu_immovables_for_sale']  = $this->load->view('front/elements/menu_properties_for_sale',array('immovables'=>$immovables_for_sale,'lang'=>$lang[0],'selected_id'=>$id), true);
        $data['menu_immovables_for_rent']  = $this->load->view('front/elements/menu_properties_for_rent',array('immovables'=>$immovables_for_rent,'lang'=>$lang[0],'selected_id'=>$id), true);
        $data['content']                   = $this->load->view('front/elements/property',array('immovable'=>$immovable,'lang'=>$lang[0]), true);


        //main menu
        $menu_items             = $this->frontside_model->get_menu_by_id($this->main_menu_id, $idlang);
        $data['main_menu']      = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items,'articles'=>$this->articles), true);

        $metatags               = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
        $data['metatags']       = $metatags;

        $this->load->view('front/layout/nieruchomosci/header', $data);
        $this->load->view('front/layout/nieruchomosci/content', $data);
        $this->load->view('front/layout/nieruchomosci/footer');
    }
    //-------------------------------------------------------------------------------------------------------------------
    function getListByParentId($id=null)
    {
        $list = null;
        if(!empty($id))
        {
            $list   = $this->list_model->getElementsByParentId($id);
        }       
        $this->load->view('front/elements/list', array('list'=>$list));
    }
    //-------------------------------------------------------------------------------------------------------------------
	//nie przystosowany do języków
	function articles($idlang = 3){
        
		$this->set_language($idlang);
		//$this->output->cache($this->cache_duration);	
		$list['articles'] = $this->frontside_model->get_articles($idlang);


		//ten widok należy uzależnic od $idlang
		$data['content'] = $this->load->view('front/elements/articles', $list, true);
		$data['blue_field_baner'] = $this->get_baner('', $idlang);
		$data['footer_content']      = $this->getFooterContent();

		$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);

		$this->load->view('front/layout/header', $metatags);
		$this->load->view('front/layout/content', $data);
		$this->load->view('front/layout/footer');
	}
	
	function show_article($id, $idlang = 3){
        
		$this->set_language($idlang);        
		//$this->output->cache($this->cache_duration);

        $home_article = $this->frontside_model->get_first_article($idlang);              
        if(!empty($home_article->idarticles) && $home_article->idarticles == $id)
        {
            return $this->index($idlang);
        }

        //pobierz pod artykuly - jeśli są przekierwuj rządanie na jego widok
        $subarticles = $this->frontside_model->get_subarticles($id, $idlang);
        if(!empty($subarticles) && is_array($subarticles))
        {
            switch($idlang)
            {
                case 4: redirect(base_url().'en/article/'.$subarticles[0]['friendlyurl'].'-'.$subarticles[0]['idarticles'].'.html');
                default: redirect(base_url().'pl/artykul/'.$subarticles[0]['friendlyurl'].'-'.$subarticles[0]['idarticles'].'.html');
            }
        }


		//"artykul dostepny takze w jezykach"
		$other_languages = $this->frontside_model->get_article($id);
		$other_versions = '';
		if(isset($other_languages[1])){
			$other_versions .= ucfirst($this->site['wersje_jezykowe']);
			$i=0;
			foreach($other_languages as $other_lang_version){
				if($this->site['lang']['skrot']!=$other_lang_version['shortname']){
					$current_lang = $this->config->item($other_lang_version['shortname']);
					if($i==0){
						$i++;
					}else{
						$other_versions .=  ' | ';
					}
					$other_versions .=  '<a href="/'.strtolower($other_lang_version['shortname']).'/'.$current_lang['linki_do_sitemapy']['artykul'].'/'.$other_lang_version['friendlyurl'].'-'.$other_lang_version['idarticles'].'.html">'.$other_lang_version['shortname'].'</a>';
				}
			}
		}
		$data['other_versions'] = $other_versions;
		
		
		
		
        //galeria
        $gallery        = $this->frontside_model->get_first_gallery($idlang);
        if(!empty($gallery))
            $gallery['images'] = $this->frontside_model->get_gallery_images($gallery['idgalleries'],$idlang);

        //praca nad artykułem
        
        $article        = $this->frontside_model->get_article($id, $idlang);
        $listId         = !empty($article[0]['idlists']) ? $article[0]['idlists'] : null;
        $lista          = null;
        
        if(!empty($listId))
        {
            $lista   = $this->list_model->getElementsByParentId($listId);
        }

        //main menu
        $menu_items         = $this->frontside_model->get_menu_by_id($this->main_menu_id, $idlang);
        $data['main_menu']  = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items,'articles'=>$this->articles), true);

        //slideshow


		if(isset($article[0]))
        {
            
			$article = $article[0];

            if($article['idgalleries']!=''){
                $article['galleries'] = $this->frontside_model->get_images_by_idgallery($article['idgalleries']);
            }
            
			$list['article'] = $article;
			$parent = $this->frontside_model->get_article($article['idparent'], $idlang);

			if(isset($parent[0])){
				$article['parent'] = $parent[0];
				$list['parent'] = $parent[0];
				if($article['parent']['idparent']==''){	
					$article['subarticles'] = $this->frontside_model->get_subarticles($article['parent']['idarticles'], $idlang);	
					$list['subarticles'] = $article['subarticles'];
					$article['subarticles_content'] = $this->frontside_model->get_subarticles($id, $idlang);
				}else{
					$article['subarticles'] = $this->frontside_model->get_subarticles($article['parent']['idparent'], $idlang);
					$article['subarticles_content'] = $this->frontside_model->get_subarticles($id, $idlang);
				}
			}else{
				$article['subarticles'] = $this->frontside_model->get_subarticles($id, $idlang);
				$article['subarticles_content'] = $article['subarticles'];
			
            }         

            $langs                  = $this->frontside_model->get_active_languages();
            $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);
            
            $this->slideshowImages = array();
            $this->slideshowImages[] = null;//'/files/img/articles/'.$article['image'];
            
            
            $data['content']    = $this->load->view('front/elements/show_article', array('article'=> $article,'list'=>$lista, 'gallery'=>$gallery, 'slideshowImages'=> $this->slideshowImages,'active_lang'=>$idlang), true);
            $data['isHomepage'] = false;

            $metatags = $this->get_metatags($article, $idlang);
		}
        else
        {
            //$list['menu_items']       = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
            //$list['menu_items_pion']  = $this->frontside_model->get_menu_by_id($this->menu_pion, $idlang);
			$metatags           = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
            $data['content']    = $this->load->view('front/elements/show_article', array('message'=> '<p class="info_box">Nie ma takiej strony</a>'), true);
            $data['isHomepage'] = false;
		}			

        $article['site']            = $this->site;
        $data['metatags']           = $metatags;


		$this->load->view('front/layout/header', $data);
		$this->load->view('front/layout/content', $data);
		$this->load->view('front/layout/footer');
	}
    //------------------------------------------------------------------------------------------------------
	function main_menu_xml($idlang = 3,$action='',$section_id=0)
    {
        $this->load->helper('url');
        $viewmodel['menu_items']                    = $this->frontside_model->get_menu_by_id($this->main_menu_id, $idlang);

        $section_type = '';
        switch($action)
        {
           case 'show_gallery': $section_type = 'gallery';  break;
           case 'show_article': $section_type = 'article';  break;
           case 'guest_book'  : $section_type = 'comments';     break;
        }
        
        $viewmodel['section_id']    = $section_id;
        $viewmodel['section_type']  = $section_type;

        $this->load->view('front/elements/main_menu_xml', $viewmodel);
    }
    //------------------------------------------------------------------------------------------------------
	function newses($idlang = 3){
		//$this->output->cache($this->cache_duration/2);
		$list['newses'] = $this->frontside_model->get_newses($idlang);
		$list['site'] = $this->site;
		$data['content'] = $this->load->view('front/elements/newses', $list, true);
		
		//$list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
		$data['menu_poziom'] = $this->load->view('front/elements/menu_poziom_trollandia', null, true);
		
		 //newsy
		$news['newses'] = $this->frontside_model->get_newses($idlang,2);
		$data['news'] = $this->load->view('front/boxes/newses_box',$news,true);
		
		$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
        $data['footer_content']      = $this->getFooterContent();

		$this->load->view('front/layout/header', $metatags);
		$this->load->view('front/layout/content', $data);
		$this->load->view('front/layout/footer',data);
	}
	
	function show_news($id = null, $idlang = 3){
		$this->set_language($idlang);
		//$this->output->cache($this->cache_duration/2);
			
		$news = $this->frontside_model->get_news($id, $idlang);
		if(isset($news[0])){
			$news = $news[0];
			$news['site'] = $this->site;
			$news['newses'] = $this->frontside_model->get_newses($idlang);
			$data['content'] = $this->load->view('front/elements/show_news', $news, true);
			$metatags = $this->get_metatags($news, $idlang);
		}else{
			$data['content'] = 'Nie ma takiego newsa';
			$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
		}
		
		 //newsy
		$news['newses'] = $this->frontside_model->get_newses($idlang,2);
		$data['news'] = $this->load->view('front/boxes/newses_box',$news,true);
		
		$list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
		$data['menu_poziom'] = $this->load->view('front/elements/menu_poziom_trollandia', null, true);

        $data['footer_content']      = $this->getFooterContent();
		$this->load->view('front/layout/header', $metatags);
		$this->load->view('front/layout/content2', $data);
		$this->load->view('front/layout/footer',$data);
	}	

	function send_contact($idlang = 3){
		$this->set_language($idlang);
		
		$emailTo=$this->contact_mail;
		$name='';
		$mail='';
		$desc='';
		$phone='';
		require_once 'files/Swift-4.0.5/lib/swift_required.php';
		if(isset($_POST['contact_email']) && $_POST['contact_email'] != ''){
			if($_POST['token']==$this->session->userdata['token'])
   			{
				//Create the Transport
				$transport = Swift_SmtpTransport::newInstance('post.pl', 25)
					->setUsername('formularz@post.pl')
					->setPassword('ebl67aic')
				;
				
				//Create the Mailer using your created Transport
				$mailer = Swift_Mailer::newInstance($transport);
					
				//Create the message
				$message = Swift_Message::newInstance()
					->setSubject('Formularz kontaktowy: '.$_POST['contact_site'])
					->setTo(array($emailTo))
					->setFrom('formularz@post.pl')
					->setBody("Temat:   ".$_POST['contact_subject']."\nOd:   ".$_POST['contact_name']."\nEmail:   ".$_POST['contact_email']."\nWiadomość:\n".$_POST['contact_content']);
		
				$headers = $message->getHeaders();
				$headers->addTextHeader('Reply-to', $_POST['contact_email']);
				
				//Send the message
				$mailer->send($message);
				unset($_POST);
				$data2['token'] =  mt_rand(1111, 9999);
				$this->session->set_userdata('token', $data2['token']);
				$data2['komunikaty'] = ucfirst($this->site['komunikaty']['wiadomosc_wyslana']);
			}else{				
				$data2['token'] =  mt_rand(1111, 9999);
				$this->session->set_userdata('token', $data2['token']);
				$data2['komunikaty'] = ucfirst($this->site['komunikaty']['blad_tokenu']);
			}
		}else{
			$data2['token'] =  mt_rand(1111, 9999);
			$this->session->set_userdata('token', $data2['token']);
			if(isset($_POST['contact_site'])){
				$data2['komunikaty'] = ucfirst($this->site['komunikaty']['blad_emaila']);
			}else{
				$data2['komunikaty'] = ucfirst($this->site['linki_do_sitemapy']['kontakt']);
            }
		}
        
        $list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
        $data2['menu_pion'] = $this->load->view('front/elements/menu_pion', $list, true);

        $data2['article'] = $this->frontside_model->get_article($this->idcontact_article, 3);
		$data['content'] = $this->load->view('front/elements/contact', $data2, true);
		
		$list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
        $data['menu_footer'] = $this->load->view('front/elements/menu_footer', $list, true);
		$data['menu_poziom'] = $this->load->view('front/elements/menu_poziom', $list, true);
		$data['iscontact'] = true;
		
		$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
		$metatags['iscontact'] = true;
		$this->load->view('front/layout/header', $metatags);
		$this->load->view('front/layout/content', $data);
		$this->load->view('front/layout/footer');       
	}
	
	function show_product($id, $idlang = 3){
		$this->set_language($idlang);
		//$this->output->cache($this->cache_duration);
		
		//"artykul dostepny takze w jezykach"
		$other_languages = $this->frontside_model->get_product_language($id);
		$other_versions = '';
		if(isset($other_languages[1])){
			$other_versions .= ucfirst($this->site['wersje_jezykowe']);
			$i=0;
			foreach($other_languages as $other_lang_version){
				if($this->site['lang']['skrot']!=$other_lang_version['shortname']){
					$current_lang = $this->config->item($other_lang_version['shortname']);
					if($i==0){
						$i++;
					}else{
						$other_versions .=  ' | ';
					}
					$other_versions .=  '<a href="/'.strtolower($other_lang_version['shortname']).'/'.$other_lang_version['cat_url'].'/'.$other_lang_version['friendlyurl'].'-'.$other_lang_version['idproducts'].'.html">'.$other_lang_version['shortname'].'</a>';
				}
			}
		}
		$data['other_versions'] = $other_versions;
		//praca nad artykułem
		$article = $this->frontside_model->get_product($id, $idlang);
		if(isset($article[0])){
			$article = $article[0];
			$article['subproducts'] = $this->frontside_model->get_subproducts($id, $idlang);
			$article['galleries'] = $this->frontside_model->get_images_by_idgallery($article['idgalleries']);
			$data['content'] = $this->load->view('front/elements/show_product', $article, true);
			$metatags = $this->get_metatags($article, $idlang);
		}else{
			$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
			$data['content'] = 'Nie ma takiego artykułu';
		}
		
		$list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
		$data['menu_poziom'] = $this->load->view('front/elements/menu_poziom', $list, true);
		
		$this->load->view('front/layout/header', $metatags);
		$this->load->view('front/layout/content', $data);
		$this->load->view('front/layout/footer');
	}
	
	function show_product_category($id = null, $idlang = 3){
		$this->set_language($idlang);
		//$data['poslij_do_boxa_z_menu_poziom']['elements'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);

		//"artykul dostepny takze w jezykach"
		$other_languages = $this->frontside_model->get_product_category($id);
		$other_versions = '';
		if(isset($other_languages[1])){
			$other_versions .= ucfirst($this->site['wersje_jezykowe']);
			$i=0;
			foreach($other_languages as $other_lang_version){
				if($this->site['lang']['skrot']!=$other_lang_version['shortname']){
					if($i==0){
						$i++;
					}else{
						$other_versions .=  ' | ';
					}
					$other_versions .=  '<a href="/'.strtolower($other_lang_version['shortname']).'/'.$other_lang_version['friendlyurl'].'.html">'.$other_lang_version['shortname'].'</a>';
				}
			}
		}
		$data['other_versions'] = $other_versions;
		//praca nad artykułem
		$article = $this->frontside_model->get_product_category($id, $idlang);
		if(isset($article[0])){
			$article = $article[0];
			$article['subproducts'] = $this->frontside_model->get_products_by_cat($id, $idlang);
			$data['content'] = $this->load->view('front/elements/show_product_category', $article, true);
			$metatags = $this->get_metatags($article, $idlang);
		}else{
			$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
			$data['content'] = ucfirst($this->site['komunikaty']['brak_artykulu']);
		}
		
		$list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
		$data['menu_poziom'] = $this->load->view('front/elements/menu_poziom', $list, true);
		
		$this->load->view('front/layout/header', $metatags);
		$this->load->view('front/layout/content', $data);
		$this->load->view('front/layout/footer');
	}
	
	function show_gallery($id = null, $idlang = 3){
		$this->set_language($idlang);
		//$this->output->cache($this->cache_duration);
        $this->slideshowImages = null; //$this->frontside_model->get_gallerypage_slideshow_images();

		$article = $this->frontside_model->get_gallery_by_id($id,$idlang);
		if(isset($article[0])){
			//"artykul dostepny takze w jezykach"
			$other_languages = $this->frontside_model->get_gallery($id);
			//print_r($other_languages);
			$other_versions = '';
			if(isset($other_languages[1])){
				$other_versions .= ucfirst($this->site['wersje_jezykowe']);
				$i=0;
				foreach($other_languages as $other_lang_version){
					if($this->site['lang']['skrot']!=$other_lang_version['shortname']){
						$current_lang = $this->config->item($other_lang_version['shortname']);
						if($i==0){
							$i++;
						}else{
							$other_versions .=  ' | ';
						}
						$other_versions .=  '<a href="/'.strtolower($other_lang_version['shortname']).'/'.$current_lang['linki_do_sitemapy']['galeria'].'/'.$other_lang_version['friendlyurl'].'-'.$other_lang_version['idgalleries'].'.html">'.$other_lang_version['shortname'].'</a>';
					}
				}
			}
			$data['other_versions'] = $other_versions;
			//praca nad artykułem
			$article = $article[0];
			$article['site'] = $this->site;
			$article['subarticles'] = array();
			
			$article['images']  = $this->frontside_model->get_gallery_images($id,$idlang);
            $article['active_lang']    = $idlang;
			$data['content']    = $this->load->view('front/elements/show_gallery', $article, true);
			$metatags = $this->get_metatags($article, $idlang);

		}else{
			$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
			$data['content'] = '<p class="info_box">There is no such gallery</a>';
			$article['subarticles'] = array();
		}
		
		$list['site'] = $this->site;

        //main menu
        $menu_items         = $this->frontside_model->get_menu_by_id($this->main_menu_id, $idlang);
        $data['main_menu']  = $this->load->view('front/elements/main_menu', array('menu_items'=>$menu_items,'articles'=>$this->articles), true);
		
		//newsy
		$news['newses'] = $this->frontside_model->get_newses($idlang,2);
		$data['news'] = $this->load->view('front/boxes/newses_box',$news,true);
		
		$data['site']                   = $this->site;
        $data['metatags']               = $metatags;
        $data['is_gallery']             = true;
        $data['menu_items']             = $this->frontside_model->get_menu_by_id($this->main_menu_id, $idlang);
        $data['slideshowImages']        = $this->slideshowImages;
        $data['isHomepage'] = false;
        
        $langs                  = $this->frontside_model->get_active_languages();
        $data['langs_menu']     = $this->load->view('front/elements/menu_lang',array('langs'=>$langs,'active_lang'=>$idlang),true);

		$this->load->view('front/layout/header', $data);
		$this->load->view('front/layout/content', $data);
		$this->load->view('front/layout/footer',$data);
	}
	function getGallery($id,$idlang = 3)
    {
        if(!empty($id))
        {
            $images = $this->frontside_model->get_gallery_images($id,$idlang);
            $this->load->view('front/elements/show_mini_gallery', array('images'=>$images));
        }
        return '';
    }
	function galleries($id = null, $idlang = 3){
		$this->set_language($idlang);
		//$this->output->cache($this->cache_duration);
		
		$articles = $this->frontside_model->get_galleries($idlang);
		if(isset($articles[0])){
			foreach($articles as $key => $art){
				$bufor = $this->frontside_model->get_gallery_images($art['idgalleries'],$idlang);
				if(isset($bufor[0])){
					$articles[$key]['photo'] = $bufor[0];
				}
				
			}
			//praca nad artykułem
			$article['articles'] = $articles;
			$article['site'] = $this->site;
			$article['subarticles'] = array();
			
			$data['content'] = $this->load->view('front/elements/galleries', $article, true);
			$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
			//$metatags = $this->get_metatags($article, $idlang);
		}else{
			$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
			$data['content'] = 'Nie ma takiej galerii.';
			$article['subarticles'] = array();
		}
		
		//$list['site'] = $this->site;
		//$list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
		$data['menu_poziom'] = $this->load->view('front/elements/menu_poziom_trollandia', null, true);
		
		//newsy
		$news['newses'] = $this->frontside_model->get_newses($idlang,2);
		$data['news'] = $this->load->view('front/boxes/newses_box',$news,true);
		
		$data['site'] = $this->site;
		$this->load->view('front/layout/header', $metatags);
		$this->load->view('front/layout/content', $data);
		$this->load->view('front/layout/footer');
	}
	
	function order($parent, $child, $idlang = 3){
		$this->set_language($idlang);

		$this->load->library('form_validation');
		$emailTo=$this->contact_mail;

		$this->form_validation->set_message('required', 'Pole %s jest wymagane.');
		$this->form_validation->set_message('is_natural_no_zero', '%s musi być liczbą naturalną(większą od zera).');
		$this->form_validation->set_message('min_length', 'Zbyt krótki wpis do pola %s.');
		$this->form_validation->set_message('valid_email', 'Pole %s powinno zawierać poprawny adres email.');

		$this->form_validation->set_rules('additional_data', 'Uwagi', '');
		$this->form_validation->set_rules('count', 'Ilość sztuk', 'required|is_natural_no_zero');
		$this->form_validation->set_rules('fname', 'Imię', 'required|min_length[2]');
		$this->form_validation->set_rules('sname', 'Nazwisko', 'required|min_length[2]');
		$this->form_validation->set_rules('email', 'Email', 'required|valid_email');
		$this->form_validation->set_rules('phone', 'Telefon', 'required|min_length[2]');
		$this->form_validation->set_rules('address', 'Adres dostawy', 'required|min_length[2]');
		if(isset($_POST['invoice'])){
			$this->form_validation->set_rules('caddress', 'Adres firmy', 'required|min_length[2]');
			$this->form_validation->set_rules('cname', 'Nazwa firmy', 'required|min_length[2]');
			$this->form_validation->set_rules('nip', 'NIP', 'required|min_length[10]');
		}

		if ($this->form_validation->run() == FALSE)
		{
			$data2['parent'] =  $this->frontside_model->get_product($parent,$idlang);
			if(isset($data2['parent'][0]))
				$data2['parent'] = $data2['parent'][0];
			$data2['child'] =  $this->frontside_model->get_product($child,$idlang);
			if(isset($data2['child'][0]))
				$data2['child'] = $data2['child'][0];
			$data2['complet'] =  $this->frontside_model->get_complet($parent,$child);
			if(isset($data2['complet'][0]))
				$data2['complet'] = $data2['complet'][0];
			$data2['idparent'] =  $parent;
			$data2['idchild'] =  $child;
			$data['content'] = $this->load->view('front/elements/order', $data2, true);
		}
		else
		{
			require_once 'files/Swift-4.0.5/lib/swift_required.php';

			$data2['parent'] =  $this->frontside_model->get_product($parent,$idlang);
			if(isset($data2['parent'][0]))
				$data2['parent'] = $data2['parent'][0];
			$data2['child'] =  $this->frontside_model->get_product($child,$idlang);
			if(isset($data2['child'][0]))
				$data2['child'] = $data2['child'][0];
			$data2['complet'] =  $this->frontside_model->get_complet($parent,$child);
			if(isset($data2['complet'][0]))
				$data2['complet'] = $data2['complet'][0];

			//Create the Transport
			$transport = Swift_SmtpTransport::newInstance('post.pl', 25)
				->setUsername('formularz@post.pl')
				->setPassword('ebl67aic')
			;

			//Create the Mailer using your created Transport
			$mailer = Swift_Mailer::newInstance($transport);
			//przygotowanie tresci wiadomosci
			$newline = chr(10);
			$tab = chr(9);
			$tresc_wiadomosci = 'Ilość:'.$tab.$tab.$_POST['count'].$newline;
			$tresc_wiadomosci .= 'Puffa/fotel:'.$tab.$data2['parent']['title'].$newline;
			$tresc_wiadomosci .= 'Cover:'.$tab.$tab.$data2['child']['title'].$newline.$newline;

			$tresc_wiadomosci .= 'Imię i nazwisko:'.$tab.$_POST['fname'].' '.$_POST['sname'].$newline;
			$tresc_wiadomosci .= 'Email:'.$tab.$tab.$tab.$_POST['email'].$newline;
			$tresc_wiadomosci .= 'Telefon:'.$tab.$tab.$_POST['phone'].$newline;
			$tresc_wiadomosci .= 'Adres:'.$newline.$_POST['address'].$newline.$newline;

			$tresc_wiadomosci .= 'Uwagi: '.$_POST['additional_data'].$newline.$newline.$newline;
			if(isset($_POST["invoice"])){
				$tresc_wiadomosci .= 'Klient zażyczył sobie faktury. Dane do faktury:'.$newline;
				$tresc_wiadomosci .= 'Nazwa firmy:'.$tab.$_POST['cname'].$newline;
				$tresc_wiadomosci .= 'NIP:'.$tab.$tab.$_POST['nip'].$newline;
				$tresc_wiadomosci .= 'Adres firmy:'.$newline.$_POST['caddress'].$newline.$newline;
			}
			//Create the message
			$message = Swift_Message::newInstance()
				->setSubject('Zamówienie '.$_POST['count'].' sztuk: '.$data2['parent']['title'].'+'.$data2['child']['title'])
				->setTo(array($emailTo))
				->setFrom('formularz@post.pl')
				->setBody($tresc_wiadomosci);

			$headers = $message->getHeaders();
			$headers->addTextHeader('Reply-to', 'xxxx');

			//Send the message
			$mailer->send($message);
			unset($_POST);
			$data2['token'] =  mt_rand(1111, 9999);
			$this->session->set_userdata('token', $data2['token']);
			$data['content'] = '<h1 class="department">Twoja wiadomość została wysłana.</h1>';

		}

		$list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
		$data['menu_poziom'] = $this->load->view('front/elements/menu_poziom', $list, true);

		$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);
		$this->load->view('front/layout/header', $metatags);
		$this->load->view('front/layout/content', $data);
		$this->load->view('front/layout/footer');
	}

    function register_afiliant($idlang = 3){
		$this->set_language($idlang);
		//praca nad artykułem

        $list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
        $article['menu_pion'] = $this->load->view('front/elements/menu_pion', $list, true);
        $article['site'] = $this->site;

        $list['content'] = $this->load->view('front/elements/register_afiliant', $article, true);
        $metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);

		$data['menu_poziom'] = $this->load->view('front/elements/menu_poziom', $list, true);

		$this->load->view('front/layout/header', $metatags);
		$this->load->view('front/layout/content', $data);
		$this->load->view('front/layout/footer');
	}
	 	
	function CheckNIP($str)
	{
		if (strlen($str) != 10)
		{
			return false;
		}
	 
		$arrSteps = array(6, 5, 7, 2, 3, 4, 5, 6, 7);
		$intSum=0;
		for ($i = 0; $i < 9; $i++)
		{
			$intSum += $arrSteps[$i] * $str[$i];
		}
		$int = $intSum % 11;
	 
		$intControlNr=($int == 10)?0:$int;
		if ($intControlNr == $str[9])
		{
			return true;
		}
		return false;
	}
	
	//funkcje stworzone specjalnie dla pokerinfo.net.pl
	private function get_baner($baner, $idlang = 3){
		$idparent = $this->poker_w_internecie_id;
		$return_data = $baner;
		$flag = 1;
		if(isset($baner)){
			if($baner != ''){
				$flag = 0;
			}
		}
		
		if($flag){
			$this->load->helper('array');
			$subarticles = $this->frontside_model->get_subarticles($idparent, $idlang);
			if(isset($subarticles[0])){
				$subarticle = random_element($subarticles);
				$return_data = 	$subarticle['additional_data'];
			}else{
				$return_data='';
			}
		}

		return $return_data;
	}
	
	//ksiega gosci - guest book
	function guest_book($id=99,$idlang = 3)
	{
		if(!empty($_POST['title']) and !empty($_POST['text']))
		{
			$this->frontside_model->add_guest(trim(strip_tags($_POST['title'])),trim(strip_tags($_POST['text'])));
		}
			
		
		$metatags = $this->get_metatags($this->get_standard_metatags('template',$idlang), $idlang);

		//newsy
		$news['newses'] = $this->frontside_model->get_newses($idlang,2);
		$data['news'] = $this->load->view('front/boxes/newses_box',$news,true);
		
		//menu glowne
		$list['menu_items'] = $this->frontside_model->get_menu_by_id($this->menu_poziom, $idlang);
		$data['menu_poziom'] = $this->load->view('front/elements/menu_poziom_trollandia', $list, true);
		
		$guests['guests']= $this->frontside_model->get_all_guests();
        
		$data['content'] = $this->load->view('front/elements/guest_book', $guests, true);
		$data['footer_content']      = $this->getFooterContent();
        $data['metatags']   = $metatags;

		$this->load->view('front/layout/header'  , $data);
		$this->load->view('front/layout/content' ,$data);
		$this->load->view('front/layout/footer',$data);
	}	
}
?>