<?php
class Admin extends Controller {
	//zmienna przechowująca języki stałych elementów strony(szczzególnie admina)
		//$this->config->load('lang_pl');
	var $site = null;
	
	//zmienne przechowujące wymiary miniaturek newsa i galerii
	var $news = array();
	var $product = array();
	var $gal_img = array();
	
//zapoznaj sie z zaladowanymi configami, bibliotekami, helperami itd
	function Admin(){
		parent::Controller();	
		$this->load->model('admin_model','',TRUE);
        $this->load->model('list_model');
        $this->load->model('immovable_model');

		$this->load->library('session');
		$this->load->helper('form');		
		$this->load->helper('url');
		
		//plik z jezykiem polskim
		$this->config->load('lang_pl');
		//rozmiary miniaturek
		$this->config->load('file');
		$this->site = $this->config->item('PL');
		$this->news = $this->config->item('news');
		$this->product = $this->config->item('product');
		$this->gal_img = $this->config->item('gal_img');
	}
	
	function index($idlang = 3){
		$data = $this->get_menus();
		$data['content'] = $this->check_login('index');
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
//inne funkcje		
	function login(){
		$user = $this->admin_model->login($this->input->post('login'),md5($this->input->post('password')));
		if(isset($user[0])){
			$user = $user[0];
			if($user['active']){
				$tabsessyjna = array(	'login'  => $this->input->post('login'),
			                   			'loggedin' => TRUE	,
										'idusers' => $user['idusers'],
										'idgroups' => $user['iduser_groups']
								);
				$this->session->set_userdata($tabsessyjna);		
			}
		}
		redirect('/admin', 'location');
	}
	
	function logout(){
		$this->session->unset_userdata('login');
		$this->session->unset_userdata('loggedin');
		$this->session->unset_userdata('idusers');
		$this->session->unset_userdata('idgroups');
		redirect('/admin', 'location');
	}
	
	//funkcja dba o aktualizowanie języka
	private function set_language($idlang){
		$lang = $this->admin_model->get_language_by_id($idlang);
		if(isset($lang)){
			$lang = $lang[0];
			$this->site = $this->config->item($lang['shortname']);
		}
		return $lang;
	}

	//funkcja sprawdza czy uzytkownik jest zalogowany, czy ma prawa dostępu do danego elementu
	private function check_login($elementname = '', $content = '', $bool=false){
		$idgroups   = $this->session->userdata('idgroups');
		$login      = $this->session->userdata('login');
		$loggedin   = $this->session->userdata('loggedin');
		
		if($login != null && $loggedin == true){
			$allowed_elements = $this->admin_model->get_elements_for_group($idgroups);
			if(isset($allowed_elements[0])){
				foreach($allowed_elements as $allowed_element){
					if($allowed_element['name'] == $elementname && $allowed_element['active'] == true){
						$flag = 1;
						break;
					}
				}
			}
		}
		// w zaleznosci od zmiennej $bool zwraca content albo wartosc booleanowska
		if($bool){
			if(isset($flag)){
				return true;
			}else{
				return false;
			}
		}else{
			if(isset($flag)){
				return $content;
			}else{
				if($elementname == 'index'){
					$content = $this->load->view('admin/layout/login','',true);
				}else{
					$content = ucfirst($this->site['nie_masz_uprawnien_do_tego_zasobu']);
				}
				return $content;
			}	
		}
	}
	
	function get_standard_metatags($type, $idlang){
		$result = $this->admin_model->get_default_metatags($type, $idlang);
		if(isset($result[0])){
			$result = $result[0];
		}else{
			$result = '';
		}
		return $result;
	}
	
	//pobiera metatagi danego typu w formacie jsona(potrzebne przy automatycznym ladowaniuu standardowych metatagow)	
	function get_json_meta($idmetatags){
		$result = $this->admin_model->get_metatag_by_id($idmetatags);
		if(isset($result[0])){
			$result = $result[0];
		}else{
			$result = '';
		}
		$data['metatags'] = json_encode($result);
		$this->load->view('admin/elements/metatags_json', $data);
	}
	
	function get_json_meta_types($idlangs){
		$results = $this->admin_model->get_metatag_types_languages_by_lang($idlangs);
		$result ='';
		if(isset($results[0])){
			foreach($results as $group){
				$result .= '<option value="'.$group['idmetatags'].'">'.$group['template'].'</option>';
			}
		}
		$result = array('content'=>$result);
		$data['metatags'] = json_encode($result);
		$this->load->view('admin/elements/metatags_json', $data);
	}
	
	//generowanie menu
	private function get_menus($layout = 'empty', $data=''){
		$idgroup = $this->session->userdata('idgroups');
		$result = '';
		if($idgroup != null){
			$result['menu_poziom'] = $this->generate_menu_poziom($idgroup);
			$result['menu_pion'] = 	$this->load->view('admin/elements/menus/menu_pion/'.$layout, $data, true);
		}
		return $result; 
	}
	
	private function generate_menu_poziom($idgroup){
		$data['elements'] = $this->admin_model->get_elements_for_group($idgroup);
		$content = $this->load->view('admin/elements/menus/menu_poziom', $data, true);		
		$data['content'] = $this->check_login('rights', $content);
		return $content;
	}

	private function generate_friendlyurl($url_before){
		$url_before = strtolower($url_before);
		$url_after = url_title($url_before, 'dash', TRUE);
		return $url_after;
	}
	
	//usunięcie całego katalogu razem z potomkami, potrzebne w galeriach
	private function full_rmdir($dirname){
        if ($dirHandle = opendir($dirname)){
            $old_cwd = getcwd();
            chdir($dirname);

            while ($file = readdir($dirHandle)){
                if ($file == '.' || $file == '..') continue;

                if (is_dir($file)){
                    if (!$this->full_rmdir($file)) return false;
                }else{
                    if (!unlink($file)) return false;
                }
            }

            closedir($dirHandle);
            chdir($old_cwd);
            if (!rmdir($dirname)) return false;

            return true;
        }else{
            return false;
        }
    }

//users
	function users($idlang = 3){	
		$data = $this->get_menus('users');	
		$list['users'] = $this->admin_model->get_users();
		$content = $this->load->view('admin/elements/users', $list, true);
		$data['content'] = $this->check_login('users', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
	function delete_user($id){
		$group = $this->session->userdata('group');
		$allow = $this->check_login('users', '', true);
		if($allow){
			$this->admin_model->delete_user($id);
		}				
		
		redirect('/admin/users', 'location');		
	}
	
	function add_user($idlang = 3){
		$allow = $this->check_login('users', '', true);
		$data = $this->get_menus('users');
		
		if($allow){			
			if(isset($_POST['login']) && $_POST['login'] != '' && isset($_POST['password']) && $_POST['password'] != ''){
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$data=array('idusers' => '',
							'iduser_groups' => $_POST['iduser_groups'],
							'fname' => $_POST['fname'],
							'lname' => $_POST['lname'],
							'login' => $_POST['login'],
							'password' => md5($_POST['password']),
							'active' => $active
				);
				$this->admin_model->add_user($data);
				redirect('/admin/users', 'location');	
			}else{
				//przygotowanie listy grup do boxa
				$groups = $this->admin_model->get_groups();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($groups as $group){
					$bufor1[$i]=$group['iduser_groups'];
					$bufor2[$i]=$group['name'];
					$i++;
				}
				$data['groups']=array_combine($bufor1,$bufor2);				
				
				$data['content'] = $this->load->view('admin/elements/add_user', $data, true);
				
				$group = $this->session->userdata('group');
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}

	function edit_user($id=null, $idlang = 3){
		$allow = $this->check_login('users', '', true);
		if($allow){			
			if(isset($_POST['login']) && $_POST['login'] != ''){
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$data=array('iduser_groups' => $_POST['iduser_groups'],
							'fname' => $_POST['fname'],
							'lname' => $_POST['lname'],
							'login' => $_POST['login'],
							'active' => $active
				);
				if(isset($_POST['password']) && $_POST['password']!=''){
					$data['password'] = md5($_POST['password']);
				}
				$this->admin_model->update_user($id,$data);
				unset($_POST);
				redirect('/admin/users', 'location');	
			}else{
				$data = $this->get_menus('users');
				$user = $this->admin_model->get_user_by_id($id);
				if(isset($user[0])){
					$user=$user[0];
					$data['idusers'] = $id;
					$data['iduser_groups'] = $user['iduser_groups'];
					$data['fname'] = $user['fname'];
					$data['lname'] = $user['lname'];
					$data['login'] = $user['login'];
					$data['active'] = $user['active'];
				//przygotowanie listy grup do boxa
					$bufor1=array($user['iduser_groups']);
					$bufor2=array('-----');
					$i = 1;
				}else{
					$bufor1=array();
					$bufor2=array();
					$i = 0;
				}
				$groups = $this->admin_model->get_groups();
				foreach($groups as $group){
					$bufor1[$i]=$group['iduser_groups'];
					$bufor2[$i]=$group['name'];
					$i++;
				}
				$data['groups']=array_combine($bufor1,$bufor2);
								
				$data['content'] = $this->load->view('admin/elements/edit_user', $data, true);
				
				$metatags = array();
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}

//galleries
	function galleries($idlang = 3){	
		$list['galleries'] = $this->admin_model->get_galleries();
		$list['gallery_languages'] = $this->admin_model->get_galleries_languages();
		
		$data = $this->get_menus('galleries');
		$content = $this->load->view('admin/elements/galleries', $list, true);
		$data['content'] = $this->check_login('galleries', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
	function gal_lang_versions($id = null){	
		if($id==null){	
			$list['galleries'] = $this->admin_model->get_galleries();
		}else{
			$list['galleries'] = $this->admin_model->get_gal_lang_versions($id);
		}
		$metatags = '';
		
		$data = $this->get_menus('galleries');
		
		//ten widok należy uzależnic od $idlang
		$content = $this->load->view('admin/elements/galleries', $list, true);
		$data['content'] = $this->check_login('galleries', $content);
		
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
	function delete_gallery($id){
		$allow = $this->check_login('galleries', '', true);
		if($allow){
			$this->admin_model->delete_gallery($id);
		}				
		redirect('/admin/galleries', 'location');		
	}
	
	function add_gallery($idlang = 3){
		$allow = $this->check_login('galleries', '', true);
		$data = $this->get_menus('galleries');
		if($allow){			
			if(isset($_POST['title'])){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$gal = array('idgalleries' => '',
							'showorder' => '',
							'active' => $active	
				);
				$this->admin_model->add_gallery($gal);				
				//przygotowanie folderu na fotki i miniaturki
				if(mkdir ("./files/img/galleries/".$this->db->insert_id(), 0777)){	
					chmod("./files/img/galleries/".$this->db->insert_id(), 0777);	
					mkdir ("./files/img/galleries/".$this->db->insert_id().'/min', 0777);
					chmod("./files/img/galleries/".$this->db->insert_id().'/min', 0777);	
					$gal_lang=array('idgalleries_languages' => '',
								'idgalleries' => $this->db->insert_id(),
								'idlanguages' => $_POST['idlanguage'],
								'title' => $_POST['title'],
								'content' => $_POST['artcontent'],
								'titleseo' => $_POST['seotitle'],
								'keywords' => $_POST['keywords'],
								'shortdesc' => $_POST['shortdesc'],
								'abstract' => $_POST['abstract'],
								'subject' => $_POST['subject'],
								'topic' => $_POST['topic'],
								'copyrights' => $_POST['copyrights'],
								'friendlyurl' => $friendlyurl
					);
					$this->admin_model->add_gallery_language($gal_lang);
				}else{
					$this->admin_model->delete_gallery($this->db->insert_id());
				}
				redirect('/admin/galleries', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];		
					$i++;								
				}
				$data['languages']=array_combine($bufor1,$bufor2);			
				$data['content'] = $this->load->view('admin/elements/add_gallery', $data, true);
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}

	function edit_gallery($id=null, $idlang = 3){
		$allow = $this->check_login('galleries', '', true);		
		if($allow){			
			if(isset($_POST['title'])){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
												
				$gal_lang=array('idgalleries_languages' => $_POST['idgalleries_languages'],
							'idgalleries' => $id,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_gallery_language($gal_lang['idgalleries_languages'], $gal_lang);
				redirect('/admin/galleries', 'location');	
			}else{
				$gallery = $this->admin_model->get_gallery_by_id($id,$idlang);
				if(isset($gallery[0])){
					$gallery = $gallery[0];
					$data = array(
							'idgalleries' => $gallery['idgalleries'],
							'active' => $gallery['active'],
							'idgalleries_languages' => $gallery['idgalleries_languages'],
							'idlanguages' => $gallery['idlanguages'],
							'title' => $gallery['title'],
							'content' => $gallery['content'],
							'titleseo' => $gallery['titleseo'],
							'keywords' => $gallery['keywords'],
							'shortdesc' => $gallery['shortdesc'],
							'abstract' => $gallery['abstract'],
							'subject' => $gallery['subject'],
							'topic' => $gallery['topic'],
							'copyrights' => $gallery['copyrights'],
							'friendlyurl' => $gallery['friendlyurl']
						);
					
					//przygotowanie listy jezykow do boxa
					$languages = $this->admin_model->get_languages();
					$bufor1	=	array($gallery['idlanguages']);
					$bufor2	=	array('-----');
					$i = 1;
					foreach($languages as $lang){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
					$data['languages']=array_combine($bufor1,$bufor2);
				}
				$cus = $this->get_menus('galleries');
				$data['menu_poziom'] = $cus['menu_poziom'];
				$data['menu_pion'] =$cus['menu_pion'];		
				
				$data['content'] = $this->load->view('admin/elements/edit_gallery', $data, true);
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function delete_gallery_language($idgal, $idgal_lang){
		$allow = $this->check_login('galleries', '', true);
		if($allow){
			$this->admin_model->delete_gallery_language($idgal_lang);
			$bufor = $this->admin_model->get_gal_lang_versions($idgal);
			if(!isset($bufor[0])){
				$data = $this->admin_model->get_data_to_delete_gallery($idgal);
				if(isset($data[0])){
					foreach($data as $img_lang){
						$this->admin_model->delete_image_language($img_lang['idimages_languages']);
					}
					foreach($data as $img){
						$this->admin_model->delete_image($img['idimages']);
					}
				}
				$this->admin_model->delete_gallery($idgal);
				$this->full_rmdir('./files/img/galleries/'.$idgal);
			}
		}
		redirect('/admin/galleries', 'location');		
	}
	
	function add_gallery_language($id=null, $idlang = 3){
		$allow = $this->check_login('galleries', '', true);
		$data = $this->get_menus('galleries');
		if($allow){			
			if(isset($_POST['title']) && $id != null){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}	
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
												
				$gal_lang=array('idgalleries_languages' => '',
							'idgalleries' => $id,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_gallery_language($gal_lang);
				redirect('/admin/galleries', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$used_langs = $this->admin_model->get_gal_lang_versions($id);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$flag = 1;
					foreach($used_langs as $used_lang){
						if($lang['idlanguages'] == $used_lang['idlanguages'])
						{
							$flag = 0;
							break;
						}
					}
					if($flag){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
				}
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);
					$data['id'] = $id;
					$data['idlang'] = $idlang;		
					$data['meta'] = $this->get_standard_metatags('gallery',$idlang);
					$data['content'] = $this->load->view('admin/elements/add_gallery_language', $data, true);
				}else{
					$data['content'] = $this->site['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}				
	}

	function edit_gallery_language($idgal_lang, $idgal, $idlang){
		$allow = $this->check_login('galleries', '', true);
		if($allow){			
			if(isset($_POST['title'])){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}	
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
												
				$gal_lang=array('title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_gallery_language($idgal_lang, $gal_lang);
				redirect($_SERVER['HTTP_REFERER'], 'location');	
			}else{
				$gallery = $this->admin_model->get_gallery_by_id($idgal,$idlang);
				if(isset($gallery[0])){
					$gallery = $gallery[0];
					$data = array(
							'idgalleries_languages' => $gallery['idgalleries_languages'],
							'active' => $gallery['active'],
							'idlanguages' => $gallery['idlanguages'],
							'title' => $gallery['title'],
							'content' => $gallery['content'],
							'titleseo' => $gallery['titleseo'],
							'keywords' => $gallery['keywords'],
							'shortdesc' => $gallery['shortdesc'],
							'abstract' => $gallery['abstract'],
							'subject' => $gallery['subject'],
							'topic' => $gallery['topic'],
							'copyrights' => $gallery['copyrights'],
							'friendlyurl' => $gallery['friendlyurl']
						);
						
					//przygotowanie listy jezykow do boxa
					$languages = $this->admin_model->get_languages();
					$bufor1	=	array($gallery['idlanguages']);
					$bufor2	=	array('-----');
					$i = 1;
					foreach($languages as $lang){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
					$data['languages']=array_combine($bufor1,$bufor2);
				}
				$data['idgal_lang'] = $idgal_lang;
				$data['idgal'] = $idgal;
				$data['idlang'] = $idlang;		
				
				
				$cus = $this->get_menus('galleries');
				$data['menu_pion'] = $cus['menu_pion'];
				$data['menu_poziom'] = $cus['menu_poziom'];
				$data['content'] = $this->load->view('admin/elements/edit_gallery_language', $data, true);
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}				
	}

	function change_gallery_priority($id){
		$allow = $this->check_login('galleries', '', true);
		if($allow){
			$showorder = $_POST['priority'];
			$data=array( 'showorder' => $showorder);
			$this->admin_model->update_gallery($id, $data);
		}		
		redirect('/admin/galleries', 'location');		
	}

//images
	function show_gallery($id, $idlang){	
		$list['images']          =  $this->admin_model->get_gallery_images($id);
		$list['image_languages'] =  $this->admin_model->get_img_lang_versions();
		$list['idgalleries']     =  $id;
		$list['idlang']          =  $idlang;
		
		$data = $this->get_menus('images');
		$content = $this->load->view('admin/elements/show_gallery', $list, true);
		$data['content'] = $this->check_login('images', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}	
	
	function add_image($idgal, $idlang = 3){
		$allow = $this->check_login('images', '', true);
		$data = $this->get_menus('images');
		if($allow){			
			if(isset($_POST['title']) && isset($_FILES['file']['name']) && $_FILES['file']['name']!=''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				//dodawanie obrazka
				//uploadowanie pliku
				$config['upload_path'] = './files/img/galleries/'.$idgal;
				$config['allowed_types'] = 'gif|jpg|png';
				$config['remove_spaces'] = TRUE;		
				
				$this->load->library('upload', $config);
				$this->upload->do_upload('file');
				$file_data = $this->upload->data();
				//zmiana praw pliku
				chmod('./files/img/galleries/'.$idgal.'/'.$file_data['file_name'], 0777);
				//tworzenie miniaturki
				$img_config['image_library'] = 'gd2';
				$img_config['source_image'] = './files/img/galleries/'.$idgal.'/'.$file_data['file_name'];
				$img_config['new_image'] = './files/img/galleries/'.$idgal.'/min/';
				$img_config['maintain_ratio'] = TRUE;
				$img_config['width'] = $this->gal_img['width'];
				$img_config['height'] = $this->gal_img['height'];
				$this->load->library('image_lib', $img_config);
				$this->image_lib->resize();
				if ( ! $this->image_lib->resize()){
				    echo $this->image_lib->display_errors();
				}	
					
				
				$gal = array('idimages' => '',
							'idgalleries' => $idgal,
							'path'	=> $file_data['file_name'],
							'active' => $active	
				);
				
				$this->admin_model->add_image($gal);				
				$gal_lang=array('idimages_languages' => '',
							'idimages' => $this->db->insert_id(),
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_image_language($gal_lang);
				redirect($_SERVER['HTTP_REFERER'], 'location');	
			}else{
				//przygotowanie metatagów
				$gal_data = $this->admin_model->get_gallery_by_id($idgal, $idlang);
				if(isset($gal_data[0])){
					$data['metatags'] = $gal_data[0];					
				}else{
					$data['metatags'] = array('title' => '',
					'titleseo' => '',
					'artcontent' => '',
					'keywords' => '',
					'shortdesc' => '',
					'abstract' => '',
					'subject' => '',
					'topic' => '',
					'copyrights' => '',
					'friendlyurl' => ''
					);
				}
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				$data['languages'] = array_combine($bufor1,$bufor2);
				$data['idgal'] = $idgal;
				$data['idlang'] = $idlang;				
				$data['meta'] = $this->get_standard_metatags('image',$idlang);
				$data['content'] = $this->load->view('admin/elements/add_img', $data, true);
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function add_multiimage($idgal, $idlang = 3){
		//$allow = $this->check_login('images', '', true);
		//if($allow){
        //
            $fileName = $_FILES['Filedata']['name'];
            $fileName = date("Y_m_d-H_i_s_u").".jpg";

			//dodawanie obrazka
			move_uploaded_file($_FILES['Filedata']['tmp_name'], './files/img/galleries/'.$idgal.'/'.$fileName);
			//zmiana praw pliku
			chmod('./files/img/galleries/'.$idgal.'/'.$fileName, 0777);
			//tworzenie miniaturki
			$img_config['image_library'] = 'GD2';
			$img_config['source_image'] = './files/img/galleries/'.$idgal.'/'.$fileName;
			$img_config['new_image'] = './files/img/galleries/'.$idgal.'/min/';
			$img_config['maintain_ratio'] = true;
			$img_config['width'] = $this->gal_img['width'];
			$img_config['height'] = $this->gal_img['height'];
			$this->load->library('image_lib', $img_config);
			$this->image_lib->resize();
			if ( ! $this->image_lib->resize()){
			    echo $this->image_lib->display_errors();
			}	
				
			$gal = array('idimages' => '',
						'idgalleries' => $idgal,
						'path'	=> $fileName,
						'active' => true	
			);
			
			$this->admin_model->add_image($gal);

            $title = explode(".",$_FILES['Filedata']['name']); //default
            if(isset($title[0]))
                $title = ucfirst($title[0]);
            else
                $title = "";

            $lastDotIndex = strripos($_FILES['Filedata']['name'], '.');
            if($lastDotIndex > 0)
                $title = ucfirst(substr($_FILES['Filedata']['name'],0,$lastDotIndex));
            


			$gal_lang=array('idimages_languages' => '',
						'idimages' => $this->db->insert_id(),
						'idlanguages' => $idlang,
						'title' => $title,
						'content' => '',
						'titleseo' => '',
						'keywords' => '',
						'shortdesc' => '',
						'abstract' => '',
						'subject' => '',
						'topic' => '',
						'copyrights' => '',
						'friendlyurl' => ''
			);
			$this->admin_model->add_image_language($gal_lang);
			
		//}					
	}
	
	function add_image_language($id=null, $idgal=null, $idlang = 3){
		$allow = $this->check_login('images', '', true);
		$data = $this->get_menus('images');
		if($allow){			
			if(isset($_POST['title']) && $id != null){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
					
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
												
				$gal_lang=array('idimages_languages' => '',
							'idimages' => $id,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_image_language($gal_lang);
				redirect($_SERVER['HTTP_REFERER'], 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$used_langs = $this->admin_model->get_img_lang_versions_by_id($id);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$flag = 1;
					foreach($used_langs as $used_lang){
						if($lang['idlanguages'] == $used_lang['idlanguages'])
						{
							$flag = 0;
							break;
						}
					}
					if($flag){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
				}
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);
					$data['id'] = $id;
					$data['idgal'] = $idgal;	
					$data['idlang'] = $idlang;		
					$data['meta'] = $this->get_standard_metatags('image',$idlang);
					$data['content'] = $this->load->view('admin/elements/add_image_language', $data, true);
				}else{
					$data['content'] = $this->site['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}				
	}

	function delete_image_language($idimg_lang, $idimg, $idgal, $idlang=3){
		$allow = $this->check_login('images', '', true);
		if($allow){
			$this->admin_model->delete_image_language($idimg_lang);
			
			$bufor = $this->admin_model->get_img_lang_versions_by_id($idimg);
			//print_r($bufor);
			if(!isset($bufor[0])){
				$image = $this->admin_model->get_image_by_id($idimg);
				if(isset($image[0])){
					$this->admin_model->delete_image($idimg);
					@unlink("./files/img/galleries/".$idgal.'/'.$image[0]['path']);
					@unlink("./files/img/galleries/".$idgal.'/min/'.$image[0]['path']);
				}
			}
		}				
		redirect('/admin/show_gallery/'.$idgal.'/'.$idlang, 'location');		
	}

    function edit_gallery_min_image()
    {
        if(empty($_POST['idimages']) || empty($_FILES['min_image']['name']))
        {
            if(empty($_POST['return_url']))
                redirect("admin");
            else
                redirect($_POST['return_url']);
        }

        $idimages = (int)$_POST['idimages'];
        $image = $this->admin_model->get_image_by_id($idimages);
        
        if(!empty($image) && is_array($image))
        {
            $image = $image[0];
            $idgalleries = $image['idgalleries'];
            @unlink("./files/img/galleries/".$idgalleries."/min/".$image['path']);

            $config['upload_path'] = './files/img/galleries/'.$idgalleries.'/min/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['remove_spaces'] = TRUE;

            $this->load->library('upload', $config);
            if(!$this->upload->do_upload('min_image'))
                echo $this->upload->display_errors();
            
            $file_data = $this->upload->data();

            //zmiana praw pliku
            chmod('./files/img/galleries/'.$idgalleries.'/min/'.$file_data['file_name'], 0777);
            rename('./files/img/galleries/'.$idgalleries.'/min/'.$file_data['file_name'], './files/img/galleries/'.$idgalleries.'/min/'.$image['path']);

        }
        redirect($_POST['return_url']);
    }

	function edit_image_language($idimg_lang, $idgal, $idlang){
		$allow = $this->check_login('images', '', true);		
		if($allow){			
			if(isset($_POST['title'])){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
															
				$gal_lang=array('idimages_languages' => $idimg_lang,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_image_language($gal_lang['idimages_languages'], $gal_lang);
				//redirect($_SERVER['HTTP_REFERER'], 'location');
                redirect('/admin/show_gallery/'.$idgal.'/'.$idlang, 'location', 301);
			}else{
				$image = $this->admin_model->get_image_lang_by_id($idimg_lang);
				if(isset($image[0])){
					$image = $image[0];
					$data = array(
							'idimages_languages' => $image['idimages_languages'],
							'active' => $image['active'],
							'idimages_languages' => $image['idimages_languages'],
							'idlanguages' => $image['idlanguages'],
							'title' => $image['title'],
							'content' => $image['content'],
							'titleseo' => $image['titleseo'],
							'keywords' => $image['keywords'],
							'shortdesc' => $image['shortdesc'],
							'abstract' => $image['abstract'],
							'subject' => $image['subject'],
							'topic' => $image['topic'],
							'copyrights' => $image['copyrights'],
							'friendlyurl' => $image['friendlyurl']
						);
									
					//przygotowanie listy jezykow do boxa
					$languages = $this->admin_model->get_languages();
					$bufor1=array($image['idlanguages']);
					$bufor2=array('-----');
					$i = 1;
					foreach($languages as $lang){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
					$data['languages']=array_combine($bufor1,$bufor2);
				}
				$cus = $this->get_menus('images');
				$data['menu_poziom'] = $cus['menu_poziom'];
				$data['menu_pion'] =$cus['menu_pion'];
				$data['idgallery'] = $idgal;	
				$data['idlang'] = $idlang;		
				$data['content'] = $this->load->view('admin/elements/edit_image', $data, true);
				
				$group = $this->session->userdata('group');
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}

	function change_image_priority($id, $idgal){
		$allow = $this->check_login('images', '', true);
		if($allow){
			$showorder = $_POST['priority'];
			$data=array( 'showorder' => $showorder);
			$this->admin_model->update_image($id, $data);
		}		
		redirect($_SERVER['HTTP_REFERER'], 'location');		
	}

//metatagi
	function metatags($idlang = 3){	
		$list['metatags'] = $this->admin_model->get_metatags();
		$list['languages'] = $this->admin_model->get_languages();
		$list['types'] = $this->admin_model->get_metatag_types();
		
		$data = $this->get_menus('metatags');
		$content = $this->load->view('admin/elements/metatags', $list, true);
		$data['content'] = $this->check_login('metatags', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
	function add_metatag( $idlang = 3){
		$allow = $this->check_login('metatags', '', true);
		$data = $this->get_menus('metatags');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				$data=array('idmetatags' => '',
							'idmetatag_types' => $_POST['idmetatag_types'],
							'idlanguages' => $_POST['idlanguage'],
							'template' => $_POST['name'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights']
				);
				$this->admin_model->add_metatags($data);
				unset($_POST);
				redirect('/admin/metatags', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);			
				}
				
				//szablony do boxa
				$types = $this->admin_model->get_metatag_types();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($types as $type){
					$bufor1[$i]=$type['idmetatag_types'];
					$bufor2[$i]=$type['name'];
					$i++;
				}
				if($bufor1!=array() && $bufor2!=array()){			
					$data['types']=array_combine($bufor1,$bufor2);			
				}
				
				$data['content'] = $this->load->view('admin/elements/add_metatag', $data, true);
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function edit_metatag($id = null,$idlang = 3){
		$allow = $this->check_login('metatags', '', true);
		$data = $this->get_menus('metatags');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				$data=array('idmetatags' => $id,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights']
				);
				$this->admin_model->update_metatag($id,$data);
				unset($_POST);
				redirect('/admin/metatags', 'location');	
			}else{
				$meta = $this->admin_model->get_metatag_by_id($id);
				$meta = $meta[0];
				$data['metatag'] = array('idmetatags' => $id,
										'idlanguages' => $meta['idlanguages'],
										'title' => $meta['title'],
										'keywords' => $meta['keywords'],
										'shortdesc' => $meta['shortdesc'],
										'abstract' => $meta['abstract'],
										'subject' => $meta['subject'],
										'topic' => $meta['topic'],
										'copyrights' => $meta['copyrights']
								);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}				
				$data['languages'] = array_combine($bufor1,$bufor2);
				
				$data['id']= $id;
				$data['content'] = $this->load->view('admin/elements/edit_metatag', $data, true);	
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function delete_metatags($id = null){
		$allow = $this->check_login('metatags', '', true);
		if($allow){
			if($id != null){
				$this->admin_model->delete_metatags($id);
			}
		}		
		redirect('/admin/metatags', 'location');		
	}

//newses	
	function newses($idlang = 3){	
		$list['newses'] = $this->admin_model->get_newses();
		$list['news_languages'] = $this->admin_model->get_news_languages();
		
		$data = $this->get_menus('newses');
		$content = $this->load->view('admin/elements/newses', $list, true);
		$data['content'] = $this->check_login('newses', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
	function change_news_priority($id){
		$allow = $this->check_login('newses', '', true);
		if($allow){
			$showorder = $_POST['priority'];
			$data=array( 'showorder' => $showorder);
			$this->admin_model->update_news($id, $data);
		}				
		
		redirect('/admin/newses', 'location');		
	}

	function delete_news_language($idnews, $idnews_language){
		$allow = $this->check_login('newses', '', true);
		if($allow){
			$this->admin_model->delete_news_language($idnews_language);
			$data = $this->admin_model->get_news_languages_by_idnewses($idnews);
			if(!isset($data[0])){
				$photo = $this->admin_model->get_newses_by_id($idnews);
				if(isset($photo[0]['image']) && $photo[0]['image'] != ''){
					unlink('./files/img/newses/'.$photo[0]['image']);
					unlink('./files/img/newses/min/'.$photo[0]['image']);					
				}
				$this->admin_model->delete_news($idnews);	
			}
		}
		redirect('/admin/newses', 'location');		
	}
	
	function add_news($idlang = 3){
		$allow = $this->check_login('newses', '', true);
		$data = $this->get_menus('newses');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				$file_data = array('file_name' => ''); 	
				if(isset($_FILES['file']) && $_FILES['file']['name']!=''){
					//uploadowanie pliku
					$config['upload_path'] = './files/img/newses/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('file');
					$file_data = $this->upload->data();
					//zmiana praw pliku
					chmod('./files/img/newses/'.$file_data['file_name'], 0777);
					//tworzenie miniaturki
					$img_config['image_library'] = 'gd2';
					$img_config['source_image'] = './files/img/newses/'.$file_data['file_name'];
					$img_config['new_image'] = './files/img/newses/min/';
					$img_config['maintain_ratio'] = TRUE;
					$img_config['width'] = $this->news['width'];
					$img_config['height'] = $this->news['height'];
					$this->load->library('image_lib', $img_config);
					$this->image_lib->resize();
					if ( ! $this->image_lib->resize()){
					    echo $this->image_lib->display_errors();
					}	
				}
				
				$data=array('idnewses' => '',
							'image' => $file_data['file_name'],
							'date' => date('c'),
							'showorder' => '',
							'active' => $active
				);
				$this->admin_model->add_news($data);
				$data=array('idnews_languages' => '',
							'idnewses' => $this->db->insert_id(),
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_news_language($data);
				redirect('/admin/newses', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				$data['languages']=array_combine($bufor1,$bufor2);		
				$data['meta'] = $this->get_standard_metatags('news',$idlang);
				$data['content'] = $this->load->view('admin/elements/add_news', $data, true);	
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function add_news_language($id_newses, $idlang = 3){
		$allow = $this->check_login('newses', '', true);
		$data = $this->get_menus('newses');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				
				$data=array('idnews_languages' => '',
							'idnewses' => $id_newses,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_news_language($data);
				redirect('/admin/newses', 'location');	
			}else{
				$data['id_newses'] = $id_newses;
				//przygotowanie listy jezykow do boxa
				//przygotowanie listy jezykow do boxa
				$used_langs = $this->admin_model->get_news_languages_by_idnewses($id_newses);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$flag = 1;
					foreach($used_langs as $used_lang){
						if($lang['idlanguages'] == $used_lang['idlanguages'])
						{
							$flag = 0;
							break;
						}
					}
					if($flag){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
				}	
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);		
					$data['meta'] = $this->get_standard_metatags('news',$idlang);
					$data['content'] = $this->load->view('admin/elements/add_news_language', $data, true);	
				}else{
					$data['content'] = $this->site['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}

	function edit_news_language($idnews_languages, $idlang = 3){
		if($idnews_languages != null){
			$allow = $this->check_login('newses', '', true);
			$data2 = $this->get_menus('newses');
			if($allow){			
				if(isset($_POST['title']) && $_POST['title'] != ''){
					if($_POST['friendlyurl'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
					}else{
						if($_POST['seotitle'] != ''){
							$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
						}else{
							$friendlyurl = $this->generate_friendlyurl($_POST['title']);
						}
					}
					
					$active = false;
					if(isset($_POST['active'])){
						$active = true;
					}
					if(isset($_FILES) && $_FILES['file']['name']!=''){
						$photo = $this->admin_model->get_newses_by_id($_POST['idnewses']);
						if(isset($photo[0]) && $photo[0]['image']!=''){
							unlink('./files/img/newses/'.$photo[0]['image']);
							unlink('./files/img/newses/min/'.$photo[0]['image']);
						}
						//uploadowanie pliku
						$config['upload_path'] = './files/img/newses/';
						$config['allowed_types'] = 'gif|jpg|png';
						$config['remove_spaces'] = TRUE;		
						
						$this->load->library('upload', $config);
						$this->upload->do_upload('file');
						$file_data = $this->upload->data();
						
						//tworzenie miniaturki
						$img_config['image_library'] = 'GD2';
						$img_config['source_image'] = './files/img/newses/'.$file_data['file_name'];
						$img_config['new_image'] = './files/img/newses/min/';
						$img_config['maintain_ratio'] = TRUE;
						$img_config['width'] = $this->news['width'];
						$img_config['height'] = $this->news['height'];
						$this->load->library('image_lib', $img_config);
						$this->image_lib->resize();
						if ( ! $this->image_lib->resize()){
						    echo $this->image_lib->display_errors();
						}	
						$data = array('image'=> $file_data['file_name']);
						$this->admin_model->update_news($_POST['idnewses'], $data);
					}
					
					$data=array('active' => $active);
					$this->admin_model->update_news($_POST['idnewses'], $data);
					
					$data=array('idlanguages' => $_POST['idlanguage'],
								'title' => $_POST['title'],
								'content' => $_POST['artcontent'],
								'titleseo' => $_POST['seotitle'],
								'keywords' => $_POST['keywords'],
								'shortdesc' => $_POST['shortdesc'],
								'abstract' => $_POST['abstract'],
								'subject' => $_POST['subject'],
								'topic' => $_POST['topic'],
								'copyrights' => $_POST['copyrights'],
								'friendlyurl' => $friendlyurl
					);
					$this->admin_model->update_news_language($idnews_languages, $data);
					
					redirect('/admin/newses', 'location');	
				}else{
					//przygotowanie danych
					$news = $this->admin_model->get_news_lang_by_id($idnews_languages);
					if(isset($news[0])){
						$news = $news[0];	
						
						$data = array(	'idnews_languages' => $idnews_languages,
										'idnewses' => $news['idnewses'],
										'title' => $news['title'],
										'content' => $news['content'],
										'titleseo' => $news['titleseo'],
										'keywords' => $news['keywords'],
										'shortdesc' => $news['shortdesc'],
										'abstract' => $news['abstract'],
										'subject' => $news['subject'],
										'topic' => $news['topic'],
										'copyrights' => $news['copyrights'],
										'friendlyurl' => $news['friendlyurl'],
										'active' => $news['active']
									);		
						
						//przygotowanie listy jezykow do boxa
						$languages = $this->admin_model->get_languages();
						$bufor1=array($news['idlanguages']);
						$bufor2=array('---');
						$i = 1;
						foreach($languages as $lang){
							$bufor1[$i]=$lang['idlanguages'];
							$bufor2[$i]=$lang['shortname'];
							$i++;
						}
						$data['languages']=array_combine($bufor1,$bufor2);
						
						
						$data2['content'] = $this->load->view('admin/elements/edit_news_language', $data, true);	
						
						$metatags = $this->get_standard_metatags('admin',$idlang);
						$this->load->view('admin/layout/header', $metatags);
						$this->load->view('admin/layout/admin',$data2);
					}else{
						redirect($_SERVER['HTTP_REFERER'], 'location');
					}
				}
			}		
		}else{
			redirect('/admin/newses', 'location');
		}
	}

//articles	
	function articles($idlang = 3){	
		$list['language'] = $this->set_language($idlang);
		$list['articles'] = $this->admin_model->get_articles();
		
		$list['article_languages'] = $this->admin_model->get_article_languages();
		$list['site'] = $this->site;
		
		//przygotowanie listy jezykow do boxa
		$languages = $this->admin_model->get_languages();
		$i = 0;
		foreach($languages as $lang){
			$bufor1[$i]=$lang['idlanguages'];
			$bufor2[$i]=$lang['fullname'];
			$i++;
		}
		$list['languages'] = array_combine($bufor1,$bufor2);

        //przygotowanie listy gallerii
		$galleries = $this->admin_model->get_galleries();
		$galleries_languages = $this->admin_model->get_galleries_languages();
		$list['galleries'] = array();
		foreach($galleries as $gallery){
			foreach($galleries_languages as $galleries_language){
				if($gallery['idgalleries'] == $galleries_language['idgalleries']){
					$list['galleries'][$gallery['idgalleries']] = $galleries_language['title'];
					break;
				}
			}
		}

        //przygotowane listy
		$list['lists'] = $this->list_model->getParents();


		$data = $this->get_menus('articles');
		$content = $this->load->view('admin/elements/articles', $list, true);
		$data['content'] = $this->check_login('articles', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
	function change_article_priority($id){
		$allow = $this->check_login('articles', '', true);
		if($allow){
			$showorder = $_POST['priority'];
			$data=array( 'showorder' => $showorder);
			$this->admin_model->update_article($id, $data);
		}				
		redirect('/admin/articles', 'location');		
	}
	function add_article($idparent = null, $idlang = 3){
		$allow = $this->check_login('articles', '', true);
		$data = $this->get_menus('articles');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				$files = array('image1'=>'','image2'=>'');

				if(isset($_FILES['image1']) && $_FILES['image1']['name']!=''){
					//uploadowanie pliku
					$config['upload_path'] = './files/img/articles/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('image1');

					$file_data          = $this->upload->data();
                    $files['image1']    =   $file_data['file_name'];

					//zmiana praw pliku
					chmod('./files/img/articles/'. $files['image1'] , 0777);
                    rename('./files/img/lists/'. $files['image1'] , './files/img/lists/'.date("Y_m_d-H_i_s")."_1.jpg");
                    $files['image1']      = '/files/img/lists/'.date("Y_m_d-H_i_s_u")."_1.jpg";
				}

				if(isset($_FILES['image2']) && $_FILES['image2']['name']!=''){
					//uploadowanie pliku
					$config['upload_path'] = './files/img/articles/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('image2');
					$file_data = $this->upload->data();
					$file_data          = $this->upload->data();
                    $files['image2']    =   $file_data['file_name'];                    
					//zmiana praw pliku
					chmod('./files/img/articles/'.$files['image2'], 0777);
                    rename('./files/img/lists/'. $files['image2'] , './files/img/lists/'.date("Y_m_d-H_i_s")."_2.jpg");
                    $files['image2']      = '/files/img/lists/'.date("Y_m_d-H_i_s_u")."_2.jpg";
				}

				$data=array('idarticles' => '',
							'image1' => $files['image1'],
                            'image2' => $files['image2'],
							'date' => date('c'),
							'idparent' => $idparent,
							'active' => $active
				);
				$this->admin_model->add_article($data);
				$data=array('idarticle_languages' => '',
							'idarticles' => $this->db->insert_id(),
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_article_language($data);
				redirect('/admin/articles', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				$data['languages']=array_combine($bufor1,$bufor2);
				$data['meta'] = $this->get_standard_metatags('article',$idlang);
				$data['idparent'] = $idparent;				
				$data['content'] = $this->load->view('admin/elements/add_article', $data, true);	
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function delete_article_language($idarticle){
		$allow = $this->check_login('articles', '', true);
		if($allow){
			$idarticle_language = $_POST['idarticle_languages'];
			$this->admin_model->delete_article_language($idarticle_language);
			$data = $this->admin_model->get_article_languages_by_idarticles($idarticle);
			if(!isset($data[0])){
				$deleted_article = $this->admin_model->get_article_by_id($idarticle);
				$this->admin_model->delete_article($idarticle);	
				//kasacja fotek
				if(isset($deleted_article[0]) && $deleted_article[0]['image']!=''){
						unlink('./files/img/articles/'.$deleted_article[0]['image']);
						unlink('./files/img/articles/min/'.$deleted_article[0]['image']);
					}
				//zmiana id parenta u potomkow
				$update_data = array( 'idparent' => $deleted_article[0]['idparent'] );
				$this->admin_model->update_change_article_parent($idarticle,$update_data);
			}
		}
		redirect('/admin/articles', 'location');	
	}
	
	function add_article_language($id_articles, $idlang = 3){
		$allow = $this->check_login('articles', '', true);
		$data = $this->get_menus('articles');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				
				$data=array('idarticle_languages' => '',
							'idarticles' => $id_articles,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_article_language($data);
				redirect('/admin/articles', 'location');	
			}else{
				$data['id_articles'] = $id_articles;
				//przygotowanie listy jezykow do boxa
				$used_langs = $this->admin_model->get_article_languages_by_idarticles($id_articles);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$flag = 1;
					foreach($used_langs as $used_lang){
						if($lang['idlanguages'] == $used_lang['idlanguages'])
						{
							$flag = 0;
							break;
						}
					}
					if($flag){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
				}	
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);		
					$data['meta'] = $this->get_standard_metatags('article',$idlang);
					$data['content'] = $this->load->view('admin/elements/add_article_language', $data, true);	
				}else{
					$data['content'] = $this->site['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function edit_article_language($idlang = 3){
		$allow = $this->check_login('articles', '', true);
		$data2 = $this->get_menus('articles');

		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$idarticle_languages = $_POST['idarticle_languages'];



                //IMAGE 1
				if(isset($_FILES['image1']['name']) && !empty($_FILES['image1']['name'])){
					$photo = $this->admin_model->get_article_by_id($_POST['idarticles']);
					if(isset($photo[0]) && $photo[0]['image1']!=''){
						@unlink('./files/img/articles/'.$photo[0]['image1']);
						@unlink('./files/img/articles/min/'.$photo[0]['image1']);
					}
					//uploadowanie pliku
					$config['upload_path'] = './files/img/articles/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('image1');
					$file_data = $this->upload->data();


                    chmod('./files/img/articles/'.$file_data['file_name'], 0777);
                    rename('./files/img/articles/'.$file_data['file_name'], './files/img/articles/'.date("Y_m_d-H_i_s_u")."_1.jpg");

					$data = array('image1'=> date("Y_m_d-H_i_s_u")."_1.jpg");
					$this->admin_model->update_article($_POST['idarticles'], $data);
				}

                //IMAGE 2
				if(isset($_FILES['image2']['name']) && !empty($_FILES['image2']['name'])){
					$photo = $this->admin_model->get_article_by_id($_POST['idarticles']);
					if(isset($photo[0]) && $photo[0]['image2']!=''){
						@unlink('./files/img/articles/'.$photo[0]['image2']);
						@unlink('./files/img/articles/min/'.$photo[0]['image2']);
					}
					//uploadowanie pliku
					$config['upload_path'] = './files/img/articles/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;

					$this->load->library('upload', $config);
					$this->upload->do_upload('image2');
					$file_data = $this->upload->data();

                    chmod('./files/img/articles/'.$file_data['file_name'], 0777);
                    rename('./files/img/articles/'.$file_data['file_name'], './files/img/articles/'.date("Y_m_d-H_i_s_u")."_2.jpg");

					$data = array('image2'=> date("Y_m_d-H_i_s_u")."_2.jpg");
					$this->admin_model->update_article($_POST['idarticles'], $data);
				}

				$data=array('active' => $active);
				$this->admin_model->update_article($_POST['idarticles'], $data);
				
				$data=array('idlanguages' => $_POST['idlanguage'],
                            'idlists' => $_POST['idlists'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_article_language($idarticle_languages, $data);
				
				redirect('/admin/articles', 'location');	
			}else{
				$idarticle_languages = $_POST['idarticle_languages'];
				//przygotowanie danych
				$article = $this->admin_model->get_article_lang_by_id($idarticle_languages);
				if(isset($article[0])){
					$article = $article[0];
                    
					
					$data = array(	'idarticle_languages' => $idarticle_languages,
									'idarticles' => $article['idarticles'],
                                    'idlists' => $article['idlists'],
									'title' => $article['title'],
                                    'image1' => $article['image1'],
                                    'image2' => $article['image2'],
									'content' => $article['content'],
									'titleseo' => $article['titleseo'],
									'keywords' => $article['keywords'],
									'shortdesc' => $article['shortdesc'],
									'abstract' => $article['abstract'],
									'subject' => $article['subject'],
									'topic' => $article['topic'],
									'copyrights' => $article['copyrights'],
									'friendlyurl' => $article['friendlyurl'],
									'additional_data' => $article['additional_data'],
									'active' => $article['active']
								);		
					
					//przygotowanie listy jezykow do boxa
					$languages = $this->admin_model->get_languages();
					$bufor1=array($article['idlanguages']);
					$bufor2=array('---');
					$i = 1;
					foreach($languages as $lang){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
					$data['languages']=array_combine($bufor1,$bufor2);


                    $list = $this->list_model->getAll();
                    $bufor1=array($article['idlists']);
					$bufor2=array(' ');
					foreach($list as $lang){
						$bufor1[$i]=$lang['id'];
						$bufor2[$i]=$lang['name'];
						$i++;
					}
					$data['list']=array_combine($bufor1,$bufor2);

					$data2['content'] = $this->load->view('admin/elements/edit_article_language', $data, true);	
					
					$metatags = $this->get_standard_metatags('admin',$idlang);
					$this->load->view('admin/layout/header', $metatags);
					$this->load->view('admin/layout/admin',$data2);
				}else{
					redirect('/admin/articles', 'location');
				}
			}
		}	
	}
    //ajax function
    function del_article_image($articleId,$imageNr)
    {
        $imageNr = (int)$imageNr;
        if($imageNr != 1 && $imageNr != 2)
        {
            echo "błędna wartość parametru";
            return;
        }

        $article = $this->admin_model->get_article_by_id($articleId);
        if(!empty($article) && is_array($article))
        {
            $article  = $article[0];
            $file     = '/files/img/articles/'.$article['image'.$imageNr];
            if(file_exists('.'.$file))
            {
                $data['image'.$imageNr] = "";
                if(unlink('.'.$file))
                {
                    $this->admin_model->update_article($articleId, $data);
                    echo 1;
                    return;
                }
            }
            else
            {
                echo "Wskazany plik : ".$file." nie istnieje";
                return;
            }
        }
        echo "Nie pobrano artykułu o wskazanym id";
    }
//menu
	function menus($idlang = 3){
		$list['menus'] = $this->admin_model->get_menus();
		$list['menu_items'] = $this->admin_model->get_menu_items();
		
		$data = $this->get_menus('menus');
		$list['site'] = $this->site;
		
		//przygotowanie listy jezykow do boxa
		$languages = $this->admin_model->get_languages();
		$i = 0;
		foreach($languages as $lang){
			$bufor1[$i]=$lang['idlanguages'];
			$bufor2[$i]=$lang['fullname'];
			$i++;
		}
		$list['languages'] = array_combine($bufor1,$bufor2);
		
		$content = $this->load->view('admin/elements/menus', $list, true);
		$data['content'] = $this->check_login('menus', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
	function add_menu($idlang = 3){
		$allow = $this->check_login('menus', '', true);
		$data = $this->get_menus('menus');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
						
				$data=array('idmenus' => '',
							'name' => $_POST['title']
				);
				$this->admin_model->add_menu($data);
				redirect('/admin/menus', 'location');
			}else{			
				$data['content'] = $this->load->view('admin/elements/add_menu', '', true);	
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}

	function delete_menu($id){
		$allow = $this->check_login('menus', '', true);
		if($allow){
			$this->admin_model->delete_menu($id);
		}				
		redirect('/admin/menus', 'location');		
	}

	function change_menu_item_priority($id){
		$allow = $this->check_login('menus', '', true);
		if($allow){
			$data=array( 'showorder' => $_POST['priority']);
			$this->admin_model->update_menu_items($id, $data);
		}		
		redirect('/admin/menus', 'location');		
	}
	
	function add_menu_item($idmenus, $idparent=null, $idlang = 3){
		$allow = $this->check_login('menus', '', true);
		$data = $this->get_menus('menus');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != '' && isset($_POST['idlanguage']) && $_POST['idlanguage'] != '' && isset($_POST['idmenu_item_types']) && $_POST['idmenu_item_types'] != ''){
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				if($_POST['friendlyurl'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
					
				$data=array('idmenu_items' => '',
							'idmenus' => $idmenus,
							'idmenu_item_types' => $_POST['idmenu_item_types'],
							'idelement' => $_POST['idelement'],
							'idparent' => $idparent,
							'active' => $active
				);
				$this->admin_model->add_menu_item($data);
				
				$mi_lang=array('idmenu_item_languages' => '',
								'idmenu_items' => $this->db->insert_id(),
								'idlanguages' => $_POST['idlanguage'],
								'friendlyurl' => $friendlyurl,
								'elementname' => $_POST['title']
				);
				$this->admin_model->add_menu_item_language($mi_lang);
				
				redirect('/admin/menus', 'location');	
			}else{		
				$data['idmenus'] = $idmenus;
				$data['idparent'] = $idparent;
				
			//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1[0]='';
				$bufor2[0]='';
				$i = 1;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				$data['languages']=array_combine($bufor1,$bufor2);
			//przygotowanie listy typow do boxa
				$mits = $this->admin_model->get_menu_item_types();
				$bufor1[0]='';
				$bufor2[0]='';
				$i = 1;
				foreach($mits as $mit){
					$bufor1[$i]=$mit['idmenu_item_types'];
					$bufor2[$i]=$mit['type'];
					$i++;
				}
				$data['menu_item_types']=array_combine($bufor1,$bufor2);
				
				$data['content'] = $this->load->view('admin/elements/add_menu_item', $data, true);	
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function delete_menu_item_language(){
		$allow = $this->check_login('menus', '', true);
		if($allow){
			$menu_item_language = $this->admin_model->get_menu_item_by_id($_POST['idmenu_item_languages']);
			$this->admin_model->delete_menu_item_language($_POST['idmenu_item_languages']);
			$data = $this->admin_model->get_menu_item_languages($menu_item_language[0]['idmenu_items']);
			if(!isset($data[0])){
				$deleted_menu_items = $this->admin_model->get_menu_item_to_delete($menu_item_language[0]['idmenu_items']);
				$update_data = array( 'idparent' => $deleted_menu_items[0]['idparent'] );
				$children = $this->admin_model->get_menu_item_children($deleted_menu_items[0]['idmenu_items']);
				//zmiana id parenta u potomkow
				$this->admin_model->delete_menu_item($menu_item_language[0]['idmenu_items']);
				foreach($children as $child){
					$this->admin_model->update_menu_items($child['idmenu_items'],$update_data);
				}
				$this->admin_model->delete_menu_item($menu_item_language[0]['idmenu_items']);	
			}
		}
		redirect('/admin/menus', 'location');		
	}
	
	function delete_menu_item($idmenu_item){
		$allow = $this->check_login('menus', '', true);
		if($allow){
			$this->admin_model->delete_menu_item_language_by_idmenu_items($idmenu_item);
			$data = $this->admin_model->get_menu_item_languages($idmenu_item);
			if(!isset($data[0])){
				$deleted_menu_items = $this->admin_model->get_menu_item_to_delete($idmenu_item);
				$update_data = array( 'idparent' => $deleted_menu_items[0]['idparent'] );
				$children = $this->admin_model->get_menu_item_children($deleted_menu_items[0]['idmenu_items']);
				//zmiana id parenta u potomkow
				$this->admin_model->delete_menu_item($idmenu_item);
				foreach($children as $child){
					$this->admin_model->update_menu_items($child['idmenu_items'],$update_data);
				}
				$this->admin_model->delete_menu_item($idmenu_item);	
			}
		}
		redirect('/admin/menus', 'location');		
	}

	function edit_menu_item_language($idlang = 3){
		$allow = $this->check_login('menus', '', true);
		$data = $this->get_menus('menus');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}


				if($_POST['friendlyurl'] != ''){
                    $pos = strpos($_POST['friendlyurl'],'http');

                    
                    if($pos === false)
                        $friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
                    else
                        $friendlyurl = $_POST['friendlyurl'];
				}else{
					$friendlyurl = $this->generate_friendlyurl($_POST['title']);
				}
				

				$idmenu_items = $_POST['idmenu_items'];
				$data = array( 'active' => $active );
				$this->admin_model->update_menu_items($idmenu_items, $data);
				
				$mi_lang=array(	'friendlyurl' => $friendlyurl,
								'elementname' => $_POST['title']
				);
				$this->admin_model->update_menu_item_languages($_POST['idmenu_item_languages'], $mi_lang);
                
				
				redirect('/admin/menus', 'location');	
			}else{		
				$menu_item_language = $this->admin_model->get_menu_item_by_id($_POST['idmenu_item_languages']);
				$data['idmenu_item_languages'] = $_POST['idmenu_item_languages'];
				$data['idmenu_items'] = $menu_item_language[0]['idmenu_items'];
				$data['active'] = $menu_item_language[0]['active'];
				$data['idlanguages'] = $menu_item_language[0]['idlanguages'];
				$data['friendlyurl'] = $menu_item_language[0]['friendlyurl'];
				$data['title'] = $menu_item_language[0]['elementname'];
				
				$data['content'] = $this->load->view('admin/elements/edit_menu_item', $data, true);	
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}

	function add_menu_item_language($idmenu_item, $idlang = 3){
		$allow = $this->check_login('menus', '', true);
		$data = $this->get_menus('menus');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$mi_lang=array('idmenu_item_languages' => '',
								'idmenu_items' => $idmenu_item,
								'idlanguages' => $_POST['idlanguage'],
								'friendlyurl' => $_POST['friendlyurl'],
								'elementname' => $_POST['title']
				);
				$this->admin_model->add_menu_item_language($mi_lang);
				
				redirect('/admin/menus', 'location');	
			}else{		
				$data['idmenu_item'] = $idmenu_item;
				
				if(isset($_POST['idlanguage']) && $_POST['idlanguage']!=null){	
					$data['languages'] = $_POST['idlanguage'];		
					$data['content'] = $this->load->view('admin/elements/add_menu_item_language', $data, true);	
				}else{
					$data['content'] = $this->site['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}

//notes
	function notes($idlang = 3){	
		$data = $this->get_menus('notes');	
		$list['notes'] = $this->admin_model->get_notes();
		
		$content = $this->load->view('admin/elements/notes', $list, true);
		$data['content'] = $this->check_login('notes', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}

	function add_note($idlang = 3){
		$allow = $this->check_login('notes', '', true);
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				$data=array('idnotes' => '',				
							'idusers' => $this->session->userdata('idusers'),
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'date' => date('c')
				);
				$this->admin_model->add_note($data);
				redirect('/admin/notes', 'location');	
			}else{				
				$data = $this->get_menus('notes');
				$data['content'] = $this->load->view('admin/elements/add_note', '', true);	

				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}

	function delete_note($idnote){
		$allow = $this->check_login('notes', '', true);
		if($allow){
			$this->admin_model->delete_note($idnote);
		}
		redirect('/admin/notes', 'location');		
	}

//json
	function get_json_data_for_menu($idmenu_item_types, $idlang){
		$bufor1=array();
		$bufor2=array();
		$i = 0;
		
		switch ($idmenu_item_types) {
		    case 4:
		        $languages = $this->admin_model->get_article_languages();
				foreach($languages as $lang){
					if($lang['idlanguages']==$idlang){
						$bufor1[$i]=$lang['idarticles'];
						$bufor2[$i]=$lang['title'];
						$i++;
					}
				}
		        break;
		    case 5:
		        $languages = $this->admin_model->get_news_languages();
				foreach($languages as $lang){
					if($lang['idlanguages']==$idlang){
						$bufor1[$i]=$lang['idnewses'];
						$bufor2[$i]=$lang['title'];
						$i++;
					}
				}
		        break;
		    case 6:
		       $languages = $this->admin_model->get_galleries_languages();
                
			   	foreach($languages as $lang){
					if($lang['idlanguages']==$idlang){
						$bufor1[$i]=$lang['idgalleries'];
						$bufor2[$i]=$lang['title'];
						$i++;
					}
				}
		        break;
			case 8:
		        $languages = $this->admin_model->get_product_categories();
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idproduct_categories'];
					$bufor2[$i]=$lang['type'];
					$i++;
				}
		        break;
			case 9:
		        $languages = $this->admin_model->get_product_languages();
				foreach($languages as $lang){
					if($lang['idlanguages']==$idlang){
						$bufor1[$i]=$lang['idproducts'];
						$bufor2[$i]=$lang['title'];
						$i++;
					}
				}
		        break;
			default:
			  $bufor1[$i] = 1;
			  $bufor2[$i] = '---';
			  break; 
		};

		//wczesniej napisany widok-nie zmieniam, bo nie ma sensu dodawac nowy
		if($bufor1 != array() && $bufor2 != array()){
			$data['metatags'] = json_encode(array_combine($bufor1,$bufor2));
		}else{
			$data['metatags'] = json_encode(array());
		}
		$data['metatags'] = json_encode(array_combine($bufor1,$bufor2));
		$this->load->view('admin/elements/metatags_json', $data);
	}

//panel zarzadzania CMSem - prawa
	function show_rights($idlang = 3){
		$data = $this->get_menus();	
		$list['rights'] = $this->admin_model->get_rights();
		$list['groups'] = $this->admin_model->get_user_groups();		
		$list['user_group_elements'] = $this->admin_model->get_user_group_elements();
		
		$content = $this->load->view('admin/elements/rights', $list, true);
		$data['content'] = $this->check_login('rights', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
	function change_user_group_elements($idelement, $idgroup){
		$allow = $this->check_login('rights', '', true);
		if($allow){
			$exist = $this->admin_model->get_user_group_element($idelement, $idgroup);
			if(isset($exist[0])){
				if($exist[0]['active']){
					//zmiana statusu na false
					$data = array( 'active'=> false);
					$this->admin_model->update_user_group_elements($exist[0]['iduser_group_elements'], $data);
				}else{
					//zmiana statusu na true
					$data = array( 'active'=> true);
					$this->admin_model->update_user_group_elements($exist[0]['iduser_group_elements'], $data);
				}
			}else{
				//utworzenie powiazania grupy z elementem
				$data = array( 'idelements' => $idelement,
								'iduser_groups' => $idgroup,
								'active' => true
							);
				$this->admin_model->add_user_group_elements($data);
			}
		}
		redirect('/admin/rights', 'location');
	}
		
	function change_element_priority($id){
		$allow = $this->check_login('rights', '', true);
		if($allow){
			$data=array( 'showorder' => $_POST['priority']);
			$this->admin_model->update_elements($id, $data);
		}		
		redirect('/admin/rights', 'location');		
	}

//jezyki
	function languages($idlang = 3){
		$data = $this->get_menus('languages');	
		$list['languages'] = $this->admin_model->get_all_languages();
		
		$content = $this->load->view('admin/elements/languages', $list, true);
		$data['content'] = $this->check_login('languages', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
	function change_language_priority($id){
		$allow = $this->check_login('languages', '', true);
		if($allow){
			$data=array( 'showorder' => $_POST['priority']);
			$this->admin_model->update_languages($id, $data);
		}		
		redirect('/admin/languages', 'location');		
	}
	
	function add_language($idlang = 3){
		$allow = $this->check_login('languages', '', true);
		if($allow){			
			if(isset($_POST['fullname']) && $_POST['fullname'] != ''){
				$data=array('idlanguages' => '',				
							'fullname' => $_POST['fullname'],
							'shortname' => $_POST['shortname']
				);
				$this->admin_model->add_language($data);
				redirect('/admin/languages', 'location');	
			}else{			
				$data = $this->get_menus('languages');
				$data['content'] = $this->load->view('admin/elements/add_language', '', true);	

				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function edit_language($idlang_to_edit, $idlang = 3){
		$allow = $this->check_login('languages', '', true);
		if($allow){			
			if(isset($_POST['fullname']) && $_POST['fullname'] != ''){
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$data=array('fullname' => $_POST['fullname'],
							'active' => $active,
							'shortname' => $_POST['shortname']
				);
				$this->admin_model->update_languages($idlang_to_edit, $data);
				redirect('/admin/languages', 'location');	
			}else{			
				$data = $this->get_menus('languages');				
				$languages = $this->admin_model->get_language_by_id($idlang_to_edit);
				if(isset($languages[0])){
					$data['content'] = $this->load->view('admin/elements/edit_language', $languages[0], true);	
				}else{
					$data['content'] = 'Nie ma takiego jezyka.';
				}
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
//generowanie sitemap.xml	
	function generate_sitemap(){
		$allow = $this->check_login('sitemap', '', true);
		if($allow){			
			$this->load->helper('file');			
			
			$newline = chr(10);
			$tab = chr(9);
			$twotabs = $tab.$tab;
			
			
			$data = '<?xml version="1.0" encoding="UTF-8"?>'.$newline;
			$data .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'.$newline;
				$data .= $tab.'<url>'.$newline;
					$data .= $twotabs.'<loc>'.base_url().'</loc>'.$newline;
					$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
					$data .= $twotabs.'<priority>1.0</priority>'.$newline;
				$data .= $tab.'</url>'.$newline;
			//tu beda wszystkie foreachy
			//przejscie po jezykach
				$languages = $this->admin_model->get_languages();
				foreach($languages as $language){	
					$site = $this->config->item($language['shortname']);
					$short = strtolower($language['shortname']);
					/*
				//przejscie po artykulach
					$data .= $tab.'<url>'.$newline;
						$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['artykuly'].'.html</loc>'.$newline;
						$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
						$data .= $twotabs.'<priority>0.9</priority>'.$newline;
					$data .= $tab.'</url>'.$newline;
					*/
					
					$articles = $this->admin_model->get_article_languages();
					foreach($articles as $article){	
						if($article['shortname'] == $language['shortname'] && $article['idarticles'] != 88){
							$flag = true;
							foreach($articles as $subarticle){	
								if($article['idarticles'] == $subarticle['idparent']){
									$flag = false;
								}
							}
							if($flag){
								$data .= $tab.'<url>'.$newline;
									$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['artykul'].'/'.$article['friendlyurl'].'-'.$article['idarticles'].'.html</loc>'.$newline;
									$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
									$data .= $twotabs.'<priority>0.8</priority>'.$newline;
								$data .= $tab.'</url>'.$newline;
							}
						}
					}
                                        //nieruchomosci
                                        $properties_for_sale = $this->immovable_model->getActiveForRent($language['idlanguages']);
                                        //var_dump($properties_for_sale);
                                        if(!empty($properties_for_sale) && is_array($properties_for_sale))
                                        {
                                            foreach($properties_for_sale as $k=>$v)
                                            {
                                                $data .= $tab.'<url>'.$newline;
                                                        $data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['nieruchomosc'].'/'.$v['id'].'.html</loc>'.$newline;
                                                        $data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
                                                        $data .= $twotabs.'<priority>0.8</priority>'.$newline;
                                                $data .= $tab.'</url>'.$newline;
                                            }
                                        }

                                        $properties_for_rent = $this->immovable_model->getActiveForRent($language['idlanguages']);
                                        //var_dump($properties_for_rent);
                                        if(!empty($properties_for_rent) && is_array($properties_for_rent))
                                        {
                                            foreach($properties_for_sale as $k=>$v)
                                            {
                                                $data .= $tab.'<url>'.$newline;
                                                        $data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['nieruchomosc'].'/'.$v['id'].'.html</loc>'.$newline;
                                                        $data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
                                                        $data .= $twotabs.'<priority>0.8</priority>'.$newline;
                                                $data .= $tab.'</url>'.$newline;
                                            }
                                        }

					//kontakt
					$data .= $tab.'<url>'.$newline;
						$data .= $twotabs.'<loc>'.base_url().$short.'/kontakt.html</loc>'.$newline;
						$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
						$data .= $twotabs.'<priority>0.8</priority>'.$newline;
					$data .= $tab.'</url>'.$newline;
				//przejscie po newsach
				/*
					$data .= $tab.'<url>'.$newline;
						$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['newsy'].'.html</loc>'.$newline;
						$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
						$data .= $twotabs.'<priority>0.9</priority>'.$newline;
					$data .= $tab.'</url>'.$newline;
					
					$newses = $this->admin_model->get_news_languages();
					foreach($newses as $news){	
						if($news['shortname'] == $language['shortname']){
							$data .= $tab.'<url>'.$newline;
								$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['news'].'/'.$news['friendlyurl'].'-'.$news['idnews_languages'].'.html</loc>'.$newline;
								$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
								$data .= $twotabs.'<priority>0.8</priority>'.$newline;
							$data .= $tab.'</url>'.$newline;
						}
					}
					*/
				//przejscie po galleriach
				/*
					$data .= $tab.'<url>'.$newline;
						$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['galerie'].'.html</loc>'.$newline;
						$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
						$data .= $twotabs.'<priority>0.9</priority>'.$newline;
					$data .= $tab.'</url>'.$newline;
					$galleries = $this->admin_model->get_galleries();
					foreach($galleries as $gallery){	
						if($gallery['shortname'] == $language['shortname']){
							$data .= $tab.'<url>'.$newline;
								$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['galeria'].'/'.$gallery['friendlyurl'].'-'.$gallery['idgalleries_languages'].'.html</loc>'.$newline;
								$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
								$data .= $twotabs.'<priority>0.8</priority>'.$newline;
							$data .= $tab.'</url>'.$newline;
						}
					}
				
				//przejscie po obrazkach
					$images = $this->admin_model->get_img_lang_versions();
					foreach($images as $image){	
						if($image['shortname'] == $language['shortname']){
							$data .= $tab.'<url>'.$newline;
								$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['galeria'].'/'.$image['friendlyurl'].'-'.$image['idimages_languages'].'.html</loc>'.$newline;
								$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
								$data .= $twotabs.'<priority>0.7</priority>'.$newline;
							$data .= $tab.'</url>'.$newline;
						}
					}
					*/	
					/*
					$products = $this->admin_model->get_menu_by_id( 15, $language['idlanguages']);
					foreach($products as $parent){
						if($parent['idparent']==null){
							switch($parent['type']){
								case 'product_category':
									$data .= $tab.'<url>'.$newline;
										$data .= $twotabs.'<loc>'.base_url().$short.'/'.$parent['friendlyurl'].'.html</loc>'.$newline;
										$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
										$data .= $twotabs.'<priority>0.8</priority>'.$newline;
									$data .= $tab.'</url>'.$newline;
									break;
								case 'product':
									$data .= $tab.'<url>'.$newline;
										$data .= $twotabs.'<loc>'.base_url().$short.'/'.$site['linki_do_sitemapy']['produkt'].'/'.$parent['friendlyurl'].'-'.$parent['idelement'].'.html</loc>'.$newline;
										$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
										$data .= $twotabs.'<priority>0.8</priority>'.$newline;
									$data .= $tab.'</url>'.$newline;
									break;
							}
							foreach($products as $product){	
								if($product['idparent']==$parent['idmenu_items']){
									switch($product['type']){
										case 'product_category':
											$data .= $tab.'<url>'.$newline;
												$data .= $twotabs.'<loc>'.base_url().$short.'/'.$product['friendlyurl'].'.html</loc>'.$newline;
												$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
												$data .= $twotabs.'<priority>0.8</priority>'.$newline;
											$data .= $tab.'</url>'.$newline;
											break;
										case 'product':
											$data .= $tab.'<url>'.$newline;
												$data .= $twotabs.'<loc>'.base_url().$short.'/'.$parent['friendlyurl'].'/'.$product['friendlyurl'].'-'.$product['idelement'].'.html</loc>'.$newline;
												$data .= $twotabs.'<changefreq>daily</changefreq>'.$newline;
												$data .= $twotabs.'<priority>0.8</priority>'.$newline;
											$data .= $tab.'</url>'.$newline;
											break;
									}
								}
							}
						}
					}
					*/	
				}
			$data .= '</urlset>';	
			
		//zapisanie do pliku i potwierdzenie wykonania mapy strony
			$wyswietl = $this->get_menus();
			if (!write_file('./files/sitemap.xml', $data, 'w'))
			{
				$wyswietl['content'] = 'Nie udało się zapisanie nowej mapy strony.';
			}
			else
			{
				if (!copy('./files/sitemap.xml','./sitemap.xml')) {
				    echo 'Kopiowanie mapy strony zakońzyło się niepowodzeniem.';
				}
				$wyswietl['content'] = 'Pomyślnie wygenerowano mapę strony.';
			}
		//wyswietlenie potwierdzenia
			$metatags = $this->get_standard_metatags('admin','3');
			$this->load->view('admin/layout/header', $metatags);
			$this->load->view('admin/layout/admin',$wyswietl);
		}					
	}
//generowanie .htaccess
	function generate_htaccess(){
		$allow = $this->check_login('htaccess', '', true);
		if($allow){			
			$this->load->helper('file');
			$newline = chr(10);
			$tab = chr(9);
			$data = '<IfModule mod_rewrite.c>'.$newline;
			$data .= $tab.'RewriteEngine On'.$newline;
			$data .= $tab.'RewriteCond $1 !^(index\.php|images|files|robots\.txt)'.$newline;
			//przejscie po jezykach
			$languages = $this->admin_model->get_languages();
			foreach($languages as $language){	
				$site = $this->config->item($language['shortname']);
				$short = strtolower($language['shortname']);
				$data .= $tab.'RewriteRule ^'.$short.'$ /index.php/frontside/index/'.$language['idlanguages'].' [L]'.$newline;
				$data .= $tab.'RewriteRule ^'.$short.'/'.$site['linki_do_sitemapy']['artykuly'].'.html$ /index.php/frontside/articles/'.$language['idlanguages'].' [L]'.$newline;
				$data .= $tab.'RewriteRule ^'.$short.'/'.$site['linki_do_sitemapy']['artykuly'].'.html$ /index.php/frontside/articles/'.$language['idlanguages'].' [L]'.$newline;				
				$data .= $tab.'RewriteRule ^'.$short.'/'.$site['linki_do_sitemapy']['artykul'].'/(.*)\-(.+)\.html$ /index.php/frontside/show_article/$2/'.$language['idlanguages'].' [L]'.$newline;	
				$data .= $tab.'RewriteRule ^'.$short.'/'.$site['linki_do_sitemapy']['newsy'].'.html$ /index.php/frontside/newses/'.$language['idlanguages'].' [L]'.$newline;			
				$data .= $tab.'RewriteRule ^'.$short.'/'.$site['linki_do_sitemapy']['news'].'/(.*)\-(.+)\.html$ /index.php/frontside/show_news/$2/'.$language['idlanguages'].' [L]'.$newline;			
				$data .= $tab.'RewriteRule ^'.$short.'/'.$site['linki_do_sitemapy']['galerie'].'.html$ /index.php/frontside/galleries/'.$language['idlanguages'].' [L]'.$newline;	
				$data .= $tab.'RewriteRule ^'.$short.'/'.$site['linki_do_sitemapy']['galeria'].'-(.+)\.html$ /index.php/frontside/show_gallery/$1/'.$language['idlanguages'].' [L]'.$newline;			
				$data .= $tab.'RewriteRule ^'.$short.'/'.$site['linki_do_sitemapy']['zdjecie'].'/(.*)\-(.+)\.html$ frontside/show_image/$2/'.$language['idlanguages'].' [L]'.$newline;
				$data .= $tab.'RewriteRule ^'.$short.'/aktualnosci.html$ /index.php/frontside/newses/3 [L]'.$newline;		
				$data .= $tab.'RewriteRule ^'.$short.'/'.$site['linki_do_sitemapy']['strona_glowna'].'.html$ /index.php/ [L]'.$newline;
				$data .= $tab.'RewriteRule ^'.$short.'/'.$site['linki_do_sitemapy']['kontakt'].'.html$ /index.php/frontside/send_contact/'.$language['idlanguages'].' [L]'.$newline;
			}
			$data .= $tab.'RewriteRule ^admin(.*)$ /index.php/admin$1 [L]'.$newline;
			//$data .= $tab.'RewriteRule ^pl/kontakt.html$ /index.php/frontside/send_contact [L]'.$newline;
			$data .= $tab.'RewriteRule ^frontside(.*)$ /index.php/frontside$1 [L]'.$newline;
			$data .= $tab.'RewriteRule ^files/sitemap.xml$ /index.php/files/sitemap.xml [L]'.$newline;
			$data .= $tab.'ErrorDocument 404 /index.php/'.$newline;
    		$data .= '</IfModule>';
		//zapisanie do pliku i potwierdzenie wykonania mapy strony
			$wyswietl = $this->get_menus();
			if ( ! write_file('./files/htaccess/.htaccess', $data, 'w'))
			{				
				$wyswietl['content'] = 'Nie udało się zapisanie nowego htaccessa.';
			}
			else
			{	
				//chmod('./.htaccess',0777);
				//unlink('./.htaccess');
				if (!copy('./files/htaccess/.htaccess','./.htaccess')) {
				    echo "Kopiowanie htaccessa zakońzyło się niepowodzeniem.";
				}
				$wyswietl['content'] = 'Pomyślnie wygenerowano htaccessa.';
			}
		//wyswietlenie potwierdzenia
			$metatags = $this->get_standard_metatags('admin','3');
			$this->load->view('admin/layout/header', $metatags);
			$this->load->view('admin/layout/admin',$wyswietl);
		}					
	}
//backup bazy
	function backup_database(){
		$allow = $this->check_login('backup_database', '', true);
		if($allow){		
			$this->load->dbutil();
			$this->load->helper('file');	
			$filname = date('YndHis').'.zip';
			$prefs = array('tables' => array(	'languages',
												'user_groups',
												'elements',
												'user_group_elements',
												'users',
												'notes',
												'metatag_types',
												'metatags',
												'newses',
												'news_languages',
												'articles',
												'article_languages',
												'galleries',
												'galleries_languages',
												'images',
												'images_languages',
												'menu_item_types',
												'menus',
												'menu_items',
												'mit_languages',
												'menu_item_languages',												
												'products',
												'subproducts',
												'products_languages',
												'product_categories',
												'product_product_categories',
												'product_categories_languages'
											),
			                'format'      => 'zip',
			                'filename'    => $filname
			              );
			$backup =& $this->dbutil->backup($prefs); 
			
			//zapisanie do pliku i potwierdzenie wykonania mapy strony
			$wyswietl = $this->get_menus();
			if ( ! write_file('./files/dbbackups/'.$filname, $backup, 'w'))
			{
				$wyswietl['content'] = 'Utworzenie kopii bazy danych nie powiodło się.';
			}
			else
			{
				$wyswietl['content'] = 'Pomyślnie utworzono kopię bazy danych.';
			}
		//wyswietlenie potwierdzenia
			$metatags = $this->get_standard_metatags('admin','3');
			$this->load->view('admin/layout/header', $metatags);
			$this->load->view('admin/layout/admin',$wyswietl);
		}					
	}

//produkty
	function products($idlang = 3){	
		$list['language'] = $this->set_language($idlang);
		$list['products'] = $this->admin_model->get_products();
		$list['product_categories'] = $this->admin_model->get_product_categories();
		$list['product_languages'] = $this->admin_model->get_product_languages();
		$list['categories_languages'] = $this->admin_model->get_product_categories_languages();
		$list['children'] = $this->admin_model->get_product_children();
		$list['site'] = $this->site;
		//przygotowanie listy gallerii
		$galleries = $this->admin_model->get_galleries();
		$galleries_languages = $this->admin_model->get_galleries_languages();
		$list['galleries'] = array();
		foreach($galleries as $gallery){
			foreach($galleries_languages as $galleries_language){
				if($gallery['idgalleries'] == $galleries_language['idgalleries']){
					$list['galleries'][$gallery['idgalleries']] = $galleries_language['title'];
					break;
				}
			}
		}
		//przygotowanie listy podproduktów
		$list['subproducts'] = $this->admin_model->get_products_by_cat_name('Elementy');
		//przygotowanie listy jezykow do boxa
		$languages = $this->admin_model->get_languages();
		$i = 0;
		foreach($languages as $lang){
			$bufor1[$i]=$lang['idlanguages'];
			$bufor2[$i]=$lang['fullname'];
			$i++;
		}
		$list['languages'] = array_combine($bufor1,$bufor2);
		$data = $this->get_menus('products');
		$content = $this->load->view('admin/elements/products', $list, true);
		$data['content'] = $this->check_login('products', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
	
	function change_product_price($id){
		$allow = $this->check_login('products', '', true);
		if($allow){
			$data=array( 'price' => $_POST['priority']);
			$this->admin_model->update_product($id, $data);
		}				
		redirect('/admin/products', 'location');		
	}
	
	function change_complet_price($idparent, $idchild){
		$allow = $this->check_login('products', '', true);
		if($allow){
			$data=array( 'complet_price' => $_POST['priority']);
			$this->admin_model->update_subproduct($idparent, $idchild, $data);
		//	echo 'boom';
		}				
		redirect('/admin/products', 'location');		
	}
	
	function add_product($idlang = 3){
		$allow = $this->check_login('products', '', true);
		$data = $this->get_menus('products');
				
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				$file_data = array('file_name' => ''); 	
				if(isset($_FILES['file']) && $_FILES['file']['name']!=''){
					//uploadowanie pliku
					$config['upload_path'] = './files/img/products/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('file');
					$file_data = $this->upload->data();
					//zmiana praw pliku
					chmod('./files/img/products/'.$file_data['file_name'], 0777);
					//tworzenie miniaturki
					$img_config['image_library'] = 'gd2';
					$img_config['source_image'] = './files/img/products/'.$file_data['file_name'];
					$img_config['new_image'] = './files/img/products/min/';
					$img_config['maintain_ratio'] = TRUE;
					$img_config['width'] = $this->product['width'];
					$img_config['height'] = $this->product['height'];
					$this->load->library('image_lib', $img_config);
					$this->image_lib->resize();
					if ( ! $this->image_lib->resize()){
					    echo $this->image_lib->display_errors();
					}	
				}				
				$data=array('idproducts' => '',
							'name' => $_POST['title'],
							'photo' => $file_data['file_name'],
							'price' => $_POST['price'],
							'active' => $active
				);
				$this->admin_model->add_product($data);
				$idadded_product = $this->db->insert_id();
				$data=array('idproducts_languages' => '',
							'idproducts' => $idadded_product,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],							
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_product_language($data);
				
				$subproducts = $this->admin_model->get_products_by_cat_name('Elementy');
				foreach($subproducts as $subproduct){
					if(isset($_POST[$subproduct['name']])){
						$data = array(	'idsubproducts' => '',
										'idparent' => $idadded_product,
										'idchild' => $subproduct['idproducts']
									);
						$this->admin_model->add_subproduct($data);
					}
				}
				
				$data = array(	'idproduct_product_categories' => '',
								'idproduct_categories' => $_POST['idcategory'],
								'idproducts' => $idadded_product
							);
				$this->admin_model->add_product_product_category($data);
						
				redirect('/admin/products', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				
				$data['languages']=array_combine($bufor1,$bufor2);
				
				//przygotowanie listy kategorii
				$categories = $this->admin_model->get_product_categories();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($categories as $category){
					$bufor1[$i]=$category['idproduct_categories'];
					$bufor2[$i]=$category['type'];
					$i++;
				}
				$data['categories']=array_combine($bufor1,$bufor2);
				
				//przygotowanie listy podproduktów
				$data['subproducts'] = $this->admin_model->get_products_by_cat_name('Elementy');
				
				//$data['meta'] = $this->get_standard_metatags('article',$idlang);
				$data['content'] = $this->load->view('admin/elements/add_product', $data, true);	
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function delete_product_language($idproduct){
		$allow = $this->check_login('products', '', true);
		if($allow){
			$idproduct_languages = $_POST['idproduct_languages'];
			$this->admin_model->delete_product_language($idproduct_languages);
			$data = $this->admin_model->get_product_languages_by_idproducts($idproduct);
			if(!isset($data[0])){
				$deleted_product = $this->admin_model->get_product_by_id($idproduct);
				$this->admin_model->delete_subproduct_by_idparent($idproduct);	
				$this->admin_model->delete_subproduct_by_idchild($idproduct);	
				$this->admin_model->delete_product_product_category_by_idproduct($idproduct);	
				$this->admin_model->delete_product($idproduct);	
				//kasacja fotek
				if(isset($deleted_product[0])){
					if($deleted_product[0]['photo']!=''){
						unlink('./files/img/products/'.$deleted_product[0]['photo']);
						unlink('./files/img/products/min/'.$deleted_product[0]['photo']);
					}
				}
			}
		}
		redirect('/admin/products', 'location');	
	}
	
	function add_product_language($idproduct, $idlang = 3){
		$allow = $this->check_login('products', '', true);
		$data = $this->get_menus('products');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				
				$data=array('idproducts_languages' => '',
							'idproducts' => $idproduct,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_product_language($data);
				redirect('/admin/products', 'location');	
			}else{
				$data['id_articles'] = $idproduct;
				//przygotowanie listy jezykow do boxa
				$used_langs = $this->admin_model->get_product_languages_by_idproducts($idproduct);
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$flag = 1;
					foreach($used_langs as $used_lang){
						if($lang['idlanguages'] == $used_lang['idlanguages'])
						{
							$flag = 0;
							break;
						}
					}
					if($flag){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
				}	
				if($bufor1!=array() && $bufor2!=array()){			
					$data['languages']=array_combine($bufor1,$bufor2);		
					$data['meta'] = $this->get_standard_metatags('product',$idlang);
					$data['content'] = $this->load->view('admin/elements/add_product_language', $data, true);	
				}else{
					$data['content'] = $this->site['wszystkie_wersje_dostepne'];
				}
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function edit_product_language($idlang = 3){
		$allow = $this->check_login('products', '', true);
		$data2 = $this->get_menus('products');
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
				
				$idarticle_languages = $_POST['idarticle_languages'];
				
				if(isset($_FILES) && $_FILES['file']['name']!=''){
					$photo = $this->admin_model->get_product_by_id($_POST['idarticles']);
					if(isset($photo[0]) && $photo[0]['photo']!=''){
						unlink('./files/img/products/'.$photo[0]['photo']);
						unlink('./files/img/products/min/'.$photo[0]['photo']);
					}
					//uploadowanie pliku
					$config['upload_path'] = './files/img/products/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['remove_spaces'] = TRUE;		
					
					$this->load->library('upload', $config);
					$this->upload->do_upload('file');
					$file_data = $this->upload->data();
					
					//tworzenie miniaturki
					$img_config['image_library'] = 'GD2';
					$img_config['source_image'] = './files/img/products/'.$file_data['file_name'];
					$img_config['new_image'] = './files/img/products/min/';
					$img_config['maintain_ratio'] = TRUE;
					$img_config['width'] = $this->product['width'];
					$img_config['height'] = $this->product['height'];
					$this->load->library('image_lib', $img_config);
					$this->image_lib->resize();
					if ( ! $this->image_lib->resize()){
					    echo $this->image_lib->display_errors();
					}	
					$data = array('photo'=> $file_data['file_name']);
					$this->admin_model->update_product($_POST['idarticles'], $data);
				}
									
				$data=array('active' => $active);
				$this->admin_model->update_product($_POST['idarticles'], $data);
				
				$data=array('idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],							
							'additional_data' => $_POST['additional_data'],
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_product_language($idarticle_languages, $data);
				
				redirect('/admin/products', 'location');	
			}else{
				$idarticle_languages = $_POST['idproduct_languages'];
				//przygotowanie danych
				$article = $this->admin_model->get_product_lang_by_id($idarticle_languages);
				if(isset($article[0])){
					$article = $article[0];	
					
					$data = array(	'idarticle_languages' => $idarticle_languages,
									'idarticles' => $article['idproducts'],
									'title' => $article['title'],
									'content' => $article['content'],
									'titleseo' => $article['titleseo'],
									'keywords' => $article['keywords'],
									'shortdesc' => $article['shortdesc'],
									'abstract' => $article['abstract'],
									'subject' => $article['subject'],
									'topic' => $article['topic'],
									'copyrights' => $article['copyrights'],
									'friendlyurl' => $article['friendlyurl'],
									'additional_data' => $article['additional_data'],
									'active' => $article['active']
								);		
					
					//przygotowanie listy jezykow do boxa
					$languages = $this->admin_model->get_languages();
					$bufor1=array($article['idlanguages']);
					$bufor2=array('---');
					$i = 1;
					foreach($languages as $lang){
						$bufor1[$i]=$lang['idlanguages'];
						$bufor2[$i]=$lang['shortname'];
						$i++;
					}
					$data['languages']=array_combine($bufor1,$bufor2);
					
					$data2['content'] = $this->load->view('admin/elements/edit_product_language', $data, true);	
					
					$metatags = $this->get_standard_metatags('admin',$idlang);
					$this->load->view('admin/layout/header', $metatags);
					$this->load->view('admin/layout/admin',$data2);
				}else{
					redirect('/admin/products', 'location');
				}
			}
		}	
	}

	function set_subproducts($idparent){
		$allow = $this->check_login('products', '', true);
		if($allow){
			//print_r($_POST);
			$subproducts = $this->admin_model->get_products_by_cat_name('Elementy');
			//print_r($subproducts);
				foreach($subproducts as $subproduct){
					if(isset($_POST[$subproduct['name']])){
						$isInDB = $this->admin_model->get_subproduct_by_parent_by_child($idparent,$subproduct['idproducts']);
						if(!isset($isInDB[0])){
							$data = array(	'idsubproducts' => '',
											'idparent' => $idparent,
											'idchild' => $subproduct['idproducts']
										);
							$this->admin_model->add_subproduct($data);
						}
					}else{
						$isInDB = $this->admin_model->get_subproduct_by_parent_by_child($idparent,$subproduct['idproducts']);
						if(isset($isInDB[0])){
							$this->admin_model->delete_subproduct_by_parent_by_child($idparent,$subproduct['idproducts']);
						}
					}
				}
		}				
		redirect('/admin/products', 'location');
	}

	function add_product_category($idlang = 3){
		$allow = $this->check_login('products', '', true);
		$data = $this->get_menus('products');
				
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}		
				$data=array('idproduct_categories' => '',
							'type' => $_POST['title']
				);
				$this->admin_model->add_product_category($data);
				$idadded_product = $this->db->insert_id();
				$data=array('idproduct_categories_languages' => '',
							'idproduct_categories' => $idadded_product,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],			
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_product_category_language($data);	
				
				redirect('/admin/products', 'location');	
			}else{
				//przygotowanie listy jezykow do boxa
				$languages = $this->admin_model->get_languages();
				$bufor1=array();
				$bufor2=array();
				$i = 0;
				foreach($languages as $lang){
					$bufor1[$i]=$lang['idlanguages'];
					$bufor2[$i]=$lang['shortname'];
					$i++;
				}
				
				$data['languages']=array_combine($bufor1,$bufor2);
				
				//$data['meta'] = $this->get_standard_metatags('article',$idlang);
				$data['content'] = $this->load->view('admin/elements/add_product_category', $data, true);	
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function add_product_category_language($id, $idlang = 3){
		$allow = $this->check_login('products', '', true);
		$data = $this->get_menus('products');
				
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}	
				$data=array('idproduct_categories_languages' => '',
							'idproduct_categories' => $id,
							'idlanguages' => $_POST['idlanguage'],
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],			
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->add_product_category_language($data);	
				
				redirect('/admin/products', 'location');	
			}else{
				$data['idproduct_categories'] = $id;
				$data['idlanguage'] = $_POST['idlanguage'];
				//$data['meta'] = $this->get_standard_metatags('article',$idlang);
				$data['content'] = $this->load->view('admin/elements/add_prod_cat_language', $data, true);	
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function edit_product_category_language($idlang = 3){
		$allow = $this->check_login('products', '', true);
		$data = $this->get_menus('products');
				
		if($allow){			
			if(isset($_POST['title']) && $_POST['title'] != ''){
				if($_POST['friendlyurl'] != ''){
					$friendlyurl = $this->generate_friendlyurl($_POST['friendlyurl']);
				}else{
					if($_POST['seotitle'] != ''){
						$friendlyurl = $this->generate_friendlyurl($_POST['seotitle']);
					}else{
						$friendlyurl = $this->generate_friendlyurl($_POST['title']);
					}
				}
				$active = false;
				if(isset($_POST['active'])){
					$active = true;
				}
					
				$id = $_POST['idproduct_categories_languages'];
				$data=array(
							'title' => $_POST['title'],
							'content' => $_POST['artcontent'],
							'titleseo' => $_POST['seotitle'],
							'keywords' => $_POST['keywords'],
							'shortdesc' => $_POST['shortdesc'],
							'abstract' => $_POST['abstract'],
							'subject' => $_POST['subject'],
							'topic' => $_POST['topic'],
							'copyrights' => $_POST['copyrights'],			
							'friendlyurl' => $friendlyurl
				);
				$this->admin_model->update_product_category_language($id, $data);	
				
				redirect('/admin/products', 'location');	
			}else{
				$id = $_POST['idproduct_categories_languages'];
				$data['idproduct_categories'] = $id;
				$categories = $this->admin_model->get_product_category_language($id);
				if(isset($categories[0])){
					$data['content'] = $this->load->view('admin/elements/edit_prod_cat_language', $categories[0], true);		
				}else{
					$data['content'] = 'Wystapił błąd. Przepraszamy';
				}
				
				$metatags = $this->get_standard_metatags('admin',$idlang);
				$this->load->view('admin/layout/header', $metatags);
				$this->load->view('admin/layout/admin',$data);
			}
		}					
	}
	
	function delete_product_category_language($idcategory){
		$allow = $this->check_login('products', '', true);
		if($allow){
			$idcategory_languages = $_POST['idproduct_languages'];
			$this->admin_model->delete_prod_cat_language($idcategory_languages);
			$data = $this->admin_model->get_prod_cat_languages_by_idcategory($idcategory);
			if(!isset($data[0])){
				$deleted_categories = $this->admin_model->get_prod_prod_cat_idcategory($idcategory);
				
				if(isset($deleted_categories[0])){
					foreach($deleted_categories as $deleted_category){
						$deleted_product = $this->admin_model->get_product_by_id($idproduct);
						$this->admin_model->delete_subproduct_by_idparent($deleted_category['idproduct']);	
						$this->admin_model->delete_subproduct_by_idchild($deleted_category['idproduct']);	
						$this->admin_model->delete_product_product_category_by_idproduct($deleted_category['idproduct']);
						$this->admin_model->delete_product_languages_by_idproduct($deleted_category['idproduct']);	
						$this->admin_model->delete_product($deleted_category['idproduct']);	
						if(isset($deleted_product[0])){
							if($deleted_product[0]['photo']!=''){
								unlink('./files/img/products/'.$deleted_product[0]['photo']);
								unlink('./files/img/products/min/'.$deleted_product[0]['photo']);
							}
						}
					}
				}
				$this->admin_model->delete_product_category($idcategory);	
			}
		}
		redirect('/admin/products', 'location');	
	}

	function change_product_gallery($id){
		$allow = $this->check_login('products', '', true);
		if($allow){
			$data=array( 'idgalleries' => $_POST['idgallery']);
			$this->admin_model->update_product($id, $data);
		}
		redirect('/admin/products', 'location');
	}

    function change_article_gallery($id){
		$allow = $this->check_login('articles', '', true);
		if($allow){
			$data=array( 'idgalleries' => $_POST['idgallery']);
			$this->admin_model->update_article($id, $data);
		}
		redirect('/admin/articles', 'location');
	}
	
	function guest_book($idlang=3,$id=null)
	{
		//kasowanie wpisu w ksiedze gosci
		if(!empty($id))
		{
			$this->admin_model->del_guest($id);
		}
		
		$list['guests'] = $this->admin_model->get_all_guests();
		//$list['news_languages'] = $this->admin_model->get_news_languages();
		
		$data = $this->get_menus('guests_book');
		$content = $this->load->view('admin/elements/guests_book', $list, true);
		$data['content'] = $this->check_login('newses', $content);
		
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
	}
    //--------------------------------------------------------------------------
    function lists($idlang=3)
    {
        $data                   = $this->get_menus('lists');
        $viewData['lists']      = $this->list_model->getTree();
        
        $content                = $this->load->view('admin/elements/lists', $viewData, true);

        $data['content']        = $this->check_login('lists', $content);
        
		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
    }
    //--------------------------------------------------------------------------
    function add_list_item($idlang=3)
    {
        $data   = $this->get_menus('lists');
		$allow  = $this->check_login('lists', '', true);
      
        if($allow)
        {

            if(!empty($_POST))
            {
                $this->load->library('form_validation');
                $this->lang->switch_to('polish');

                $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
                $this->form_validation->set_rules('name', 'Nazwa', 'required');
                $this->form_validation->set_rules('description', 'Opis', '');
                $this->form_validation->set_rules('link', 'Link', '');
                $this->form_validation->set_rules('image', 'Obrazek', '');
                $this->form_validation->set_rules('param1', 'Param 1', '');
                $this->form_validation->set_rules('param2', 'Param 2', '');
                $this->form_validation->set_rules('param3', 'Param 3', '');
                $this->form_validation->set_rules('param4', 'Param 4', '');

                $this->form_validation->set_rules('parent_id', 'Kategoria nadrzędna', 'integer');
                $this->form_validation->set_rules('show_order', 'Kolejność', 'integer');
                $this->form_validation->set_rules('id_galleries', 'Galeria', 'integer');

                if($this->form_validation->run() == TRUE)
                {
                    //nullable fields
                    $parent_id                  =   set_value('parent_id');
                    $id_galleries               =   set_value('id_galleries');
                    $link                       =   set_value('link');

                    $param1                     =   set_value('param1');
                    $param2                     =   set_value('param2');
                    $param3                     =   set_value('param3');
                    $param4                     =   set_value('param4');


                    if(isset($_FILES['image']) && $_FILES['image']['name']!=''){
                        //uploadowanie pliku
                        $config['upload_path'] = './files/img/lists/';
                        $config['allowed_types'] = 'gif|jpg|png';
                        $config['remove_spaces'] = TRUE;

                        $this->load->library('upload', $config);
                        if($this->upload->do_upload('image'))
                        {
                            $file_data = $this->upload->data();
                            //zmiana praw pliku
                            chmod('./files/img/lists/'.$file_data['file_name'], 0777);
                            rename('./files/img/lists/'.$file_data['file_name'], './files/img/lists/'.date("Y_m_d-H_i_s_u").".jpg");
                            $item['image']      = '/files/img/lists/'.date("Y_m_d-H_i_s_u").".jpg";
                        }
                    }

                    //------------------------------------------------------
                    $item['name']           =   set_value('name');
                    $item['description']    =   set_value('description');

                    $item['description']    = trim($item['description']);
                    if($item['description'] == '<br />' || $item['description'] == '<br/>' || $item['description'] == '&lt;br /&gt;')
                        $item['description']  = null;

                    $item['parent_id']      =   empty($parent_id) ? null : set_value('parent_id');
                    $item['link']           =   empty($link) ? null : set_value('link');
                    $item['param1']         =   empty($param1) ? null : set_value('param1');
                    $item['param2']         =   empty($param2) ? null : set_value('param2');
                    $item['param3']         =   empty($param3) ? null : set_value('param3');
                    $item['param4']         =   empty($param4) ? null : set_value('param4');

                    $item['show_order']     =   set_value('show_order');
                    $item['id_galleries']   =   empty($id_galleries) ? null : set_value('id_galleries');

                    if($this->list_model->create($item))
                       redirect('admin/lists','location');
                    else
                        $data['message'] = "Wystąpił błąd";
                }
            }
            
            $data['lists']              = $this->list_model->getAll();
            $data['galleries']          = $this->admin_model->get_galleries();
            $data['content']            = $this->load->view('admin/elements/add_list_item', $data, true);
        }
        else
           $data['content'] = ucfirst($this->site['nie_masz_uprawnien_do_tego_zasobu']);

        $metatags        = $this->get_standard_metatags('admin',$idlang);
        $this->load->view('admin/layout/header', $metatags);
        $this->load->view('admin/layout/admin',$data);
    }
    //--------------------------------------------------------------------------
    function edit_list_item($id,$idlang = 3)
    {
		$allow                      = $this->check_login('lists', '', true);
        $data                       = $this->get_menus('lists');
        

        if($allow)
        {
            $data['list_item']   = $this->list_model->getById($id);
            if(!empty($_POST))
            {
                $this->load->library('form_validation');
                $this->lang->switch_to('polish');

                $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
                $this->form_validation->set_rules('name', 'Nazwa', 'required');
                $this->form_validation->set_rules('description', 'Opis', '');
                $this->form_validation->set_rules('link', 'Link', '');

                $this->form_validation->set_rules('param1', 'Param1', '');
                $this->form_validation->set_rules('param2', 'Param2', '');
                $this->form_validation->set_rules('param3', 'Param3', '');
                $this->form_validation->set_rules('param4', 'Param4', '');

                $this->form_validation->set_rules('parent_id', 'Kategoria nadrzędna', 'integer');
                $this->form_validation->set_rules('show_order', 'Kolejność', 'integer');
                $this->form_validation->set_rules('id_galleries', 'Galeria', 'integer');

                if($this->form_validation->run() == TRUE)
                {
                    $parent_id                  =   set_value('parent_id');
                    $id_galleries               =   set_value('id_galleries');
                    $link                       =   set_value('link');
                    //----------------------------------------------------------
                    if(isset($_FILES['image']) && $_FILES['image']['name']!=''){
                        //uploadowanie pliku
                        $config['upload_path'] = './files/img/lists/';
                        $config['allowed_types'] = 'gif|jpg|png';
                        $config['remove_spaces'] = TRUE;

                        $this->load->library('upload', $config);
                        if($this->upload->do_upload('image'))
                        {
                            $file_data = $this->upload->data();
                            //zmiana praw pliku
                            chmod('./files/img/lists/'.$file_data['file_name'], 0777);
                            rename('./files/img/lists/'.$file_data['file_name'], './files/img/lists/'.date("Y_m_d-H_i_s_u").".jpg");
                            $item['image']      = '/files/img/lists/'.date("Y_m_d-H_i_s_u").".jpg";
                        }
                    }


                    $item['name']           =   set_value('name');
                    $item['description']    =   set_value('description');

                    $item['link']           =   empty($link) ? null : set_value('link');

                    $item['param1']           =   empty($link) ? null : set_value('param1');
                    $item['param2']           =   empty($link) ? null : set_value('param2');
                    $item['param3']           =   empty($link) ? null : set_value('param3');
                    $item['param4']           =   empty($link) ? null : set_value('param4');

                    $item['description']    = trim($item['description']);
                    if($item['description'] == '<br />' || $item['description'] == '<br/>' || $item['description'] == '&lt;br /&gt;')
                        $item['description']  = null;

                    $item['parent_id']      =   empty($parent_id) ? null : set_value('parent_id');
                    $item['show_order']     =   set_value('show_order');
                    $item['id_galleries']   =   empty($id_galleries) ? null : set_value('id_galleries');

                    //----------------------------------------------------------
                    $data['list_item']->parent_id       = $item['parent_id'];
                    $data['list_item']->name            = $item['name'];
                    $data['list_item']->description     = $item['description'];
                    $data['list_item']->link            = $item['link'];

                    $data['param1']->link            = $item['param1'];
                    $data['param2']->link            = $item['param2'];
                    $data['param3']->link            = $item['param3'];
                    $data['param4']->link            = $item['param4'];

                    $data['list_item']->show_order      = $item['show_order'];
                    $data['list_item']->id_galleries    = $item['id_galleries'];

                    if($this->list_model->update($id,$item))
                       redirect('admin/lists','location');
                    else
                        $data['message'] = "Wystąpił błąd";
                }
            }


            $data['lists']              = $this->list_model->getAll();
            $data['galleries']          = $this->admin_model->get_galleries();
            $data['content']            = $this->load->view('admin/elements/edit_list_item', $data, true);
        }
        else
           $data['content'] = ucfirst($this->site['nie_masz_uprawnien_do_tego_zasobu']);

        $metatags        = $this->get_standard_metatags('admin',$idlang);
        $this->load->view('admin/layout/header', $metatags);
        $this->load->view('admin/layout/admin',$data);
    }
    //--------------------------------------------------------------------------
    function delete_list_item($id)
    {
        $allow  = $this->check_login('lists', '', true);
        if($allow)
        {        
            $id = (int)$id;
            $this->list_model->delete($id);
        }
        redirect('admin/lists','location');
    }
    //--------------------------------------------------------------------------
    function delete_list_item_image($id)
    {
		$allow       = $this->check_login('lists', '', true);

        if($allow)
        {        
            $id                 = (int)$id;
            $list_item   = $this->list_model->getById($id);

            if(!empty($list_item->image))
                unlink('.'.$list_item->image);

            $item['image']      =  '';
            $this->list_model->update($id,$item);
        }
        redirect('admin/lists','location');
    }
    //--------------------------------------------------------------------------
    function immovables($idlang=3)
    {
        $data                   = $this->get_menus('immovables');
        $viewData['immovables'] = $this->immovable_model->getAll();

        $languages              = $this->admin_model->get_languages();

        if(!empty($viewData['immovables']) && is_array($viewData['immovables']))
            foreach($viewData['immovables'] as $k=>$v)
            {
                $viewData['immovables'][$k]['languages']            = $this->immovable_model->getLangVersions($v['id']);
                $viewData['immovables'][$k]['not_added_languages']  = null;

                if(!empty($languages) && is_array($languages))
                foreach($languages as $kk=>$vv)
                {
                    $exists = false;

                    if(!empty($viewData['immovables'][$k]['languages']) && is_array($viewData['immovables'][$k]['languages']))
                        foreach($viewData['immovables'][$k]['languages'] as $kkk=>$vvv)
                            if($vvv['lang_id'] == $vv['idlanguages'])
                                {$exists = true; break;}

                    if(!$exists)
                    {
                        $viewData['immovables'][$k]['not_added_languages'][] = $vv;
                    }
                }
            }

        $content                = $this->load->view('admin/elements/immovables', $viewData, true);
        $data['content']        = $this->check_login('immovables', $content);

		$metatags = $this->get_standard_metatags('admin',$idlang);
		$this->load->view('admin/layout/header', $metatags);
		$this->load->view('admin/layout/admin',$data);
    }
    //--------------------------------------------------------------------------
    function add_immovable($idlang=3)
    {
        $data   = $this->get_menus('immovables');
		$allow  = $this->check_login('immovables', '', true);

        if($allow)
        {
            if(!empty($_POST))
            {
                $this->load->library('form_validation');
                $this->lang->switch_to('polish');

                $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
                $this->form_validation->set_rules('name', 'Nazwa', 'required');
                $this->form_validation->set_rules('price', 'Cena', 'required');

                $this->form_validation->set_rules('building_type_id', 'Typ budynku', 'required');
                $this->form_validation->set_rules('offer_type_id', 'Typ ofert', 'required');
                $this->form_validation->set_rules('gallery_id', 'Galeria', 'required');
                $this->form_validation->set_rules('lang_id', 'Język', 'required');


                $this->form_validation->set_rules('localization', 'Lokalizacja', '');
                $this->form_validation->set_rules('surface', 'Powierzchnia', '');
                $this->form_validation->set_rules('floor', 'Piętro', '');
                $this->form_validation->set_rules('rooms', 'Ilość pokoi', '');
                $this->form_validation->set_rules('garage_surface', 'Powierzchnia garażowana', '');
                $this->form_validation->set_rules('plot_type', 'Typ działki', '');

                $this->form_validation->set_rules('description', 'Opis', '');
                $this->form_validation->set_rules('nowelty', 'Nowość', '');
                $this->form_validation->set_rules('active', 'Aktywność', '');

                $data['form_values']['name']                   =    $_POST['name'];
                $data['form_values']['price']                   =    $_POST['price'];
                $data['form_values']['building_type_id']       =   (int)$_POST['building_type_id'];
                $data['form_values']['offer_type_id']          =   (int)$_POST['offer_type_id'];
                $data['form_values']['gallery_id']             =   (int)$_POST['gallery_id'];
                $data['form_values']['lang_id']                =   (int)$_POST['lang_id'];

                $data['form_values']['localization']           =   empty($_POST['localization'])    ? null:$_POST['localization'];
                $data['form_values']['surface']                   =   empty($_POST['surface'])            ? null:$_POST['surface'];
                $data['form_values']['floor']                  =   empty($_POST['floor'])           ? null:$_POST['floor'];
                $data['form_values']['rooms']                  =   empty($_POST['rooms'])           ? null:$_POST['rooms'];
                $data['form_values']['garage_surface']            =   empty($_POST['garage_surface'])     ? null:$_POST['garage_surface'];
                $data['form_values']['plot_type']               =   empty($_POST['plot_type'])     ? null:$_POST['plot_type'];


                $data['form_values']['description']            =   empty($_POST['description'])     ? null:$_POST['description'];
                $data['form_values']['nowelty']                =   isset($_POST['nowelty'])         ? true:false;
                $data['form_values']['active']                 =   isset($_POST['active'])          ? true:false;
                $data['form_values']['date_added']             =   date("Y_m_d-H_i_s");

                if($this->form_validation->run() == TRUE)
                {

                    $immovable['name']                      = $data['form_values']['name'];

                    $immovable['nowelty']                   = $data['form_values']['nowelty'];
                    $immovable['active']                    = $data['form_values']['active'];
                    $immovable['date_added']                = $data['form_values']['date_added'];

                    $immovable['building_type_id']          = $data['form_values']['building_type_id'];
                    $immovable['offer_type_id']             = $data['form_values']['offer_type_id'];
                    $immovable['gallery_id']                = $data['form_values']['gallery_id'];


                    $immovable['localization']              = $data['form_values']['localization'];
                    $immovable['surface']                      = $data['form_values']['surface'];

                    $immovable['rooms']                     = $data['form_values']['rooms'];
                    $immovable['garage_surface']               = $data['form_values']['garage_surface'];
                    

                    //----------------------------------------------------------
                    $immovable_language['lang_id']          = $data['form_values']['lang_id'];
                    $immovable_language['floor']            = $data['form_values']['floor'];
                    $immovable_language['price']            = $data['form_values']['price'];
                    $immovable_language['description']      = $data['form_values']['description'];
                    $immovable_language['plot_type']        = $data['form_values']['plot_type'];
                    //----------------------------------------------------------

                    if($this->immovable_model->create($immovable,$immovable_language))
                       redirect('admin/immovables','location');
                    else
                        $data['message'] = "Wystąpił błąd";
                }
            }
            

            
            
            $data['galleries']         = $this->admin_model->get_gallery_list(3);
            $data['languages']         = $this->admin_model->get_languages();
            $data['building_types']    = $this->immovable_model->getBuildingTypes();
            $data['offer_types']       = $this->immovable_model->getOfferTypes();
            $data['content']           = $this->load->view('admin/elements/add_immovable', $data, true);

        }
        else
           $data['content'] = ucfirst($this->site['nie_masz_uprawnien_do_tego_zasobu']);

        $metatags        = $this->get_standard_metatags('admin',$idlang);
        $this->load->view('admin/layout/header', $metatags);
        $this->load->view('admin/layout/admin',$data);
    }
    //--------------------------------------------------------------------------
    function add_immovable_language($id,$idlang=3)
    {
        $id     = (int)$id;
        $idlang = (int)$idlang;

        if(empty($id) || empty($idlang))
            redirect('admin/immovables','location');

        $data               = $this->get_menus('immovables');
	$allow              = $this->check_login('immovables', '', true);
        $data['immovable']  = $this->immovable_model->getByLangVersionId($id,$idlang);

        if($allow)
        {
            $data['lang_verson']        = '';
            $data['languages']          = $this->admin_model->get_languages();
            foreach($data['languages'] as $k=>$v)
                if($v['idlanguages'] == $idlang)
                {
                    $data['lang_verson'] = $v['shortname'];
                    break;
                }

            if(!empty($_POST))
            {
                $this->load->library('form_validation');
                $this->lang->switch_to('polish');
                $this->form_validation->set_error_delimiters('<span class="error">', '</span>');

                $this->form_validation->set_rules('plot_type', 'Typ działki', '');
                $this->form_validation->set_rules('localization', 'Lokalizacja', '');
                $this->form_validation->set_rules('surface', 'Powierzchnia', '');
                $this->form_validation->set_rules('floor', 'Piętro', '');
                $this->form_validation->set_rules('rooms', 'Ilość pokoi', '');
                $this->form_validation->set_rules('price', 'Cena', '');
                $this->form_validation->set_rules('garage_surface', 'Powierzchnia garażowana', '');
                $this->form_validation->set_rules('description', 'Opis', '');


                $data['form_values']['plot_type']       =   empty($_POST['plot_type']) ? null:$_POST['plot_type'];
                $data['form_values']['localization']    =   empty($_POST['localization']) ? null:$_POST['localization'];
                $data['form_values']['surface']         =   empty($_POST['surface']) ? null:$_POST['surface'];
                $data['form_values']['floor']           =   empty($_POST['floor']) ? null:$_POST['floor'];
                $data['form_values']['rooms']           =   empty($_POST['rooms']) ? null:$_POST['rooms'];
                $data['form_values']['price']           =   empty($_POST['price']) ? null:$_POST['price'];
                $data['form_values']['garage_surface']  =   empty($_POST['garage_surface']) ? null:$_POST['garage_surface'];
                $data['form_values']['description']     =   empty($_POST['description']) ? null:$_POST['description'];

                if($this->form_validation->run() == TRUE)
                {

                    
                    $immobable['localization']      =   $data['form_values']['localization'];
                    $immobable['surface']           =   $data['form_values']['surface'];

                    $immobable['rooms']            =   $data['form_values']['rooms'];
                    $immobable['garage_surface']   =   $data['form_values']['garage_surface'];


                    $immobable_lang['immovable_id']     =   $id;
                    $immobable_lang['lang_id']          =   $idlang;

                    $immobable_lang['price']            =   $data['form_values']['price'];
                    $immobable_lang['floor']            =   $data['form_values']['floor'];
                    $immobable_lang['description']      =   $data['form_values']['description'];
                    $immobable_lang['plot_type']         =   $data['form_values']['plot_type'];

                    if($this->immovable_model->createLang($immobable_lang) && $this->immovable_model->update($id,$immobable))
                       redirect('admin/immovables','location');
                    else
                    {
                        $data['message'] = "Wystąpił błąd";
                    }
                }
            }
            else
            {
                //wczytaj pl jako wzor do dodania kolejnych wersji
                 $immovable = $this->immovable_model->getById($id,3);
                 if(!empty($immovable))
                 {
                     
                    $data['form_values']['name']            = $immovable['name'];
                    $data['form_values']['plot_type']       = $immovable['plot_type'];
                    $data['form_values']['localization']    = $immovable['localization'];
                    $data['form_values']['surface']         = $immovable['surface'];
                    $data['form_values']['rooms']           = $immovable['rooms'];
                    $data['form_values']['floor']           = $immovable['floor'];
                    $data['form_values']['price']           = $immovable['price'];
                    $data['form_values']['description']     = $immovable['description'];
                    $data['form_values']['garage_surface']  = $immovable['garage_surface'];
                 }
            }
            //$data['content']           = $this->load->view('admin/elements/edit_immovable_lang', $data, true);
            $data['content'] = $this->load->view('admin/elements/add_immovable_language', $data, true);
        }
        else
           $data['content'] = ucfirst($this->site['nie_masz_uprawnien_do_tego_zasobu']);

        $metatags        = $this->get_standard_metatags('admin',$idlang);
        $this->load->view('admin/layout/header', $metatags);
        $this->load->view('admin/layout/admin',$data);
    }
    //--------------------------------------------------------------------------
    function edit_immovable($id,$idlang=3)
    {
        $data               = $this->get_menus('immovables');
	$allow              = $this->check_login('immovables', '', true);
        

        if($allow)
        {
            $data['form_values'] = $this->immovable_model->getById($id);
            if(empty($data['form_values']))
                $data['message'] = "Wystąpił błąd";


            
            if(!empty($_POST))
            {
                $this->load->library('form_validation');
                $this->lang->switch_to('polish');

                $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
                $this->form_validation->set_rules('building_type_id', 'Typ budynku', 'required');
                $this->form_validation->set_rules('offer_type_id', 'Typ ofert', 'required');
                $this->form_validation->set_rules('gallery_id', 'Galeria', 'required');
                $this->form_validation->set_rules('name', 'Nazwa', 'required');

                $this->form_validation->set_rules('nowelty', 'Nowość', '');
                $this->form_validation->set_rules('active', 'Aktywność', '');

                $data['form_values']['building_type_id']       =   (int)$_POST['building_type_id'];
                $data['form_values']['offer_type_id']          =   (int)$_POST['offer_type_id'];
                $data['form_values']['gallery_id']             =   (int)$_POST['gallery_id'];

                $data['form_values']['name']                   =   empty($_POST['name'])            ? null:$_POST['name'];

                $data['form_values']['nowelty']                =   isset($_POST['nowelty'])         ? true:false;
                $data['form_values']['active']                 =   isset($_POST['active'])          ? true:false;


                if($this->form_validation->run() == TRUE)
                {
                    $immobable['building_type_id']  =   $data['form_values']['building_type_id'];
                    $immobable['offer_type_id']     =   $data['form_values']['offer_type_id'];
                    $immobable['gallery_id']        =   $data['form_values']['gallery_id'];

                    $immobable['name']      =   $data['form_values']['name'];
                    $immobable['nowelty']   =   $data['form_values']['nowelty'];
                    $immobable['active']    =   $data['form_values']['active'];

                    if($this->immovable_model->update($id,$immobable))
                       redirect('admin/immovables','location');
                    else
                        echo $data['message'] = "Wystąpił błąd przy edycji danych";
                }
                else
                   $data['message'] = "Wystąpił błąd podczas walidacji danych";
            }
            $data['galleries']         = $this->admin_model->get_gallery_list(3);
            $data['building_types']    = $this->immovable_model->getBuildingTypes();
            $data['offer_types']       = $this->immovable_model->getOfferTypes();
            $data['content']           = $this->load->view('admin/elements/edit_immovable', $data, true);
        }
        else
           $data['content'] = ucfirst($this->site['nie_masz_uprawnien_do_tego_zasobu']);

        $metatags        = $this->get_standard_metatags('admin',$idlang);
        $this->load->view('admin/layout/header', $metatags);
        $this->load->view('admin/layout/admin',$data);
    }
    //--------------------------------------------------------------------------
    function edit_immovable_lang($id,$idlang=3)
    {
        $id                 = (int)$id;
        $data               = $this->get_menus('immovables');
	$allow              = $this->check_login('immovables', '', true);
        $data['immovable']  = $this->immovable_model->getByLangVersionId($id,$idlang);

        
        if($allow)
        {
            $data['form_values'] = $this->immovable_model->getLangVersion($id);
            $idlang              = empty($data['form_values']['lang_id']) ? $idlang: $data['form_values']['lang_id'];
            $data['form_values']['name']     = '';



            if(!empty($data['form_values']) && !empty($data['form_values']['immovable_id']))
            {
                 $immovable = $this->immovable_model->getById($data['form_values']['immovable_id'],$idlang);
                 if(!empty($immovable))
                 {
                    $data['form_values']['name']            = $immovable['name'];
                    $data['form_values']['plot_type']       = $immovable['plot_type'];
                    $data['form_values']['localization']    = $immovable['localization'];
                    $data['form_values']['surface']         = $immovable['surface'];
                    $data['form_values']['rooms']           = $immovable['rooms'];
                    $data['form_values']['garage_surface']  = $immovable['garage_surface'];
                 }
                 
                 
            }
            else
                redirect('admin/immovables','location');

            if(!empty($_POST))
            {
                $this->load->library('form_validation');
                $this->lang->switch_to('polish');
                $this->form_validation->set_error_delimiters('<span class="error">', '</span>');

                $this->form_validation->set_rules('plot_type', 'Typ działki', '');
                $this->form_validation->set_rules('localization', 'Lokalizacja', '');
                $this->form_validation->set_rules('surface', 'Powierzchnia', '');
                $this->form_validation->set_rules('floor', 'Piętro', '');
                $this->form_validation->set_rules('rooms', 'Ilość pokoi', '');
                $this->form_validation->set_rules('price', 'Cena', '');
                $this->form_validation->set_rules('garage_surface', 'Powierzchnia garażowana', '');
                $this->form_validation->set_rules('description', 'Opis', '');

                $data['form_values']['plot_type']       =   empty($_POST['plot_type']) ? null:$_POST['plot_type'];
                $data['form_values']['localization']    =   empty($_POST['localization']) ? null:$_POST['localization'];
                $data['form_values']['surface']         =   empty($_POST['surface']) ? null:$_POST['surface'];

                $data['form_values']['floor']           =   empty($_POST['floor']) ? null:$_POST['floor'];
                $data['form_values']['rooms']           =   empty($_POST['rooms']) ? null:$_POST['rooms'];
                $data['form_values']['price']           =   empty($_POST['price']) ? null:$_POST['price'];
                $data['form_values']['garage_surface']  =   empty($_POST['garage_surface']) ? null:$_POST['garage_surface'];

                $data['form_values']['description']     =   empty($_POST['description']) ? null:$_POST['description'];

                if($this->form_validation->run() == TRUE)
                {

                    $immovable_data = null;
                    
                    $immovable_data['localization']     =   $data['form_values']['localization'];
                    $immovable_data['surface']          =   $data['form_values']['surface'];
                    $immovable_data['rooms']            =   $data['form_values']['rooms'];
                    $immovable_data['garage_surface']   =   $data['form_values']['garage_surface'];


                    $immovable_lang['floor']            =   $data['form_values']['floor'];
                    $immovable_lang['price']            =   $data['form_values']['price'];
                    $immovable_lang['description']      =   $data['form_values']['description'];
                    $immovable_lang['plot_type']        =   $data['form_values']['plot_type'];

                    
                    if($this->immovable_model->update($data['form_values']['immovable_id'],$immovable_data) &&  $this->immovable_model->updateLangVersion($id,$immovable_lang))
                       redirect('admin/immovables','location');
                    else
                    {
                        $data['message'] = "Wystąpił błąd";
                    }
                }
            }
            $data['content']           = $this->load->view('admin/elements/edit_immovable_lang', $data, true);
        }
        else
           $data['content'] = ucfirst($this->site['nie_masz_uprawnien_do_tego_zasobu']);

        $metatags        = $this->get_standard_metatags('admin',$idlang);
        $this->load->view('admin/layout/header', $metatags);
        $this->load->view('admin/layout/admin',$data);
    }
    //--------------------------------------------------------------------------
    function delete_immovable($id)
    {
        $allow  = $this->check_login('immovables', '', true);
        if($allow)
        {
            $id = (int)$id;
            $this->immovable_model->delete($id);
        }
        redirect('admin/immovables','location');
    }
    //--------------------------------------------------------------------------
}
?>