(function($) {

CKEDITOR.disableAutoInline = true;

// Exclude every id starting with 'cke_' in ajax_html_ids during AJAX requests.
Drupal.wysiwyg.excludeIdSelectors.wysiwyg_ckeditor = ['[id^="cke_"]'];

// Keeps track of private instance data.
var instanceMap;

/**
 * Initialize the editor library.
 *
 * This method is called once the first time a library is needed. If new
 * WYSIWYG fieldsare added later, update() will be called instead.
 *
 * @param settings
 *   An object containing editor settings for each input format.
 * @param pluginInfo
 *   An object containing global plugin configuration.
 */
Drupal.wysiwyg.editor.init.ckeditor = function(settings, pluginInfo) {
  instanceMap = {};
  // Nothing to do here other than register new plugins etc.
  Drupal.wysiwyg.editor.update.ckeditor(settings, pluginInfo);
};

/**
 * Update the editor library when new settings are available.
 *
 * This method is called instead of init() when at least one new WYSIWYG field
 * has been added to the document and the library has already been initialized.
 *
 * $param settings
 *   An object containing editor settings for each input format.
 * $param pluginInfo
 *   An object containing global plugin configuration.
 */
Drupal.wysiwyg.editor.update.ckeditor = function(settings, pluginInfo) {
  // Register native external plugins.
  // Array syntax required; 'native' is a predefined token in JavaScript.
  for (var pluginId in pluginInfo['native']) {
    if (pluginInfo['native'].hasOwnProperty(pluginId) && (!CKEDITOR.plugins.externals || !CKEDITOR.plugins.externals[pluginId])) {
      var plugin = pluginInfo['native'][pluginId];
      CKEDITOR.plugins.addExternal(pluginId, plugin.path, plugin.fileName);
    }
  }
  // Build and register Drupal plugin wrappers.
  for (var pluginId in pluginInfo.drupal) {
    if (pluginInfo.drupal.hasOwnProperty(pluginId) && (!CKEDITOR.plugins.registered || !CKEDITOR.plugins.registered[pluginId])) {
      Drupal.wysiwyg.editor.instance.ckeditor.addPlugin(pluginId, pluginInfo.drupal[pluginId]);
    }
  }
  // Register Font styles (versions 3.2.1 and above).
  for (var format in settings) {
    if (settings[format].stylesSet && (!CKEDITOR.stylesSet || !CKEDITOR.stylesSet.registered[format])) {
      CKEDITOR.stylesSet.add(format, settings[format].stylesSet);
    }
  }
};

/**
 * Attach this editor to a target element.
 */
Drupal.wysiwyg.editor.attach.ckeditor = function(context, params, settings) {
  // Apply editor instance settings.
  CKEDITOR.config.customConfig = '';

  var $drupalToolbars = $('#toolbar, #admin-menu', Drupal.overlayChild ? window.parent.document : document);
  if (!settings.height) {
    settings.height = $('#' + params.field).height();
  }
  settings.on = {
    instanceReady: function(ev) {
      var editor = ev.editor;
      // Get a list of block, list and table tags from CKEditor's XHTML DTD.
      // @see http://docs.cksource.com/CKEditor_3.x/Developers_Guide/Output_Formatting.
      var dtd = CKEDITOR.dtd;
      var tags = CKEDITOR.tools.extend({}, dtd.$block, dtd.$listItem, dtd.$tableContent);
      // Set source formatting rules for each listed tag except <pre>.
      // Linebreaks can be inserted before or after opening and closing tags.
      if (settings.simple_source_formatting) {
        // Mimic FCKeditor output, by breaking lines between tags.
        for (var tag in tags) {
          if (tag == 'pre') {
            continue;
          }
          this.dataProcessor.writer.setRules(tag, {
            indent: true,
            breakBeforeOpen: true,
            breakAfterOpen: false,
            breakBeforeClose: false,
            breakAfterClose: true
          });
        }
      }
      else {
        // CKEditor adds default formatting to <br>, so we want to remove that
        // here too.
        tags.br = 1;
        // No indents or linebreaks;
        for (var tag in tags) {
          if (tag == 'pre') {
            continue;
          }
          this.dataProcessor.writer.setRules(tag, {
            indent: false,
            breakBeforeOpen: false,
            breakAfterOpen: false,
            breakBeforeClose: false,
            breakAfterClose: false
          });
        }
      }
    },

    pluginsLoaded: function(ev) {
      var wysiwygInstance = instanceMap[this.name];
      var enabledPlugins = wysiwygInstance.pluginInfo.instances.drupal;
      // Override the conversion methods to let Drupal plugins modify the data.
      var editor = ev.editor;
      if (editor.dataProcessor && enabledPlugins) {
        editor.dataProcessor.toHtml = CKEDITOR.tools.override(editor.dataProcessor.toHtml, function(originalToHtml) {
          // Convert raw data for display in WYSIWYG mode.
          return function(data, fixForBody) {
            for (var plugin in enabledPlugins) {
              if (typeof Drupal.wysiwyg.plugins[plugin].attach == 'function') {
                data = Drupal.wysiwyg.plugins[plugin].attach(data, wysiwygInstance.pluginInfo.global.drupal[plugin], editor.name);
                data = wysiwygInstance.prepareContent(data);
              }
            }
            return originalToHtml.call(this, data, fixForBody);
          };
        });
        editor.dataProcessor.toDataFormat = CKEDITOR.tools.override(editor.dataProcessor.toDataFormat, function(originalToDataFormat) {
          // Convert WYSIWYG mode content to raw data.
          return function(data, fixForBody) {
            data = originalToDataFormat.call(this, data, fixForBody);
            for (var plugin in enabledPlugins) {
              if (typeof Drupal.wysiwyg.plugins[plugin].detach == 'function') {
                data = Drupal.wysiwyg.plugins[plugin].detach(data, wysiwygInstance.pluginInfo.global.drupal[plugin], editor.name);
              }
            }
            return data;
          };
        });
      }
    },

    selectionChange: function (event) {
      var wysiwygInstance = instanceMap[this.name];
      var enabledPlugins = wysiwygInstance.pluginInfo.instances.drupal;
      for (var name in enabledPlugins) {
        var plugin = Drupal.wysiwyg.plugins[name];
        if ($.isFunction(plugin.isNode)) {
          var node = event.data.selection.getSelectedElement();
          var state = plugin.isNode(node ? node.$ : null) ? CKEDITOR.TRISTATE_ON : CKEDITOR.TRISTATE_OFF;
          event.editor.getCommand(name).setState(state);
        }
      }
    },

    focus: function(ev) {
      Drupal.wysiwyg.activeId = ev.editor.name;
    },

    afterCommandExec: function(ev) {
      // Fix Drupal toolbar obscuring editor toolbar in fullscreen mode.
      if (ev.data.name != 'maximize') {
        return;
      }
      if (ev.data.command.state == CKEDITOR.TRISTATE_ON) {
        $drupalToolbars.hide();
      }
      else {
        $drupalToolbars.show();
      }
    },

    destroy: function (event) {
      // Free our reference to the private instance to not risk memory leaks.
      delete instanceMap[this.name];
    }
  };
  instanceMap[params.field] = this;
  // Attach editor.
  var editorInstance = CKEDITOR.replace(params.field, settings);
};

/**
 * Detach a single editor instance.
 */
Drupal.wysiwyg.editor.detach.ckeditor = function (context, params, trigger) {
  var method = (trigger == 'serialize') ? 'updateElement' : 'destroy';
  var instance = CKEDITOR.instances[params.field];
  if (!instance) {
    return;
  }
  instance[method]();
};

Drupal.wysiwyg.editor.instance.ckeditor = {
  addPlugin: function (pluginName, pluginSettings) {
    CKEDITOR.plugins.add(pluginName, {
      // Wrap Drupal plugin in a proxy pluygin.
      init: function(editor) {
        if (pluginSettings.css) {
          editor.on('mode', function(ev) {
            if (ev.editor.mode == 'wysiwyg') {
              // Inject CSS files directly into the editing area head tag.
              var iframe = $('#cke_contents_' + ev.editor.name + ' iframe, #' + ev.editor.id + '_contents iframe');
              $('head', iframe.eq(0).contents()).append('<link rel="stylesheet" href="' + pluginSettings.css + '" type="text/css" >');
            }
          });
        }
        if (typeof Drupal.wysiwyg.plugins[pluginName].invoke == 'function') {
          var pluginCommand = {
            exec: function (editor) {
              var data = { format: 'html', node: null, content: '' };
              var selection = editor.getSelection();
              if (selection) {
                data.node = selection.getSelectedElement();
                if (data.node) {
                  data.node = data.node.$;
                }
                if (selection.getType() == CKEDITOR.SELECTION_TEXT) {
                  data.content = selection.getSelectedText();
                }
                else if (data.node) {
                  // content is supposed to contain the "outerHTML".
                  data.content = data.node.parentNode.innerHTML;
                }
              }
              Drupal.wysiwyg.plugins[pluginName].invoke(data, pluginSettings, editor.name);
            }
          };
          editor.addCommand(pluginName, pluginCommand);
        }
        editor.ui.addButton(pluginName, {
          label: pluginSettings.title,
          command: pluginName,
          icon: pluginSettings.icon
        });

        // @todo Add button state handling.
      }
    });
  },
  prepareContent: function(content) {
    // @todo Don't know if we need this yet.
    return content;
  },

  insert: function(content) {
    content = this.prepareContent(content);
    if (CKEDITOR.env.webkit || CKEDITOR.env.chrome || CKEDITOR.env.opera || CKEDITOR.env.safari) {
      // Works around a WebKit bug which removes wrapper elements.
      // @see https://drupal.org/node/1927968
      var tmp = new CKEDITOR.dom.element('div'), children, skip = 0, item;
      tmp.setHtml(content);
      children = tmp.getChildren();
      skip = 0;
      while (children.count() > skip) {
        item = children.getItem(skip);
        switch(item.type) {
          case 1:
            CKEDITOR.instances[this.field].insertElement(item);
            break;
          case 3:
            CKEDITOR.instances[this.field].insertText(item.getText());
            skip++;
            break;
          case 8:
            CKEDITOR.instances[this.field].insertHtml(item.getOuterHtml());
            skip++;
            break;
        }
      }
    }
    else {
      CKEDITOR.instances[this.field].insertHtml(content);
    }
  },

  setContent: function (content) {
    CKEDITOR.instances[this.field].setData(content);
  },

  getContent: function () {
    return CKEDITOR.instances[this.field].getData();
  },

  isFullscreen: function () {
    var cmd = CKEDITOR.instances[this.field].commands.maximize;
    return !!(cmd && cmd.state == CKEDITOR.TRISTATE_ON);
  }
};

})(jQuery);
;
(function($) {

/**
 * Attach this editor to a target element.
 *
 * @param context
 *   A DOM element, supplied by Drupal.attachBehaviors().
 * @param params
 *   An object containing input format parameters. Default parameters are:
 *   - editor: The internal editor name.
 *   - theme: The name/key of the editor theme/profile to use.
 *   - field: The CSS id of the target element.
 * @param settings
 *   An object containing editor settings for all enabled editor themes.
 */
Drupal.wysiwyg.editor.attach.none = function(context, params, settings) {
  if (params.resizable) {
    var $wrapper = $('#' + params.field, context).parents('.form-textarea-wrapper:first');
    $wrapper.addClass('resizable');
    if (Drupal.behaviors.textarea) {
      Drupal.behaviors.textarea.attach(context);
    }
  }
};

/**
 * Detach a single editor instance.
 *
 * The editor syncs its contents back to the original field before its instance
 * is removed.
 *
 * In here, 'this' is an instance of WysiwygInternalInstance.
 * See Drupal.wysiwyg.editor.instance.none for more details.
 *
 * @param context
 *   A DOM element, supplied by Drupal.attachBehaviors().
 * @param params
 *   An object containing input format parameters. Only the editor instance in
 *   params.field should be detached and saved, so its data can be submitted in
 *   AJAX/AHAH applications.
 * @param trigger
 *   A string describing why the editor is being detached.
 *   Possible triggers are:
 *   - unload: (default) Another or no editor is about to take its place.
 *   - move: Currently expected to produce the same result as unload.
 *   - serialize: The form is about to be serialized before an AJAX request or
 *     a normal form submission. If possible, perform a quick detach and leave
 *     the editor's GUI elements in place to avoid flashes or scrolling issues.
 * @see Drupal.detachBehaviors
 */
Drupal.wysiwyg.editor.detach.none = function (context, params, trigger) {
  if (trigger != 'serialize') {
    var $wrapper = $('#' + params.field, context).parents('.form-textarea-wrapper:first');
    $wrapper.removeOnce('textarea').removeClass('.resizable-textarea').removeClass('resizable')
      .find('.grippie').remove();
  }
};

/**
 * Instance methods for plain text areas.
 */
Drupal.wysiwyg.editor.instance.none = {
  insert: function(content) {
    var editor = document.getElementById(this.field);

    // IE support.
    if (document.selection) {
      editor.focus();
      var sel = document.selection.createRange();
      sel.text = content;
    }
    // Mozilla/Firefox/Netscape 7+ support.
    else if (editor.selectionStart || editor.selectionStart == '0') {
      var startPos = editor.selectionStart;
      var endPos = editor.selectionEnd;
      editor.value = editor.value.substring(0, startPos) + content + editor.value.substring(endPos, editor.value.length);
    }
    // Fallback, just add to the end of the content.
    else {
      editor.value += content;
    }
  },

  setContent: function (content) {
    $('#' + this.field).val(content);
  },

  getContent: function () {
    return $('#' + this.field).val();
  }
};

})(jQuery);
;
(function($) {
//Global container.
window.imce = {tree: {}, findex: [], fids: {}, selected: {}, selcount: 0, ops: {}, cache: {}, urlId: {},
vars: {previewImages: 1, cache: 1},
hooks: {load: [], list: [], navigate: [], cache: []},

//initiate imce.
initiate: function() {
  imce.conf = Drupal.settings.imce || {};
  if (imce.conf.error != false) return;
  imce.ie = (navigator.userAgent.match(/msie (\d+)/i) || ['', 0])[1] * 1;
  imce.FLW = imce.el('file-list-wrapper'), imce.SBW = imce.el('sub-browse-wrapper');
  imce.NW = imce.el('navigation-wrapper'), imce.BW = imce.el('browse-wrapper');
  imce.PW = imce.el('preview-wrapper'), imce.FW = imce.el('forms-wrapper');
  imce.updateUI();
  imce.prepareMsgs();//process initial status messages
  imce.initiateTree();//build directory tree
  imce.hooks.list.unshift(imce.processRow);//set the default list-hook.
  imce.initiateList();//process file list
  imce.initiateOps();//prepare operation tabs
  imce.refreshOps();
  // Bind global error handler
  $(document).ajaxError(imce.ajaxError);
  imce.invoke('load', window);//run functions set by external applications.
},

//process navigation tree
initiateTree: function() {
  $('#navigation-tree li').each(function(i) {
    var a = this.firstChild, txt = a.firstChild;
    txt && (txt.data = imce.decode(txt.data));
    var branch = imce.tree[a.title] = {'a': a, li: this, ul: this.lastChild.tagName == 'UL' ? this.lastChild : null};
    if (a.href) imce.dirClickable(branch);
    imce.dirCollapsible(branch);
  });
},

//Add a dir to the tree under parent
dirAdd: function(dir, parent, clickable) {
  if (imce.tree[dir]) return clickable ? imce.dirClickable(imce.tree[dir]) : imce.tree[dir];
  var parent = parent || imce.tree['.'];
  parent.ul = parent.ul ? parent.ul : parent.li.appendChild(imce.newEl('ul'));
  var branch = imce.dirCreate(dir, imce.decode(dir.substr(dir.lastIndexOf('/')+1)), clickable);
  parent.ul.appendChild(branch.li);
  return branch;
},

//create list item for navigation tree
dirCreate: function(dir, text, clickable) {
  if (imce.tree[dir]) return imce.tree[dir];
  var branch = imce.tree[dir] = {li: imce.newEl('li'), a: imce.newEl('a')};
  $(branch.a).addClass('folder').text(text).attr('title', dir).appendTo(branch.li);
  imce.dirCollapsible(branch);
  return clickable ? imce.dirClickable(branch) : branch;
},

//change currently active directory
dirActivate: function(dir) {
  if (dir != imce.conf.dir) {
    if (imce.tree[imce.conf.dir]){
      $(imce.tree[imce.conf.dir].a).removeClass('active');
    }
    $(imce.tree[dir].a).addClass('active');
    imce.conf.dir = dir;
  }
  return imce.tree[imce.conf.dir];
},

//make a dir accessible
dirClickable: function(branch) {
  if (branch.clkbl) return branch;
  $(branch.a).attr('href', '#').removeClass('disabled').click(function() {imce.navigate(this.title); return false;});
  branch.clkbl = true;
  return branch;
},

//sub-directories expand-collapse ability
dirCollapsible: function (branch) {
  if (branch.clpsbl) return branch;
  $(imce.newEl('span')).addClass('expander').html('&nbsp;').click(function() {
    if (branch.ul) {
      $(branch.ul).toggle();
      $(branch.li).toggleClass('expanded');
      imce.ie && $('#navigation-header').css('top', imce.NW.scrollTop);
    }
    else if (branch.clkbl){
      $(branch.a).click();
    }
  }).prependTo(branch.li);
  branch.clpsbl = true;
  return branch;
},

//update navigation tree after getting subdirectories.
dirSubdirs: function(dir, subdirs) {
  var branch = imce.tree[dir];
  if (subdirs && subdirs.length) {
    var prefix = dir == '.' ? '' : dir +'/';
    for (var i in subdirs) {//add subdirectories
      imce.dirAdd(prefix + subdirs[i], branch, true);
    }
    $(branch.li).removeClass('leaf').addClass('expanded');
    $(branch.ul).show();
  }
  else if (!branch.ul){//no subdirs->leaf
    $(branch.li).removeClass('expanded').addClass('leaf');
  }
},

//process file list
initiateList: function(cached) {
  var L = imce.hooks.list, dir = imce.conf.dir, token = {'%dir':  dir == '.' ? $(imce.tree['.'].a).text() : imce.decode(dir)}
  imce.findex = [], imce.fids = {}, imce.selected = {}, imce.selcount = 0, imce.vars.lastfid = null;
  imce.tbody = imce.el('file-list').tBodies[0];
  if (imce.tbody.rows.length) {
    for (var row, i = 0; row = imce.tbody.rows[i]; i++) {
      var fid = row.id;
      imce.findex[i] = imce.fids[fid] = row;
      if (cached) {
        if (imce.hasC(row, 'selected')) {
          imce.selected[imce.vars.lastfid = fid] = row;
          imce.selcount++;
        }
      }
      else {
        for (var func, j = 0; func = L[j]; j++) func(row);//invoke list-hook
      }
    }
  }
  if (!imce.conf.perm.browse) {
    imce.setMessage(Drupal.t('File browsing is disabled in directory %dir.', token), 'error');
  }
},

//add a file to the list. (having properties name,size,formatted size,width,height,date,formatted date)
fileAdd: function(file) {
  var row, fid = file.name, i = imce.findex.length, attr = ['name', 'size', 'width', 'height', 'date'];
  if (!(row = imce.fids[fid])) {
    row = imce.findex[i] = imce.fids[fid] = imce.tbody.insertRow(i);
    for (var i in attr) row.insertCell(i).className = attr[i];
  }
  row.cells[0].innerHTML = row.id = fid;
  row.cells[1].innerHTML = file.fsize; row.cells[1].id = file.size;
  row.cells[2].innerHTML = file.width;
  row.cells[3].innerHTML = file.height;
  row.cells[4].innerHTML = file.fdate; row.cells[4].id = file.date;
  imce.invoke('list', row);
  if (imce.vars.prvfid == fid) imce.setPreview(fid);
  if (file.id) imce.urlId[imce.getURL(fid)] = file.id;
},

//remove a file from the list
fileRemove: function(fid) {
  if (!(row = imce.fids[fid])) return;
  imce.fileDeSelect(fid);
  imce.findex.splice(row.rowIndex, 1);
  $(row).remove();
  delete imce.fids[fid];
  if (imce.vars.prvfid == fid) imce.setPreview();
},

//return a file object containing all properties.
fileGet: function (fid) {
  var file = imce.fileProps(fid);
  if (file) {
    file.name = imce.decode(fid);
    file.url = imce.getURL(fid);
    file.relpath = imce.getRelpath(fid);
    file.id = imce.urlId[file.url] || 0; //file id for newly uploaded files
  }
  return file;
},

//return file properties embedded in html.
fileProps: function (fid) {
  var row = imce.fids[fid];
  return row ? {
    size: row.cells[1].innerHTML,
    bytes: row.cells[1].id * 1,
    width: row.cells[2].innerHTML * 1,
    height: row.cells[3].innerHTML * 1,
    date: row.cells[4].innerHTML,
    time: row.cells[4].id * 1
  } : null;
},

//simulate row click. selection-highlighting
fileClick: function(row, ctrl, shft) {
  if (!row) return;
  var fid = typeof(row) == 'string' ? row : row.id;
  if (ctrl || fid == imce.vars.prvfid) {
    imce.fileToggleSelect(fid);
  }
  else if (shft) {
    var last = imce.lastFid();
    var start = last ? imce.fids[last].rowIndex : -1;
    var end = imce.fids[fid].rowIndex;
    var step = start > end ? -1 : 1;
    while (start != end) {
      start += step;
      imce.fileSelect(imce.findex[start].id);
    }
  }
  else {
    for (var fname in imce.selected) {
      imce.fileDeSelect(fname);
    }
    imce.fileSelect(fid);
  }
  //set preview
  imce.setPreview(imce.selcount == 1 ? imce.lastFid() : null);
},

//file select/deselect functions
fileSelect: function (fid) {
  if (imce.selected[fid] || !imce.fids[fid]) return;
  imce.selected[fid] = imce.fids[imce.vars.lastfid=fid];
  $(imce.selected[fid]).addClass('selected');
  imce.selcount++;
},
fileDeSelect: function (fid) {
  if (!imce.selected[fid] || !imce.fids[fid]) return;
  if (imce.vars.lastfid == fid) imce.vars.lastfid = null;
  $(imce.selected[fid]).removeClass('selected');
  delete imce.selected[fid];
  imce.selcount--;
},
fileToggleSelect: function (fid) {
  imce['file'+ (imce.selected[fid] ? 'De' : '') +'Select'](fid);
},

//process file operation form and create operation tabs.
initiateOps: function() {
  imce.setHtmlOps();
  imce.setUploadOp();//upload
  imce.setFileOps();//thumb, delete, resize
},

//process existing html ops.
setHtmlOps: function () {
  $(imce.el('ops-list')).children('li').each(function() {
    if (!this.firstChild) return $(this).remove();
    var name = this.id.substr(8);
    var Op = imce.ops[name] = {div: imce.el('op-content-'+ name), li: imce.el('op-item-'+ name)};
    Op.a = Op.li.firstChild;
    Op.title = Op.a.innerHTML;
    $(Op.a).click(function() {imce.opClick(name); return false;});
  });
},

//convert upload form to an op.
setUploadOp: function () {
  var el, form = imce.el('imce-upload-form');
  if (!form) return;
  $(form).ajaxForm(imce.uploadSettings()).find('fieldset').each(function() {//clean up fieldsets
    this.removeChild(this.firstChild);
    $(this).after(this.childNodes);
  }).remove();
  // Set html response flag
  el = form.elements['files[imce]'];
  if (el && el.files && window.FormData) {
    if (el = form.elements.html_response) {
      el.value = 0;
    }
  } 
  imce.opAdd({name: 'upload', title: Drupal.t('Upload'), content: form});//add op
},

//convert fileop form submit buttons to ops.
setFileOps: function () {
  var form = imce.el('imce-fileop-form');
  if (!form) return;
  $(form.elements.filenames).parent().remove();
  $(form).find('fieldset').each(function() {//remove fieldsets
    var $sbmt = $('input:submit', this);
    if (!$sbmt.length) return;
    var Op = {name: $sbmt.attr('id').substr(5)};
    var func = function() {imce.fopSubmit(Op.name); return false;};
    $sbmt.click(func);
    Op.title = $(this).children('legend').remove().text() || $sbmt.val();
    Op.name == 'delete' ? (Op.func = func) : (Op.content = this.childNodes);
    imce.opAdd(Op);
  }).remove();
  imce.vars.opform = $(form).serialize();//serialize remaining parts.
},

//refresh ops states. enable/disable
refreshOps: function() {
  for (var p in imce.conf.perm) {
    if (imce.conf.perm[p]) imce.opEnable(p);
    else imce.opDisable(p);
  }
},

//add a new file operation
opAdd: function (op) {
  var oplist = imce.el('ops-list'), opcons = imce.el('op-contents');
  var name = op.name || ('op-'+ $(oplist).children('li').length);
  var title = op.title || 'Untitled';
  var Op = imce.ops[name] = {title: title};
  if (op.content) {
    Op.div = imce.newEl('div');
    $(Op.div).attr({id: 'op-content-'+ name, 'class': 'op-content'}).appendTo(opcons).append(op.content);
  }
  Op.a = imce.newEl('a');
  Op.li = imce.newEl('li');
  $(Op.a).attr({href: '#', name: name, title: title}).html('<span>' + title +'</span>').click(imce.opClickEvent);
  $(Op.li).attr('id', 'op-item-'+ name).append(Op.a).appendTo(oplist);
  Op.func = op.func || imce.opVoid;
  return Op;
},

//click event for file operations
opClickEvent: function(e) {
  imce.opClick(this.name);
  return false;
},

//void operation function
opVoid: function() {},

//perform op click
opClick: function(name) {
  var Op = imce.ops[name], oldop = imce.vars.op;
  if (!Op || Op.disabled) {
    return imce.setMessage(Drupal.t('You can not perform this operation.'), 'error');
  }
  if (Op.div) {
    if (oldop) {
      var toggle = oldop == name;
      imce.opShrink(oldop, toggle ? 'fadeOut' : 'hide');
      if (toggle) return false;
    }
    var left = Op.li.offsetLeft;
    var $opcon = $('#op-contents').css({left: 0});
    $(Op.div).fadeIn('normal', function() {
      setTimeout(function() {
        if (imce.vars.op) {
          var $inputs = $('input', imce.ops[imce.vars.op].div);
          $inputs.eq(0).focus();
          //form inputs become invisible in IE. Solution is as stupid as the behavior.
          $('html').hasClass('ie') && $inputs.addClass('dummyie').removeClass('dummyie');
       }
      });
    });
    var diff = left + $opcon.width() - $('#imce-content').width();
    $opcon.css({left: diff > 0 ? left - diff - 1 : left});
    $(Op.li).addClass('active');
    $(imce.opCloseLink).fadeIn(300);
    imce.vars.op = name;
  }
  Op.func(true);
  return true;
},

//enable a file operation
opEnable: function(name) {
  var Op = imce.ops[name];
  if (Op && Op.disabled) {
    Op.disabled = false;
    $(Op.li).show();
  }
},

//disable a file operation
opDisable: function(name) {
  var Op = imce.ops[name];
  if (Op && !Op.disabled) {
    Op.div && imce.opShrink(name);
    $(Op.li).hide();
    Op.disabled = true;
  }
},

//hide contents of a file operation
opShrink: function(name, effect) {
  if (imce.vars.op != name) return;
  var Op = imce.ops[name];
  $(Op.div).stop(true, true)[effect || 'hide']();
  $(Op.li).removeClass('active');
  $(imce.opCloseLink).hide();
  Op.func(false);
  imce.vars.op = null;
},

//navigate to dir
navigate: function(dir) {
  if (imce.vars.navbusy || (dir == imce.conf.dir && !confirm(Drupal.t('Do you want to refresh the current directory?')))) return;
  var cache = imce.vars.cache && dir != imce.conf.dir;
  var set = imce.navSet(dir, cache);
  if (cache && imce.cache[dir]) {//load from the cache
    set.success({data: imce.cache[dir]});
    set.complete();
  }
  else $.ajax(set);//live load
},
//ajax navigation settings
navSet: function (dir, cache) {
  $(imce.tree[dir].li).addClass('loading');
  imce.vars.navbusy = dir;
  return {url: imce.ajaxURL('navigate', dir),
  type: 'GET',
  dataType: 'json',
  success: function(response) {
    if (response.data && !response.data.error) {
      if (cache) imce.navCache(imce.conf.dir, dir);//cache the current dir
      imce.navUpdate(response.data, dir);
    }
    imce.processResponse(response);
  },
  complete: function () {
    $(imce.tree[dir].li).removeClass('loading');
    imce.vars.navbusy = null;
  }
  };
},

//update directory using the given data
navUpdate: function(data, dir) {
  var cached = data == imce.cache[dir], olddir = imce.conf.dir;
  if (cached) data.files.id = 'file-list';
  $(imce.FLW).html(data.files);
  imce.dirActivate(dir);
  imce.dirSubdirs(dir, data.subdirectories);
  $.extend(imce.conf.perm, data.perm);
  imce.refreshOps();
  imce.initiateList(cached);
  imce.setPreview(imce.selcount == 1 ? imce.lastFid() : null);
  imce.SBW.scrollTop = 0;
  imce.invoke('navigate', data, olddir, cached);
},

//set cache
navCache: function (dir, newdir) {
  var C = imce.cache[dir] = {'dir': dir, files: imce.el('file-list'), dirsize: imce.el('dir-size').innerHTML, perm: $.extend({}, imce.conf.perm)};
  C.files.id = 'cached-list-'+ dir;
  imce.FW.appendChild(C.files);
  imce.invoke('cache', C, newdir);
},

//validate upload form
uploadValidate: function (data, form, options) {
  var path = $('#edit-imce').val();
  if (!path) return false;
  if (imce.conf.extensions != '*') {
    var ext = path.substr(path.lastIndexOf('.') + 1);
    if ((' '+ imce.conf.extensions +' ').indexOf(' '+ ext.toLowerCase() +' ') == -1) {
      return imce.setMessage(Drupal.t('Only files with the following extensions are allowed: %files-allowed.', {'%files-allowed': imce.conf.extensions}), 'error');
    }
  }
  options.url = imce.ajaxURL('upload');//make url contain current dir.
  imce.fopLoading('upload', true);
  return true;
},

//settings for upload
uploadSettings: function () {
  return {
    beforeSubmit: imce.uploadValidate,
    success: function (response) {
      try{
        imce.processResponse($.parseJSON(response));
      } catch(e) {}
    },
    complete: function () {
      imce.fopLoading('upload', false);
    },
    resetForm: true,
    dataType: 'text'
  };
},

//validate default ops(delete, thumb, resize)
fopValidate: function(fop) {
  if (!imce.validateSelCount(1, imce.conf.filenum)) return false;
  switch (fop) {
    case 'delete':
      return confirm(Drupal.t('Delete selected files?'));
    case 'thumb':
      if (!$('input:checked', imce.ops['thumb'].div).length) {
        return imce.setMessage(Drupal.t('Please select a thumbnail.'), 'error');
      }
      return imce.validateImage();
    case 'resize':
      var w = imce.el('edit-width').value, h = imce.el('edit-height').value;
      var maxDim = imce.conf.dimensions.split('x');
      var maxW = maxDim[0]*1, maxH = maxW ? maxDim[1]*1 : 0;
      if (!(/^[1-9][0-9]*$/).test(w) || !(/^[1-9][0-9]*$/).test(h) || (maxW && (maxW < w*1 || maxH < h*1))) {
        return imce.setMessage(Drupal.t('Please specify dimensions within the allowed range that is from 1x1 to @dimensions.', {'@dimensions': maxW ? imce.conf.dimensions : Drupal.t('unlimited')}), 'error');
      }
      return imce.validateImage();
  }

  var func = fop +'OpValidate';
  if (imce[func]) return imce[func](fop);
  return true;
},

//submit wrapper for default ops
fopSubmit: function(fop) {
  switch (fop) {
    case 'thumb': case 'delete': case 'resize':  return imce.commonSubmit(fop);
  }
  var func = fop +'OpSubmit';
  if (imce[func]) return imce[func](fop);
},

//common submit function shared by default ops
commonSubmit: function(fop) {
  if (!imce.fopValidate(fop)) return false;
  imce.fopLoading(fop, true);
  $.ajax(imce.fopSettings(fop));
},

//settings for default file operations
fopSettings: function (fop) {
  return {url: imce.ajaxURL(fop), type: 'POST', dataType: 'json', success: imce.processResponse, complete: function (response) {imce.fopLoading(fop, false);}, data: imce.vars.opform +'&filenames='+ encodeURIComponent(imce.serialNames()) +'&jsop='+ fop + (imce.ops[fop].div ? '&'+ $('input, select, textarea', imce.ops[fop].div).serialize() : '')};
},

//toggle loading state
fopLoading: function(fop, state) {
  var el = imce.el('edit-'+ fop), func = state ? 'addClass' : 'removeClass';
  if (el) {
    $(el)[func]('loading');
    el.disabled = state;
  }
  else {
    $(imce.ops[fop].li)[func]('loading');
    imce.ops[fop].disabled = state;
  }
},

//preview a file.
setPreview: function (fid) {
  var row, html = '';
  imce.vars.prvfid = fid;
  if (fid && (row = imce.fids[fid])) {
    var width = row.cells[2].innerHTML * 1;
    html = imce.vars.previewImages && width ? imce.imgHtml(fid, width, row.cells[3].innerHTML) : imce.decodePlain(fid);
    html = '<a href="#" onclick="imce.send(\''+ fid +'\'); return false;" title="'+ (imce.vars.prvtitle||'') +'">'+ html +'</a>';
  }
  imce.el('file-preview').innerHTML = html;
},

//default file send function. sends the file to the new window.
send: function (fid) {
  fid && window.open(imce.getURL(fid));
},

//add an operation for an external application to which the files are send.
setSendTo: function (title, func) {
  imce.send = function (fid) { fid && func(imce.fileGet(fid), window);};
  var opFunc = function () {
    if (imce.selcount != 1) return imce.setMessage(Drupal.t('Please select a file.'), 'error');
    imce.send(imce.vars.prvfid);
  };
  imce.vars.prvtitle = title;
  return imce.opAdd({name: 'sendto', title: title, func: opFunc});
},

//move initial page messages into log
prepareMsgs: function () {
  var msgs;
  if (msgs = imce.el('imce-messages')) {
    $('>div', msgs).each(function (){
      var type = this.className.split(' ')[1];
      var li = $('>ul li', this);
      if (li.length) li.each(function () {imce.setMessage(this.innerHTML, type);});
      else imce.setMessage(this.innerHTML, type);
    });
    $(msgs).remove();
  }
},

//insert log message
setMessage: function (msg, type) {
  var $box = $(imce.msgBox);
  var logs = imce.el('log-messages') || $(imce.newEl('div')).appendTo('#help-box-content').before('<h4>'+ Drupal.t('Log messages') +':</h4>').attr('id', 'log-messages')[0];
  var msg = '<div class="message '+ (type || 'status') +'">'+ msg +'</div>';
  $box.queue(function() {
    $box.css({opacity: 0, display: 'block'}).html(msg);
    $box.dequeue();
  });
  var q = $box.queue().length, t = imce.vars.msgT || 1000;
  q = q < 2 ? 1 : q < 3 ? 0.8 : q < 4 ? 0.7 : 0.4;//adjust speed with respect to queue length
  $box.fadeTo(600 * q, 1).fadeTo(t * q, 1).fadeOut(400 * q);
  $(logs).append(msg);
  return false;
},

//invoke hooks
invoke: function (hook) {
  var i, args, func, funcs;
  if ((funcs = imce.hooks[hook]) && funcs.length) {
    (args = $.makeArray(arguments)).shift();
    for (i = 0; func = funcs[i]; i++) func.apply(this, args);
  }
},

//process response
processResponse: function (response) {
  if (response.data) imce.resData(response.data);
  if (response.messages) imce.resMsgs(response.messages);
},

//process response data
resData: function (data) {
  var i, added, removed;
  if (added = data.added) {
    var cnt = imce.findex.length;
    for (i in added) {//add new files or update existing
      imce.fileAdd(added[i]);
    }
    if (added.length == 1) {//if it is a single file operation
      imce.highlight(added[0].name);//highlight
    }
    if (imce.findex.length != cnt) {//if new files added, scroll to bottom.
      $(imce.SBW).animate({scrollTop: imce.SBW.scrollHeight}).focus();
    }
  }
  if (removed = data.removed) for (i in removed) {
    imce.fileRemove(removed[i]);
  }
  imce.conf.dirsize = data.dirsize;
  imce.updateStat();
},

//set response messages
resMsgs: function (msgs) {
  for (var type in msgs) for (var i in msgs[type]) {
    imce.setMessage(msgs[type][i], type);
  }
},

//return img markup
imgHtml: function (fid, width, height) {
  return '<img src="'+ imce.getURL(fid, true) +'" width="'+ width +'" height="'+ height +'" alt="'+ imce.decodePlain(fid) +'">';
},

//check if the file is an image
isImage: function (fid) {
  return imce.fids[fid].cells[2].innerHTML * 1;
},

//find the first non-image in the selection
getNonImage: function (selected) {
  for (var fid in selected) {
    if (!imce.isImage(fid)) return fid;
  }
  return false;
},

//validate current selection for images
validateImage: function () {
  var nonImg = imce.getNonImage(imce.selected);
  return nonImg ? imce.setMessage(Drupal.t('%filename is not an image.', {'%filename': imce.decode(nonImg)}), 'error') : true;
},

//validate number of selected files
validateSelCount: function (Min, Max) {
  if (Min && imce.selcount < Min) {
    return imce.setMessage(Min == 1 ? Drupal.t('Please select a file.') : Drupal.t('You must select at least %num files.', {'%num': Min}), 'error');
  }
  if (Max && Max < imce.selcount) {
    return imce.setMessage(Drupal.t('You are not allowed to operate on more than %num files.', {'%num': Max}), 'error');
  }
  return true;
},

//update file count and dir size
updateStat: function () {
  imce.el('file-count').innerHTML = imce.findex.length;
  imce.el('dir-size').innerHTML = imce.conf.dirsize;
},

//serialize selected files. return fids with a colon between them
serialNames: function () {
  var str = '';
  for (var fid in imce.selected) {
    str += ':'+ fid;
  }
  return str.substr(1);
},

//get file url. re-encode & and # for mod rewrite
getURL: function (fid, uncached) {
  var url = imce.getRelpath(fid);
  if (imce.conf.modfix) {
    url = url.replace(/%(23|26)/g, '%25$1');
  }
  url = imce.conf.furl + url;
  if (uncached) {
    var file = imce.fileProps(fid);
    url += (url.indexOf('?') === -1 ? '?' : '&') + 's' + file.bytes + 'd' + file.time;
  }
  return url;
},

//get encoded file path relative to root. 
getRelpath: function (fid) {
  var dir = imce.conf.dir;
  return (dir === '.' ? '' : dir + '/') + fid;
},

//el. by id
el: function (id) {
  return document.getElementById(id);
},

//find the latest selected fid
lastFid: function () {
  if (imce.vars.lastfid) return imce.vars.lastfid;
  for (var fid in imce.selected);
  return fid;
},

//create ajax url
ajaxURL: function (op, dir) {
  return imce.conf.url + (imce.conf.clean ? '?' :'&') +'jsop='+ op +'&dir='+ (dir||imce.conf.dir);
},

//fast class check
hasC: function (el, name) {
  return el.className && (' '+ el.className +' ').indexOf(' '+ name +' ') != -1;
},

//highlight a single file
highlight: function (fid) {
  if (imce.vars.prvfid) imce.fileClick(imce.vars.prvfid);
  imce.fileClick(fid);
},

//process a row
processRow: function (row) {
  row.cells[0].innerHTML = '<span>' + imce.decodePlain(row.id) + '</span>';
  row.onmousedown = function(e) {
    var e = e||window.event;
    imce.fileClick(this, e.ctrlKey, e.shiftKey);
    return !(e.ctrlKey || e.shiftKey);
  };
  row.ondblclick = function(e) {
    imce.send(this.id);
    return false;
  };
},

//decode urls. uses unescape. can be overridden to use decodeURIComponent
decode: function (str) {
  try {
    return decodeURIComponent(str);
  } catch(e) {}
  return str;
},

//decode and convert to plain text
decodePlain: function (str) {
  return Drupal.checkPlain(imce.decode(str));
},

//global ajax error function
ajaxError: function (e, response, settings, thrown) {
  imce.setMessage(Drupal.ajaxError(response, settings.url).replace(/\n/g, '<br />'), 'error');
},

//convert button elements to standard input buttons
convertButtons: function(form) {
  $('button:submit', form).each(function(){
    $(this).replaceWith('<input type="submit" value="'+ $(this).text() +'" name="'+ this.name +'" class="form-submit" id="'+ this.id +'" />');
  });
},

//create element
newEl: function(name) {
  return document.createElement(name);
},

//scroll syncronization for section headers
syncScroll: function(scrlEl, fixEl, bottom) {
  var $fixEl = $(fixEl);
  var prop = bottom ? 'bottom' : 'top';
  var factor = bottom ? -1 : 1;
  var syncScrl = function(el) {
    $fixEl.css(prop, factor * el.scrollTop);
  }
  $(scrlEl).scroll(function() {
    var el = this;
    syncScrl(el);
    setTimeout(function() {
      syncScrl(el);
    });
  });
},

//get UI ready. provide backward compatibility.
updateUI: function() {
  //file urls.
  var furl = imce.conf.furl, isabs = furl.indexOf('://') > -1;
  var absurls = imce.conf.absurls = imce.vars.absurls || imce.conf.absurls;
  var host = location.host;
  var baseurl = location.protocol + '//' + host;
  if (furl.charAt(furl.length - 1) != '/') {
    furl = imce.conf.furl = furl + '/';
  }
  imce.conf.modfix = imce.conf.clean && furl.indexOf(host + '/system/') > -1;
  if (absurls && !isabs) {
    imce.conf.furl = baseurl + furl;
  }
  else if (!absurls && isabs && furl.indexOf(baseurl) == 0) {
    imce.conf.furl = furl.substr(baseurl.length);
  }
  //convert button elements to input elements.
  imce.convertButtons(imce.FW);
  //ops-list
  $('#ops-list').removeClass('tabs secondary').addClass('clear-block clearfix');
  imce.opCloseLink = $(imce.newEl('a')).attr({id: 'op-close-link', href: '#', title: Drupal.t('Close')}).click(function() {
    imce.vars.op && imce.opClick(imce.vars.op);
    return false;
  }).appendTo('#op-contents')[0];
  //navigation-header
  if (!$('#navigation-header').length) {
    $(imce.NW).children('.navigation-text').attr('id', 'navigation-header').wrapInner('<span></span>');
  }
  //log
  $('#log-prv-wrapper').before($('#log-prv-wrapper > #preview-wrapper')).remove();
  $('#log-clearer').remove();
  //content resizer
  $('#content-resizer').remove();
  //message-box
  imce.msgBox = imce.el('message-box') || $(imce.newEl('div')).attr('id', 'message-box').prependTo('#imce-content')[0];
  //create help tab
  var $hbox = $('#help-box');
  $hbox.is('a') && $hbox.replaceWith($(imce.newEl('div')).attr('id', 'help-box').append($hbox.children()));
  imce.hooks.load.push(function() {
    imce.opAdd({name: 'help', title: $('#help-box-title').remove().text(), content: $('#help-box').show()});
  });
  //add ie classes
  imce.ie && $('html').addClass('ie') && imce.ie < 8 && $('html').addClass('ie-7');
  // enable box view for file list
  imce.vars.boxW && imce.boxView();
  //scrolling file list
  imce.syncScroll(imce.SBW, '#file-header-wrapper');
  imce.syncScroll(imce.SBW, '#dir-stat', true);
  //scrolling directory tree
  imce.syncScroll(imce.NW, '#navigation-header');
}

};

//initiate
$(document).ready(imce.initiate);

})(jQuery);;
/*
 * IMCE Integration by URL
 * Ex-1: http://example.com/imce?app=XEditor|url@urlFieldId|width@widthFieldId|height@heightFieldId
 * Creates "Insert file" operation tab, which fills the specified fields with url, width, height properties
 * of the selected file in the parent window
 * Ex-2: http://example.com/imce?app=XEditor|sendto@functionName
 * "Insert file" operation calls parent window's functionName(file, imceWindow)
 * Ex-3: http://example.com/imce?app=XEditor|imceload@functionName
 * Parent window's functionName(imceWindow) is called as soon as IMCE UI is ready. Send to operation
 * needs to be set manually. See imce.setSendTo() method in imce.js
 */

(function($) {

var appFields = {}, appWindow = (top.appiFrm||window).opener || parent;

// Execute when imce loads.
imce.hooks.load.push(function(win) {
  var index = location.href.lastIndexOf('app=');
  if (index == -1) return;
  var data = decodeURIComponent(location.href.substr(index + 4)).split('|');
  var arr, prop, str, func, appName = data.shift();
  // Extract fields
  for (var i = 0, len = data.length; i < len; i++) {
    str = data[i];
    if (!str.length) continue;
    if (str.indexOf('&') != -1) str = str.split('&')[0];
    arr = str.split('@');
    if (arr.length > 1) {
      prop = arr.shift();
      appFields[prop] = arr.join('@');
    }
  }
  // Run custom onload function if available
  if (appFields.imceload && (func = isFunc(appFields.imceload))) {
    func(win);
    delete appFields.imceload;
  }
  // Set custom sendto function. appFinish is the default.
  var sendtoFunc = appFields.url ? appFinish : false;
  //check sendto@funcName syntax in URL
  if (appFields.sendto && (func = isFunc(appFields.sendto))) {
    sendtoFunc = func;
    delete appFields.sendto;
  }
  // Check old method windowname+ImceFinish.
  else if (win.name && (func = isFunc(win.name +'ImceFinish'))) {
    sendtoFunc = func;
  }
  // Highlight file
  if (appFields.url) {
    // Support multiple url fields url@field1,field2..
    if (appFields.url.indexOf(',') > -1) {
      var arr = appFields.url.split(',');
      for (var i in arr) {
        if ($('#'+ arr[i], appWindow.document).length) {
          appFields.url = arr[i];
          break;
        }
      }
    }
    var filename = $('#'+ appFields.url, appWindow.document).val() || '';
    imce.highlight(filename.substr(filename.lastIndexOf('/')+1));
  }
  // Set send to
  sendtoFunc && imce.setSendTo(Drupal.t('Insert file'), sendtoFunc);
});

// Default sendTo function
var appFinish = function(file, win) {
  var $doc = $(appWindow.document);
  for (var i in appFields) {
    $doc.find('#'+ appFields[i]).val(file[i]);
  }
  if (appFields.url) {
    try{
      $doc.find('#'+ appFields.url).blur().change().focus();
    }catch(e){
      try{
        $doc.find('#'+ appFields.url).trigger('onblur').trigger('onchange').trigger('onfocus');//inline events for IE
      }catch(e){}
    }
  }
  appWindow.focus();
  win.close();
};

// Checks if a string is a function name in the given scope.
// Returns function reference. Supports x.y.z notation.
var isFunc = function(str, scope) {
  var obj = scope || appWindow;
  var parts = str.split('.'), len = parts.length;
  for (var i = 0; i < len && (obj = obj[parts[i]]); i++);
  return obj && i == len && (typeof obj == 'function' || typeof obj != 'string' && !obj.nodeName && obj.constructor != Array && /^[\s[]?function/.test(obj.toString())) ? obj : false;
}

})(jQuery);;

/**
 * Wysiwyg API integration helper function.
 */
function imceImageBrowser(field_name, url, type, win) {
  // TinyMCE.
  if (win !== 'undefined') {
    win.open(Drupal.settings.imce.url + encodeURIComponent(field_name), '', 'width=760,height=560,resizable=1');
  }
}

/**
 * CKeditor integration.
 */
var imceCkeditSendTo = function (file, win) {
  var parts = /\?(?:.*&)?CKEditorFuncNum=(\d+)(?:&|$)/.exec(win.location.href);
  if (parts && parts.length > 1) {
    CKEDITOR.tools.callFunction(parts[1], file.url);
    win.close();
  }
  else {
    throw 'CKEditorFuncNum parameter not found or invalid: ' + win.location.href;
  }
};
;
(function ($) {

// @todo Array syntax required; 'break' is a predefined token in JavaScript.
Drupal.wysiwyg.plugins['break'] = {

  /**
   * Return whether the passed node belongs to this plugin.
   */
  isNode: function(node) {
    return ($(node).is('img.wysiwyg-break'));
  },

  /**
   * Execute the button.
   */
  invoke: function(data, settings, instanceId) {
    if (data.format == 'html') {
      // Prevent duplicating a teaser break.
      if ($(data.node).is('img.wysiwyg-break')) {
        return;
      }
      var content = this._getPlaceholder(settings);
    }
    else {
      // Prevent duplicating a teaser break.
      // @todo data.content is the selection only; needs access to complete content.
      if (data.content.match(/<!--break-->/)) {
        return;
      }
      var content = '<!--break-->';
    }
    if (typeof content != 'undefined') {
      Drupal.wysiwyg.instances[instanceId].insert(content);
    }
  },

  /**
   * Replace all <!--break--> tags with images.
   */
  attach: function(content, settings, instanceId) {
    content = content.replace(/<!--break-->/g, this._getPlaceholder(settings));
    return content;
  },

  /**
   * Replace images with <!--break--> tags in content upon detaching editor.
   */
  detach: function(content, settings, instanceId) {
    var $content = $('<div>' + content + '</div>'); // No .outerHTML() in jQuery :(
    // #404532: document.createComment() required or IE will strip the comment.
    // #474908: IE 8 breaks when using jQuery methods to replace the elements.
    // @todo Add a generic implementation for all Drupal plugins for this.
    $.each($('img.wysiwyg-break', $content), function (i, elem) {
      elem.parentNode.insertBefore(document.createComment('break'), elem);
      elem.parentNode.removeChild(elem);
    });
    return $content.html();
  },

  /**
   * Helper function to return a HTML placeholder.
   */
  _getPlaceholder: function (settings) {
    return '<img src="' + settings.path + '/images/spacer.gif" alt="&lt;--break-&gt;" title="&lt;--break--&gt;" class="wysiwyg-break drupal-content" />';
  }
};

})(jQuery);
;
(function ($) {

Drupal.behaviors.textarea = {
  attach: function (context, settings) {
    $('.form-textarea-wrapper.resizable', context).once('textarea', function () {
      var staticOffset = null;
      var textarea = $(this).addClass('resizable-textarea').find('textarea');
      var grippie = $('<div class="grippie"></div>').mousedown(startDrag);

      grippie.insertAfter(textarea);

      function startDrag(e) {
        staticOffset = textarea.height() - e.pageY;
        textarea.css('opacity', 0.25);
        $(document).mousemove(performDrag).mouseup(endDrag);
        return false;
      }

      function performDrag(e) {
        textarea.height(Math.max(32, staticOffset + e.pageY) + 'px');
        return false;
      }

      function endDrag(e) {
        $(document).unbind('mousemove', performDrag).unbind('mouseup', endDrag);
        textarea.css('opacity', 1);
      }
    });
  }
};

})(jQuery);
;

(function ($) {

/**
 * Auto-hide summary textarea if empty and show hide and unhide links.
 */
Drupal.behaviors.textSummary = {
  attach: function (context, settings) {
    $('.text-summary', context).once('text-summary', function () {
      var $widget = $(this).closest('div.field-type-text-with-summary');
      var $summaries = $widget.find('div.text-summary-wrapper');

      $summaries.once('text-summary-wrapper').each(function(index) {
        var $summary = $(this);
        var $summaryLabel = $summary.find('label').first();
        var $full = $widget.find('.text-full').eq(index).closest('.form-item');
        var $fullLabel = $full.find('label').first();

        // Create a placeholder label when the field cardinality is
        // unlimited or greater than 1.
        if ($fullLabel.length == 0) {
          $fullLabel = $('<label></label>').prependTo($full);
        }

        // Setup the edit/hide summary link.
        var $link = $('<span class="field-edit-link">(<a class="link-edit-summary" href="#">' + Drupal.t('Hide summary') + '</a>)</span>');
        var $a = $link.find('a');
        var toggleClick = true;
        $link.bind('click', function (e) {
          if (toggleClick) {
            $summary.hide();
            $a.html(Drupal.t('Edit summary'));
            $link.appendTo($fullLabel);
          }
          else {
            $summary.show();
            $a.html(Drupal.t('Hide summary'));
            $link.appendTo($summaryLabel);
          }
          toggleClick = !toggleClick;
          return false;
        }).appendTo($summaryLabel);

        // If no summary is set, hide the summary field.
        if ($(this).find('.text-summary').val() == '') {
          $link.click();
        }
      });
    });
  }
};

})(jQuery);
;
(function ($) {

/**
 * A progressbar object. Initialized with the given id. Must be inserted into
 * the DOM afterwards through progressBar.element.
 *
 * method is the function which will perform the HTTP request to get the
 * progress bar state. Either "GET" or "POST".
 *
 * e.g. pb = new progressBar('myProgressBar');
 *      some_element.appendChild(pb.element);
 */
Drupal.progressBar = function (id, updateCallback, method, errorCallback) {
  var pb = this;
  this.id = id;
  this.method = method || 'GET';
  this.updateCallback = updateCallback;
  this.errorCallback = errorCallback;

  // The WAI-ARIA setting aria-live="polite" will announce changes after users
  // have completed their current activity and not interrupt the screen reader.
  this.element = $('<div class="progress" aria-live="polite"></div>').attr('id', id);
  this.element.html('<div class="bar"><div class="filled"></div></div>' +
                    '<div class="percentage"></div>' +
                    '<div class="message">&nbsp;</div>');
};

/**
 * Set the percentage and status message for the progressbar.
 */
Drupal.progressBar.prototype.setProgress = function (percentage, message) {
  if (percentage >= 0 && percentage <= 100) {
    $('div.filled', this.element).css('width', percentage + '%');
    $('div.percentage', this.element).html(percentage + '%');
  }
  $('div.message', this.element).html(message);
  if (this.updateCallback) {
    this.updateCallback(percentage, message, this);
  }
};

/**
 * Start monitoring progress via Ajax.
 */
Drupal.progressBar.prototype.startMonitoring = function (uri, delay) {
  this.delay = delay;
  this.uri = uri;
  this.sendPing();
};

/**
 * Stop monitoring progress via Ajax.
 */
Drupal.progressBar.prototype.stopMonitoring = function () {
  clearTimeout(this.timer);
  // This allows monitoring to be stopped from within the callback.
  this.uri = null;
};

/**
 * Request progress data from server.
 */
Drupal.progressBar.prototype.sendPing = function () {
  if (this.timer) {
    clearTimeout(this.timer);
  }
  if (this.uri) {
    var pb = this;
    // When doing a post request, you need non-null data. Otherwise a
    // HTTP 411 or HTTP 406 (with Apache mod_security) error may result.
    $.ajax({
      type: this.method,
      url: this.uri,
      data: '',
      dataType: 'json',
      success: function (progress) {
        // Display errors.
        if (progress.status == 0) {
          pb.displayError(progress.data);
          return;
        }
        // Update display.
        pb.setProgress(progress.percentage, progress.message);
        // Schedule next timer.
        pb.timer = setTimeout(function () { pb.sendPing(); }, pb.delay);
      },
      error: function (xmlhttp) {
        pb.displayError(Drupal.ajaxError(xmlhttp, pb.uri));
      }
    });
  }
};

/**
 * Display errors on the page.
 */
Drupal.progressBar.prototype.displayError = function (string) {
  var error = $('<div class="messages error"></div>').html(string);
  $(this.element).before(error).hide();

  if (this.errorCallback) {
    this.errorCallback(this);
  }
};

})(jQuery);
;
// $Id: mfw.js,v 1.6 2010/11/23 05:51:16 webchick Exp $

/**
 * @file
 * Provides JavaScript additions to the managed file field type.
 *
 * This file provides progress bar support (if available), popup windows for
 * file previews, and disabling of other file fields during AJAX uploads (which
 * prevents separate file fields from accidentally uploading files).
 */

(function ($) {

/**
 * Attach behaviors to managed file element upload fields.
 */
Drupal.behaviors.fileValidateMultipleAutoAttach = {
  attach: function (context, settings) {
    if (settings.mfw && settings.mfw.elements) {
      $.each(settings.mfw.elements, function(selector) {
        var extensions = settings.mfw.elements[selector];
        $(selector, context).bind('change', {extensions: extensions}, Drupal.mfw.validateMultipleExtensions);
      });
    }
  },
  detach: function (context, settings) {
    if (settings.mfw && settings.mfw.elements) {
      $.each(settings.mfw.elements, function(selector) {
        $(selector, context).unbind('change', Drupal.mfw.validateMultipleExtensions);
      });
    }
  }
};

/**
 * File upload utility functions.
 */
Drupal.mfw = Drupal.mfw || {
  /**
   * Client-side file input validation of file extensions.
   */
  validateMultipleExtensions: function (event) {
    // Remove any previous errors.
    $('.file-upload-js-error').remove();

    // Add client side validation for the input[type=file].
    var extensionPattern = event.data.extensions.replace(/,\s*/g, '|');
    if (extensionPattern.length > 1 && this.value.length > 0) {
      // Instead of the original 'ig' ending we have just 'i' otherwise test()
      // evaluates to 'false' after the second call.
      var acceptableMatch = new RegExp('\\.(' + extensionPattern + ')$', 'i');
      if (typeof(this.files) == 'object') {
        for (i = 0; i < this.files.length; i++) {
          var fileName = this.files[i].name;
          var match = acceptableMatch.test(fileName);
          if (!match) {
            var error = Drupal.t("The selected file %filename cannot be uploaded. Only files with the following extensions are allowed: %extensions.", {
              '%filename': fileName,
              '%extensions': extensionPattern.replace(/\|/g, ', ')
            });
            $(this).parents('div.form-managed-file').prepend('<div class="messages error file-upload-js-error">' + error + '</div>');
            this.value = '';
            return false;
          }
        }
      }
    }
  },
};

})(jQuery);
;
(function ($) {

/**
 * Attaches sticky table headers.
 */
Drupal.behaviors.tableHeader = {
  attach: function (context, settings) {
    if (!$.support.positionFixed) {
      return;
    }

    $('table.sticky-enabled', context).once('tableheader', function () {
      $(this).data("drupal-tableheader", new Drupal.tableHeader(this));
    });
  }
};

/**
 * Constructor for the tableHeader object. Provides sticky table headers.
 *
 * @param table
 *   DOM object for the table to add a sticky header to.
 */
Drupal.tableHeader = function (table) {
  var self = this;

  this.originalTable = $(table);
  this.originalHeader = $(table).children('thead');
  this.originalHeaderCells = this.originalHeader.find('> tr > th');
  this.displayWeight = null;

  // React to columns change to avoid making checks in the scroll callback.
  this.originalTable.bind('columnschange', function (e, display) {
    // This will force header size to be calculated on scroll.
    self.widthCalculated = (self.displayWeight !== null && self.displayWeight === display);
    self.displayWeight = display;
  });

  // Clone the table header so it inherits original jQuery properties. Hide
  // the table to avoid a flash of the header clone upon page load.
  this.stickyTable = $('<table class="sticky-header"/>')
    .insertBefore(this.originalTable)
    .css({ position: 'fixed', top: '0px' });
  this.stickyHeader = this.originalHeader.clone(true)
    .hide()
    .appendTo(this.stickyTable);
  this.stickyHeaderCells = this.stickyHeader.find('> tr > th');

  this.originalTable.addClass('sticky-table');
  $(window)
    .bind('scroll.drupal-tableheader', $.proxy(this, 'eventhandlerRecalculateStickyHeader'))
    .bind('resize.drupal-tableheader', { calculateWidth: true }, $.proxy(this, 'eventhandlerRecalculateStickyHeader'))
    // Make sure the anchor being scrolled into view is not hidden beneath the
    // sticky table header. Adjust the scrollTop if it does.
    .bind('drupalDisplaceAnchor.drupal-tableheader', function () {
      window.scrollBy(0, -self.stickyTable.outerHeight());
    })
    // Make sure the element being focused is not hidden beneath the sticky
    // table header. Adjust the scrollTop if it does.
    .bind('drupalDisplaceFocus.drupal-tableheader', function (event) {
      if (self.stickyVisible && event.clientY < (self.stickyOffsetTop + self.stickyTable.outerHeight()) && event.$target.closest('sticky-header').length === 0) {
        window.scrollBy(0, -self.stickyTable.outerHeight());
      }
    })
    .triggerHandler('resize.drupal-tableheader');

  // We hid the header to avoid it showing up erroneously on page load;
  // we need to unhide it now so that it will show up when expected.
  this.stickyHeader.show();
};

/**
 * Event handler: recalculates position of the sticky table header.
 *
 * @param event
 *   Event being triggered.
 */
Drupal.tableHeader.prototype.eventhandlerRecalculateStickyHeader = function (event) {
  var self = this;
  var calculateWidth = event.data && event.data.calculateWidth;

  // Reset top position of sticky table headers to the current top offset.
  this.stickyOffsetTop = Drupal.settings.tableHeaderOffset ? eval(Drupal.settings.tableHeaderOffset + '()') : 0;
  this.stickyTable.css('top', this.stickyOffsetTop + 'px');

  // Save positioning data.
  var viewHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
  if (calculateWidth || this.viewHeight !== viewHeight) {
    this.viewHeight = viewHeight;
    this.vPosition = this.originalTable.offset().top - 4 - this.stickyOffsetTop;
    this.hPosition = this.originalTable.offset().left;
    this.vLength = this.originalTable[0].clientHeight - 100;
    calculateWidth = true;
  }

  // Track horizontal positioning relative to the viewport and set visibility.
  var hScroll = document.documentElement.scrollLeft || document.body.scrollLeft;
  var vOffset = (document.documentElement.scrollTop || document.body.scrollTop) - this.vPosition;
  this.stickyVisible = vOffset > 0 && vOffset < this.vLength;
  this.stickyTable.css({ left: (-hScroll + this.hPosition) + 'px', visibility: this.stickyVisible ? 'visible' : 'hidden' });

  // Only perform expensive calculations if the sticky header is actually
  // visible or when forced.
  if (this.stickyVisible && (calculateWidth || !this.widthCalculated)) {
    this.widthCalculated = true;
    var $that = null;
    var $stickyCell = null;
    var display = null;
    var cellWidth = null;
    // Resize header and its cell widths.
    // Only apply width to visible table cells. This prevents the header from
    // displaying incorrectly when the sticky header is no longer visible.
    for (var i = 0, il = this.originalHeaderCells.length; i < il; i += 1) {
      $that = $(this.originalHeaderCells[i]);
      $stickyCell = this.stickyHeaderCells.eq($that.index());
      display = $that.css('display');
      if (display !== 'none') {
        cellWidth = $that.css('width');
        // Exception for IE7.
        if (cellWidth === 'auto') {
          cellWidth = $that[0].clientWidth + 'px';
        }
        $stickyCell.css({'width': cellWidth, 'display': display});
      }
      else {
        $stickyCell.css('display', 'none');
      }
    }
    this.stickyTable.css('width', this.originalTable.outerWidth());
  }
};

})(jQuery);
;
/**
 * @file
 * Provides JavaScript additions to the managed file field type.
 *
 * This file provides progress bar support (if available), popup windows for
 * file previews, and disabling of other file fields during Ajax uploads (which
 * prevents separate file fields from accidentally uploading files).
 */

(function ($) {

/**
 * Attach behaviors to managed file element upload fields.
 */
Drupal.behaviors.fileValidateAutoAttach = {
  attach: function (context, settings) {
    if (settings.file && settings.file.elements) {
      $.each(settings.file.elements, function(selector) {
        var extensions = settings.file.elements[selector];
        $(selector, context).bind('change', {extensions: extensions}, Drupal.file.validateExtension);
      });
    }
  },
  detach: function (context, settings) {
    if (settings.file && settings.file.elements) {
      $.each(settings.file.elements, function(selector) {
        $(selector, context).unbind('change', Drupal.file.validateExtension);
      });
    }
  }
};

/**
 * Attach behaviors to the file upload and remove buttons.
 */
Drupal.behaviors.fileButtons = {
  attach: function (context) {
    $('input.form-submit', context).bind('mousedown', Drupal.file.disableFields);
    $('div.form-managed-file input.form-submit', context).bind('mousedown', Drupal.file.progressBar);
  },
  detach: function (context) {
    $('input.form-submit', context).unbind('mousedown', Drupal.file.disableFields);
    $('div.form-managed-file input.form-submit', context).unbind('mousedown', Drupal.file.progressBar);
  }
};

/**
 * Attach behaviors to links within managed file elements.
 */
Drupal.behaviors.filePreviewLinks = {
  attach: function (context) {
    $('div.form-managed-file .file a, .file-widget .file a', context).bind('click',Drupal.file.openInNewWindow);
  },
  detach: function (context){
    $('div.form-managed-file .file a, .file-widget .file a', context).unbind('click', Drupal.file.openInNewWindow);
  }
};

/**
 * File upload utility functions.
 */
Drupal.file = Drupal.file || {
  /**
   * Client-side file input validation of file extensions.
   */
  validateExtension: function (event) {
    // Remove any previous errors.
    $('.file-upload-js-error').remove();

    // Add client side validation for the input[type=file].
    var extensionPattern = event.data.extensions.replace(/,\s*/g, '|');
    if (extensionPattern.length > 1 && this.value.length > 0) {
      var acceptableMatch = new RegExp('\\.(' + extensionPattern + ')$', 'gi');
      if (!acceptableMatch.test(this.value)) {
        var error = Drupal.t("The selected file %filename cannot be uploaded. Only files with the following extensions are allowed: %extensions.", {
          // According to the specifications of HTML5, a file upload control
          // should not reveal the real local path to the file that a user
          // has selected. Some web browsers implement this restriction by
          // replacing the local path with "C:\fakepath\", which can cause
          // confusion by leaving the user thinking perhaps Drupal could not
          // find the file because it messed up the file path. To avoid this
          // confusion, therefore, we strip out the bogus fakepath string.
          '%filename': this.value.replace('C:\\fakepath\\', ''),
          '%extensions': extensionPattern.replace(/\|/g, ', ')
        });
        $(this).closest('div.form-managed-file').prepend('<div class="messages error file-upload-js-error" aria-live="polite">' + error + '</div>');
        this.value = '';
        return false;
      }
    }
  },
  /**
   * Prevent file uploads when using buttons not intended to upload.
   */
  disableFields: function (event){
    var clickedButton = this;

    // Only disable upload fields for Ajax buttons.
    if (!$(clickedButton).hasClass('ajax-processed')) {
      return;
    }

    // Check if we're working with an "Upload" button.
    var $enabledFields = [];
    if ($(this).closest('div.form-managed-file').length > 0) {
      $enabledFields = $(this).closest('div.form-managed-file').find('input.form-file');
    }

    // Temporarily disable upload fields other than the one we're currently
    // working with. Filter out fields that are already disabled so that they
    // do not get enabled when we re-enable these fields at the end of behavior
    // processing. Re-enable in a setTimeout set to a relatively short amount
    // of time (1 second). All the other mousedown handlers (like Drupal's Ajax
    // behaviors) are excuted before any timeout functions are called, so we
    // don't have to worry about the fields being re-enabled too soon.
    // @todo If the previous sentence is true, why not set the timeout to 0?
    var $fieldsToTemporarilyDisable = $('div.form-managed-file input.form-file').not($enabledFields).not(':disabled');
    $fieldsToTemporarilyDisable.attr('disabled', 'disabled');
    setTimeout(function (){
      $fieldsToTemporarilyDisable.attr('disabled', false);
    }, 1000);
  },
  /**
   * Add progress bar support if possible.
   */
  progressBar: function (event) {
    var clickedButton = this;
    var $progressId = $(clickedButton).closest('div.form-managed-file').find('input.file-progress');
    if ($progressId.length) {
      var originalName = $progressId.attr('name');

      // Replace the name with the required identifier.
      $progressId.attr('name', originalName.match(/APC_UPLOAD_PROGRESS|UPLOAD_IDENTIFIER/)[0]);

      // Restore the original name after the upload begins.
      setTimeout(function () {
        $progressId.attr('name', originalName);
      }, 1000);
    }
    // Show the progress bar if the upload takes longer than half a second.
    setTimeout(function () {
      $(clickedButton).closest('div.form-managed-file').find('div.ajax-progress-bar').slideDown();
    }, 500);
  },
  /**
   * Open links to files within forms in a new window.
   */
  openInNewWindow: function (event) {
    $(this).attr('target', '_blank');
    window.open(this.href, 'filePreview', 'toolbar=0,scrollbars=1,location=1,statusbar=1,menubar=0,resizable=1,width=500,height=550');
    return false;
  }
};

})(jQuery);
;
(function ($) {

/**
 * Toggle the visibility of a fieldset using smooth animations.
 */
Drupal.toggleFieldset = function (fieldset) {
  var $fieldset = $(fieldset);
  if ($fieldset.is('.collapsed')) {
    var $content = $('> .fieldset-wrapper', fieldset).hide();
    $fieldset
      .removeClass('collapsed')
      .trigger({ type: 'collapsed', value: false })
      .find('> legend span.fieldset-legend-prefix').html(Drupal.t('Hide'));
    $content.slideDown({
      duration: 'fast',
      easing: 'linear',
      complete: function () {
        Drupal.collapseScrollIntoView(fieldset);
        fieldset.animating = false;
      },
      step: function () {
        // Scroll the fieldset into view.
        Drupal.collapseScrollIntoView(fieldset);
      }
    });
  }
  else {
    $fieldset.trigger({ type: 'collapsed', value: true });
    $('> .fieldset-wrapper', fieldset).slideUp('fast', function () {
      $fieldset
        .addClass('collapsed')
        .find('> legend span.fieldset-legend-prefix').html(Drupal.t('Show'));
      fieldset.animating = false;
    });
  }
};

/**
 * Scroll a given fieldset into view as much as possible.
 */
Drupal.collapseScrollIntoView = function (node) {
  var h = document.documentElement.clientHeight || document.body.clientHeight || 0;
  var offset = document.documentElement.scrollTop || document.body.scrollTop || 0;
  var posY = $(node).offset().top;
  var fudge = 55;
  if (posY + node.offsetHeight + fudge > h + offset) {
    if (node.offsetHeight > h) {
      window.scrollTo(0, posY);
    }
    else {
      window.scrollTo(0, posY + node.offsetHeight - h + fudge);
    }
  }
};

Drupal.behaviors.collapse = {
  attach: function (context, settings) {
    $('fieldset.collapsible', context).once('collapse', function () {
      var $fieldset = $(this);
      // Expand fieldset if there are errors inside, or if it contains an
      // element that is targeted by the URI fragment identifier.
      var anchor = location.hash && location.hash != '#' ? ', ' + location.hash : '';
      if ($fieldset.find('.error' + anchor).length) {
        $fieldset.removeClass('collapsed');
      }

      var summary = $('<span class="summary"></span>');
      $fieldset.
        bind('summaryUpdated', function () {
          var text = $.trim($fieldset.drupalGetSummary());
          summary.html(text ? ' (' + text + ')' : '');
        })
        .trigger('summaryUpdated');

      // Turn the legend into a clickable link, but retain span.fieldset-legend
      // for CSS positioning.
      var $legend = $('> legend .fieldset-legend', this);

      $('<span class="fieldset-legend-prefix element-invisible"></span>')
        .append($fieldset.hasClass('collapsed') ? Drupal.t('Show') : Drupal.t('Hide'))
        .prependTo($legend)
        .after(' ');

      // .wrapInner() does not retain bound events.
      var $link = $('<a class="fieldset-title" href="#"></a>')
        .prepend($legend.contents())
        .appendTo($legend)
        .click(function () {
          var fieldset = $fieldset.get(0);
          // Don't animate multiple times.
          if (!fieldset.animating) {
            fieldset.animating = true;
            Drupal.toggleFieldset(fieldset);
          }
          return false;
        });

      $legend.append(summary);
    });
  }
};

})(jQuery);
;

/**
 * @file
 * This file contains the javascript functions used by the google map field
 * widget
 */

/**
 * Add code to generate the maps on page load.
 */
(function ($) {

  Drupal.behaviors.google_map_field = {
    attach: function (context) {

      googleMapFieldPreviews();

      $('.google-map-field-clear').bind('click', function(event) {
        event.preventDefault();
        var data_delta = $(this).attr('data-delta');
        var data_field_id = $(this).attr('data-field-id');
        $('input[data-name-delta="'+data_delta+'"][data-name-field-id="'+data_field_id+'"]').prop('value', '').attr('value', '');
        $('input[data-lat-delta="'+data_delta+'"][data-lat-field-id="'+data_field_id+'"]').prop('value', '').attr('value', '');
        $('input[data-lng-delta="'+data_delta+'"][data-lng-field-id="'+data_field_id+'"]').prop('value', '').attr('value', '');
        $('input[data-zoom-delta="'+data_delta+'"][data-zoom-field-id="'+data_field_id+'"]').prop('value', '').attr('value', '');
        googleMapFieldPreviews(data_delta);
      });

      $('.google-map-field-defaults').bind('click', function(event) {
        event.preventDefault();
        var data_delta = $(this).attr('data-delta');
        var data_field_id = $(this).attr('data-field-id');
        $('input[data-name-delta="'+data_delta+'"][data-name-field-id="'+data_field_id+'"]').prop('value', $(this).attr('data-default-name')).attr('value', $(this).attr('data-default-name'));
        $('input[data-lat-delta="'+data_delta+'"][data-lat-field-id="'+data_field_id+'"]').prop('value', $(this).attr('data-default-lat')).attr('value', $(this).attr('data-default-lat'));
        $('input[data-lng-delta="'+data_delta+'"][data-lng-field-id="'+data_field_id+'"]').prop('value', $(this).attr('data-default-lon')).attr('value', $(this).attr('data-default-lon'));
        $('input[data-zoom-delta="'+data_delta+'"][data-zoom-field-id="'+data_field_id+'"]').prop('value', $(this).attr('data-default-zoom')).attr('value', $(this).attr('data-default-zoom'));
        googleMapFieldPreviews(data_delta);
      });

      $('.google-map-field-watch-change').change(function(event) {
        var data_delta = $(this).attr('data-lat-delta') || $(this).attr('data-lng-delta') || $(this).attr('data-zoom-delta');
        var data_field_id = $(this).attr('data-lat-field-id') || $(this).attr('data-lng-field-id') || $(this).attr('data-zoom-field-id');
        googleMapFieldPreviews(data_delta);
      });

    }
  };

})(jQuery);
;

/**
 * @file
 * This file contains the javascript functions used by the field widget
 * to enable admins to set map locations
 */

(function ($) {

  var dialog;
  var google_map_field_map;

  googleMapFieldSetter = function(field_id, delta) {

    btns = {};

    btns[Drupal.t('Insert map')] = function () {
      var latlng = google_map_field_map.getCenter();
      var zoom = google_map_field_map.getZoom();
      $('input[data-lat-delta="'+delta+'"][data-lat-field-id="'+field_id+'"]').prop('value', latlng.lat()).attr('value', latlng.lat());
      $('input[data-lng-delta="'+delta+'"][data-lng-field-id="'+field_id+'"]').prop('value', latlng.lng()).attr('value', latlng.lng());
      $('input[data-zoom-delta="'+delta+'"][data-zoom-field-id="'+field_id+'"]').prop('value', zoom).attr('value', zoom);
      $('.google-map-field-preview[data-delta="'+delta+'"][data-field-id="'+field_id+'"]').attr('data-lat', latlng.lat());
      $('.google-map-field-preview[data-delta="'+delta+'"][data-field-id="'+field_id+'"]').attr('data-lng', latlng.lng());
      $('.google-map-field-preview[data-delta="'+delta+'"][data-field-id="'+field_id+'"]').attr('data-zoom', zoom);
      googleMapFieldPreviews(delta);
      $(this).dialog("close");
    };

    btns[Drupal.t('Cancel')] = function () {
      $(this).dialog("close");
    };

    dialogHTML = '';
    dialogHTML += '<div id="google_map_field_dialog">';
    dialogHTML += '  <p>' + Drupal.t('Use the map below to drop a marker at the required location.') + '</p>';
    dialogHTML += '  <div id="gmf_container"></div>';
    dialogHTML += '  <div id="centre_on">';
    dialogHTML += '    <label>' + Drupal.t('Enter an address/town/postcode etc to centre the map on:') + '<input type="text" name="centre_map_on" id="centre_map_on" value=""/></label>';
    dialogHTML += '    <button onclick="return doCentre();" type="button" role="button">' + Drupal.t('find') + '</button>';
    dialogHTML += '    <div id="map_error"></div>';
    dialogHTML += '  </div>';
    dialogHTML += '</div>';

    $('body').append(dialogHTML);

    dialog = $('#google_map_field_dialog').dialog({
      modal: true,
      autoOpen: false,
      width: 750,
      height: 550,
      closeOnEscape: true,
      resizable: false,
      draggable: false,
      title: Drupal.t('Set Map Marker'),
      dialogClass: 'jquery_ui_dialog-dialog',
      buttons: btns,
      close: function(event, ui) {
        $(this).dialog('destroy').remove();
      }
    });

    dialog.dialog('open');

    // Create the map setter map.
    // get the lat/lon from form elements
    var lat = $('input[data-lat-delta="'+delta+'"][data-lat-field-id="'+field_id+'"]').attr('value');
    var lng = $('input[data-lng-delta="'+delta+'"][data-lng-field-id="'+field_id+'"]').attr('value');
    var zoom = $('input[data-zoom-delta="'+delta+'"][data-zoom-field-id="'+field_id+'"]').attr('value');

    lat = googleMapFieldValidateLat(lat);
    lng = googleMapFieldValidateLng(lng);

    if (zoom == null || zoom == '') {
      var zoom = '9';
    }

    var latlng = new google.maps.LatLng(lat, lng);
    var mapOptions = {
      zoom: parseInt(zoom),
      center: latlng,
      streetViewControl: false,
      mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    google_map_field_map = new google.maps.Map(document.getElementById("gmf_container"), mapOptions);

    // drop a marker at the specified lat/lng coords
    marker = new google.maps.Marker({
      position: latlng,
      optimized: false,
      draggable: true,
      map: google_map_field_map
    });

    // add a click listener for marker placement
    google.maps.event.addListener(google_map_field_map, "click", function(event) {
      latlng = event.latLng;
      marker.setMap(null);
      google_map_field_map.panTo(latlng);
      marker = new google.maps.Marker({
        position: latlng,
        optimized: false,
        draggable: true,
        map: google_map_field_map
      });
    });
    google.maps.event.addListener(marker, 'dragend', function(event) {
      google_map_field_map.panTo(event.latLng);
    });
    return false;
  }

  googleMapFieldPreviews = function(delta) {

    delta = typeof delta !== 'undefined' ? delta : -1;

    $('.google-map-field-preview').each(function() {
      var data_delta = $(this).attr('data-delta');
      var data_field_id = $(this).attr('data-field-id');

      if (data_delta == delta || delta == -1) {

        var data_name  = $('input[data-name-delta="'+data_delta+'"][data-name-field-id="'+data_field_id+'"]').val();
        var data_lat   = $('input[data-lat-delta="'+data_delta+'"][data-lat-field-id="'+data_field_id+'"]').val();
        var data_lng   = $('input[data-lng-delta="'+data_delta+'"][data-lng-field-id="'+data_field_id+'"]').val();
        var data_zoom  = $('input[data-zoom-delta="'+data_delta+'"][data-zoom-field-id="'+data_field_id+'"]').val();

        data_lat = googleMapFieldValidateLat(data_lat);
        data_lng = googleMapFieldValidateLng(data_lng);

        if (data_zoom == null || data_zoom == '') {
          var data_zoom = '9';
        }

        var latlng = new google.maps.LatLng(data_lat, data_lng);

        // Create the map preview.
        var mapOptions = {
          zoom: parseInt(data_zoom),
          center: latlng,
          streetViewControl: false,
          mapTypeId: google.maps.MapTypeId.ROADMAP
        };
        google_map_field_map = new google.maps.Map(this, mapOptions);

        // drop a marker at the specified lat/lng coords
        marker = new google.maps.Marker({
          position: latlng,
          optimized: false,
          map: google_map_field_map
        });

        $('#map_setter_' + data_field_id + '_' + data_delta).unbind();
        $('#map_setter_' + data_field_id + '_' + data_delta).bind('click', function(event) {
          event.preventDefault();
          googleMapFieldSetter($(this).attr('data-field-id'), $(this).attr('data-delta'));
        });

      }

    });  // end .each

  }

  googleMapFieldValidateLat = function(lat) {
    lat = parseFloat(lat);
    if (lat >= -90 && lat <= 90) {
      return lat;
    }
    else {
      return '51.524295';
    }
  }

  googleMapFieldValidateLng = function(lng) {
    lng = parseFloat(lng);
    if (lng >= -180 && lng <= 180) {
      return lng;
    }
    else {
      return '-0.127990';
    }
  }

  doCentre = function() {
    var centreOnVal = $('#centre_map_on').val();

    if (centreOnVal == '' || centreOnVal == null) {
      $('#centre_map_on').css("border", "1px solid red");
      $('#map_error').html(Drupal.t('Enter a value in the field provided.'));
      return false;
    }
    else {
      $('#centre_map_on').css("border", "1px solid lightgrey");
      $('#map_error').html('');
    }

    var geocoder = new google.maps.Geocoder();
    geocoder.geocode({ 'address': centreOnVal}, function (result, status) {
      if (status == 'OK') {
        var latlng = new google.maps.LatLng(result[0].geometry.location.lat(), result[0].geometry.location.lng());
        google_map_field_map.panTo(latlng);
        marker.setMap(null);
        marker = new google.maps.Marker({
          position: latlng,
          draggable: true,
          map: google_map_field_map
        });
        google.maps.event.addListener(marker, 'dragend', function(event) {
          google_map_field_map.panTo(event.latLng);
        });
        $('#centre_map_on').val('');
      } else {
        $('#map_error').html(Drupal.t('Could not find location.'));
      }
    });

    return false;

  }

})(jQuery);
;
(function ($) {

/**
 * Automatically display the guidelines of the selected text format.
 */
Drupal.behaviors.filterGuidelines = {
  attach: function (context) {
    $('.filter-guidelines', context).once('filter-guidelines')
      .find(':header').hide()
      .closest('.filter-wrapper').find('select.filter-list')
      .bind('change', function () {
        $(this).closest('.filter-wrapper')
          .find('.filter-guidelines-item').hide()
          .siblings('.filter-guidelines-' + this.value).show();
      })
      .change();
  }
};

})(jQuery);
;
(function ($) {

Drupal.behaviors.menuFieldsetSummaries = {
  attach: function (context) {
    $('fieldset.menu-link-form', context).drupalSetSummary(function (context) {
      if ($('.form-item-menu-enabled input', context).is(':checked')) {
        return Drupal.checkPlain($('.form-item-menu-link-title input', context).val());
      }
      else {
        return Drupal.t('Not in menu');
      }
    });
  }
};

/**
 * Automatically fill in a menu link title, if possible.
 */
Drupal.behaviors.menuLinkAutomaticTitle = {
  attach: function (context) {
    $('fieldset.menu-link-form', context).each(function () {
      // Try to find menu settings widget elements as well as a 'title' field in
      // the form, but play nicely with user permissions and form alterations.
      var $checkbox = $('.form-item-menu-enabled input', this);
      var $link_title = $('.form-item-menu-link-title input', context);
      var $title = $(this).closest('form').find('.form-item-title input');
      // Bail out if we do not have all required fields.
      if (!($checkbox.length && $link_title.length && $title.length)) {
        return;
      }
      // If there is a link title already, mark it as overridden. The user expects
      // that toggling the checkbox twice will take over the node's title.
      if ($checkbox.is(':checked') && $link_title.val().length) {
        $link_title.data('menuLinkAutomaticTitleOveridden', true);
      }
      // Whenever the value is changed manually, disable this behavior.
      $link_title.keyup(function () {
        $link_title.data('menuLinkAutomaticTitleOveridden', true);
      });
      // Global trigger on checkbox (do not fill-in a value when disabled).
      $checkbox.change(function () {
        if ($checkbox.is(':checked')) {
          if (!$link_title.data('menuLinkAutomaticTitleOveridden')) {
            $link_title.val($title.val());
          }
        }
        else {
          $link_title.val('');
          $link_title.removeData('menuLinkAutomaticTitleOveridden');
        }
        $checkbox.closest('fieldset.vertical-tabs-pane').trigger('summaryUpdated');
        $checkbox.trigger('formUpdated');
      });
      // Take over any title change.
      $title.keyup(function () {
        if (!$link_title.data('menuLinkAutomaticTitleOveridden') && $checkbox.is(':checked')) {
          $link_title.val($title.val());
          $link_title.val($title.val()).trigger('formUpdated');
        }
      });
    });
  }
};

})(jQuery);
;

(function ($) {

Drupal.behaviors.xmlsitemapFieldsetSummaries = {
  attach: function (context) {
    $('fieldset#edit-xmlsitemap', context).drupalSetSummary(function (context) {
      var vals = [];

      // Inclusion select field.
      var status = $('#edit-xmlsitemap-status option:selected').text();
      vals.push(Drupal.t('Inclusion: @value', { '@value': status }));

      // Priority select field.
      var priority = $('#edit-xmlsitemap-priority option:selected').text();
      vals.push(Drupal.t('Priority: @value', { '@value': priority }));

      return vals.join('<br />');
    });
  }
};

})(jQuery);
;
(function ($) {

Drupal.behaviors.pathFieldsetSummaries = {
  attach: function (context) {
    $('fieldset.path-form', context).drupalSetSummary(function (context) {
      var path = $('.form-item-path-alias input', context).val();
      var automatic = $('.form-item-path-pathauto input', context).attr('checked');

      if (automatic) {
        return Drupal.t('Automatic alias');
      }
      else if (path) {
        return Drupal.t('Alias: @alias', { '@alias': path });
      }
      else {
        return Drupal.t('No alias');
      }
    });
  }
};

})(jQuery);
;
/**
 * @file
 * Custom JS for controlling the Metatag vertical tab.
 */

(function ($) {
  'use strict';

Drupal.behaviors.metatagFieldsetSummaries = {
  attach: function (context) {
    $('fieldset.metatags-form', context).drupalSetSummary(function (context) {
      var vals = [];
      $("input[type='text'], select, textarea", context).each(function() {
        var input_field = $(this).attr('name');
        // Verify the field exists before proceeding.
        if (input_field === undefined) {
          return false;
        }
        var default_name = input_field.replace(/\[value\]/, '[default]');
        var default_value = $("input[type='hidden'][name='" + default_name + "']", context);
        if (default_value.length && default_value.val() === $(this).val()) {
          // Meta tag has a default value and form value matches default value.
          return true;
        }
        else if (!default_value.length && !$(this).val().length) {
          // Meta tag has no default value and form value is empty.
          return true;
        }
        var label = $("label[for='" + $(this).attr('id') + "']").text();
        vals.push(Drupal.t('@label: @value', {
          '@label': $.trim(label),
          '@value': Drupal.truncate($(this).val(), 25) || Drupal.t('None')
        }));
      });
      if (vals.length === 0) {
        return Drupal.t('Using defaults');
      }
      else {
        return vals.join('<br />');
      }
    });
  }
};

/**
 * Encode special characters in a plain-text string for display as HTML.
 */
Drupal.truncate = function (str, limit) {
  if (str.length > limit) {
    return str.substr(0, limit) + '...';
  }
  else {
    return str;
  }
};

})(jQuery);
;
(function ($) {

/**
 * Attaches the autocomplete behavior to all required fields.
 */
Drupal.behaviors.autocomplete = {
  attach: function (context, settings) {
    var acdb = [];
    $('input.autocomplete', context).once('autocomplete', function () {
      var uri = this.value;
      if (!acdb[uri]) {
        acdb[uri] = new Drupal.ACDB(uri);
      }
      var $input = $('#' + this.id.substr(0, this.id.length - 13))
        .attr('autocomplete', 'OFF')
        .attr('aria-autocomplete', 'list');
      $($input[0].form).submit(Drupal.autocompleteSubmit);
      $input.parent()
        .attr('role', 'application')
        .append($('<span class="element-invisible" aria-live="assertive"></span>')
          .attr('id', $input.attr('id') + '-autocomplete-aria-live')
        );
      new Drupal.jsAC($input, acdb[uri]);
    });
  }
};

/**
 * Prevents the form from submitting if the suggestions popup is open
 * and closes the suggestions popup when doing so.
 */
Drupal.autocompleteSubmit = function () {
  return $('#autocomplete').each(function () {
    this.owner.hidePopup();
  }).length == 0;
};

/**
 * An AutoComplete object.
 */
Drupal.jsAC = function ($input, db) {
  var ac = this;
  this.input = $input[0];
  this.ariaLive = $('#' + this.input.id + '-autocomplete-aria-live');
  this.db = db;

  $input
    .keydown(function (event) { return ac.onkeydown(this, event); })
    .keyup(function (event) { ac.onkeyup(this, event); })
    .blur(function () { ac.hidePopup(); ac.db.cancel(); });

};

/**
 * Handler for the "keydown" event.
 */
Drupal.jsAC.prototype.onkeydown = function (input, e) {
  if (!e) {
    e = window.event;
  }
  switch (e.keyCode) {
    case 40: // down arrow.
      this.selectDown();
      return false;
    case 38: // up arrow.
      this.selectUp();
      return false;
    default: // All other keys.
      return true;
  }
};

/**
 * Handler for the "keyup" event.
 */
Drupal.jsAC.prototype.onkeyup = function (input, e) {
  if (!e) {
    e = window.event;
  }
  switch (e.keyCode) {
    case 16: // Shift.
    case 17: // Ctrl.
    case 18: // Alt.
    case 20: // Caps lock.
    case 33: // Page up.
    case 34: // Page down.
    case 35: // End.
    case 36: // Home.
    case 37: // Left arrow.
    case 38: // Up arrow.
    case 39: // Right arrow.
    case 40: // Down arrow.
      return true;

    case 9:  // Tab.
    case 13: // Enter.
    case 27: // Esc.
      this.hidePopup(e.keyCode);
      return true;

    default: // All other keys.
      if (input.value.length > 0 && !input.readOnly) {
        this.populatePopup();
      }
      else {
        this.hidePopup(e.keyCode);
      }
      return true;
  }
};

/**
 * Puts the currently highlighted suggestion into the autocomplete field.
 */
Drupal.jsAC.prototype.select = function (node) {
  this.input.value = $(node).data('autocompleteValue');
  $(this.input).trigger('autocompleteSelect', [node]);
};

/**
 * Highlights the next suggestion.
 */
Drupal.jsAC.prototype.selectDown = function () {
  if (this.selected && this.selected.nextSibling) {
    this.highlight(this.selected.nextSibling);
  }
  else if (this.popup) {
    var lis = $('li', this.popup);
    if (lis.length > 0) {
      this.highlight(lis.get(0));
    }
  }
};

/**
 * Highlights the previous suggestion.
 */
Drupal.jsAC.prototype.selectUp = function () {
  if (this.selected && this.selected.previousSibling) {
    this.highlight(this.selected.previousSibling);
  }
};

/**
 * Highlights a suggestion.
 */
Drupal.jsAC.prototype.highlight = function (node) {
  if (this.selected) {
    $(this.selected).removeClass('selected');
  }
  $(node).addClass('selected');
  this.selected = node;
  $(this.ariaLive).html($(this.selected).html());
};

/**
 * Unhighlights a suggestion.
 */
Drupal.jsAC.prototype.unhighlight = function (node) {
  $(node).removeClass('selected');
  this.selected = false;
  $(this.ariaLive).empty();
};

/**
 * Hides the autocomplete suggestions.
 */
Drupal.jsAC.prototype.hidePopup = function (keycode) {
  // Select item if the right key or mousebutton was pressed.
  if (this.selected && ((keycode && keycode != 46 && keycode != 8 && keycode != 27) || !keycode)) {
    this.select(this.selected);
  }
  // Hide popup.
  var popup = this.popup;
  if (popup) {
    this.popup = null;
    $(popup).fadeOut('fast', function () { $(popup).remove(); });
  }
  this.selected = false;
  $(this.ariaLive).empty();
};

/**
 * Positions the suggestions popup and starts a search.
 */
Drupal.jsAC.prototype.populatePopup = function () {
  var $input = $(this.input);
  var position = $input.position();
  // Show popup.
  if (this.popup) {
    $(this.popup).remove();
  }
  this.selected = false;
  this.popup = $('<div id="autocomplete"></div>')[0];
  this.popup.owner = this;
  $(this.popup).css({
    top: parseInt(position.top + this.input.offsetHeight, 10) + 'px',
    left: parseInt(position.left, 10) + 'px',
    width: $input.innerWidth() + 'px',
    display: 'none'
  });
  $input.before(this.popup);

  // Do search.
  this.db.owner = this;
  this.db.search(this.input.value);
};

/**
 * Fills the suggestion popup with any matches received.
 */
Drupal.jsAC.prototype.found = function (matches) {
  // If no value in the textfield, do not show the popup.
  if (!this.input.value.length) {
    return false;
  }

  // Prepare matches.
  var ul = $('<ul></ul>');
  var ac = this;
  for (key in matches) {
    $('<li></li>')
      .html($('<div></div>').html(matches[key]))
      .mousedown(function () { ac.hidePopup(this); })
      .mouseover(function () { ac.highlight(this); })
      .mouseout(function () { ac.unhighlight(this); })
      .data('autocompleteValue', key)
      .appendTo(ul);
  }

  // Show popup with matches, if any.
  if (this.popup) {
    if (ul.children().length) {
      $(this.popup).empty().append(ul).show();
      $(this.ariaLive).html(Drupal.t('Autocomplete popup'));
    }
    else {
      $(this.popup).css({ visibility: 'hidden' });
      this.hidePopup();
    }
  }
};

Drupal.jsAC.prototype.setStatus = function (status) {
  switch (status) {
    case 'begin':
      $(this.input).addClass('throbbing');
      $(this.ariaLive).html(Drupal.t('Searching for matches...'));
      break;
    case 'cancel':
    case 'error':
    case 'found':
      $(this.input).removeClass('throbbing');
      break;
  }
};

/**
 * An AutoComplete DataBase object.
 */
Drupal.ACDB = function (uri) {
  this.uri = uri;
  this.delay = 300;
  this.cache = {};
};

/**
 * Performs a cached and delayed search.
 */
Drupal.ACDB.prototype.search = function (searchString) {
  var db = this;
  this.searchString = searchString;

  // See if this string needs to be searched for anyway. The pattern ../ is
  // stripped since it may be misinterpreted by the browser.
  searchString = searchString.replace(/^\s+|\.{2,}\/|\s+$/g, '');
  // Skip empty search strings, or search strings ending with a comma, since
  // that is the separator between search terms.
  if (searchString.length <= 0 ||
    searchString.charAt(searchString.length - 1) == ',') {
    return;
  }

  // See if this key has been searched for before.
  if (this.cache[searchString]) {
    return this.owner.found(this.cache[searchString]);
  }

  // Initiate delayed search.
  if (this.timer) {
    clearTimeout(this.timer);
  }
  this.timer = setTimeout(function () {
    db.owner.setStatus('begin');

    // Ajax GET request for autocompletion. We use Drupal.encodePath instead of
    // encodeURIComponent to allow autocomplete search terms to contain slashes.
    $.ajax({
      type: 'GET',
      url: db.uri + '/' + Drupal.encodePath(searchString),
      dataType: 'json',
      success: function (matches) {
        if (typeof matches.status == 'undefined' || matches.status != 0) {
          db.cache[searchString] = matches;
          // Verify if these are still the matches the user wants to see.
          if (db.searchString == searchString) {
            db.owner.found(matches);
          }
          db.owner.setStatus('found');
        }
      },
      error: function (xmlhttp) {
        Drupal.displayAjaxError(Drupal.ajaxError(xmlhttp, db.uri));
      }
    });
  }, this.delay);
};

/**
 * Cancels the current autocomplete request.
 */
Drupal.ACDB.prototype.cancel = function () {
  if (this.owner) this.owner.setStatus('cancel');
  if (this.timer) clearTimeout(this.timer);
  this.searchString = '';
};

})(jQuery);
;

(function ($) {

Drupal.behaviors.nodeFieldsetSummaries = {
  attach: function (context) {
    $('fieldset.node-form-revision-information', context).drupalSetSummary(function (context) {
      var revisionCheckbox = $('.form-item-revision input', context);

      // Return 'New revision' if the 'Create new revision' checkbox is checked,
      // or if the checkbox doesn't exist, but the revision log does. For users
      // without the "Administer content" permission the checkbox won't appear,
      // but the revision log will if the content type is set to auto-revision.
      if (revisionCheckbox.is(':checked') || (!revisionCheckbox.length && $('.form-item-log textarea', context).length)) {
        return Drupal.t('New revision');
      }

      return Drupal.t('No revision');
    });

    $('fieldset.node-form-author', context).drupalSetSummary(function (context) {
      var name = $('.form-item-name input', context).val() || Drupal.settings.anonymous,
        date = $('.form-item-date input', context).val();
      return date ?
        Drupal.t('By @name on @date', { '@name': name, '@date': date }) :
        Drupal.t('By @name', { '@name': name });
    });

    $('fieldset.node-form-options', context).drupalSetSummary(function (context) {
      var vals = [];

      $('input:checked', context).parent().each(function () {
        vals.push(Drupal.checkPlain($.trim($(this).text())));
      });

      if (!$('.form-item-status input', context).is(':checked')) {
        vals.unshift(Drupal.t('Not published'));
      }
      return vals.join(', ');
    });
  }
};

})(jQuery);
;


window.google = window.google || {};
google.maps = google.maps || {};
(function() {
  
  function getScript(src) {
    document.write('<' + 'script src="' + src + '"><' + '/script>');
  }
  
  var modules = google.maps.modules = {};
  google.maps.__gjsload__ = function(name, text) {
    modules[name] = text;
  };
  
  google.maps.Load = function(apiLoad) {
    delete google.maps.Load;
    apiLoad([0.009999999776482582,[null,[["http://khm0.googleapis.com/kh?v=729\u0026hl=en-US\u0026","http://khm1.googleapis.com/kh?v=729\u0026hl=en-US\u0026"],null,null,null,1,"729",["https://khms0.google.com/kh?v=729\u0026hl=en-US\u0026","https://khms1.google.com/kh?v=729\u0026hl=en-US\u0026"]],null,null,null,null,[["http://cbk0.googleapis.com/cbk?","http://cbk1.googleapis.com/cbk?"]],[["http://khm0.googleapis.com/kh?v=105\u0026hl=en-US\u0026","http://khm1.googleapis.com/kh?v=105\u0026hl=en-US\u0026"],null,null,null,null,"105",["https://khms0.google.com/kh?v=105\u0026hl=en-US\u0026","https://khms1.google.com/kh?v=105\u0026hl=en-US\u0026"]],[["http://mt0.googleapis.com/mapslt?hl=en-US\u0026","http://mt1.googleapis.com/mapslt?hl=en-US\u0026"]],null,null,null,[["https://mts0.googleapis.com/mapslt?hl=en-US\u0026","https://mts1.googleapis.com/mapslt?hl=en-US\u0026"]]],["en-US","US",null,0,null,null,"http://maps.gstatic.com/mapfiles/","http://csi.gstatic.com","https://maps.googleapis.com","http://maps.googleapis.com",null,"https://maps.google.com","https://gg.google.com","http://maps.gstatic.com/maps-api-v3/api/images/","https://www.google.com/maps",0,"https://www.google.com"],["http://maps.googleapis.com/maps-api-v3/api/js/29/8","3.29.8"],[147870424],1,null,null,null,null,null,"",null,null,0,"http://khm.googleapis.com/mz?v=729\u0026",null,"https://earthbuilder.googleapis.com","https://earthbuilder.googleapis.com",null,"http://mt.googleapis.com/maps/vt/icon",[["http://maps.googleapis.com/maps/vt"],["https://maps.googleapis.com/maps/vt"],null,null,null,null,null,null,null,null,null,null,["https://www.google.com/maps/vt"],"/maps/vt",383000000,383],2,500,[null,null,null,null,"http://www.google.com/maps/preview/log204","","http://static.panoramio.com.storage.googleapis.com/photos/",["http://geo0.ggpht.com/cbk","http://geo1.ggpht.com/cbk","http://geo2.ggpht.com/cbk","http://geo3.ggpht.com/cbk"],"https://maps.googleapis.com/maps/api/js/GeoPhotoService.GetMetadata","https://maps.googleapis.com/maps/api/js/GeoPhotoService.SingleImageSearch",["https://lh3.ggpht.com/","https://lh4.ggpht.com/","https://lh5.ggpht.com/","https://lh6.ggpht.com/"]],["https://www.google.com/maps/api/js/master?pb=!1m2!1u29!2s8!2sen-US!3sUS!4s29/8","https://www.google.com/maps/api/js/widget?pb=!1m2!1u29!2s8!2sen-US"],null,0,null,"/maps/api/js/ApplicationService.GetEntityDetails",0,null,null,[null,null,null,null,null,null,null,null,null,[0,0]],null,[],["29.8"]], loadScriptTime);
  };
  var loadScriptTime = (new Date).getTime();
})();
// inlined
(function(_){var va,xa,Ea,Qa,Ra,Wa,$a,rb,xb,yb,zb,Ab,Eb,Fb,Ib,Lb,Hb,Pb,Ub,Wb,Zb,ac,fc,ec,jc,kc,nc,sc,Ec,Ic,Jc,Mc,Pc,Qc,Sc,Uc,Wc,Rc,Tc,Yc,ad,bd,cd,gd,sd,zd,Ad,Bd,Gd,Jd,Md,Od,Qd,Ud,Xd,de,fe,ee,ke,me,ne,re,Ge,He,Ie,Ke,Le,Ne,Oe,Se,Te,Ue,Ve,$e,bf,cf,mf,nf,of,pf,qf,rf,sf,uf,vf,wf,Bf,Gf,If,Wf,Xf,Yf,dg,eg,fg,gg,hg,ig,kg,lg,mg,ng,ug,sg,vg,wg,yg,Bg,Dg,Cg,Fg,Ng,Qg,Rg,Vg,Wg,Zg,$g,ah,bh,ch,Aa,wa,ya,dh,eh,fh,Na,Oa;_.aa="ERROR";_.ba="INVALID_REQUEST";_.ca="MAX_DIMENSIONS_EXCEEDED";_.da="MAX_ELEMENTS_EXCEEDED";_.ea="MAX_WAYPOINTS_EXCEEDED";
_.ha="NOT_FOUND";_.ia="OK";_.ja="OVER_QUERY_LIMIT";_.ka="REQUEST_DENIED";_.la="UNKNOWN_ERROR";_.ma="ZERO_RESULTS";_.na=function(){return function(a){return a}};_.oa=function(){return function(){}};_.pa=function(a){return function(b){this[a]=b}};_.qa=function(a){return function(){return this[a]}};_.ra=function(a){return function(){return a}};_.ua=function(a){return function(){return _.sa[a].apply(this,arguments)}};va=function(){va=_.oa();wa.Symbol||(wa.Symbol=xa)};
xa=function(a){return"jscomp_symbol_"+(a||"")+ya++};_.Ca=function(){va();var a=wa.Symbol.iterator;a||(a=wa.Symbol.iterator=wa.Symbol("iterator"));"function"!=typeof Array.prototype[a]&&Aa(Array.prototype,a,{configurable:!0,writable:!0,value:function(){return _.Ba(this)}});_.Ca=_.oa()};_.Ba=function(a){var b=0;return Ea(function(){return b<a.length?{done:!1,value:a[b++]}:{done:!0}})};Ea=function(a){(0,_.Ca)();a={next:a};a[wa.Symbol.iterator]=function(){return this};return a};
_.m=function(a){return void 0!==a};_.Fa=function(a){return"string"==typeof a};_.Ga=function(a){return"number"==typeof a};_.Ha=_.oa();
_.Ia=function(a){var b=typeof a;if("object"==b)if(a){if(a instanceof Array)return"array";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if("[object Window]"==c)return"object";if("[object Array]"==c||"number"==typeof a.length&&"undefined"!=typeof a.splice&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("splice"))return"array";if("[object Function]"==c||"undefined"!=typeof a.call&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("call"))return"function"}else return"null";
else if("function"==b&&"undefined"==typeof a.call)return"object";return b};_.Ja=function(a){return"array"==_.Ia(a)};_.Ka=function(a){var b=_.Ia(a);return"array"==b||"object"==b&&"number"==typeof a.length};_.La=function(a){return"function"==_.Ia(a)};_.Ma=function(a){var b=typeof a;return"object"==b&&null!=a||"function"==b};_.Pa=function(a){return a[Na]||(a[Na]=++Oa)};Qa=function(a,b,c){return a.call.apply(a.bind,arguments)};
Ra=function(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}};_.p=function(a,b,c){Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?_.p=Qa:_.p=Ra;return _.p.apply(null,arguments)};_.Sa=function(){return+new Date};
_.t=function(a,b){function c(){}c.prototype=b.prototype;a.nb=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.Je=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];b.prototype[c].apply(a,d)}};_.Ta=function(a){return a.replace(/^[\s\xa0]+|[\s\xa0]+$/g,"")};_.Va=function(){return-1!=_.Ua.toLowerCase().indexOf("webkit")};
_.Xa=function(a,b){var c=0;a=_.Ta(String(a)).split(".");b=_.Ta(String(b)).split(".");for(var d=Math.max(a.length,b.length),e=0;0==c&&e<d;e++){var f=a[e]||"",g=b[e]||"";do{f=/(\d*)(\D*)(.*)/.exec(f)||["","","",""];g=/(\d*)(\D*)(.*)/.exec(g)||["","","",""];if(0==f[0].length&&0==g[0].length)break;c=Wa(0==f[1].length?0:(0,window.parseInt)(f[1],10),0==g[1].length?0:(0,window.parseInt)(g[1],10))||Wa(0==f[2].length,0==g[2].length)||Wa(f[2],g[2]);f=f[3];g=g[3]}while(0==c)}return c};
Wa=function(a,b){return a<b?-1:a>b?1:0};_.Ya=function(a,b,c){c=null==c?0:0>c?Math.max(0,a.length+c):c;if(_.Fa(a))return _.Fa(b)&&1==b.length?a.indexOf(b,c):-1;for(;c<a.length;c++)if(c in a&&a[c]===b)return c;return-1};_.v=function(a,b,c){for(var d=a.length,e=_.Fa(a)?a.split(""):a,f=0;f<d;f++)f in e&&b.call(c,e[f],f,a)};$a=function(a,b){for(var c=a.length,d=_.Fa(a)?a.split(""):a,e=0;e<c;e++)if(e in d&&b.call(void 0,d[e],e,a))return e;return-1};
_.bb=function(a,b){b=_.Ya(a,b);var c;(c=0<=b)&&_.ab(a,b);return c};_.ab=function(a,b){Array.prototype.splice.call(a,b,1)};_.cb=function(a,b,c){return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};_.w=function(a){return a?a.length:0};_.eb=function(a,b){_.db(b,function(c){a[c]=b[c]})};_.fb=function(a){for(var b in a)return!1;return!0};_.gb=function(a,b,c){null!=b&&(a=Math.max(a,b));null!=c&&(a=Math.min(a,c));return a};
_.hb=function(a,b,c){c-=b;return((a-b)%c+c)%c+b};_.ib=function(a,b,c){return Math.abs(a-b)<=(c||1E-9)};_.jb=function(a,b){for(var c=[],d=_.w(a),e=0;e<d;++e)c.push(b(a[e],e));return c};_.lb=function(a,b){for(var c=_.kb(void 0,_.w(b)),d=_.kb(void 0,0);d<c;++d)a.push(b[d])};_.y=function(a){return"number"==typeof a};_.mb=function(a){return"object"==typeof a};_.kb=function(a,b){return null==a?b:a};_.nb=function(a){return"string"==typeof a};_.ob=function(a){return a===!!a};
_.db=function(a,b){for(var c in a)b(c,a[c])};_.qb=function(a){return function(){var b=this,c=arguments;_.pb(function(){a.apply(b,c)})}};_.pb=function(a){return window.setTimeout(a,0)};rb=function(a,b){if(Object.prototype.hasOwnProperty.call(a,b))return a[b]};_.sb=function(a){window.console&&window.console.error&&window.console.error(a)};_.tb=function(a){a.cancelBubble=!0;a.stopPropagation&&a.stopPropagation()};
_.ub=function(a){a.preventDefault&&_.m(a.defaultPrevented)?a.preventDefault():a.returnValue=!1};_.vb=function(a){a=a||window.event;_.tb(a);_.ub(a)};_.wb=function(a){a.handled=!0;_.m(a.bubbles)||(a.returnValue="handled")};xb=function(a,b){a.__e3_||(a.__e3_={});a=a.__e3_;a[b]||(a[b]={});return a[b]};yb=function(a,b){var c=a.__e3_||{};if(b)a=c[b]||{};else for(b in a={},c)_.eb(a,c[b]);return a};zb=function(a,b){return function(c){return b.call(a,c,this)}};
Ab=function(a,b,c){return function(d){var e=[b,a];_.lb(e,arguments);_.A.trigger.apply(this,e);c&&_.wb.apply(null,arguments)}};Eb=function(a,b,c,d){this.f=a;this.b=b;this.j=c;this.l=null;this.m=d;this.id=++Bb;xb(a,b)[this.id]=this;Cb&&"tagName"in a&&(Db[this.id]=this)};Fb=function(a){return a.l=function(b){b||(b=window.event);if(b&&!b.target)try{b.target=b.srcElement}catch(d){}var c=a.j.apply(a.f,[b]);return b&&"click"==b.type&&(b=b.srcElement)&&"A"==b.tagName&&"javascript:void(0)"==b.href?!1:c}};
_.Gb=function(a){return""+(_.Ma(a)?_.Pa(a):a)};_.D=_.oa();Ib=function(a,b){var c=b+"_changed";if(a[c])a[c]();else a.changed(b);var c=Hb(a,b),d;for(d in c){var e=c[d];Ib(e.Gc,e.hb)}_.A.trigger(a,b.toLowerCase()+"_changed")};_.Kb=function(a){return Jb[a]||(Jb[a]=a.substr(0,1).toUpperCase()+a.substr(1))};Lb=function(a){a.gm_accessors_||(a.gm_accessors_={});return a.gm_accessors_};Hb=function(a,b){a.gm_bindings_||(a.gm_bindings_={});a.gm_bindings_.hasOwnProperty(b)||(a.gm_bindings_[b]={});return a.gm_bindings_[b]};
_.Mb=function(a){return-1!=_.Ua.indexOf(a)};_.Nb=function(a,b,c){for(var d in a)b.call(c,a[d],d,a)};_.Ob=function(){return _.Mb("Trident")||_.Mb("MSIE")};_.Qb=function(){return _.Mb("Safari")&&!(Pb()||_.Mb("Coast")||_.Mb("Opera")||_.Mb("Edge")||_.Mb("Silk")||_.Mb("Android"))};Pb=function(){return(_.Mb("Chrome")||_.Mb("CriOS"))&&!_.Mb("Edge")};_.Rb=function(){return _.Mb("iPhone")&&!_.Mb("iPod")&&!_.Mb("iPad")};_.Sb=function(a){_.Sb[" "](a);return a};
Ub=function(a,b){var c=Tb;return Object.prototype.hasOwnProperty.call(c,a)?c[a]:c[a]=b(a)};Wb=function(){var a=_.Vb.document;return a?a.documentMode:void 0};_.Yb=function(a){return Ub(a,function(){return 0<=_.Xa(_.Xb,a)})};Zb=function(a,b,c){this.l=c;this.j=a;this.m=b;this.f=0;this.b=null};_.$b=_.na();ac=function(a){_.Vb.setTimeout(function(){throw a;},0)};
fc=function(){var a=_.bc.f,a=cc(a);!_.La(_.Vb.setImmediate)||_.Vb.Window&&_.Vb.Window.prototype&&!_.Mb("Edge")&&_.Vb.Window.prototype.setImmediate==_.Vb.setImmediate?(dc||(dc=ec()),dc(a)):_.Vb.setImmediate(a)};
ec=function(){var a=_.Vb.MessageChannel;"undefined"===typeof a&&"undefined"!==typeof window&&window.postMessage&&window.addEventListener&&!_.Mb("Presto")&&(a=function(){var a=window.document.createElement("IFRAME");a.style.display="none";a.src="";window.document.documentElement.appendChild(a);var b=a.contentWindow,a=b.document;a.open();a.write("");a.close();var c="callImmediate"+Math.random(),d="file:"==b.location.protocol?"*":b.location.protocol+"//"+b.location.host,a=(0,_.p)(function(a){if(("*"==
d||a.origin==d)&&a.data==c)this.port1.onmessage()},this);b.addEventListener("message",a,!1);this.port1={};this.port2={postMessage:function(){b.postMessage(c,d)}}});if("undefined"!==typeof a&&!_.Ob()){var b=new a,c={},d=c;b.port1.onmessage=function(){if(_.m(c.next)){c=c.next;var a=c.tg;c.tg=null;a()}};return function(a){d.next={tg:a};d=d.next;b.port2.postMessage(0)}}return"undefined"!==typeof window.document&&"onreadystatechange"in window.document.createElement("SCRIPT")?function(a){var b=window.document.createElement("SCRIPT");
b.onreadystatechange=function(){b.onreadystatechange=null;b.parentNode.removeChild(b);b=null;a();a=null};window.document.documentElement.appendChild(b)}:function(a){_.Vb.setTimeout(a,0)}};jc=function(){this.f=this.b=null};kc=function(){this.next=this.b=this.Dc=null};_.bc=function(a,b){_.bc.b||_.bc.m();_.bc.j||(_.bc.b(),_.bc.j=!0);_.bc.l.add(a,b)};_.lc=function(a){return a*Math.PI/180};_.mc=function(a){return 180*a/Math.PI};nc=function(a){this.message=a;this.name="InvalidValueError";this.stack=Error().stack};
_.oc=function(a,b){var c="";if(null!=b){if(!(b instanceof nc))return b;c=": "+b.message}return new nc(a+c)};_.qc=function(a){if(!(a instanceof nc))throw a;_.sb(a.name+": "+a.message)};
_.rc=function(a,b){var c=c?c+": ":"";return function(d){if(!d||!_.mb(d))throw _.oc(c+"not an Object");var e={},f;for(f in d)if(e[f]=d[f],!b&&!a[f])throw _.oc(c+"unknown property "+f);for(f in a)try{var g=a[f](e[f]);if(_.m(g)||Object.prototype.hasOwnProperty.call(d,f))e[f]=a[f](e[f])}catch(h){throw _.oc(c+"in property "+f,h);}return e}};sc=function(a){try{return!!a.cloneNode}catch(b){return!1}};
_.tc=function(a,b,c){return c?function(c){if(c instanceof a)return c;try{return new a(c)}catch(e){throw _.oc("when calling new "+b,e);}}:function(c){if(c instanceof a)return c;throw _.oc("not an instance of "+b);}};_.uc=function(a){return function(b){for(var c in a)if(a[c]==b)return b;throw _.oc(b);}};_.vc=function(a){return function(b){if(!_.Ja(b))throw _.oc("not an Array");return _.jb(b,function(b,d){try{return a(b)}catch(e){throw _.oc("at index "+d,e);}})}};
_.wc=function(a,b){return function(c){if(a(c))return c;throw _.oc(b||""+c);}};_.xc=function(a){return function(b){for(var c=[],d=0,e=a.length;d<e;++d){var f=a[d];try{(f.Of||f)(b)}catch(g){if(!(g instanceof nc))throw g;c.push(g.message);continue}return(f.then||f)(b)}throw _.oc(c.join("; and "));}};_.yc=function(a,b){return function(c){return b(a(c))}};_.Dc=function(a){return function(b){return null==b?b:a(b)}};
Ec=function(a){return function(b){if(b&&null!=b[a])return b;throw _.oc("no "+a+" property");}};_.F=function(a,b,c){if(a&&(void 0!==a.lat||void 0!==a.lng))try{Fc(a),b=a.lng,a=a.lat,c=!1}catch(d){_.qc(d)}a-=0;b-=0;c||(a=_.gb(a,-90,90),180!=b&&(b=_.hb(b,-180,180)));this.lat=function(){return a};this.lng=function(){return b}};_.Gc=function(a){return _.lc(a.lat())};_.Hc=function(a){return _.lc(a.lng())};Ic=function(a,b){b=Math.pow(10,b);return Math.round(a*b)/b};Jc=_.oa();
_.Kc=function(a){try{if(a instanceof _.F)return a;a=Fc(a);return new _.F(a.lat,a.lng)}catch(b){throw _.oc("not a LatLng or LatLngLiteral",b);}};_.Lc=function(a){this.b=_.Kc(a)};Mc=function(a){if(a instanceof Jc)return a;try{return new _.Lc(_.Kc(a))}catch(b){}throw _.oc("not a Geometry or LatLng or LatLngLiteral object");};_.Nc=function(a,b){if(a)return function(){--a||b()};b();return _.Ha};
_.Oc=function(a,b,c){var d=a.getElementsByTagName("head")[0];a=a.createElement("script");a.type="text/javascript";a.charset="UTF-8";a.src=b;c&&(a.onerror=c);d.appendChild(a);return a};Pc=function(a){for(var b="",c=0,d=arguments.length;c<d;++c){var e=arguments[c];e.length&&"/"==e[0]?b=e:(b&&"/"!=b[b.length-1]&&(b+="/"),b+=e)}return b};Qc=function(a){this.j=window.document;this.b={};this.f=a};Sc=function(){this.l={};this.f={};this.m={};this.b={};this.j=new Rc};
Uc=function(a,b){a.l[b]||(a.l[b]=!0,Tc(a.j,function(c){for(var d=c.b[b],e=d?d.length:0,f=0;f<e;++f){var g=d[f];a.b[g]||Uc(a,g)}c=c.j;c.b[b]||_.Oc(c.j,Pc(c.f,b)+".js")}))};Wc=function(a,b){var c=Vc;this.j=a;this.b=c;a={};for(var d in c)for(var e=c[d],f=0,g=e.length;f<g;++f){var h=e[f];a[h]||(a[h]=[]);a[h].push(d)}this.l=a;this.f=b};Rc=function(){this.b=[]};Tc=function(a,b){a.f?b(a.f):a.b.push(b)};_.G=function(a,b,c){var d=Sc.b();a=""+a;d.b[a]?b(d.b[a]):((d.f[a]=d.f[a]||[]).push(b),c||Uc(d,a))};
_.Xc=function(a,b){Sc.b().b[""+a]=b};Yc=function(a,b,c){var d=[],e=_.Nc(a.length,function(){b.apply(null,d)});_.v(a,function(a,b){_.G(a,function(a){d[b]=a;e()},c)})};_.Zc=function(a){a=a||{};this.j=a.id;this.b=null;try{this.b=a.geometry?Mc(a.geometry):null}catch(b){_.qc(b)}this.f=a.properties||{}};_.K=function(a,b){this.x=a;this.y=b};ad=function(a){if(a instanceof _.K)return a;try{_.rc({x:_.$c,y:_.$c},!0)(a)}catch(b){throw _.oc("not a Point",b);}return new _.K(a.x,a.y)};
_.L=function(a,b,c,d){this.width=a;this.height=b;this.f=c||"px";this.b=d||"px"};bd=function(a){if(a instanceof _.L)return a;try{_.rc({height:_.$c,width:_.$c},!0)(a)}catch(b){throw _.oc("not a Size",b);}return new _.L(a.width,a.height)};cd=function(a,b){-180==a&&180!=b&&(a=180);-180==b&&180!=a&&(b=180);this.b=a;this.f=b};_.dd=function(a){return a.b>a.f};_.ed=function(a,b){var c=b-a;return 0<=c?c:b+180-(a-180)};_.fd=function(a){return a.isEmpty()?0:_.dd(a)?360-(a.b-a.f):a.f-a.b};
gd=function(a,b){this.b=a;this.f=b};_.jd=function(a){return a.isEmpty()?0:a.f-a.b};_.kd=function(a,b){a=a&&_.Kc(a);b=b&&_.Kc(b);if(a){b=b||a;var c=_.gb(a.lat(),-90,90),d=_.gb(b.lat(),-90,90);this.f=new gd(c,d);a=a.lng();b=b.lng();360<=b-a?this.b=new cd(-180,180):(a=_.hb(a,-180,180),b=_.hb(b,-180,180),this.b=new cd(a,b))}else this.f=new gd(1,-1),this.b=new cd(180,-180)};_.ld=function(a,b,c,d){return new _.kd(new _.F(a,b,!0),new _.F(c,d,!0))};
_.nd=function(a){if(a instanceof _.kd)return a;try{return a=md(a),_.ld(a.south,a.west,a.north,a.east)}catch(b){throw _.oc("not a LatLngBounds or LatLngBoundsLiteral",b);}};_.od=function(a,b){this.f=a||0;this.j=b||0};_.pd=function(a){return function(){return this.get(a)}};_.qd=function(a,b){return b?function(c){try{this.set(a,b(c))}catch(d){_.qc(_.oc("set"+_.Kb(a),d))}}:function(b){this.set(a,b)}};
_.rd=function(a,b){_.db(b,function(b,d){var c=_.pd(b);a["get"+_.Kb(b)]=c;d&&(d=_.qd(b,d),a["set"+_.Kb(b)]=d)})};_.td=function(a){this.b=a||[];sd(this)};sd=function(a){a.set("length",a.b.length)};_.ud=function(a){this.j=a||_.Gb;this.f={}};_.vd=function(a,b){var c=a.f,d=a.j(b);c[d]||(c[d]=b,_.A.trigger(a,"insert",b),a.b&&a.b(b))};_.yd=_.pa("b");zd=function(a,b){this.b=a;this.f=b};
Ad=function(a,b,c){var d=Math.pow(2,Math.round(Math.log(a)/Math.LN2))/256;this.b=Math.round(a/d)*d;a=Math.cos(b*Math.PI/180);b=Math.cos(c*Math.PI/180);c=Math.sin(c*Math.PI/180);this.m11=this.b*b;this.m12=this.b*c;this.m21=-this.b*a*c;this.m22=this.b*a*b;this.f=this.m11*this.m22-this.m12*this.m21};Bd=function(a,b){return new zd((a.m22*b.ab-a.m12*b.cb)/a.f,(-a.m21*b.ab+a.m11*b.cb)/a.f)};_.Cd=function(a){this.J=this.I=window.Infinity;this.L=this.K=-window.Infinity;_.v(a||[],this.extend,this)};
_.Dd=function(a,b,c,d){var e=new _.Cd;e.I=a;e.J=b;e.K=c;e.L=d;return e};_.Ed=function(a,b,c){this.heading=a;this.pitch=_.gb(b,-90,90);this.zoom=Math.max(0,c)};_.Fd=function(){this.__gm=new _.D;this.l=null};Gd=function(a){this.P=[];this.b=a&&a.ld||_.Ha;this.f=a&&a.md||_.Ha};_.Id=function(a,b,c,d){function e(){_.v(f,function(a){b.call(c||null,function(b){if(a.once){if(a.once.qg)return;a.once.qg=!0;_.bb(g.P,a);g.P.length||g.b()}a.Dc.call(a.context,b)})})}var f=a.P.slice(0),g=a;d&&d.sync?e():Hd(e)};
Jd=function(a,b){return function(c){return c.Dc==a&&c.context==(b||null)}};_.Kd=function(){this.P=new Gd({ld:(0,_.p)(this.ld,this),md:(0,_.p)(this.md,this)})};_.Ld=function(a){_.Kd.call(this);this.m=!!a};_.Nd=function(a){return new Md(a,void 0)};Md=function(a,b){_.Ld.call(this,b);this.b=a};Od=_.oa();Qd=function(a){var b=a;if(a instanceof Array)b=Array(a.length),_.Pd(b,a);else if(a instanceof Object){var c=b={},d;for(d in a)a.hasOwnProperty(d)&&(c[d]=Qd(a[d]))}return b};
_.Pd=function(a,b){for(var c=0;c<b.length;++c)b.hasOwnProperty(c)&&(a[c]=Qd(b[c]))};_.Rd=function(a,b){a[b]||(a[b]=[]);return a[b]};_.Vd=function(a,b){if(null==a||null==b)return null==a==(null==b);if(a.constructor!=Array&&a.constructor!=Object)throw Error("Invalid object type passed into jsproto.areObjectsEqual()");if(a===b)return!0;if(a.constructor!=b.constructor)return!1;for(var c in a)if(!(c in b&&Ud(a[c],b[c])))return!1;for(var d in b)if(!(d in a))return!1;return!0};
Ud=function(a,b){if(a===b||!(!0!==a&&1!==a||!0!==b&&1!==b)||!(!1!==a&&0!==a||!1!==b&&0!==b))return!0;if(a instanceof Object&&b instanceof Object){if(!_.Vd(a,b))return!1}else return!1;return!0};_.Wd=function(a,b,c,d){this.type=a;this.label=b;this.tk=c;this.Bc=d};Xd=function(a){switch(a){case "d":case "f":case "i":case "j":case "u":case "v":case "x":case "y":case "g":case "h":case "n":case "o":case "e":return 0;case "s":case "z":case "B":return"";case "b":return!1;default:return null}};
_.Yd=function(a,b,c){return new _.Wd(a,1,_.m(b)?b:Xd(a),c)};_.Zd=function(a,b,c){return new _.Wd(a,2,_.m(b)?b:Xd(a),c)};_.$d=function(a){return _.Yd("i",a)};_.ae=function(a){return _.Yd("v",a)};_.be=function(a){return _.Yd("b",a)};_.ce=function(a){return _.Yd("e",a)};_.M=function(a,b){return _.Yd("m",a,b)};de=_.oa();fe=function(a,b,c){for(var d=1;d<b.A.length;++d){var e=b.A[d],f=a[d+b.b];if(e&&null!=f)if(3==e.label)for(var g=0;g<f.length;++g)ee(f[g],d,e,c);else ee(f,d,e,c)}};
ee=function(a,b,c,d){if("m"==c.type){var e=d.length;fe(a,c.Bc,d);d.splice(e,0,[b,"m",d.length-e].join(""))}else"b"==c.type&&(a=a?"1":"0"),a=[b,c.type,(0,window.encodeURIComponent)(a)].join(""),d.push(a)};_.N=function(a){this.data=a||[]};_.ge=function(a,b,c){a=a.data[b];return null!=a?a:c};_.O=function(a,b,c){return _.ge(a,b,c||0)};_.P=function(a,b,c){return _.ge(a,b,c||"")};_.Q=function(a,b){var c=a.data[b];c||(c=a.data[b]=[]);return c};_.he=function(a,b){return _.Rd(a.data,b)};
_.ie=function(a,b,c){return _.he(a,b)[c]};_.je=function(a,b){return a.data[b]?a.data[b].length:0};ke=_.oa();_.le=_.pa("__gm");me=function(){this.b={};this.j={};this.f={}};ne=function(){this.b={}};re=function(a){this.b=new ne;var b=this;_.A.addListenerOnce(a,"addfeature",function(){_.G("data",function(c){c.b(b,a,b.b)})})};_.te=function(a){this.b=[];try{this.b=se(a)}catch(b){_.qc(b)}};_.ve=function(a){this.b=(0,_.ue)(a)};_.we=function(a){this.b=(0,_.ue)(a)};_.ye=function(a){this.b=xe(a)};
_.ze=function(a){this.b=(0,_.ue)(a)};_.Be=function(a){this.b=Ae(a)};_.De=function(a){this.b=Ce(a)};
_.Ee=function(a,b,c){function d(a){if(!a)throw _.oc("not a Feature");if("Feature"!=a.type)throw _.oc('type != "Feature"');var b=a.geometry;try{b=null==b?null:e(b)}catch(I){throw _.oc('in property "geometry"',I);}var d=a.properties||{};if(!_.mb(d))throw _.oc("properties is not an Object");var f=c.idPropertyName;a=f?d[f]:a.id;if(null!=a&&!_.y(a)&&!_.nb(a))throw _.oc((f||"id")+" is not a string or number");return{id:a,geometry:b,properties:d}}function e(a){if(null==a)throw _.oc("is null");var b=(a.type+
"").toLowerCase(),c=a.coordinates;try{switch(b){case "point":return new _.Lc(h(c));case "multipoint":return new _.ze(n(c));case "linestring":return g(c);case "multilinestring":return new _.ye(q(c));case "polygon":return f(c);case "multipolygon":return new _.De(u(c))}}catch(H){throw _.oc('in property "coordinates"',H);}if("geometrycollection"==b)try{return new _.te(C(a.geometries))}catch(H){throw _.oc('in property "geometries"',H);}throw _.oc("invalid type");}function f(a){return new _.Be(r(a))}function g(a){return new _.ve(n(a))}
function h(a){a=l(a);return _.Kc({lat:a[1],lng:a[0]})}if(!b)return[];c=c||{};var l=_.vc(_.$c),n=_.vc(h),q=_.vc(g),r=_.vc(function(a){a=n(a);if(!a.length)throw _.oc("contains no elements");if(!a[0].V(a[a.length-1]))throw _.oc("first and last positions are not equal");return new _.we(a.slice(0,-1))}),u=_.vc(f),C=_.vc(e),z=_.vc(d);if("FeatureCollection"==b.type){b=b.features;try{return _.jb(z(b),function(b){return a.add(b)})}catch(x){throw _.oc('in property "features"',x);}}if("Feature"==b.type)return[a.add(d(b))];
throw _.oc("not a Feature or FeatureCollection");};Ge=function(a){var b=this;a=a||{};this.setValues(a);this.b=new me;_.A.forward(this.b,"addfeature",this);_.A.forward(this.b,"removefeature",this);_.A.forward(this.b,"setgeometry",this);_.A.forward(this.b,"setproperty",this);_.A.forward(this.b,"removeproperty",this);this.f=new re(this.b);this.f.bindTo("map",this);this.f.bindTo("style",this);_.v(_.Fe,function(a){_.A.forward(b.f,a,b)});this.j=!1};He=function(a){a.j||(a.j=!0,_.G("drawing_impl",function(b){b.ol(a)}))};
Ie=function(a){if(!a)return null;if(_.Fa(a)){var b=window.document.createElement("div");b.style.overflow="auto";b.innerHTML=a}else 3==a.nodeType?(b=window.document.createElement("div"),b.appendChild(a)):b=a;return b};Ke=function(a){var b=Je,c=Sc.b().j;a=c.f=new Wc(new Qc(a),b);for(var b=0,d=c.b.length;b<d;++b)c.b[b](a);c.b.length=0};Le=function(a){a=a||{};a.clickable=_.kb(a.clickable,!0);a.visible=_.kb(a.visible,!0);this.setValues(a);_.G("marker",_.Ha)};
_.Me=function(a){this.__gm={set:null,Md:null,Mb:{map:null,ce:null}};Le.call(this,a)};Ne=function(a,b){this.b=a;this.f=b;a.addListener("map_changed",(0,_.p)(this.lm,this));this.bindTo("map",a);this.bindTo("disableAutoPan",a);this.bindTo("maxWidth",a);this.bindTo("position",a);this.bindTo("zIndex",a);this.bindTo("internalAnchor",a,"anchor");this.bindTo("internalContent",a,"content");this.bindTo("internalPixelOffset",a,"pixelOffset")};Oe=function(a,b,c,d){c?a.bindTo(b,c,d):(a.unbind(b),a.set(b,void 0))};
_.Pe=function(a){function b(){e||(e=!0,_.G("infowindow",function(a){a.Sj(d)}))}window.setTimeout(function(){_.G("infowindow",_.Ha)},100);a=a||{};var c=!!a.b;delete a.b;var d=new Ne(this,c),e=!1;_.A.addListenerOnce(this,"anchor_changed",b);_.A.addListenerOnce(this,"map_changed",b);this.setValues(a)};_.Re=function(a){_.Qe&&a&&_.Qe.push(a)};Se=function(a){this.setValues(a)};Te=_.oa();Ue=_.oa();Ve=_.oa();_.We=function(){_.G("geocoder",_.Ha)};
_.Ze=function(a,b,c){this.H=null;this.set("url",a);this.set("bounds",_.Dc(_.nd)(b));this.setValues(c)};$e=function(a,b){_.nb(a)?(this.set("url",a),this.setValues(b)):this.setValues(a)};_.af=function(){var a=this;_.G("layers",function(b){b.b(a)})};bf=function(a){this.setValues(a);var b=this;_.G("layers",function(a){a.f(b)})};cf=function(){var a=this;_.G("layers",function(b){b.j(a)})};_.df=function(){this.b=""};_.ef=function(a){var b=new _.df;b.b=a;return b};
_.gf=function(){this.Ze="";this.mj=_.ff;this.b=null};_.hf=function(a,b){var c=new _.gf;c.Ze=a;c.b=b;return c};_.jf=function(a,b){b.parentNode&&b.parentNode.insertBefore(a,b.nextSibling)};_.kf=function(a){a&&a.parentNode&&a.parentNode.removeChild(a)};_.lf=_.oa();mf=function(a,b,c,d,e){this.b=!!b;this.node=null;this.f=0;this.j=!1;this.l=!c;a&&this.setPosition(a,d);this.depth=void 0!=e?e:this.f||0;this.b&&(this.depth*=-1)};nf=function(a,b,c,d){mf.call(this,a,b,c,null,d)};
of=function(a){this.data=a||[]};pf=function(a){this.data=a||[]};qf=function(a){this.data=a||[]};rf=function(a){this.data=a||[]};sf=function(a){this.data=a||[]};_.tf=function(a){this.data=a||[]};uf=function(a){this.data=a||[]};vf=function(a){this.data=a||[]};wf=function(a){this.data=a||[]};_.xf=function(a){return _.P(a,0)};_.yf=function(a){return _.P(a,1)};_.zf=function(){return _.P(_.R,16)};_.Af=function(a){return new sf(a.data[2])};
Bf=function(a,b,c,d,e){var f=_.P(_.Af(_.R),7);this.b=a;this.f=d;this.j=_.m(e)?e:_.Sa();var g=f+"/csi?v=2&s=mapsapi3&v3v="+_.P(new wf(_.R.data[36]),0)+"&action="+a;_.Nb(c,function(a,b){g+="&"+(0,window.encodeURIComponent)(b)+"="+(0,window.encodeURIComponent)(a)});b&&(g+="&e="+b);this.l=g};_.Df=function(a,b){var c={};c[b]=void 0;_.Cf(a,c)};
_.Cf=function(a,b){var c="";_.Nb(b,function(a,b){var d=(null!=a?a:_.Sa())-this.j;c&&(c+=",");c+=b+"."+Math.round(d);null==a&&window.performance&&window.performance.mark&&window.performance.mark("mapsapi:"+this.b+":"+b)},a);b=a.l+"&rt="+c;a.f.createElement("img").src=b;(a=_.Vb.__gm_captureCSI)&&a(b)};
_.Ef=function(a,b){b=b||{};var c=b.Fm||{},d=_.he(_.R,12).join(",");d&&(c.libraries=d);var d=_.P(_.R,6),e=new of(_.R.data[33]),f=[];d&&f.push(d);_.v(e.data,function(a,b){a&&_.v(a,function(a,c){null!=a&&f.push(b+1+"_"+(c+1)+"_"+a)})});b.Hk&&(f=f.concat(b.Hk));return new Bf(a,f.join(","),c,b.document||window.document,b.startTime)};Gf=function(){this.f=_.Ef("apiboot2",{startTime:_.Ff});_.Df(this.f,"main");this.b=!1};If=function(){var a=Hf;a.b||(a.b=!0,_.Df(a.f,"firstmap"))};
_.Rf=function(){this.b=new _.K(128,128);this.j=256/360;this.l=256/(2*Math.PI);this.f=!0};_.Sf=function(a,b,c){if(a=a.fromLatLngToPoint(b))c=Math.pow(2,c),a.x*=c,a.y*=c;return a};_.Tf=function(a,b){var c=a.lat()+_.mc(b);90<c&&(c=90);var d=a.lat()-_.mc(b);-90>d&&(d=-90);b=Math.sin(b);var e=Math.cos(_.lc(a.lat()));if(90==c||-90==d||1E-6>e)return new _.kd(new _.F(d,-180),new _.F(c,180));b=_.mc(Math.asin(b/e));return new _.kd(new _.F(d,a.lng()-b),new _.F(c,a.lng()+b))};
Wf=function(a,b){_.Fd.call(this);_.Re(a);this.__gm=new _.D;this.f=null;b&&b.client&&(this.f=_.Uf[b.client]||null);var c=this.controls=[];_.db(_.Vf,function(a,b){c[b]=new _.td});this.j=!0;this.b=a;this.m=!1;this.__gm.ea=b&&b.ea||new _.ud;this.set("standAlone",!0);this.setPov(new _.Ed(0,0,1));b&&b.od&&!_.y(b.od.zoom)&&(b.od.zoom=_.y(b.zoom)?b.zoom:1);this.setValues(b);void 0==this.getVisible()&&this.setVisible(!0);_.A.addListenerOnce(this,"pano_changed",_.qb(function(){_.G("marker",(0,_.p)(function(a){a.b(this.__gm.ea,
this)},this))}))};Xf=function(){this.l=[];this.j=this.b=this.f=null};Yf=function(a,b,c){this.R=b;this.b=_.Nd(new _.yd([]));this.B=new _.ud;new _.td;this.D=new _.ud;this.F=new _.ud;this.l=new _.ud;var d=this.ea=new _.ud;d.b=function(){delete d.b;_.G("marker",_.qb(function(b){b.b(d,a)}))};this.j=new Wf(c,{visible:!1,enableCloseButton:!0,ea:d});this.j.bindTo("reportErrorControl",a);this.j.j=!1;this.f=new Xf;this.overlayLayer=null};_.Zf=function(){this.P=new Gd};
_.$f=function(a,b){this.size=new zd(256,256);this.b=a;this.heading=b};_.ag=function(a){this.ri=a||0;_.A.bind(this,"forceredraw",this,this.C)};_.bg=function(a,b){a=a.style;a.width=b.width+b.f;a.height=b.height+b.b};_.cg=function(a){return new _.L(a.offsetWidth,a.offsetHeight)};dg=function(a){this.data=a||[]};eg=function(a){this.data=a||[]};fg=function(a){this.data=a||[]};gg=function(a){this.data=a||[]};hg=function(a){this.data=a||[]};
ig=function(a,b,c,d,e){_.ag.call(this);this.G=b;this.F=new _.Rf;this.O=c+"/maps/api/js/StaticMapService.GetMapImage";this.b=this.f=null;this.B=d;this.j=e?new Md(null,void 0):null;this.l=null;this.m=!1;this.set("div",a);this.set("loading",!0)};kg=function(a){var b=a.get("tilt")||_.w(a.get("styles"));a=a.get("mapTypeId");return b?null:jg[a]};lg=function(a){a.parentNode&&a.parentNode.removeChild(a)};
mg=function(a,b){var c=a.b;c.onload=null;c.onerror=null;var d=a.get("size");d&&(b&&(c.parentNode||a.f.appendChild(c),a.j||_.bg(c,d),_.A.trigger(a,"staticmaploaded"),a.B.set(_.Sa())),a.set("loading",!1))};ng=function(a,b){var c=a.b;b!=c.src?(a.j||lg(c),c.onload=function(){mg(a,!0)},c.onerror=function(){mg(a,!1)},c.src=b):!c.parentNode&&b&&a.f.appendChild(c)};_.pg=function(a){for(var b;b=a.firstChild;)_.og(b),a.removeChild(b)};
_.og=function(a){a=new nf(a);try{for(;;)_.A.clearInstanceListeners(a.next())}catch(b){if(b!==_.qg)throw b;}};
ug=function(a,b){var c=_.Sa();Hf&&If();var d=new _.Zf,e=b||{};e.noClear||_.pg(a);var f="undefined"==typeof window.document?null:window.document.createElement("div");f&&a.appendChild&&(a.appendChild(f),f.style.width=f.style.height="100%");_.le.call(this,new Yf(this,a,f));_.m(e.mapTypeId)||(e.mapTypeId="roadmap");this.setValues(e);this.W=_.rg[15]&&e.noControlsOrLogging;this.mapTypes=new ke;this.features=new _.D;_.Re(f);this.notify("streetView");a=_.cg(f);var g=null;_.R&&sg(e.useStaticMap,a)&&(g=new ig(f,
_.tg,_.P(_.Af(_.R),9),new Md(null,void 0),!1),_.A.forward(g,"staticmaploaded",this),g.set("size",a),g.bindTo("center",this),g.bindTo("zoom",this),g.bindTo("mapTypeId",this),g.bindTo("styles",this));this.overlayMapTypes=new _.td;var h=this.controls=[];_.db(_.Vf,function(a,b){h[b]=new _.td});var l=this,n=!0;_.G("map",function(a){l.getDiv()&&f&&a.f(l,e,f,g,n,c,d)});n=!1;this.data=new Ge({map:this})};sg=function(a,b){if(_.m(a))return!!a;a=b.width;b=b.height;return 384E3>=a*b&&800>=a&&800>=b};
vg=function(){_.G("maxzoom",_.Ha)};wg=function(a,b){!a||_.nb(a)||_.y(a)?(this.set("tableId",a),this.setValues(b)):this.setValues(a)};_.xg=_.oa();yg=function(a){a=a||{};a.visible=_.kb(a.visible,!0);return a};_.zg=function(a){return a&&a.radius||6378137};Bg=function(a){return a instanceof _.td?Ag(a):new _.td((0,_.ue)(a))};
Dg=function(a){if(_.Ja(a)||a instanceof _.td)if(0==_.w(a))var b=!0;else b=a instanceof _.td?a.getAt(0):a[0],b=_.Ja(b)||b instanceof _.td;else b=!1;return b?a instanceof _.td?Cg(Ag)(a):new _.td(_.vc(Bg)(a)):new _.td([Bg(a)])};Cg=function(a){return function(b){if(!(b instanceof _.td))throw _.oc("not an MVCArray");b.forEach(function(b,d){try{a(b)}catch(e){throw _.oc("at index "+d,e);}});return b}};_.Eg=function(a){this.setValues(yg(a));_.G("poly",_.Ha)};
Fg=function(a){this.set("latLngs",new _.td([new _.td]));this.setValues(yg(a));_.G("poly",_.Ha)};_.Gg=function(a){Fg.call(this,a)};_.Hg=function(a){Fg.call(this,a)};_.Ig=function(a){this.setValues(yg(a));_.G("poly",_.Ha)};Ng=function(){this.b=null};_.Og=function(){this.b=null};
_.Pg=function(a){var b=this;this.tileSize=a.tileSize||new _.L(256,256);this.name=a.name;this.alt=a.alt;this.minZoom=a.minZoom;this.maxZoom=a.maxZoom;this.j=(0,_.p)(a.getTileUrl,a);this.b=new _.ud;this.f=null;this.set("opacity",a.opacity);_.G("map",function(a){var c=b.f=a.b,e=b.tileSize||new _.L(256,256);b.b.forEach(function(a){var d=a.__gmimt,f=d.Y,l=d.zoom,n=b.j(f,l);d.Pb=c({ca:f.x,ba:f.y,fa:l},e,a,n,function(){return _.A.trigger(a,"load")})})})};
Qg=function(a,b){null!=a.style.opacity?a.style.opacity=b:a.style.filter=b&&"alpha(opacity="+Math.round(100*b)+")"};Rg=function(a){a=a.get("opacity");return"number"==typeof a?a:1};_.Sg=function(){_.Sg.Je(this,"constructor")};_.Tg=function(a,b){_.Tg.Je(this,"constructor");this.set("styles",a);a=b||{};this.f=a.baseMapTypeId||"roadmap";this.minZoom=a.minZoom;this.maxZoom=a.maxZoom||20;this.name=a.name;this.alt=a.alt;this.projection=null;this.tileSize=new _.L(256,256)};
_.Ug=function(a,b){_.wc(sc,"container is not a Node")(a);this.setValues(b);_.G("controls",(0,_.p)(function(b){b.Fl(this,a)},this))};Vg=_.pa("b");Wg=function(a,b,c){for(var d=Array(b.length),e=0,f=b.length;e<f;++e)d[e]=b.charCodeAt(e);d.unshift(c);a=a.b;c=b=0;for(e=d.length;c<e;++c)b*=1729,b+=d[c],b%=a;return b};
Zg=function(){var a=_.O(new uf(_.R.data[4]),0),b=new Vg(131071),c=(0,window.unescape)("%26%74%6F%6B%65%6E%3D");return function(d){d=d.replace(Xg,"%27");var e=d+c;Yg||(Yg=/(?:https?:\/\/[^/]+)?(.*)/);d=Yg.exec(d);return e+Wg(b,d&&d[1],a)}};$g=function(){var a=new Vg(2147483647);return function(b){return Wg(a,b,0)}};ah=function(a){for(var b=a.split("."),c=window,d=window,e=0;e<b.length;e++)if(d=c,c=c[b[e]],!c)throw _.oc(a+" is not a function");return function(){c.apply(d)}};
bh=function(){for(var a in Object.prototype)window.console&&window.console.error("This site adds property <"+a+"> to Object.prototype. Extending Object.prototype breaks JavaScript for..in loops, which are used heavily in Google Maps API v3.")};ch=function(a){(a="version"in a)&&window.console&&window.console.error("You have included the Google Maps API multiple times on this page. This may cause unexpected errors.");return a};_.sa=[];
Aa="function"==typeof Object.defineProperties?Object.defineProperty:function(a,b,c){a!=Array.prototype&&a!=Object.prototype&&(a[b]=c.value)};wa="undefined"!=typeof window&&window===this?this:"undefined"!=typeof window.global&&null!=window.global?window.global:this;ya=0;dh=wa;eh=["Array","prototype","fill"];fh=0;for(;fh<eh.length-1;fh++){var gh=eh[fh];gh in dh||(dh[gh]={});dh=dh[gh]}
var hh=eh[eh.length-1],ih=dh[hh],jh=ih?ih:function(a,b,c){var d=this.length||0;0>b&&(b=Math.max(0,d+b));if(null==c||c>d)c=d;c=Number(c);0>c&&(c=Math.max(0,d+c));for(b=Number(b||0);b<c;b++)this[b]=a;return this};jh!=ih&&null!=jh&&Aa(dh,hh,{configurable:!0,writable:!0,value:jh});_.Vb=this;Na="closure_uid_"+(1E9*Math.random()>>>0);Oa=0;var Cb,Db;_.A={};Cb="undefined"!=typeof window.navigator&&-1!=window.navigator.userAgent.toLowerCase().indexOf("msie");Db={};_.A.addListener=function(a,b,c){return new Eb(a,b,c,0)};_.A.hasListeners=function(a,b){b=(a=a.__e3_)&&a[b];return!!b&&!_.fb(b)};_.A.removeListener=function(a){a&&a.remove()};_.A.clearListeners=function(a,b){_.db(yb(a,b),function(a,b){b&&b.remove()})};_.A.clearInstanceListeners=function(a){_.db(yb(a),function(a,c){c&&c.remove()})};
_.A.trigger=function(a,b){if(_.A.hasListeners(a,b)){var c=_.cb(arguments,2),d=yb(a,b),e;for(e in d){var f=d[e];f&&f.j.apply(f.f,c)}}};_.A.addDomListener=function(a,b,c,d){if(a.addEventListener){var e=d?4:1;a.addEventListener(b,c,d);c=new Eb(a,b,c,e)}else a.attachEvent?(c=new Eb(a,b,c,2),a.attachEvent("on"+b,Fb(c))):(a["on"+b]=c,c=new Eb(a,b,c,3));return c};_.A.addDomListenerOnce=function(a,b,c,d){var e=_.A.addDomListener(a,b,function(){e.remove();return c.apply(this,arguments)},d);return e};
_.A.U=function(a,b,c,d){return _.A.addDomListener(a,b,zb(c,d))};_.A.bind=function(a,b,c,d){return _.A.addListener(a,b,(0,_.p)(d,c))};_.A.addListenerOnce=function(a,b,c){var d=_.A.addListener(a,b,function(){d.remove();return c.apply(this,arguments)});return d};_.A.forward=function(a,b,c){return _.A.addListener(a,b,Ab(b,c))};_.A.La=function(a,b,c,d){return _.A.addDomListener(a,b,Ab(b,c,!d))};_.A.ci=function(){var a=Db,b;for(b in a)a[b].remove();Db={};(a=_.Vb.CollectGarbage)&&a()};
_.A.Tm=function(){Cb&&_.A.addDomListener(window,"unload",_.A.ci)};var Bb=0;Eb.prototype.remove=function(){if(this.f){switch(this.m){case 1:this.f.removeEventListener(this.b,this.j,!1);break;case 4:this.f.removeEventListener(this.b,this.j,!0);break;case 2:this.f.detachEvent("on"+this.b,this.l);break;case 3:this.f["on"+this.b]=null}delete xb(this.f,this.b)[this.id];this.l=this.j=this.f=null;delete Db[this.id]}};_.k=_.D.prototype;_.k.get=function(a){var b=Lb(this);a+="";b=rb(b,a);if(_.m(b)){if(b){a=b.hb;var b=b.Gc,c="get"+_.Kb(a);return b[c]?b[c]():b.get(a)}return this[a]}};_.k.set=function(a,b){var c=Lb(this);a+="";var d=rb(c,a);if(d)if(a=d.hb,d=d.Gc,c="set"+_.Kb(a),d[c])d[c](b);else d.set(a,b);else this[a]=b,c[a]=null,Ib(this,a)};_.k.notify=function(a){var b=Lb(this);a+="";(b=rb(b,a))?b.Gc.notify(b.hb):Ib(this,a)};
_.k.setValues=function(a){for(var b in a){var c=a[b],d="set"+_.Kb(b);if(this[d])this[d](c);else this.set(b,c)}};_.k.setOptions=_.D.prototype.setValues;_.k.changed=_.oa();var Jb={};_.D.prototype.bindTo=function(a,b,c,d){a+="";c=(c||a)+"";this.unbind(a);var e={Gc:this,hb:a},f={Gc:b,hb:c,og:e};Lb(this)[a]=f;Hb(b,c)[_.Gb(e)]=e;d||Ib(this,a)};_.D.prototype.unbind=function(a){var b=Lb(this),c=b[a];c&&(c.og&&delete Hb(c.Gc,c.hb)[_.Gb(c.og)],this[a]=this.get(a),b[a]=null)};
_.D.prototype.unbindAll=function(){var a=(0,_.p)(this.unbind,this),b=Lb(this),c;for(c in b)a(c)};_.D.prototype.addListener=function(a,b){return _.A.addListener(this,a,b)};_.kh={ROADMAP:"roadmap",SATELLITE:"satellite",HYBRID:"hybrid",TERRAIN:"terrain"};_.Vf={TOP_LEFT:1,TOP_CENTER:2,TOP:2,TOP_RIGHT:3,LEFT_CENTER:4,LEFT_TOP:5,LEFT:5,LEFT_BOTTOM:6,RIGHT_TOP:7,RIGHT:7,RIGHT_CENTER:8,RIGHT_BOTTOM:9,BOTTOM_LEFT:10,BOTTOM_CENTER:11,BOTTOM:11,BOTTOM_RIGHT:12,CENTER:13};a:{var lh=_.Vb.navigator;if(lh){var mh=lh.userAgent;if(mh){_.Ua=mh;break a}}_.Ua=""};_.Sb[" "]=_.Ha;var zh,Tb;_.nh=_.Mb("Opera");_.oh=_.Ob();_.ph=_.Mb("Edge");_.qh=_.Mb("Gecko")&&!(_.Va()&&!_.Mb("Edge"))&&!(_.Mb("Trident")||_.Mb("MSIE"))&&!_.Mb("Edge");_.rh=_.Va()&&!_.Mb("Edge");_.sh=_.Mb("Macintosh");_.th=_.Mb("Windows");_.uh=_.Mb("Linux")||_.Mb("CrOS");_.vh=_.Mb("Android");_.wh=_.Rb();_.xh=_.Mb("iPad");_.yh=_.Mb("iPod");
a:{var Ah="",Bh=function(){var a=_.Ua;if(_.qh)return/rv\:([^\);]+)(\)|;)/.exec(a);if(_.ph)return/Edge\/([\d\.]+)/.exec(a);if(_.oh)return/\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(a);if(_.rh)return/WebKit\/(\S+)/.exec(a);if(_.nh)return/(?:Version)[ \/]?(\S+)/.exec(a)}();Bh&&(Ah=Bh?Bh[1]:"");if(_.oh){var Ch=Wb();if(null!=Ch&&Ch>(0,window.parseFloat)(Ah)){zh=String(Ch);break a}}zh=Ah}_.Xb=zh;Tb={};var Eh=_.Vb.document;_.Dh=Eh&&_.oh?Wb()||("CSS1Compat"==Eh.compatMode?(0,window.parseInt)(_.Xb,10):5):void 0;_.Fh=_.Mb("Firefox");_.Gh=_.Rb()||_.Mb("iPod");_.Hh=_.Mb("iPad");_.Ih=_.Mb("Android")&&!(Pb()||_.Mb("Firefox")||_.Mb("Opera")||_.Mb("Silk"));_.Jh=Pb();_.Kh=_.Qb()&&!(_.Rb()||_.Mb("iPad")||_.Mb("iPod"));var Lh;Lh=_.qh||_.rh&&!_.Kh||_.nh;_.Mh=Lh||"function"==typeof _.Vb.btoa;_.Nh=Lh||!_.Kh&&!_.oh&&"function"==typeof _.Vb.atob;Zb.prototype.get=function(){if(0<this.f){this.f--;var a=this.b;this.b=a.next;a.next=null}else a=this.j();return a};var Oh=function(a){return function(){return a}}(null);var dc,cc=_.$b;var Ph=new Zb(function(){return new kc},function(a){a.reset()},100);jc.prototype.add=function(a,b){var c=Ph.get();c.set(a,b);this.f?this.f.next=c:this.b=c;this.f=c};jc.prototype.remove=function(){var a=null;this.b&&(a=this.b,this.b=this.b.next,this.b||(this.f=null),a.next=null);return a};kc.prototype.set=function(a,b){this.Dc=a;this.b=b;this.next=null};kc.prototype.reset=function(){this.next=this.b=this.Dc=null};_.bc.m=function(){if(-1!=String(_.Vb.Promise).indexOf("[native code]")){var a=_.Vb.Promise.resolve(void 0);_.bc.b=function(){a.then(_.bc.f)}}else _.bc.b=function(){fc()}};_.bc.B=function(a){_.bc.b=function(){fc();a&&a(_.bc.f)}};_.bc.j=!1;_.bc.l=new jc;_.bc.f=function(){for(var a;a=_.bc.l.remove();){try{a.Dc.call(a.b)}catch(c){ac(c)}var b=Ph;b.m(a);b.f<b.l&&(b.f++,a.next=b.b,b.b=a)}_.bc.j=!1};_.t(nc,Error);var Qh,Sh;_.$c=_.wc(_.y,"not a number");Qh=_.yc(_.$c,function(a){if((0,window.isNaN)(a))throw _.oc("NaN is not an accepted value");return a});_.Rh=_.wc(_.nb,"not a string");Sh=_.wc(_.ob,"not a boolean");_.Th=_.Dc(_.$c);_.Uh=_.Dc(_.Rh);_.Vh=_.Dc(Sh);var Fc=_.rc({lat:_.$c,lng:_.$c},!0);_.F.prototype.toString=function(){return"("+this.lat()+", "+this.lng()+")"};_.F.prototype.toJSON=function(){return{lat:this.lat(),lng:this.lng()}};_.F.prototype.V=function(a){return a?_.ib(this.lat(),a.lat())&&_.ib(this.lng(),a.lng()):!1};_.F.prototype.equals=_.F.prototype.V;_.F.prototype.toUrlValue=function(a){a=_.m(a)?a:6;return Ic(this.lat(),a)+","+Ic(this.lng(),a)};_.ue=_.vc(_.Kc);_.t(_.Lc,Jc);_.Lc.prototype.getType=_.ra("Point");_.Lc.prototype.forEachLatLng=function(a){a(this.b)};_.Lc.prototype.get=_.qa("b");var se=_.vc(Mc);Sc.f=void 0;Sc.b=function(){return Sc.f?Sc.f:Sc.f=new Sc};Sc.prototype.ib=function(a,b){var c=this,d=c.m;Tc(c.j,function(e){for(var f=e.b[a]||[],g=e.l[a]||[],h=d[a]=_.Nc(f.length,function(){delete d[a];b(e.f);for(var f=c.f[a],h=f?f.length:0,l=0;l<h;++l)f[l](c.b[a]);delete c.f[a];l=0;for(f=g.length;l<f;++l)h=g[l],d[h]&&d[h]()}),l=0,n=f.length;l<n;++l)c.b[f[l]]&&h()})};_.k=_.Zc.prototype;_.k.getId=_.qa("j");_.k.getGeometry=_.qa("b");_.k.setGeometry=function(a){var b=this.b;try{this.b=a?Mc(a):null}catch(c){_.qc(c);return}_.A.trigger(this,"setgeometry",{feature:this,newGeometry:this.b,oldGeometry:b})};_.k.getProperty=function(a){return rb(this.f,a)};_.k.setProperty=function(a,b){if(void 0===b)this.removeProperty(a);else{var c=this.getProperty(a);this.f[a]=b;_.A.trigger(this,"setproperty",{feature:this,name:a,newValue:b,oldValue:c})}};
_.k.removeProperty=function(a){var b=this.getProperty(a);delete this.f[a];_.A.trigger(this,"removeproperty",{feature:this,name:a,oldValue:b})};_.k.forEachProperty=function(a){for(var b in this.f)a(this.getProperty(b),b)};_.k.toGeoJson=function(a){var b=this;_.G("data",function(c){c.f(b,a)})};var Wh={po:"Point",no:"LineString",POLYGON:"Polygon"};_.Xh=new _.K(0,0);_.K.prototype.toString=function(){return"("+this.x+", "+this.y+")"};_.K.prototype.V=function(a){return a?a.x==this.x&&a.y==this.y:!1};_.K.prototype.equals=_.K.prototype.V;_.K.prototype.round=function(){this.x=Math.round(this.x);this.y=Math.round(this.y)};_.K.prototype.Pd=_.ua(0);_.Yh=new _.L(0,0);_.L.prototype.toString=function(){return"("+this.width+", "+this.height+")"};_.L.prototype.V=function(a){return a?a.width==this.width&&a.height==this.height:!1};_.L.prototype.equals=_.L.prototype.V;var Zh={CIRCLE:0,FORWARD_CLOSED_ARROW:1,FORWARD_OPEN_ARROW:2,BACKWARD_CLOSED_ARROW:3,BACKWARD_OPEN_ARROW:4};_.k=cd.prototype;_.k.isEmpty=function(){return 360==this.b-this.f};_.k.intersects=function(a){var b=this.b,c=this.f;return this.isEmpty()||a.isEmpty()?!1:_.dd(this)?_.dd(a)||a.b<=this.f||a.f>=b:_.dd(a)?a.b<=c||a.f>=b:a.b<=c&&a.f>=b};_.k.contains=function(a){-180==a&&(a=180);var b=this.b,c=this.f;return _.dd(this)?(a>=b||a<=c)&&!this.isEmpty():a>=b&&a<=c};_.k.extend=function(a){this.contains(a)||(this.isEmpty()?this.b=this.f=a:_.ed(a,this.b)<_.ed(this.f,a)?this.b=a:this.f=a)};
_.k.V=function(a){return 1E-9>=Math.abs(a.b-this.b)%360+Math.abs(_.fd(a)-_.fd(this))};_.k.Cb=function(){var a=(this.b+this.f)/2;_.dd(this)&&(a=_.hb(a+180,-180,180));return a};_.k=gd.prototype;_.k.isEmpty=function(){return this.b>this.f};_.k.intersects=function(a){var b=this.b,c=this.f;return b<=a.b?a.b<=c&&a.b<=a.f:b<=a.f&&b<=c};_.k.contains=function(a){return a>=this.b&&a<=this.f};_.k.extend=function(a){this.isEmpty()?this.f=this.b=a:a<this.b?this.b=a:a>this.f&&(this.f=a)};
_.k.V=function(a){return this.isEmpty()?a.isEmpty():1E-9>=Math.abs(a.b-this.b)+Math.abs(this.f-a.f)};_.k.Cb=function(){return(this.f+this.b)/2};_.k=_.kd.prototype;_.k.getCenter=function(){return new _.F(this.f.Cb(),this.b.Cb())};_.k.toString=function(){return"("+this.getSouthWest()+", "+this.getNorthEast()+")"};_.k.toJSON=function(){return{south:this.f.b,west:this.b.b,north:this.f.f,east:this.b.f}};_.k.toUrlValue=function(a){var b=this.getSouthWest(),c=this.getNorthEast();return[b.toUrlValue(a),c.toUrlValue(a)].join()};_.k.V=function(a){if(!a)return!1;a=_.nd(a);return this.f.V(a.f)&&this.b.V(a.b)};_.kd.prototype.equals=_.kd.prototype.V;
_.k=_.kd.prototype;_.k.contains=function(a){a=_.Kc(a);return this.f.contains(a.lat())&&this.b.contains(a.lng())};_.k.intersects=function(a){a=_.nd(a);return this.f.intersects(a.f)&&this.b.intersects(a.b)};_.k.extend=function(a){a=_.Kc(a);this.f.extend(a.lat());this.b.extend(a.lng());return this};_.k.union=function(a){a=_.nd(a);if(!a||a.isEmpty())return this;this.extend(a.getSouthWest());this.extend(a.getNorthEast());return this};_.k.getSouthWest=function(){return new _.F(this.f.b,this.b.b,!0)};
_.k.getNorthEast=function(){return new _.F(this.f.f,this.b.f,!0)};_.k.toSpan=function(){return new _.F(_.jd(this.f),_.fd(this.b),!0)};_.k.isEmpty=function(){return this.f.isEmpty()||this.b.isEmpty()};var md=_.rc({south:_.$c,west:_.$c,north:_.$c,east:_.$c},!1);_.od.prototype.heading=_.qa("f");_.od.prototype.b=_.qa("j");_.od.prototype.toString=function(){return this.f+","+this.j};_.$h=new _.od;_.t(_.td,_.D);_.k=_.td.prototype;_.k.getAt=function(a){return this.b[a]};_.k.indexOf=function(a){for(var b=0,c=this.b.length;b<c;++b)if(a===this.b[b])return b;return-1};_.k.forEach=function(a){for(var b=0,c=this.b.length;b<c;++b)a(this.b[b],b)};_.k.setAt=function(a,b){var c=this.b[a],d=this.b.length;if(a<d)this.b[a]=b,_.A.trigger(this,"set_at",a,c),this.l&&this.l(a,c);else{for(c=d;c<a;++c)this.insertAt(c,void 0);this.insertAt(a,b)}};
_.k.insertAt=function(a,b){this.b.splice(a,0,b);sd(this);_.A.trigger(this,"insert_at",a);this.f&&this.f(a)};_.k.removeAt=function(a){var b=this.b[a];this.b.splice(a,1);sd(this);_.A.trigger(this,"remove_at",a,b);this.j&&this.j(a,b);return b};_.k.push=function(a){this.insertAt(this.b.length,a);return this.b.length};_.k.pop=function(){return this.removeAt(this.b.length-1)};_.k.getArray=_.qa("b");_.k.clear=function(){for(;this.get("length");)this.pop()};_.rd(_.td.prototype,{length:null});_.ud.prototype.remove=function(a){var b=this.f,c=this.j(a);b[c]&&(delete b[c],_.A.trigger(this,"remove",a),this.onRemove&&this.onRemove(a))};_.ud.prototype.contains=function(a){return!!this.f[this.j(a)]};_.ud.prototype.forEach=function(a){var b=this.f,c;for(c in b)a.call(this,b[c])};_.yd.prototype.Xa=_.ua(1);_.yd.prototype.forEach=function(a,b){_.v(this.b,function(c,d){a.call(b,c,d)})};zd.prototype.V=function(a){return a?this.b==a.b&&this.f==a.f:!1};Ad.prototype.V=function(a){return a?this.m11==a.m11&&this.m12==a.m12&&this.m21==a.m21&&this.m22==a.m22:!1};_.Cd.prototype.isEmpty=function(){return!(this.I<this.K&&this.J<this.L)};_.Cd.prototype.extend=function(a){a&&(this.I=Math.min(this.I,a.x),this.K=Math.max(this.K,a.x),this.J=Math.min(this.J,a.y),this.L=Math.max(this.L,a.y))};_.Cd.prototype.getCenter=function(){return new _.K((this.I+this.K)/2,(this.J+this.L)/2)};_.Cd.prototype.V=function(a){return a?this.I==a.I&&this.J==a.J&&this.K==a.K&&this.L==a.L:!1};_.ai=_.Dd(-window.Infinity,-window.Infinity,window.Infinity,window.Infinity);_.bi=_.Dd(0,0,0,0);var ci=_.rc({zoom:_.Dc(Qh),heading:Qh,pitch:Qh});_.t(_.Fd,_.D);Gd.prototype.addListener=function(a,b,c){c=c?{qg:!1}:null;var d=!this.P.length;var e=this.P;var f=$a(e,Jd(a,b));(e=0>f?null:_.Fa(e)?e.charAt(f):e[f])?e.once=e.once&&c:this.P.push({Dc:a,context:b||null,once:c});d&&this.f();return a};Gd.prototype.addListenerOnce=function(a,b){this.addListener(a,b,!0);return a};Gd.prototype.removeListener=function(a,b){if(this.P.length){var c=this.P;a=$a(c,Jd(a,b));0<=a&&_.ab(c,a);this.P.length||this.b()}};var Hd=_.bc;_.k=_.Kd.prototype;_.k.md=_.oa();_.k.ld=_.oa();_.k.addListener=function(a,b){return this.P.addListener(a,b)};_.k.addListenerOnce=function(a,b){return this.P.addListenerOnce(a,b)};_.k.removeListener=function(a,b){return this.P.removeListener(a,b)};_.k.notify=function(a){_.Id(this.P,function(a){a(this.get())},this,a)};_.t(_.Ld,_.Kd);_.Ld.prototype.set=function(a){this.m&&this.get()===a||(this.Nh(a),this.notify())};_.t(Md,_.Ld);Md.prototype.get=_.qa("b");Md.prototype.Nh=_.pa("b");_.t(Od,_.D);_.di=_.Yd("d",void 0);_.ei=_.Yd("f",void 0);_.S=_.$d();_.fi=_.Zd("i",void 0);_.gi=new _.Wd("i",3,void 0,void 0);_.hi=new _.Wd("j",3,"",void 0);_.ii=_.Yd("u",void 0);_.ji=_.Zd("u",void 0);_.ki=new _.Wd("u",3,void 0,void 0);_.li=_.ae();_.T=_.be();_.U=_.ce();_.mi=new _.Wd("e",3,void 0,void 0);_.V=_.Yd("s",void 0);_.ni=_.Zd("s",void 0);_.oi=new _.Wd("s",3,void 0,void 0);_.pi=_.Yd("B",void 0);_.qi=_.Yd("x",void 0);_.ri=_.Zd("x",void 0);_.si=new _.Wd("x",3,void 0,void 0);_.ti=new _.Wd("y",3,void 0,void 0);var vi;_.ui=new de;vi=/'/g;de.prototype.b=function(a,b){var c=[];fe(a,b,c);return c.join("&").replace(vi,"%27")};_.N.prototype.V=function(a){return _.Vd(this.data,a?a.data:null)};_.N.prototype.$h=_.ua(2);_.t(ke,_.D);ke.prototype.set=function(a,b){if(null!=b&&!(b&&_.y(b.maxZoom)&&b.tileSize&&b.tileSize.width&&b.tileSize.height&&b.getTile&&b.getTile.apply))throw Error("Expected value implementing google.maps.MapType");return _.D.prototype.set.apply(this,arguments)};_.t(_.le,_.D);_.k=me.prototype;_.k.contains=function(a){return this.b.hasOwnProperty(_.Gb(a))};_.k.getFeatureById=function(a){return rb(this.f,a)};
_.k.add=function(a){a=a||{};a=a instanceof _.Zc?a:new _.Zc(a);if(!this.contains(a)){var b=a.getId();if(b){var c=this.getFeatureById(b);c&&this.remove(c)}c=_.Gb(a);this.b[c]=a;b&&(this.f[b]=a);var d=_.A.forward(a,"setgeometry",this),e=_.A.forward(a,"setproperty",this),f=_.A.forward(a,"removeproperty",this);this.j[c]=function(){_.A.removeListener(d);_.A.removeListener(e);_.A.removeListener(f)};_.A.trigger(this,"addfeature",{feature:a})}return a};
_.k.remove=function(a){var b=_.Gb(a),c=a.getId();if(this.b[b]){delete this.b[b];c&&delete this.f[c];if(c=this.j[b])delete this.j[b],c();_.A.trigger(this,"removefeature",{feature:a})}};_.k.forEach=function(a){for(var b in this.b)a(this.b[b])};_.Fe="click dblclick mousedown mousemove mouseout mouseover mouseup rightclick".split(" ");ne.prototype.get=function(a){return this.b[a]};ne.prototype.set=function(a,b){var c=this.b;c[a]||(c[a]={});_.eb(c[a],b);_.A.trigger(this,"changed",a)};ne.prototype.reset=function(a){delete this.b[a];_.A.trigger(this,"changed",a)};ne.prototype.forEach=function(a){_.db(this.b,a)};_.t(re,_.D);re.prototype.overrideStyle=function(a,b){this.b.set(_.Gb(a),b)};re.prototype.revertStyle=function(a){a?this.b.reset(_.Gb(a)):this.b.forEach((0,_.p)(this.b.reset,this.b))};_.t(_.te,Jc);_.k=_.te.prototype;_.k.getType=_.ra("GeometryCollection");_.k.getLength=function(){return this.b.length};_.k.getAt=function(a){return this.b[a]};_.k.getArray=function(){return this.b.slice()};_.k.forEachLatLng=function(a){this.b.forEach(function(b){b.forEachLatLng(a)})};_.t(_.ve,Jc);_.k=_.ve.prototype;_.k.getType=_.ra("LineString");_.k.getLength=function(){return this.b.length};_.k.getAt=function(a){return this.b[a]};_.k.getArray=function(){return this.b.slice()};_.k.forEachLatLng=function(a){this.b.forEach(a)};var xe=_.vc(_.tc(_.ve,"google.maps.Data.LineString",!0));_.t(_.we,Jc);_.k=_.we.prototype;_.k.getType=_.ra("LinearRing");_.k.getLength=function(){return this.b.length};_.k.getAt=function(a){return this.b[a]};_.k.getArray=function(){return this.b.slice()};_.k.forEachLatLng=function(a){this.b.forEach(a)};var Ae=_.vc(_.tc(_.we,"google.maps.Data.LinearRing",!0));_.t(_.ye,Jc);_.k=_.ye.prototype;_.k.getType=_.ra("MultiLineString");_.k.getLength=function(){return this.b.length};_.k.getAt=function(a){return this.b[a]};_.k.getArray=function(){return this.b.slice()};_.k.forEachLatLng=function(a){this.b.forEach(function(b){b.forEachLatLng(a)})};_.t(_.ze,Jc);_.k=_.ze.prototype;_.k.getType=_.ra("MultiPoint");_.k.getLength=function(){return this.b.length};_.k.getAt=function(a){return this.b[a]};_.k.getArray=function(){return this.b.slice()};_.k.forEachLatLng=function(a){this.b.forEach(a)};_.t(_.Be,Jc);_.k=_.Be.prototype;_.k.getType=_.ra("Polygon");_.k.getLength=function(){return this.b.length};_.k.getAt=function(a){return this.b[a]};_.k.getArray=function(){return this.b.slice()};_.k.forEachLatLng=function(a){this.b.forEach(function(b){b.forEachLatLng(a)})};var Ce=_.vc(_.tc(_.Be,"google.maps.Data.Polygon",!0));_.t(_.De,Jc);_.k=_.De.prototype;_.k.getType=_.ra("MultiPolygon");_.k.getLength=function(){return this.b.length};_.k.getAt=function(a){return this.b[a]};_.k.getArray=function(){return this.b.slice()};_.k.forEachLatLng=function(a){this.b.forEach(function(b){b.forEachLatLng(a)})};_.wi=_.Dc(_.tc(_.le,"Map"));_.t(Ge,_.D);_.k=Ge.prototype;_.k.contains=function(a){return this.b.contains(a)};_.k.getFeatureById=function(a){return this.b.getFeatureById(a)};_.k.add=function(a){return this.b.add(a)};_.k.remove=function(a){this.b.remove(a)};_.k.forEach=function(a){this.b.forEach(a)};_.k.addGeoJson=function(a,b){return _.Ee(this.b,a,b)};_.k.loadGeoJson=function(a,b,c){var d=this.b;_.G("data",function(e){e.Kk(d,a,b,c)})};_.k.toGeoJson=function(a){var b=this.b;_.G("data",function(c){c.Gk(b,a)})};
_.k.overrideStyle=function(a,b){this.f.overrideStyle(a,b)};_.k.revertStyle=function(a){this.f.revertStyle(a)};_.k.controls_changed=function(){this.get("controls")&&He(this)};_.k.drawingMode_changed=function(){this.get("drawingMode")&&He(this)};_.rd(Ge.prototype,{map:_.wi,style:_.$b,controls:_.Dc(_.vc(_.uc(Wh))),controlPosition:_.Dc(_.uc(_.Vf)),drawingMode:_.Dc(_.uc(Wh))});_.xi={METRIC:0,IMPERIAL:1};_.yi={DRIVING:"DRIVING",WALKING:"WALKING",BICYCLING:"BICYCLING",TRANSIT:"TRANSIT"};_.zi={BEST_GUESS:"bestguess",OPTIMISTIC:"optimistic",PESSIMISTIC:"pessimistic"};_.Ii={BUS:"BUS",RAIL:"RAIL",SUBWAY:"SUBWAY",TRAIN:"TRAIN",TRAM:"TRAM"};_.Ji={LESS_WALKING:"LESS_WALKING",FEWER_TRANSFERS:"FEWER_TRANSFERS"};var Ki=_.rc({routes:_.vc(_.wc(_.mb))},!0);var Vc={main:[],common:["main"],util:["common"],adsense:["main"],controls:["util"],data:["util"],directions:["util","geometry"],distance_matrix:["util"],drawing:["main"],drawing_impl:["controls"],elevation:["util","geometry"],geocoder:["util"],geojson:["main"],imagery_viewer:["main"],geometry:["main"],infowindow:["util"],kml:["onion","util","map"],layers:["map"],map:["common"],marker:["util"],maxzoom:["util"],onion:["util","map"],overlay:["common"],panoramio:["main"],places:["main"],places_impl:["controls"],
poly:["util","map","geometry"],search:["main"],search_impl:["onion"],stats:["util"],streetview:["util","geometry"],usage:["util"],visualization:["main"],visualization_impl:["onion"],weather:["main"],zombie:["main"]};var Li=_.Vb.google.maps,Mi=Sc.b(),Ni=(0,_.p)(Mi.ib,Mi);Li.__gjsload__=Ni;_.db(Li.modules,Ni);delete Li.modules;var Oi=_.rc({source:_.Rh,webUrl:_.Uh,iosDeepLinkId:_.Uh});var Pi=_.yc(_.rc({placeId:_.Uh,query:_.Uh,location:_.Kc}),function(a){if(a.placeId&&a.query)throw _.oc("cannot set both placeId and query");if(!a.placeId&&!a.query)throw _.oc("must set one of placeId or query");return a});_.t(Le,_.D);
_.rd(Le.prototype,{position:_.Dc(_.Kc),title:_.Uh,icon:_.Dc(_.xc([_.Rh,{Of:Ec("url"),then:_.rc({url:_.Rh,scaledSize:_.Dc(bd),size:_.Dc(bd),origin:_.Dc(ad),anchor:_.Dc(ad),labelOrigin:_.Dc(ad),path:_.wc(function(a){return null==a})},!0)},{Of:Ec("path"),then:_.rc({path:_.xc([_.Rh,_.uc(Zh)]),anchor:_.Dc(ad),labelOrigin:_.Dc(ad),fillColor:_.Uh,fillOpacity:_.Th,rotation:_.Th,scale:_.Th,strokeColor:_.Uh,strokeOpacity:_.Th,strokeWeight:_.Th,url:_.wc(function(a){return null==a})},!0)}])),label:_.Dc(_.xc([_.Rh,{Of:Ec("text"),
then:_.rc({text:_.Rh,fontSize:_.Uh,fontWeight:_.Uh,fontFamily:_.Uh},!0)}])),shadow:_.$b,shape:_.$b,cursor:_.Uh,clickable:_.Vh,animation:_.$b,draggable:_.Vh,visible:_.Vh,flat:_.$b,zIndex:_.Th,opacity:_.Th,place:_.Dc(Pi),attribution:_.Dc(Oi)});var Qi=_.Dc(_.tc(_.Fd,"StreetViewPanorama"));_.t(_.Me,Le);_.Me.prototype.map_changed=function(){this.__gm.set&&this.__gm.set.remove(this);var a=this.get("map");this.__gm.set=a&&a.__gm.ea;this.__gm.set&&_.vd(this.__gm.set,this)};_.Me.MAX_ZINDEX=1E6;_.rd(_.Me.prototype,{map:_.xc([_.wi,Qi])});_.t(Ne,_.D);_.k=Ne.prototype;_.k.internalAnchor_changed=function(){var a=this.get("internalAnchor");Oe(this,"attribution",a);Oe(this,"place",a);Oe(this,"internalAnchorMap",a,"map");Oe(this,"internalAnchorPoint",a,"anchorPoint");a instanceof _.Me?Oe(this,"internalAnchorPosition",a,"internalPosition"):Oe(this,"internalAnchorPosition",a,"position")};
_.k.internalAnchorPoint_changed=Ne.prototype.internalPixelOffset_changed=function(){var a=this.get("internalAnchorPoint")||_.Xh,b=this.get("internalPixelOffset")||_.Yh;this.set("pixelOffset",new _.L(b.width+Math.round(a.x),b.height+Math.round(a.y)))};_.k.internalAnchorPosition_changed=function(){var a=this.get("internalAnchorPosition");a&&this.set("position",a)};_.k.internalAnchorMap_changed=function(){this.get("internalAnchor")&&this.b.set("map",this.get("internalAnchorMap"))};
_.k.lm=function(){var a=this.get("internalAnchor");!this.b.get("map")&&a&&a.get("map")&&this.set("internalAnchor",null)};_.k.internalContent_changed=function(){this.set("content",Ie(this.get("internalContent")))};_.k.trigger=function(a){_.A.trigger(this.b,a)};_.k.close=function(){this.b.set("map",null)};_.t(_.Pe,_.D);_.rd(_.Pe.prototype,{content:_.xc([_.Uh,_.wc(sc)]),position:_.Dc(_.Kc),size:_.Dc(bd),map:_.xc([_.wi,Qi]),anchor:_.Dc(_.tc(_.D,"MVCObject")),zIndex:_.Th});_.Pe.prototype.open=function(a,b){this.set("anchor",b);b?!this.get("map")&&a&&this.set("map",a):this.set("map",a)};_.Pe.prototype.close=function(){this.set("map",null)};_.Qe=[];_.t(Se,_.D);Se.prototype.changed=function(a){if("map"==a||"panel"==a){var b=this;_.G("directions",function(c){c.pl(b,a)})}"panel"==a&&_.Re(this.getPanel())};_.rd(Se.prototype,{directions:Ki,map:_.wi,panel:_.Dc(_.wc(sc)),routeIndex:_.Th});Te.prototype.route=function(a,b){_.G("directions",function(c){c.Lh(a,b,!0)})};Ue.prototype.getDistanceMatrix=function(a,b){_.G("distance_matrix",function(c){c.b(a,b)})};Ve.prototype.getElevationAlongPath=function(a,b){_.G("elevation",function(c){c.getElevationAlongPath(a,b)})};Ve.prototype.getElevationForLocations=function(a,b){_.G("elevation",function(c){c.getElevationForLocations(a,b)})};_.Ri=_.tc(_.kd,"LatLngBounds");_.We.prototype.geocode=function(a,b){_.G("geocoder",function(c){c.geocode(a,b)})};_.t(_.Ze,_.D);_.Ze.prototype.map_changed=function(){var a=this;_.G("kml",function(b){b.b(a)})};_.rd(_.Ze.prototype,{map:_.wi,url:null,bounds:null,opacity:_.Th});_.Ti={UNKNOWN:"UNKNOWN",OK:_.ia,INVALID_REQUEST:_.ba,DOCUMENT_NOT_FOUND:"DOCUMENT_NOT_FOUND",FETCH_ERROR:"FETCH_ERROR",INVALID_DOCUMENT:"INVALID_DOCUMENT",DOCUMENT_TOO_LARGE:"DOCUMENT_TOO_LARGE",LIMITS_EXCEEDED:"LIMITS_EXECEEDED",TIMED_OUT:"TIMED_OUT"};_.t($e,_.D);_.k=$e.prototype;_.k.xd=function(){var a=this;_.G("kml",function(b){b.f(a)})};_.k.url_changed=$e.prototype.xd;_.k.driveFileId_changed=$e.prototype.xd;_.k.map_changed=$e.prototype.xd;_.k.zIndex_changed=$e.prototype.xd;_.rd($e.prototype,{map:_.wi,defaultViewport:null,metadata:null,status:null,url:_.Uh,screenOverlays:_.Vh,zIndex:_.Th});_.t(_.af,_.D);_.rd(_.af.prototype,{map:_.wi});_.t(bf,_.D);_.rd(bf.prototype,{map:_.wi});_.t(cf,_.D);_.rd(cf.prototype,{map:_.wi});!_.qh&&!_.oh||_.oh&&9<=Number(_.Dh)||_.qh&&_.Yb("1.9.1");_.oh&&_.Yb("9");_.df.prototype.df=!0;_.df.prototype.Eb=_.ua(4);_.df.prototype.bh=!0;_.df.prototype.Jd=_.ua(6);_.ef("about:blank");_.gf.prototype.bh=!0;_.gf.prototype.Jd=_.ua(5);_.gf.prototype.df=!0;_.gf.prototype.Eb=_.ua(3);_.ff={};_.hf("<!DOCTYPE html>",0);_.hf("",0);_.hf("<br>",0);_.qg="StopIteration"in _.Vb?_.Vb.StopIteration:{message:"StopIteration",stack:""};_.lf.prototype.next=function(){throw _.qg;};_.lf.prototype.Fe=function(){return this};_.t(mf,_.lf);mf.prototype.setPosition=function(a,b,c){if(this.node=a)this.f=_.Ga(b)?b:1!=this.node.nodeType?0:this.b?-1:1;_.Ga(c)&&(this.depth=c)};
mf.prototype.next=function(){if(this.j){if(!this.node||this.l&&0==this.depth)throw _.qg;var a=this.node;var b=this.b?-1:1;if(this.f==b){var c=this.b?a.lastChild:a.firstChild;c?this.setPosition(c):this.setPosition(a,-1*b)}else(c=this.b?a.previousSibling:a.nextSibling)?this.setPosition(c):this.setPosition(a.parentNode,-1*b);this.depth+=this.f*(this.b?-1:1)}else this.j=!0;a=this.node;if(!this.node)throw _.qg;return a};mf.prototype.V=function(a){return a.node==this.node&&(!this.node||a.f==this.f)};
mf.prototype.splice=function(a){var b=this.node,c=this.b?1:-1;this.f==c&&(this.f=-1*c,this.depth+=this.f*(this.b?-1:1));this.b=!this.b;mf.prototype.next.call(this);this.b=!this.b;for(var c=_.Ka(arguments[0])?arguments[0]:arguments,d=c.length-1;0<=d;d--)_.jf(c[d],b);_.kf(b)};_.t(nf,mf);nf.prototype.next=function(){do nf.nb.next.call(this);while(-1==this.f);return this.node};var Ui;_.t(of,_.N);var Vi;_.t(pf,_.N);var Wi;_.t(qf,_.N);var Xi;_.t(rf,_.N);_.t(sf,_.N);_.t(_.tf,_.N);_.t(uf,_.N);_.t(vf,_.N);_.t(wf,_.N);_.rg={};var Hf;_.Rf.prototype.fromLatLngToPoint=function(a,b){b=b||new _.K(0,0);var c=this.b;b.x=c.x+a.lng()*this.j;a=_.gb(Math.sin(_.lc(a.lat())),-(1-1E-15),1-1E-15);b.y=c.y+.5*Math.log((1+a)/(1-a))*-this.l;return b};_.Rf.prototype.fromPointToLatLng=function(a,b){var c=this.b;return new _.F(_.mc(2*Math.atan(Math.exp((a.y-c.y)/-this.l))-Math.PI/2),(a.x-c.x)/this.j,b)};_.Uf={japan_prequake:20,japan_postquake2010:24};_.Zi={NEAREST:"nearest",BEST:"best"};_.$i={DEFAULT:"default",OUTDOOR:"outdoor"};_.t(Wf,_.Fd);Wf.prototype.visible_changed=function(){var a=this;!a.m&&a.getVisible()&&(a.m=!0,_.G("streetview",function(b){if(a.f)var c=a.f;b.Dm(a,c)}))};_.rd(Wf.prototype,{visible:_.Vh,pano:_.Uh,position:_.Dc(_.Kc),pov:_.Dc(ci),motionTracking:Sh,photographerPov:null,location:null,links:_.vc(_.wc(_.mb)),status:null,zoom:_.Th,enableCloseButton:_.Vh});Wf.prototype.registerPanoProvider=function(a,b){this.set("panoProvider",{Ch:a,options:b||{}})};_.t(Yf,Od);_.Zf.prototype.addListener=function(a,b){this.P.addListener(a,b)};_.Zf.prototype.addListenerOnce=function(a,b){this.P.addListenerOnce(a,b)};_.Zf.prototype.removeListener=function(a,b){this.P.removeListener(a,b)};_.Zf.prototype.b=_.ua(7);_.aj=new _.$f(0,0);_.t(_.ag,_.D);_.ag.prototype.N=function(){var a=this;a.D||(a.D=_.Vb.setTimeout(function(){a.D=void 0;a.aa()},a.ri))};_.ag.prototype.C=function(){this.D&&_.Vb.clearTimeout(this.D);this.D=void 0;this.aa()};var bj;_.t(dg,_.N);var cj;_.t(eg,_.N);var dj;_.t(fg,_.N);var ej;_.t(gg,_.N);var fj;_.t(hg,_.N);hg.prototype.getZoom=function(){return _.O(this,2)};hg.prototype.setZoom=function(a){this.data[2]=a};_.t(ig,_.ag);var jg={roadmap:0,satellite:2,hybrid:3,terrain:4},gj={0:1,2:2,3:2,4:2};_.k=ig.prototype;_.k.Ng=_.pd("center");_.k.cg=_.pd("zoom");_.k.changed=function(){var a=this.Ng(),b=this.cg(),c=kg(this);if(a&&!a.V(this.T)||this.S!=b||this.Z!=c)this.j||lg(this.b),this.N(),this.S=b,this.Z=c;this.T=a};
_.k.aa=function(){var a=kg(this);if(this.j&&this.m)this.l!=a&&lg(this.b);else{var b="",c=this.Ng(),d=this.cg(),e=this.get("size");if(e){if(c&&(0,window.isFinite)(c.lat())&&(0,window.isFinite)(c.lng())&&1<d&&null!=a&&e&&e.width&&e.height&&this.f){_.bg(this.f,e);if(c=_.Sf(this.F,c,d)){var f=new _.Cd;f.I=Math.round(c.x-e.width/2);f.K=f.I+e.width;f.J=Math.round(c.y-e.height/2);f.L=f.J+e.height}else f=null;c=gj[a];if(f){this.m=!0;this.l=a;this.j&&this.b&&(b=new Ad(Math.pow(2,d),0,0),this.j.set({Ua:this.b,
Ba:{min:Bd(b,{ab:f.I,cb:f.J}),max:Bd(b,{ab:f.K,cb:f.L})},size:{width:e.width,height:e.height}}));var b=new hg,g=new fg(_.Q(b,0));g.data[0]=f.I;g.data[1]=f.J;b.data[1]=c;b.setZoom(d);d=new gg(_.Q(b,3));d.data[0]=f.K-f.I;d.data[1]=f.L-f.J;d=new eg(_.Q(b,4));d.data[0]=a;d.data[4]=_.xf(_.Af(_.R));d.data[5]=_.yf(_.Af(_.R)).toLowerCase();d.data[9]=!0;d.data[11]=!0;a=this.O+(0,window.unescape)("%3F");if(!fj){d=fj={b:-1,A:[]};c=new fg([]);dj||(dj={b:-1,A:[,_.S,_.S]});c=_.M(c,dj);f=new gg([]);ej||(ej={b:-1,
A:[]},ej.A=[,_.ii,_.ii,_.ce(1)]);f=_.M(f,ej);g=new eg([]);if(!cj){var h=[];cj={b:-1,A:h};h[1]=_.U;h[2]=_.T;h[3]=_.T;h[5]=_.V;h[6]=_.V;var l=new dg([]);bj||(bj={b:-1,A:[,_.mi,_.T]});h[9]=_.M(l,bj);h[10]=_.T;h[11]=_.T;h[12]=_.T;h[13]=_.mi;h[100]=_.T}g=_.M(g,cj);h=new of([]);if(!Ui){var l=Ui={b:-1,A:[]},n=new pf([]);Vi||(Vi={b:-1,A:[,_.T]});var n=_.M(n,Vi),q=new rf([]);Xi||(Xi={b:-1,A:[,_.T,_.T]});var q=_.M(q,Xi),r=new qf([]);Wi||(Wi={b:-1,A:[,_.T]});l.A=[,n,,,,,,,,,q,,_.M(r,Wi)]}d.A=[,c,_.U,_.ii,f,
g,_.M(h,Ui)]}b=_.ui.b(b.data,fj);b=this.G(a+b)}}this.b&&(_.bg(this.b,e),ng(this,b))}}};
_.k.div_changed=function(){var a=this.get("div"),b=this.f;if(a)if(b)a.appendChild(b);else{b=this.f=window.document.createElement("div");b.style.overflow="hidden";var c=this.b=window.document.createElement("img");_.A.addDomListener(b,"contextmenu",function(a){_.ub(a);_.wb(a)});c.ontouchstart=c.ontouchmove=c.ontouchend=c.ontouchcancel=function(a){_.vb(a);_.wb(a)};_.bg(c,_.Yh);a.appendChild(b);this.aa()}else b&&(lg(b),this.f=null)};_.t(ug,_.le);_.k=ug.prototype;_.k.streetView_changed=function(){var a=this.get("streetView");a?a.set("standAlone",!1):this.set("streetView",this.__gm.j)};_.k.getDiv=function(){return this.__gm.R};_.k.panBy=function(a,b){var c=this.__gm;_.G("map",function(){_.A.trigger(c,"panby",a,b)})};_.k.panTo=function(a){var b=this.__gm;a=_.Kc(a);_.G("map",function(){_.A.trigger(b,"panto",a)})};_.k.panToBounds=function(a){var b=this.__gm,c=_.nd(a);_.G("map",function(){_.A.trigger(b,"pantolatlngbounds",c)})};
_.k.fitBounds=function(a,b){var c=this;a=_.nd(a);_.G("map",function(d){d.fitBounds(c,a,b)})};_.rd(ug.prototype,{bounds:null,streetView:Qi,center:_.Dc(_.Kc),zoom:_.Th,mapTypeId:_.Uh,projection:null,heading:_.Th,tilt:_.Th,clickableIcons:Sh});vg.prototype.getMaxZoomAtLatLng=function(a,b){_.G("maxzoom",function(c){c.getMaxZoomAtLatLng(a,b)})};_.t(wg,_.D);wg.prototype.changed=function(a){if("suppressInfoWindows"!=a&&"clickable"!=a){var b=this;_.G("onion",function(a){a.b(b)})}};_.rd(wg.prototype,{map:_.wi,tableId:_.Th,query:_.Dc(_.xc([_.Rh,_.wc(_.mb,"not an Object")]))});_.t(_.xg,_.D);_.xg.prototype.map_changed=function(){var a=this;_.G("overlay",function(b){b.Uj(a)})};_.rd(_.xg.prototype,{panes:null,projection:null,map:_.xc([_.wi,Qi])});var Ag=Cg(_.tc(_.F,"LatLng"));_.t(_.Eg,_.D);_.Eg.prototype.map_changed=_.Eg.prototype.visible_changed=function(){var a=this;_.G("poly",function(b){b.b(a)})};_.Eg.prototype.center_changed=function(){_.A.trigger(this,"bounds_changed")};_.Eg.prototype.radius_changed=_.Eg.prototype.center_changed;_.Eg.prototype.getBounds=function(){var a=this.get("radius"),b=this.get("center");if(b&&_.y(a)){var c=this.get("map"),c=c&&c.__gm.get("baseMapType");return _.Tf(b,a/_.zg(c))}return null};
_.rd(_.Eg.prototype,{center:_.Dc(_.Kc),draggable:_.Vh,editable:_.Vh,map:_.wi,radius:_.Th,visible:_.Vh});_.t(Fg,_.D);Fg.prototype.map_changed=Fg.prototype.visible_changed=function(){var a=this;_.G("poly",function(b){b.f(a)})};Fg.prototype.getPath=function(){return this.get("latLngs").getAt(0)};Fg.prototype.setPath=function(a){try{this.get("latLngs").setAt(0,Bg(a))}catch(b){_.qc(b)}};_.rd(Fg.prototype,{draggable:_.Vh,editable:_.Vh,map:_.wi,visible:_.Vh});_.t(_.Gg,Fg);_.Gg.prototype.Ea=!0;_.Gg.prototype.getPaths=function(){return this.get("latLngs")};_.Gg.prototype.setPaths=function(a){this.set("latLngs",Dg(a))};_.t(_.Hg,Fg);_.Hg.prototype.Ea=!1;_.t(_.Ig,_.D);_.Ig.prototype.map_changed=_.Ig.prototype.visible_changed=function(){var a=this;_.G("poly",function(b){b.j(a)})};_.rd(_.Ig.prototype,{draggable:_.Vh,editable:_.Vh,bounds:_.Dc(_.nd),map:_.wi,visible:_.Vh});_.t(Ng,_.D);Ng.prototype.map_changed=function(){var a=this;_.G("streetview",function(b){b.Tj(a)})};_.rd(Ng.prototype,{map:_.wi});_.Og.prototype.getPanorama=function(a,b){var c=this.b||void 0;_.G("streetview",function(d){_.G("geometry",function(e){d.Qk(a,b,e.computeHeading,e.computeOffset,c)})})};_.Og.prototype.getPanoramaByLocation=function(a,b,c){this.getPanorama({location:a,radius:b,preference:50>(b||0)?"best":"nearest"},c)};_.Og.prototype.getPanoramaById=function(a,b){this.getPanorama({pano:a},b)};_.t(_.Pg,_.D);_.k=_.Pg.prototype;_.k.getTile=function(a,b,c){if(!a||!c)return null;var d=c.createElement("div");c={Y:a,zoom:b,Pb:null};d.__gmimt=c;_.vd(this.b,d);var e=Rg(this);1!=e&&Qg(d,e);if(this.f){var e=this.tileSize||new _.L(256,256),f=this.j(a,b);c.Pb=this.f({ca:a.x,ba:a.y,fa:b},e,d,f,function(){_.A.trigger(d,"load")})}return d};_.k.releaseTile=function(a){a&&this.b.contains(a)&&(this.b.remove(a),(a=a.__gmimt.Pb)&&a.release())};_.k.Ue=_.ua(8);
_.k.opacity_changed=function(){var a=Rg(this);this.b.forEach(function(b){return Qg(b,a)})};_.k.Rb=!0;_.rd(_.Pg.prototype,{opacity:_.Th});_.t(_.Sg,_.D);_.Sg.prototype.getTile=Oh;_.Sg.prototype.tileSize=new _.L(256,256);_.Sg.prototype.Rb=!0;_.t(_.Tg,_.Sg);_.t(_.Ug,_.D);_.rd(_.Ug.prototype,{attribution:_.Dc(Oi),place:_.Dc(Pi)});var hj={Animation:{BOUNCE:1,DROP:2,qo:3,oo:4},Circle:_.Eg,ControlPosition:_.Vf,Data:Ge,GroundOverlay:_.Ze,ImageMapType:_.Pg,InfoWindow:_.Pe,LatLng:_.F,LatLngBounds:_.kd,MVCArray:_.td,MVCObject:_.D,Map:ug,MapTypeControlStyle:{DEFAULT:0,HORIZONTAL_BAR:1,DROPDOWN_MENU:2,INSET:3,INSET_LARGE:4},MapTypeId:_.kh,MapTypeRegistry:ke,Marker:_.Me,MarkerImage:function(a,b,c,d,e){this.url=a;this.size=b||e;this.origin=c;this.anchor=d;this.scaledSize=e;this.labelOrigin=null},NavigationControlStyle:{DEFAULT:0,SMALL:1,
ANDROID:2,ZOOM_PAN:3,ro:4,Ej:5},OverlayView:_.xg,Point:_.K,Polygon:_.Gg,Polyline:_.Hg,Rectangle:_.Ig,ScaleControlStyle:{DEFAULT:0},Size:_.L,StreetViewPreference:_.Zi,StreetViewSource:_.$i,StrokePosition:{CENTER:0,INSIDE:1,OUTSIDE:2},SymbolPath:Zh,ZoomControlStyle:{DEFAULT:0,SMALL:1,LARGE:2,Ej:3},event:_.A};
_.eb(hj,{BicyclingLayer:_.af,DirectionsRenderer:Se,DirectionsService:Te,DirectionsStatus:{OK:_.ia,UNKNOWN_ERROR:_.la,OVER_QUERY_LIMIT:_.ja,REQUEST_DENIED:_.ka,INVALID_REQUEST:_.ba,ZERO_RESULTS:_.ma,MAX_WAYPOINTS_EXCEEDED:_.ea,NOT_FOUND:_.ha},DirectionsTravelMode:_.yi,DirectionsUnitSystem:_.xi,DistanceMatrixService:Ue,DistanceMatrixStatus:{OK:_.ia,INVALID_REQUEST:_.ba,OVER_QUERY_LIMIT:_.ja,REQUEST_DENIED:_.ka,UNKNOWN_ERROR:_.la,MAX_ELEMENTS_EXCEEDED:_.da,MAX_DIMENSIONS_EXCEEDED:_.ca},DistanceMatrixElementStatus:{OK:_.ia,
NOT_FOUND:_.ha,ZERO_RESULTS:_.ma},ElevationService:Ve,ElevationStatus:{OK:_.ia,UNKNOWN_ERROR:_.la,OVER_QUERY_LIMIT:_.ja,REQUEST_DENIED:_.ka,INVALID_REQUEST:_.ba,lo:"DATA_NOT_AVAILABLE"},FusionTablesLayer:wg,Geocoder:_.We,GeocoderLocationType:{ROOFTOP:"ROOFTOP",RANGE_INTERPOLATED:"RANGE_INTERPOLATED",GEOMETRIC_CENTER:"GEOMETRIC_CENTER",APPROXIMATE:"APPROXIMATE"},GeocoderStatus:{OK:_.ia,UNKNOWN_ERROR:_.la,OVER_QUERY_LIMIT:_.ja,REQUEST_DENIED:_.ka,INVALID_REQUEST:_.ba,ZERO_RESULTS:_.ma,ERROR:_.aa},KmlLayer:$e,
KmlLayerStatus:_.Ti,MaxZoomService:vg,MaxZoomStatus:{OK:_.ia,ERROR:_.aa},SaveWidget:_.Ug,StreetViewCoverageLayer:Ng,StreetViewPanorama:Wf,StreetViewService:_.Og,StreetViewStatus:{OK:_.ia,UNKNOWN_ERROR:_.la,ZERO_RESULTS:_.ma},StyledMapType:_.Tg,TrafficLayer:bf,TrafficModel:_.zi,TransitLayer:cf,TransitMode:_.Ii,TransitRoutePreference:_.Ji,TravelMode:_.yi,UnitSystem:_.xi});_.eb(Ge,{Feature:_.Zc,Geometry:Jc,GeometryCollection:_.te,LineString:_.ve,LinearRing:_.we,MultiLineString:_.ye,MultiPoint:_.ze,MultiPolygon:_.De,Point:_.Lc,Polygon:_.Be});_.Xc("main",{});var Xg=/'/g,Yg;var Je=arguments[0];
window.google.maps.Load(function(a,b){var c=window.google.maps;bh();var d=ch(c);_.R=new vf(a);_.ij=Math.random()<_.O(_.R,0,1);_.jj=Math.round(1E15*Math.random()).toString(36);_.tg=Zg();_.Si=$g();_.Yi=new _.td;_.Ff=b;for(a=0;a<_.je(_.R,8);++a)_.rg[_.ie(_.R,8,a)]=!0;a=new _.tf(_.R.data[3]);Ke(_.P(a,0));_.db(hj,function(a,b){c[a]=b});c.version=_.P(a,1);window.setTimeout(function(){Yc(["util","stats"],function(a,b){a.f.b();a.j();d&&b.b.b({ev:"api_alreadyloaded",client:_.P(_.R,6),key:_.zf()})})},5E3);
_.A.Tm();Hf=new Gf;(a=_.P(_.R,11))&&Yc(_.he(_.R,12),ah(a),!0)});}).call(this,{});

;

(function($) {

/**
 * Drupal FieldGroup object.
 */
Drupal.FieldGroup = Drupal.FieldGroup || {};
Drupal.FieldGroup.Effects = Drupal.FieldGroup.Effects || {};
Drupal.FieldGroup.groupWithfocus = null;

Drupal.FieldGroup.setGroupWithfocus = function(element) {
  element.css({display: 'block'});
  Drupal.FieldGroup.groupWithfocus = element;
}

/**
 * Implements Drupal.FieldGroup.processHook().
 */
Drupal.FieldGroup.Effects.processFieldset = {
  execute: function (context, settings, type) {
    if (type == 'form') {
      // Add required fields mark to any fieldsets containing required fields
      $('fieldset.fieldset', context).once('fieldgroup-effects', function(i) {
        if ($(this).is('.required-fields') && $(this).find('.form-required').length > 0) {
          $('legend span.fieldset-legend', $(this)).eq(0).append(' ').append($('.form-required').eq(0).clone());
        }
        if ($('.error', $(this)).length) {
          $('legend span.fieldset-legend', $(this)).eq(0).addClass('error');
          Drupal.FieldGroup.setGroupWithfocus($(this));
        }
      });
    }
  }
}

/**
 * Implements Drupal.FieldGroup.processHook().
 */
Drupal.FieldGroup.Effects.processAccordion = {
  execute: function (context, settings, type) {
    $('div.field-group-accordion-wrapper', context).once('fieldgroup-effects', function () {
      var wrapper = $(this);

      // Get the index to set active.
      var active_index = false;
      wrapper.find('.accordion-item').each(function(i) {
        if ($(this).hasClass('field-group-accordion-active')) {
          active_index = i;
        }
      });

      wrapper.accordion({
        heightStyle: "content",
        active: active_index,
        collapsible: true,
        changestart: function(event, ui) {
          if ($(this).hasClass('effect-none')) {
            ui.options.animated = false;
          }
          else {
            ui.options.animated = 'slide';
          }
        }
      });

      if (type == 'form') {

        var $firstErrorItem = false;

        // Add required fields mark to any element containing required fields
        wrapper.find('div.field-group-accordion-item').each(function(i) {

          if ($(this).is('.required-fields') && $(this).find('.form-required').length > 0) {
            $('h3.ui-accordion-header a').eq(i).append(' ').append($('.form-required').eq(0).clone());
          }
          if ($('.error', $(this)).length) {
            // Save first error item, for focussing it.
            if (!$firstErrorItem) {
              $firstErrorItem = $(this).parent().accordion("activate" , i);
            }
            $('h3.ui-accordion-header').eq(i).addClass('error');
          }
        });

        // Save first error item, for focussing it.
        if (!$firstErrorItem) {
          $('.ui-accordion-content-active', $firstErrorItem).css({height: 'auto', width: 'auto', display: 'block'});
        }

      }
    });
  }
}

/**
 * Implements Drupal.FieldGroup.processHook().
 */
Drupal.FieldGroup.Effects.processHtabs = {
  execute: function (context, settings, type) {
    if (type == 'form') {
      // Add required fields mark to any element containing required fields
      $('fieldset.horizontal-tabs-pane', context).once('fieldgroup-effects', function(i) {
        if ($(this).is('.required-fields') && $(this).find('.form-required').length > 0) {
          $(this).data('horizontalTab').link.find('strong:first').after($('.form-required').eq(0).clone()).after(' ');
        }
        if ($('.error', $(this)).length) {
          $(this).data('horizontalTab').link.parent().addClass('error');
          Drupal.FieldGroup.setGroupWithfocus($(this));
          $(this).data('horizontalTab').focus();
        }
      });
    }
  }
}

/**
 * Implements Drupal.FieldGroup.processHook().
 */
Drupal.FieldGroup.Effects.processTabs = {
  execute: function (context, settings, type) {
    if (type == 'form') {

      var errorFocussed = false;

      // Add required fields mark to any fieldsets containing required fields
      $('fieldset.vertical-tabs-pane', context).once('fieldgroup-effects', function(i) {
        if ($(this).is('.required-fields') && $(this).find('.form-required').length > 0) {
          $(this).data('verticalTab').link.find('strong:first').after($('.form-required').eq(0).clone()).after(' ');
        }
        if ($('.error', $(this)).length) {
          $(this).data('verticalTab').link.parent().addClass('error');
          // Focus the first tab with error.
          if (!errorFocussed) {
            Drupal.FieldGroup.setGroupWithfocus($(this));
            $(this).data('verticalTab').focus();
            errorFocussed = true;
          }
        }
      });
    }
  }
}

/**
 * Implements Drupal.FieldGroup.processHook().
 *
 * TODO clean this up meaning check if this is really
 *      necessary.
 */
Drupal.FieldGroup.Effects.processDiv = {
  execute: function (context, settings, type) {

    $('div.collapsible', context).once('fieldgroup-effects', function() {
      var $wrapper = $(this);

      // Turn the legend into a clickable link, but retain span.field-group-format-toggler
      // for CSS positioning.

      var $toggler = $('span.field-group-format-toggler:first', $wrapper);
      var $link = $('<a class="field-group-format-title" href="#"></a>');
      $link.prepend($toggler.contents());

      // Add required field markers if needed
      if ($(this).is('.required-fields') && $(this).find('.form-required').length > 0) {
        $link.append(' ').append($('.form-required').eq(0).clone());
      }

      $link.appendTo($toggler);

      // .wrapInner() does not retain bound events.
      $link.click(function () {
        var wrapper = $wrapper.get(0);
        // Don't animate multiple times.
        if (!wrapper.animating) {
          wrapper.animating = true;
          var speed = $wrapper.hasClass('speed-fast') ? 300 : 1000;
          if ($wrapper.hasClass('effect-none') && $wrapper.hasClass('speed-none')) {
            $('> .field-group-format-wrapper', wrapper).toggle();
          }
          else if ($wrapper.hasClass('effect-blind')) {
            $('> .field-group-format-wrapper', wrapper).toggle('blind', {}, speed);
          }
          else {
            $('> .field-group-format-wrapper', wrapper).toggle(speed);
          }
          wrapper.animating = false;
        }
        $wrapper.toggleClass('collapsed');
        return false;
      });

    });
  }
};

/**
 * Behaviors.
 */
Drupal.behaviors.fieldGroup = {
  attach: function (context, settings) {
    settings.field_group = settings.field_group || Drupal.settings.field_group;
    if (settings.field_group == undefined) {
      return;
    }

    // Execute all of them.
    $.each(Drupal.FieldGroup.Effects, function (func) {
      // We check for a wrapper function in Drupal.field_group as
      // alternative for dynamic string function calls.
      var type = func.toLowerCase().replace("process", "");
      if (settings.field_group[type] != undefined && $.isFunction(this.execute)) {
        this.execute(context, settings, settings.field_group[type]);
      }
    });

    // Fixes css for fieldgroups under vertical tabs.
    $('.fieldset-wrapper .fieldset > legend').css({display: 'block'});
    $('.vertical-tabs fieldset.fieldset').addClass('default-fallback');

    // Add a new ID to each fieldset.
    $('.group-wrapper .horizontal-tabs-panes > fieldset', context).once('group-wrapper-panes-processed', function() {
      // Tats bad, but we have to keep the actual id to prevent layouts to break.
      var fieldgroupID = 'field_group-' + $(this).attr('id');
      $(this).attr('id', fieldgroupID);
    });
    // Set the hash in url to remember last userselection.
    $('.group-wrapper ul li').once('group-wrapper-ul-processed', function() {
      var fieldGroupNavigationListIndex = $(this).index();
      $(this).children('a').click(function() {
        var fieldset = $('.group-wrapper fieldset').get(fieldGroupNavigationListIndex);
        // Grab the first id, holding the wanted hashurl.
        var hashUrl = $(fieldset).attr('id').replace(/^field_group-/, '').split(' ')[0];
        window.location.hash = hashUrl;
      });
    });

  }
};

})(jQuery);
;
