Drupal.locale = { 'pluralFormula': function ($n) { return Number((($n==1)?(0):((((($n%10)>=2)&&(($n%10)<=4))&&((($n%100)<10)||(($n%100)>=20)))?(1):2))); }, 'strings': {"":{"An AJAX HTTP error occurred.":"Wyst\u0105pi\u0142 b\u0142\u0105d w AJAX HTTP.","HTTP Result Code: !status":"B\u0142\u0105d HTTP: !status","An AJAX HTTP request terminated abnormally.":"Zapytanie AJAX HTTP zosta\u0142o przerwane.","Debugging information follows.":"Informacje diagnostyczne.","Path: !uri":"\u015acie\u017cka: !uri","StatusText: !statusText":"StatusText: !statusText","ResponseText: !responseText":"ResponseText: !responseText","ReadyState: !readyState":"ReadyState: !readyState","CustomMessage: !customMessage":"CustomMessage: !customMessage","All":"Wszystko","Re-order rows by numerical weight instead of dragging.":"Zmie\u0144 kolejno\u015b\u0107 wierszy podaj\u0105c warto\u015bci numeryczne zamiast przeci\u0105gaj\u0105c.","Show row weights":"Poka\u017c wagi wierszy","Hide row weights":"Ukryj wagi wierszy","Drag to re-order":"Chwy\u0107, by zmieni\u0107 kolejno\u015b\u0107","Changes made in this table will not be saved until the form is submitted.":"Zmiany wprowadzone w tabeli zachowuje si\u0119 przyciskiem u do\u0142u formularza.","Hide":"Ukryj","Show":"Poka\u017c","Edit":"Edytuj","Add":"Dodaj","Not published":"Nie do publikacji","(active tab)":"(aktywna karta)","@title dialog":"@title dialog","Configure":"Konfiguruj","Loading":"\u0141adowanie","Select all rows in this table":"Zaznacza wszystkie wiersze tabeli","Deselect all rows in this table":"Cofa zaznaczenie wszystkich wierszy tabeli","Upload":"Wy\u015blij plik","Only files with the following extensions are allowed: %files-allowed.":"Dozwolone s\u0105 jedynie pliki o nast\u0119puj\u0105cych rozszerzeniach: %files-allowed.","Hide summary":"Ukryj podsumowanie","Edit summary":"Edycja podsumowania","Please wait...":"Prosz\u0119 czeka\u0107...","The response failed verification so will not be processed.":"Odpowied\u017a nie zosta\u0142a zweryfikowana zatem nie zostanie przetworzona.","The callback URL is not local and not trusted: !url":"Adres URL wywo\u0142ania zwrotnego nie jest lokalny i nie mo\u017cna uzna\u0107 go za zaufany: !url","The selected file %filename cannot be uploaded. Only files with the following extensions are allowed: %extensions.":"Wybrany plik %filename nie m\u00f3g\u0142 zosta\u0107 wys\u0142any. Dozwolone s\u0105 jedynie nast\u0119puj\u0105ce rozszerzenia: %extensions.","Cancel":"Anuluj","Not in menu":"Nie ma w menu","Alias: @alias":"Alias: @alias","No alias":"Brak aliasu","New revision":"Nowa wersja","No revision":"Brak wersji","By @name on @date":"Przez @name w @date","By @name":"Przez @name","Autocomplete popup":"Okienko autouzupe\u0142niania","Searching for matches...":"Wyszukiwanie pasuj\u0105cych...","The changes to these blocks will not be saved until the \u003Cem\u003ESave blocks\u003C\/em\u003E button is clicked.":"Zmiany wprowadzone w blokach zachowuje si\u0119 przyciskiem u do\u0142u formularza.","Not restricted":"Bez ogranicze\u0144","Not customizable":"Niekonfigurowalne","Restricted to certain pages":"Ograniczenie do okre\u015blonych stron.","The block cannot be placed in this region.":"Blok nie mo\u017ce by\u0107 umieszczony w tym regionie."}} };;
/**
 * @file
 * Page Load Progress allows you to set a screen lock showing a spinner when the
 * user clicks on an element that triggers a time consuming task.
 */

(function($){
  Drupal.behaviors.page_load_progress = {
    attach: function(context, settings) {
      var delay = Number(Drupal.settings.page_load_progress.delay);
      var exit_elements = String(Drupal.settings.page_load_progress.elements).split(',');
      var screen_lock = '<div class="page-load-progress-lock-screen hidden">\n\
                          <div class="page-load-progress-spinner"></div>\n\
                         </div>';
      var body = $('body', context);
      for (i in exit_elements) {
        $(exit_elements[i]).click(function() {
          setTimeout(lockScreen, delay);
        });
      }
      var lockScreen = function () {
        body.append(screen_lock);
        body.css({
          'overflow' : 'hidden'
        });
        $('.page-load-progress-lock-screen').fadeIn('slow');
      }
    }
  };
})(jQuery);
;
(function ($) {

/**
 * Attaches sticky table headers.
 */
Drupal.behaviors.tableHeader = {
  attach: function (context, settings) {
    if (!$.support.positionFixed) {
      return;
    }

    $('table.sticky-enabled', context).once('tableheader', function () {
      $(this).data("drupal-tableheader", new Drupal.tableHeader(this));
    });
  }
};

/**
 * Constructor for the tableHeader object. Provides sticky table headers.
 *
 * @param table
 *   DOM object for the table to add a sticky header to.
 */
Drupal.tableHeader = function (table) {
  var self = this;

  this.originalTable = $(table);
  this.originalHeader = $(table).children('thead');
  this.originalHeaderCells = this.originalHeader.find('> tr > th');
  this.displayWeight = null;

  // React to columns change to avoid making checks in the scroll callback.
  this.originalTable.bind('columnschange', function (e, display) {
    // This will force header size to be calculated on scroll.
    self.widthCalculated = (self.displayWeight !== null && self.displayWeight === display);
    self.displayWeight = display;
  });

  // Clone the table header so it inherits original jQuery properties. Hide
  // the table to avoid a flash of the header clone upon page load.
  this.stickyTable = $('<table class="sticky-header"/>')
    .insertBefore(this.originalTable)
    .css({ position: 'fixed', top: '0px' });
  this.stickyHeader = this.originalHeader.clone(true)
    .hide()
    .appendTo(this.stickyTable);
  this.stickyHeaderCells = this.stickyHeader.find('> tr > th');

  this.originalTable.addClass('sticky-table');
  $(window)
    .bind('scroll.drupal-tableheader', $.proxy(this, 'eventhandlerRecalculateStickyHeader'))
    .bind('resize.drupal-tableheader', { calculateWidth: true }, $.proxy(this, 'eventhandlerRecalculateStickyHeader'))
    // Make sure the anchor being scrolled into view is not hidden beneath the
    // sticky table header. Adjust the scrollTop if it does.
    .bind('drupalDisplaceAnchor.drupal-tableheader', function () {
      window.scrollBy(0, -self.stickyTable.outerHeight());
    })
    // Make sure the element being focused is not hidden beneath the sticky
    // table header. Adjust the scrollTop if it does.
    .bind('drupalDisplaceFocus.drupal-tableheader', function (event) {
      if (self.stickyVisible && event.clientY < (self.stickyOffsetTop + self.stickyTable.outerHeight()) && event.$target.closest('sticky-header').length === 0) {
        window.scrollBy(0, -self.stickyTable.outerHeight());
      }
    })
    .triggerHandler('resize.drupal-tableheader');

  // We hid the header to avoid it showing up erroneously on page load;
  // we need to unhide it now so that it will show up when expected.
  this.stickyHeader.show();
};

/**
 * Event handler: recalculates position of the sticky table header.
 *
 * @param event
 *   Event being triggered.
 */
Drupal.tableHeader.prototype.eventhandlerRecalculateStickyHeader = function (event) {
  var self = this;
  var calculateWidth = event.data && event.data.calculateWidth;

  // Reset top position of sticky table headers to the current top offset.
  this.stickyOffsetTop = Drupal.settings.tableHeaderOffset ? eval(Drupal.settings.tableHeaderOffset + '()') : 0;
  this.stickyTable.css('top', this.stickyOffsetTop + 'px');

  // Save positioning data.
  var viewHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
  if (calculateWidth || this.viewHeight !== viewHeight) {
    this.viewHeight = viewHeight;
    this.vPosition = this.originalTable.offset().top - 4 - this.stickyOffsetTop;
    this.hPosition = this.originalTable.offset().left;
    this.vLength = this.originalTable[0].clientHeight - 100;
    calculateWidth = true;
  }

  // Track horizontal positioning relative to the viewport and set visibility.
  var hScroll = document.documentElement.scrollLeft || document.body.scrollLeft;
  var vOffset = (document.documentElement.scrollTop || document.body.scrollTop) - this.vPosition;
  this.stickyVisible = vOffset > 0 && vOffset < this.vLength;
  this.stickyTable.css({ left: (-hScroll + this.hPosition) + 'px', visibility: this.stickyVisible ? 'visible' : 'hidden' });

  // Only perform expensive calculations if the sticky header is actually
  // visible or when forced.
  if (this.stickyVisible && (calculateWidth || !this.widthCalculated)) {
    this.widthCalculated = true;
    var $that = null;
    var $stickyCell = null;
    var display = null;
    var cellWidth = null;
    // Resize header and its cell widths.
    // Only apply width to visible table cells. This prevents the header from
    // displaying incorrectly when the sticky header is no longer visible.
    for (var i = 0, il = this.originalHeaderCells.length; i < il; i += 1) {
      $that = $(this.originalHeaderCells[i]);
      $stickyCell = this.stickyHeaderCells.eq($that.index());
      display = $that.css('display');
      if (display !== 'none') {
        cellWidth = $that.css('width');
        // Exception for IE7.
        if (cellWidth === 'auto') {
          cellWidth = $that[0].clientWidth + 'px';
        }
        $stickyCell.css({'width': cellWidth, 'display': display});
      }
      else {
        $stickyCell.css('display', 'none');
      }
    }
    this.stickyTable.css('width', this.originalTable.outerWidth());
  }
};

})(jQuery);
;
/**
 * @file
 * Custom admin-side JS for the Metatag module.
 */

(function ($) {
  'use strict';

Drupal.behaviors.metatagUIConfigListing = {
  attach: function (context) {
    // Hidden elements to be visible if JavaScript is enabled.
    $('.js-show').show();

    // Make the leaf arrow clickable.
    $('.metatag-config-label').hover(function(){
      $(this).css({'cursor': 'pointer'});
    })
    .click(function(){
      $(this).find('a.toggle-details', context).trigger('click');
    });

    // Show or hide the summary
    $('table.metatag-config-overview a.toggle-details', context).click(function(event) {
      $(this).parent('div').siblings('div.metatag-config-details').each(function() {
        if ($(this).hasClass('js-hide')) {
          $(this).slideDown('slow').removeClass('js-hide');
        }
        else {
          $(this).slideUp('slow').addClass('js-hide');
        }
      });

      // Change the expanded or collapsed state of the instance label.
      if ($(this).parent('div').hasClass('collapsed')) {
        $(this).parent('div').removeClass('collapsed').addClass('expanded');
      }
      else {
        $(this).parent('div').removeClass('expanded').addClass('collapsed');
      }

      // This event may be triggered by a parent element click - so we don't
      // want the click to bubble up otherwise we get recursive click events.
      event.stopPropagation();
    });
  }
};

})(jQuery);
;
